/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoDeducaoCreditoValidacaoDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class EstornoDeducaoCreditoValidacaoAMService {
    private static final Long TRIBUTOS_MUNICIPAIS = 22L;

    public List<ErrosImportacaoSIMAM> validate(EstornoDeducaoCreditoValidacaoDTO estornoDeducaoCreditoValidacaoDTO, StepExecution stepExecution) {
        ArrayList<Optional> erros = new ArrayList<Optional>();
        LocalDate dataRemessa = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        erros.add(this.validateRegistroDuplicadoNrEstorno(estornoDeducaoCreditoValidacaoDTO));
        erros.add(this.validateNrDeducaoExistente(estornoDeducaoCreditoValidacaoDTO));
        erros.add(this.validateCdControleLeiAto(estornoDeducaoCreditoValidacaoDTO));
        erros.add(this.validateDtEstorno(estornoDeducaoCreditoValidacaoDTO, dataRemessa));
        erros.add(this.validateVlEstorno(estornoDeducaoCreditoValidacaoDTO));
        erros.add(this.validateDsMotivo(estornoDeducaoCreditoValidacaoDTO));
        erros.add(this.validateRegistroDuplicadoNrDeducao(estornoDeducaoCreditoValidacaoDTO));
        erros.add(this.validateNrCreditoExercicioFinanceiro(estornoDeducaoCreditoValidacaoDTO));
        return erros.stream().flatMap(Optional::stream).collect(Collectors.toList());
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicadoNrEstorno(EstornoDeducaoCreditoValidacaoDTO estornoDeducaoCreditoValidacaoDTO) {
        if (estornoDeducaoCreditoValidacaoDTO.getNrRegistroEstorno() > 1L) {
            String mensagemErro = "O conjunto (nrEstorno e nrAnoEstorno) da tabela (EstornoDeducaoCredito) apresenta-se com registro duplicado.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(estornoDeducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO).codigoErro(Long.valueOf(1347L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrDeducaoExistente(EstornoDeducaoCreditoValidacaoDTO estornoDeducaoCreditoValidacaoDTO) {
        if (Objects.isNull(estornoDeducaoCreditoValidacaoDTO.getNrDeducaoDeducaoCredito()) || Objects.isNull(estornoDeducaoCreditoValidacaoDTO.getNrAnoDeducaoDeducaoCredito())) {
            String mensagemErro = "O N\u00famero e Ano da Dedu\u00e7\u00e3o do Cr\u00e9dito (nrDeducao e nrAnoDeducao) da tabela (EstornoDeducaoCredito) n\u00e3o existe na tabela (DeducaoCredito).";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(estornoDeducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO).codigoErro(Long.valueOf(1348L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateCdControleLeiAto(EstornoDeducaoCreditoValidacaoDTO estornoDeducaoCreditoValidacaoDTO) {
        if (Objects.isNull(estornoDeducaoCreditoValidacaoDTO.getCdControleLeiAtoCgAto()) || !TRIBUTOS_MUNICIPAIS.equals(estornoDeducaoCreditoValidacaoDTO.getEscopoLei())) {
            String mensagemErro = "O Controle de Lei/Ato (cdControleLeiAto) da tabela (EstornoDeducaoCredito) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(estornoDeducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO).codigoErro(Long.valueOf(1349L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDtEstorno(EstornoDeducaoCreditoValidacaoDTO estornoDeducaoCreditoValidacaoDTO, LocalDate dataRemessa) {
        if (Objects.nonNull(estornoDeducaoCreditoValidacaoDTO.getDtDeducaoDeducaoCredito()) && estornoDeducaoCreditoValidacaoDTO.getDtEstorno().isBefore(estornoDeducaoCreditoValidacaoDTO.getDtDeducaoDeducaoCredito()) || estornoDeducaoCreditoValidacaoDTO.getDtEstorno().isAfter(dataRemessa)) {
            String mensagemErro = "A data do estorno da dedu\u00e7\u00e3o do cr\u00e9dito (dtEstorno) da tabela (EstornoDeducaoCredito) n\u00e3o pode ser menor que (dtDeducao) informada na tabela (DeducaoCredito) e nem maior que o m\u00eas/ano de trabalho.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(estornoDeducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO).codigoErro(Long.valueOf(1350L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateVlEstorno(EstornoDeducaoCreditoValidacaoDTO estornoDeducaoCreditoValidacaoDTO) {
        if (estornoDeducaoCreditoValidacaoDTO.getVlEstorno().compareTo(BigDecimal.ZERO) < 0) {
            String mensagemErro = "O valor do estorno da dedu\u00e7\u00e3o do cr\u00e9dito (vlEstorno) da tabela (EstornoDeducaoCredito) n\u00e3o pode ser negativo.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(estornoDeducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO).codigoErro(Long.valueOf(1351L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDsMotivo(EstornoDeducaoCreditoValidacaoDTO estornoDeducaoCreditoValidacaoDTO) {
        if (Objects.isNull(estornoDeducaoCreditoValidacaoDTO.getDsMotivo()) || estornoDeducaoCreditoValidacaoDTO.getDsMotivo().length() < 20) {
            String mensagemErro = "A descri\u00e7\u00e3o do motivo do estorno da dedu\u00e7\u00e3o do cr\u00e9dito (dsMotivo) da tabela (EstornoDeducaoCredito) deve possuir no m\u00ednimo 20 (vinte) caracteres.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(estornoDeducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO).codigoErro(Long.valueOf(1352L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicadoNrDeducao(EstornoDeducaoCreditoValidacaoDTO estornoDeducaoCreditoValidacaoDTO) {
        if (estornoDeducaoCreditoValidacaoDTO.getNrRegistroDeducao() > 1L) {
            String mensagemErro = "O registro da tabela (EstornoDeducaoCredito) para o conjunto (nrAnoEstorno, nrDeducao, nrAnoDeducao, cdControleLeiAto, dtEstorno) n\u00e3o pode ser duplicado.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(estornoDeducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO).codigoErro(Long.valueOf(2235L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrCreditoExercicioFinanceiro(EstornoDeducaoCreditoValidacaoDTO estornoDeducaoCreditoValidacaoDTO) {
        if (Objects.nonNull(estornoDeducaoCreditoValidacaoDTO.getNrAnoCreditoDeducaoCredito()) && estornoDeducaoCreditoValidacaoDTO.getNrAnoCreditoDeducaoCredito() < 2023L) {
            String mensagemErro = "O registro da tabela (EstornoDeducaoCredito) n\u00e3o pode estar vinculado com ano de cr\u00e9dito (nrAnoCredito) menor que o exerc\u00edcio financeiro de 2023.";
            return Optional.of(ErrosImportacaoSIMAM.builder().idRegistro(estornoDeducaoCreditoValidacaoDTO.getId()).identificadorArquivo(TipoRegistroSimAm.ESTORNO_DEDUCAO_CREDITO).codigoErro(Long.valueOf(2246L)).dataValidacao(LocalDate.now()).mensagemErro(mensagemErro).build());
        }
        return Optional.empty();
    }
}

