/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaogeomais;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.LogradouroTestada;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.SituacaoImobiliario;
import br.com.elotech.tributos.domain.SituacaoSegmentoImob;
import br.com.elotech.tributos.domain.SolicitacaoAlvara;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoSegmento;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioTestada;
import br.com.elotech.tributos.domain.solicitacaotestada.SolicitacaoTestadaLog;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralExistsElogeoDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralPostGeomaisDTO;
import br.com.elotech.tributos.repository.SolicitacaoAlvaraRepository;
import br.com.elotech.tributos.repository.solicitacaotestada.SolicitacaoTestadaLogRepository;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.CondominioService;
import br.com.elotech.tributos.service.DistritoService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.LoteamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.SetorService;
import br.com.elotech.tributos.service.integracaogeomais.CadastroImobiliarioElogeo;
import br.com.elotech.tributos.util.EloRequireNonNull;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public abstract class CadastroImobiliarioElogeoServiceAbstract
implements CadastroImobiliarioElogeo {
    private static final Logger LOGGER = LoggerFactory.getLogger(CadastroImobiliarioElogeoServiceAbstract.class);
    protected final CadastroGeralService cadastroGeralService;
    protected final CadastroImobiliarioService cadastroImobiliarioService;
    protected final DistritoService distritoService;
    protected final SetorService setorService;
    protected final BairroService bairroService;
    protected final SetorQuadraService setorQuadraService;
    protected final SolicitacaoTestadaLogRepository solicitacaoTestadaLogRepository;
    protected final SolicitacaoAlvaraRepository solicitacaoAlvaraRepository;
    protected final LogradouroService logradouroService;
    protected final LoteamentoService loteamentoService;
    protected final CondominioService condominioService;
    protected final ParametroGeralService parametroGeralService;

    protected abstract void mergeBoletins(CadastroGeralPostGeomaisDTO var1, CadastroImobiliario var2);

    protected abstract CadastroImobiliario prepareGeomaisToSave(CadastroImobiliario var1, Boolean var2, CadastroGeralPostGeomaisDTO var3);

    protected abstract CadastroGeralGeomaisDTO entityToGeomaisDTO(CadastroImobiliario var1);

    public Page<CadastroGeralGeomaisDTO> findAllGeomaisDTO(Pageable page, String search) {
        return this.cadastroImobiliarioService.findByRsql(search, page).map(arg_0 -> this.entityToGeomaisDTO(arg_0));
    }

    public CadastroGeralGeomaisDTO findByCadastroGeralGeomaisDTO(Long cadastroGeral) {
        CadastroImobiliario cadastroImobiliario = this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, cadastroGeral);
        if (Objects.isNull(cadastroImobiliario)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar o Cadastro Imobili\u00e1rio com o C\u00f3digo '%d'.", cadastroGeral));
        }
        return this.entityToGeomaisDTO(cadastroImobiliario);
    }

    public Page<CadastroGeralGeomaisDTO> findByRSQL(String search, Pageable pageable) {
        return this.cadastroImobiliarioService.findByRsql(search, pageable).map(arg_0 -> this.entityToGeomaisDTO(arg_0));
    }

    public CadastroGeralExistsElogeoDTO exists(Long cadastroGeral) {
        CadastroGeralExistsElogeoDTO dto = new CadastroGeralExistsElogeoDTO();
        dto.setCadastroLocalizado(Boolean.valueOf(this.cadastroGeralService.exists(TipoCadastro.IMOBILIARIO, cadastroGeral)));
        return dto;
    }

    public CadastroGeralGeomaisDTO saveGeomaisDTO(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, Boolean novoCadastro, Long cadastroGeral) {
        LOGGER.info("In\u00edcio atualiza\u00e7\u00e3o do Cadastro Geral {}, Tipo Cadastro {}", (Object)cadastroGeralPostGeomaisDTO.getCodigo(), (Object)cadastroGeralPostGeomaisDTO.getTipo());
        if (!novoCadastro.booleanValue() && !cadastroGeralPostGeomaisDTO.getCodigo().equals(cadastroGeral)) {
            throw new EloValidationException(String.format("C\u00f3digo do Cadastro %d diferente do Request %d.", cadastroGeral, cadastroGeralPostGeomaisDTO.getCodigo()));
        }
        cadastroGeralPostGeomaisDTO.setCodigo(this.cadastroImobiliarioService.validateAndGetCadastroGeralSequence(cadastroGeralPostGeomaisDTO.getCodigo()));
        CadastroImobiliario cadastroImobiliarioToSave = cadastroGeralPostGeomaisDTO.toEntity();
        cadastroImobiliarioToSave.setDistritoLocalizacao((Distrito)this.distritoService.findById((Serializable)((Object)cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito())).orElseThrow(() -> new EloValidationException(String.format("Distrito %s n\u00e3o localizado.", cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito()))));
        cadastroImobiliarioToSave.setSetorLocalizacao((Setor)EloRequireNonNull.eloRequireNonNull((Object)this.setorService.findByDistritoDistritoAndSetor(cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor()), (String)String.format("Setor %s n\u00e3o localizado.", cadastroGeralPostGeomaisDTO.getImobiliario().getSetor())));
        cadastroImobiliarioToSave.setQuadraLocalizacao((SetorQuadra)EloRequireNonNull.eloRequireNonNull((Object)this.setorQuadraService.findBySetorDistritoDistritoAndSetorSetorAndQuadra(cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor(), cadastroGeralPostGeomaisDTO.getImobiliario().getQuadra()), (String)String.format("Quadra %s n\u00e3o localizada.", cadastroGeralPostGeomaisDTO.getImobiliario().getQuadra())));
        cadastroImobiliarioToSave.setBairro((Bairro)this.bairroService.findByBairroAndCidadeEntidadePrincipal(cadastroGeralPostGeomaisDTO.getBairro().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Bairro %s n\u00e3o localizado.", cadastroGeralPostGeomaisDTO.getBairro().getCodigo()))));
        if (Objects.nonNull(cadastroGeralPostGeomaisDTO.getImobiliario().getCondominio())) {
            this.setCondominioToSave(cadastroGeralPostGeomaisDTO, cadastroImobiliarioToSave);
        }
        if (Objects.nonNull(cadastroGeralPostGeomaisDTO.getImobiliario().getLoteamento())) {
            this.setLoteamentoToSave(cadastroGeralPostGeomaisDTO, cadastroImobiliarioToSave);
        }
        this.setProprietariosToSave(cadastroGeralPostGeomaisDTO, cadastroImobiliarioToSave);
        if (Objects.nonNull(cadastroGeralPostGeomaisDTO.getImobiliario().getSegmentos())) {
            this.setSegmentosToSave(cadastroGeralPostGeomaisDTO, cadastroImobiliarioToSave);
        }
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_SITUACAO_IMOBILIARIO).booleanValue() && Objects.nonNull(cadastroGeralPostGeomaisDTO.getImobiliario().getSituacao())) {
            this.setSituacaoImobiliarioToSave(cadastroGeralPostGeomaisDTO, cadastroImobiliarioToSave);
        }
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_TESTADA_GENERICA).booleanValue()) {
            this.setTestadasGenericaToSave(cadastroGeralPostGeomaisDTO, cadastroImobiliarioToSave);
        } else {
            this.setTestadasToSave(cadastroGeralPostGeomaisDTO, novoCadastro, cadastroGeral, cadastroImobiliarioToSave);
        }
        cadastroImobiliarioToSave.validaCamposFiscalizacao();
        CadastroImobiliario prepared = this.prepareGeomaisToSave(cadastroImobiliarioToSave, novoCadastro, cadastroGeralPostGeomaisDTO);
        CadastroImobiliario saved = (CadastroImobiliario)this.cadastroImobiliarioService.save((EloEntity)prepared, null);
        this.mergeBoletins(cadastroGeralPostGeomaisDTO, saved);
        CadastroGeralGeomaisDTO cadastroGeralGeomaisDTO = this.entityToGeomaisDTO(saved);
        LOGGER.info("Fim atualiza\u00e7\u00e3o do Cadastro Geral {}, Tipo Cadastro {}", (Object)cadastroGeralGeomaisDTO.getCodigo(), (Object)cadastroGeralGeomaisDTO.getTipo());
        return cadastroGeralGeomaisDTO;
    }

    private void setCondominioToSave(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroImobiliarioToSave.setCondominio(Optional.ofNullable(this.condominioService.findBySetorDistritoDistritoAndSetorSetorAndCondominio(cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor(), cadastroGeralPostGeomaisDTO.getImobiliario().getCondominio().getCodigo())).orElseThrow(() -> new EloValidationException(String.format("Condom\u00ednio %s do Distrito %s e Setor %s n\u00e3o localizado.", cadastroGeralPostGeomaisDTO.getImobiliario().getCondominio().getCodigo(), cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor()))));
    }

    private void setLoteamentoToSave(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroImobiliarioToSave.setLoteamento(Optional.ofNullable(this.loteamentoService.findBySetorDistritoDistritoAndSetorSetorAndLoteamento(cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor(), cadastroGeralPostGeomaisDTO.getImobiliario().getLoteamento().getCodigo())).orElseThrow(() -> new EloValidationException(String.format("Loteamento %s do Distrito %s e Setor %s n\u00e3o localizado.", cadastroGeralPostGeomaisDTO.getImobiliario().getLoteamento().getCodigo(), cadastroGeralPostGeomaisDTO.getImobiliario().getDistrito(), cadastroGeralPostGeomaisDTO.getImobiliario().getSetor()))));
    }

    private void setProprietariosToSave(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroGeralPostGeomaisDTO.getProprietarios().stream().map(proprietario -> {
            Pessoa pessoa = (Pessoa)EloRequireNonNull.eloRequireNonNull((Object)((Pessoa)this.cadastroImobiliarioService.getEm().find(Pessoa.class, (Object)proprietario.getPessoa().getId())), (String)String.format("Pessoa %s n\u00e3o localizada.", proprietario.getPessoa().getId()));
            Vinculo vinculo = (Vinculo)EloRequireNonNull.eloRequireNonNull((Object)((Vinculo)this.cadastroImobiliarioService.getEm().find(Vinculo.class, (Object)proprietario.getVinculo().getId())), (String)String.format("V\u00ednculo %s n\u00e3o localizado.", proprietario.getVinculo().getId()));
            return proprietario.toEntity(pessoa, vinculo);
        }).forEach(cadastroImobiliarioToSave.getProprietarios()::add);
    }

    private void setSegmentosToSave(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroGeralPostGeomaisDTO.getImobiliario().getSegmentos().stream().map(segmento -> {
            TipoSegmento tipoSegmento = (TipoSegmento)EloRequireNonNull.eloRequireNonNull((Object)((TipoSegmento)this.cadastroImobiliarioService.getEm().find(TipoSegmento.class, (Object)segmento.getTipo().getId())), (String)String.format("Tipo de Segmento %s n\u00e3o localizado.", segmento.getTipo().getId()));
            if (Boolean.TRUE.equals(this.cadastroImobiliarioService.utilizaSituacaoSegmento())) {
                SituacaoSegmentoImob situacaoSegmentoImob = (SituacaoSegmentoImob)EloRequireNonNull.eloRequireNonNull((Object)((SituacaoSegmentoImob)this.cadastroImobiliarioService.getEm().find(SituacaoSegmentoImob.class, (Object)segmento.getSituacao().getId())), (String)String.format("Situa\u00e7\u00e3o de Segmento %s n\u00e3o localizada.", segmento.getSituacao().getId()));
                return segmento.toEntity(cadastroGeralPostGeomaisDTO.getCodigo(), tipoSegmento, situacaoSegmentoImob);
            }
            return segmento.toEntity(cadastroGeralPostGeomaisDTO.getCodigo(), tipoSegmento);
        }).forEach(cadastroImobiliarioToSave.getSegmentos()::add);
    }

    private void setSituacaoImobiliarioToSave(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroImobiliarioToSave.setSituacaoImobiliario((SituacaoImobiliario)EloRequireNonNull.eloRequireNonNull((Object)((SituacaoImobiliario)this.cadastroImobiliarioService.getEm().find(SituacaoImobiliario.class, (Object)cadastroGeralPostGeomaisDTO.getImobiliario().getSituacao().getId())), (String)String.format("Situa\u00e7\u00e3o do Imobili\u00e1rio %s n\u00e3o encontrada.", cadastroGeralPostGeomaisDTO.getImobiliario().getSituacao().getId())));
    }

    private void setTestadasGenericaToSave(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, CadastroImobiliario cadastroImobiliarioToSave) {
        cadastroGeralPostGeomaisDTO.getImobiliario().getTestadasGenericas().stream().map(testadaGenerica -> {
            Logradouro logradouro = (Logradouro)this.logradouroService.findByLogradouroAndCidadeEntidadePrincipal(testadaGenerica.getLogradouro().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Logradouro %s da Testada Gen\u00e9rica n\u00e3o encontrado.", testadaGenerica.getLogradouro().getCodigo())));
            return testadaGenerica.toEntity(logradouro);
        }).forEach(cadastroImobiliarioToSave.getTestadasGenericas()::add);
    }

    private void setTestadasToSave(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, Boolean novoCadastro, Long cadastroGeral, CadastroImobiliario cadastroImobiliarioToSave) {
        CadastroImobiliario cadImobiliario = this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, cadastroGeral);
        if (Objects.nonNull(cadastroGeral) && !novoCadastro.booleanValue() && Objects.nonNull(cadImobiliario)) {
            try {
                List testadasRemovidas = this.separarTestadasRemovidas(cadastroGeralPostGeomaisDTO, cadImobiliario);
                Long testadaPrincipal = cadImobiliario.getTestadas().stream().filter(CadastroImobiliarioTestada::getPrincipal).findFirst().orElseThrow().getIdLogradouroTestada();
                this.removeVinculoSolicitacaoByTestadaRemovida(cadastroGeral, testadasRemovidas, testadaPrincipal);
            }
            catch (NoSuchElementException e) {
                throw new EloValidationException(String.format("Cadastro Imobili\u00e1rio %d, n\u00e3o possui uma testada principal", cadastroGeral));
            }
        }
        this.adicionarTestadasASalvar(cadastroGeralPostGeomaisDTO, cadastroImobiliarioToSave, cadImobiliario);
    }

    private List<CadastroImobiliarioTestada> separarTestadasRemovidas(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, CadastroImobiliario cadImobiliario) {
        return cadImobiliario.getTestadas().stream().filter(testada -> cadastroGeralPostGeomaisDTO.getImobiliarioTestadas().stream().noneMatch(cadTestada -> cadTestada.getSecaoId().equals(testada.getIdLogradouroTestada()))).collect(Collectors.toList());
    }

    private void removeVinculoSolicitacaoByTestadaRemovida(Long cadastroGeral, List<CadastroImobiliarioTestada> testadasRemovidas, Long testadaPrincipal) {
        for (CadastroImobiliarioTestada testada : testadasRemovidas) {
            Optional solicitacao = this.solicitacaoAlvaraRepository.getSolicitacaoByLogradouroTestadaAndCadastroGeral(testada.getIdLogradouroTestada(), cadastroGeral);
            if (!solicitacao.isPresent()) continue;
            this.solicitacaoAlvaraRepository.save((Object)new SolicitacaoAlvara((Long)solicitacao.get(), testadaPrincipal, cadastroGeral));
            this.saveLogSolicitacaoTestada(cadastroGeral, testada, solicitacao, testadaPrincipal);
        }
    }

    private void adicionarTestadasASalvar(CadastroGeralPostGeomaisDTO cadastroGeralPostGeomaisDTO, CadastroImobiliario cadastroImobiliarioToSave, CadastroImobiliario cadastroImobiliarioOriginal) {
        if (Objects.nonNull(cadastroImobiliarioOriginal)) {
            cadastroGeralPostGeomaisDTO.getImobiliarioTestadas().forEach(testadaGeo -> cadastroImobiliarioOriginal.getTestadas().stream().filter(testada -> testadaGeo.getSecaoId().equals(testada.getIdLogradouroTestada())).forEach(cadastroImobiliarioToSave.getTestadas()::add));
        }
        if (cadastroImobiliarioToSave.getTestadas().isEmpty()) {
            cadastroGeralPostGeomaisDTO.getImobiliarioTestadas().stream().map(testada -> {
                LogradouroTestada logradouroTestada = (LogradouroTestada)EloRequireNonNull.eloRequireNonNull((Object)((LogradouroTestada)this.cadastroImobiliarioService.getEm().find(LogradouroTestada.class, (Object)testada.getSecaoId())), (String)String.format("Se\u00e7\u00e3o %s da Testada n\u00e3o localizada.", testada.getSecaoId()));
                return testada.toEntity(logradouroTestada);
            }).forEach(cadastroImobiliarioToSave.getTestadas()::add);
        }
    }

    private void saveLogSolicitacaoTestada(Long cadastroGeral, CadastroImobiliarioTestada testada, Optional<Long> solicitacao, Long testadaPrincipal) {
        SolicitacaoTestadaLog log = new SolicitacaoTestadaLog();
        log.setTipoCadastro(TipoCadastro.IMOBILIARIO.getValue());
        log.setCadastroGeral(cadastroGeral);
        log.setIdTestadaNova(testadaPrincipal);
        log.setIdTestadaAntiga(testada.getIdLogradouroTestada());
        log.setNumeroSolicitacaoAlvara(solicitacao.orElseThrow());
        this.solicitacaoTestadaLogRepository.save((Object)log);
    }

    @Generated
    public CadastroImobiliarioElogeoServiceAbstract(CadastroGeralService cadastroGeralService, CadastroImobiliarioService cadastroImobiliarioService, DistritoService distritoService, SetorService setorService, BairroService bairroService, SetorQuadraService setorQuadraService, SolicitacaoTestadaLogRepository solicitacaoTestadaLogRepository, SolicitacaoAlvaraRepository solicitacaoAlvaraRepository, LogradouroService logradouroService, LoteamentoService loteamentoService, CondominioService condominioService, ParametroGeralService parametroGeralService) {
        this.cadastroGeralService = cadastroGeralService;
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.distritoService = distritoService;
        this.setorService = setorService;
        this.bairroService = bairroService;
        this.setorQuadraService = setorQuadraService;
        this.solicitacaoTestadaLogRepository = solicitacaoTestadaLogRepository;
        this.solicitacaoAlvaraRepository = solicitacaoAlvaraRepository;
        this.logradouroService = logradouroService;
        this.loteamentoService = loteamentoService;
        this.condominioService = condominioService;
        this.parametroGeralService = parametroGeralService;
    }
}

