/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.repository.simam.ErrosImportacaoSIMAMCustomRepository;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ValidaRegrasImportacaoSimAMJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final ErrosImportacaoSIMAMCustomRepository errosImportacaoSIMAMRepository;
    @Qualifier(value="validaRegrasImportacaoSimAmJob")
    private final Job validaRegrasImportacaoSimAMJob;

    public ValidaRegrasImportacaoSimAMJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="validaRegrasImportacaoSimAmJob") Job validaRegrasImportacaoSimAMJob, ErrosImportacaoSIMAMCustomRepository errosImportacaoSIMAMRepository) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.validaRegrasImportacaoSimAMJob = validaRegrasImportacaoSimAMJob;
        this.errosImportacaoSIMAMRepository = errosImportacaoSIMAMRepository;
    }

    public JobExecution startJob(LocalDate dataInicial, LocalDate dataFinal, Long entidade, Long exercicio) {
        this.validaSeExisteJobNaoFinalizado(dataInicial, dataFinal, entidade, exercicio);
        this.errosImportacaoSIMAMRepository.clearErrosImportacao(dataInicial, dataFinal);
        JobParameters jobParameters = this.createJobParameters(dataInicial, dataFinal, entidade, exercicio);
        return this.startJob(jobParameters);
    }

    private JobExecution startJob(JobParameters jobParameters) {
        try {
            return this.jobLauncher.run(this.validaRegrasImportacaoSimAMJob, jobParameters);
        }
        catch (Exception e) {
            throw new EloValidationException(String.format("Erro ao executar o job de valida\u00e7\u00e3o das regras de importa\u00e7\u00e3o do SIMAM. %s", e.getMessage()));
        }
    }

    private JobParameters createJobParameters(LocalDate dataInicial, LocalDate dataFinal, Long entidade, Long exercicio) {
        return new JobParametersBuilder().addDate("dataInicial", DateUtils.localDateToDate((LocalDate)dataInicial)).addDate("dataFinal", DateUtils.localDateToDate((LocalDate)dataFinal)).addLong("entidade", entidade).addDate("dataReferencia", new Date()).addLong("exercicio", exercicio).toJobParameters();
    }

    private void validaSeExisteJobNaoFinalizado(LocalDate dataInicial, LocalDate dataFinal, Long entidade, Long exercicio) {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.VALIDA_REGRAS_IMPORTACAO_SIMAM.getTipo()).stream().anyMatch(job -> dataInicial.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataInicial")))) && dataFinal.equals(DateUtils.dateToLocalDate((Date)Objects.requireNonNull(job.getJobParameters().getDate("dataFinal")))) && entidade.equals(Objects.requireNonNull(job.getJobParameters().getLong("entidade"))) && exercicio.equals(Objects.requireNonNull(job.getJobParameters().getLong("exercicio"))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe uma execu\u00e7\u00e3o do job com os mesmos par\u00e2metros em andamento.");
        }
    }
}

