/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.rsql.RsqlSpecification;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoDebitoID;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.EnvioProtestoRemessaDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.LoteBatchInstanceDTO;
import br.com.elotech.tributos.dto.ProtestoDTO;
import br.com.elotech.tributos.dto.documento.GeracaoDocumentoSimplificadoRequest;
import br.com.elotech.tributos.enums.SituacaoProtesto;
import br.com.elotech.tributos.repository.DebitoParcelaRepository;
import br.com.elotech.tributos.repository.JobLoteProtestoRepository;
import br.com.elotech.tributos.repository.ProtestoRemessaItemRepository;
import br.com.elotech.tributos.repository.ProtestoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProtestoService
extends CrudService<Protesto, Long> {
    private final ProtestoRepository protestoRepository;
    private final ProtestoRemessaItemRepository protestoRemessaItemRepository;
    private final EntityManager em;
    private JobLoteProtestoRepository jobLoteProtestoRepository;
    private final ResolversHandler resolversHandler;
    private final ParametroGeralService parametroGeralService;
    private final DebitoParcelaRepository debitoParcelaRepository;
    private final DocumentoService documentoService;

    public void saveAll(List<Protesto> protestos) {
        this.protestoRepository.saveAll(protestos);
    }

    public Long findNextProtesto(Long exercicio) {
        Long numeroProtesto = this.protestoRepository.findNextProtesto(exercicio);
        return Optional.ofNullable(numeroProtesto).orElse(1L);
    }

    public Optional<Protesto> findByDocumento(Documento documento) {
        return this.protestoRepository.findByDocumento(documento);
    }

    public Page<ProtestoDTO> getProtestos(Optional<String> search, Pageable pageable) {
        Page result = search.isPresent() ? this.protestoRepository.findAll((Specification)new RsqlSpecification(this.em, search.get(), Optional.empty()), pageable) : this.protestoRepository.findAll(pageable);
        return result.map(arg_0 -> this.buildProtestoDTO(arg_0));
    }

    private ProtestoDTO buildProtestoDTO(Protesto protesto) {
        ProtestoDTO protestoDTO = ProtestoDTO.from((Protesto)protesto);
        this.fillRemessaInfoIfRemessaExists(protesto, protestoDTO);
        return protestoDTO;
    }

    private void fillRemessaInfoIfRemessaExists(Protesto protesto, ProtestoDTO protestoDTO) {
        List remessas = this.protestoRemessaItemRepository.findByProtesto(protesto);
        if (!remessas.isEmpty() && remessas.stream().noneMatch(remessa -> SituacaoProtesto.CANCELADO.equals((Object)remessa.getProtesto().getSituacao()))) {
            protestoDTO.setRemessa(((ProtestoRemessaItem)remessas.get(0)).getProtestoRemessa().getId());
            protestoDTO.setExercicioRemessa(((ProtestoRemessaItem)remessas.get(0)).getProtestoRemessa().getExercicio());
        }
    }

    public void validaDebitoProtestado(List<BoletoDebito> boletoDebitos) {
        if (Objects.isNull(boletoDebitos)) {
            return;
        }
        boletoDebitos.stream().map(BoletoDebito::getId).map(BoletoDebitoID::getDebitoParcelaTributo).map(DebitoParcelaTributo::getDebitoParcela).forEach(arg_0 -> this.validaDebitoProtestado(arg_0));
    }

    public void validaDebitosProtestados(List<DebitoParcela> debitoParcelas) {
        if (Objects.isNull(debitoParcelas)) {
            return;
        }
        debitoParcelas.forEach(arg_0 -> this.validaDebitoProtestado(arg_0));
    }

    public void validaDebitoProtestado(DebitoParcela debitoParcela) {
        Integer diasBloqueioDebitoProtesto = this.parametroGeralService.getParamValueAsInteger(ParametroGeralEnum.DIAS_BLOQ_DEB_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        this.validaDebitoProtestado(debitoParcela, diasBloqueioDebitoProtesto);
    }

    public void validaDebitoProtestado(DebitoParcela debitoParcela, Integer diasBloqueioDebitoProtesto) {
        LocalDate dataEmissaoProtesto;
        if (Objects.isNull(diasBloqueioDebitoProtesto)) {
            return;
        }
        if (Objects.isNull(debitoParcela) || Objects.isNull(debitoParcela.getIdProtesto()) || !debitoParcela.getSituacaoDebito().isAberto().booleanValue()) {
            return;
        }
        Optional protesto = this.protestoRepository.findById((Object)debitoParcela.getIdProtesto());
        if (protesto.isEmpty()) {
            return;
        }
        if (((Protesto)protesto.get()).isProtestado() && (dataEmissaoProtesto = ((Protesto)protesto.get()).getDataEmissao()).plusDays(diasBloqueioDebitoProtesto.intValue()).isBefore(LocalDate.now())) {
            throw new EloValidationException(String.format("O d\u00e9bito do exerc\u00edcio: %d, guia: %d, sub: %d, parc: %d do cadastro %d-%d foi protestado no dia %s e n\u00e3o pode ser movimentado.", debitoParcela.getId().getExercicio(), debitoParcela.getId().getDivida(), debitoParcela.getId().getSubDivida(), debitoParcela.getId().getParcela(), debitoParcela.getId().getTipoCadastro(), debitoParcela.getId().getCadastroGeral(), dataEmissaoProtesto.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"))));
        }
    }

    public void validaDebitoProtestadoList(List<DebitoParcela> debitoParcelaList) {
        Integer diasBloqueioDebitoProtesto = this.parametroGeralService.getParamValueAsInteger(ParametroGeralEnum.DIAS_BLOQ_DEB_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        this.validaDebitoProtestadoList(debitoParcelaList, diasBloqueioDebitoProtesto);
    }

    public void validaDebitoProtestadoList(List<DebitoParcela> debitoParcelaList, Integer diasBloqueioDebitoProtesto) {
        if (Objects.isNull(diasBloqueioDebitoProtesto) || Objects.isNull(debitoParcelaList) || debitoParcelaList.isEmpty()) {
            return;
        }
        List filteredDebitoParcelaList = debitoParcelaList.stream().filter(debitoParcela -> Objects.nonNull(debitoParcela.getIdProtesto()) && debitoParcela.getSituacaoDebito().isAberto() != false).collect(Collectors.toList());
        if (filteredDebitoParcelaList.isEmpty()) {
            return;
        }
        Set idsProtestos = filteredDebitoParcelaList.stream().map(DebitoParcela::getIdProtesto).collect(Collectors.toSet());
        List protestos = this.protestoRepository.findByIdIn(idsProtestos);
        if (Objects.isNull(protestos) || protestos.isEmpty()) {
            return;
        }
        protestos.forEach(protesto -> {
            LocalDate dataEmissaoProtesto;
            if (protesto.isProtestado() && (dataEmissaoProtesto = protesto.getDataEmissao()).plusDays(diasBloqueioDebitoProtesto.intValue()).isBefore(LocalDate.now())) {
                filteredDebitoParcelaList.forEach(debitoParcela -> {
                    if (debitoParcela.getIdProtesto().equals(protesto.getProtesto())) {
                        throw new EloValidationException(String.format("O d\u00e9bito do exerc\u00edcio: %d, guia: %d, sub: %d, parc: %d do cadastro %d-%d foi protestado no dia %s e n\u00e3o pode ser movimentado.", debitoParcela.getId().getExercicio(), debitoParcela.getId().getDivida(), debitoParcela.getId().getSubDivida(), debitoParcela.getId().getParcela(), debitoParcela.getId().getTipoCadastro(), debitoParcela.getId().getCadastroGeral(), dataEmissaoProtesto.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"))));
                    }
                });
            }
        });
    }

    public Page<LoteBatchInstanceDTO> getLoteProtestos(Optional<String> search, Pageable pageable) {
        return this.jobLoteProtestoRepository.getLoteProtestos(search, pageable);
    }

    public Page<ProtestoDTO> findProtestosByLote(Long idLote, Pageable pageable) {
        Page result = this.protestoRepository.findByBatchJobExecutionId(idLote, pageable);
        return result.map(ProtestoDTO::from);
    }

    public LoteBatchInstanceDTO findLoteProtestosByIdJob(Long idLote) {
        List loteBatchInstanceDTOS = this.jobLoteProtestoRepository.getLoteProtestosByIdJob(idLote);
        if (loteBatchInstanceDTOS.isEmpty()) {
            throw new EloValidationException("N\u00e3o encontrado Job com o ID informado.");
        }
        return (LoteBatchInstanceDTO)loteBatchInstanceDTOS.stream().findFirst().get();
    }

    public String getUrlArquivoAgrupadoProtesto(Long idProtesto) {
        try {
            Protesto protesto = (Protesto)this.protestoRepository.findOne((Object)idProtesto);
            ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + protesto.getIdTermoProtestoS3()));
            return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
        }
        catch (Exception exception) {
            throw new EloValidationException("Falha ao fazer o download no arquivo.");
        }
    }

    public void validateProtestosParaEnvio(EnvioProtestoRemessaDTO envioProtestoRemessaDTO) {
        if (envioProtestoRemessaDTO.getIdsProtesto().isEmpty()) {
            throw new EloValidationException("N\u00e3o est\u00e1 sendo enviado nenhum ID de protesto para gerar a remessa.");
        }
        List protestos = this.protestoRepository.findByIdIn(envioProtestoRemessaDTO.getIdsProtesto());
        protestos.forEach(protesto -> {
            if (Objects.isNull(protesto.getIdTermoProtestoS3())) {
                throw new EloValidationException(String.format("\u00c9 necess\u00e1rio gerar o documento para o protesto %d/%d antes de enviar para o CRA.", protesto.getProtesto(), protesto.getExercicio()));
            }
            if (SituacaoProtesto.GERADO.equals((Object)protesto.getSituacao())) {
                throw new EloValidationException(String.format("O protesto %d/%d j\u00e1 foi enviado para o CRA.", protesto.getProtesto(), protesto.getExercicio()));
            }
        });
    }

    public byte[] findTermoProtestoS3(Protesto protesto) {
        ArquivoFindRequest arquivoFindRequest = ArquivoFindRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + protesto.getIdTermoProtestoS3()));
        try {
            return ((ArquivoContent)this.resolveArquivoClient().buscarArquivo(arquivoFindRequest).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o termo para o protesto com n\u00famero %s da entidade %s no exerc\u00edcio de %s, verifique se foi gerado o termo para esse protesto.", protesto.getProtesto(), protesto.getEntidade(), protesto.getExercicio())))).getContent().readAllBytes();
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao buscar termo de protesto. " + e.getMessage());
        }
    }

    @Transactional
    public void cancelarProtesto(Long idProtesto) {
        Protesto protesto = (Protesto)this.protestoRepository.findById((Object)idProtesto).orElseThrow(() -> new EloValidationException(String.format("Protesto com id %d n\u00e3o encontrado.", idProtesto)));
        if (Objects.nonNull(protesto.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel cancelar o protesto na situa\u00e7\u00e3o %s", protesto.getSituacao().getDescricao()));
        }
        this.protestoRepository.save((Object)protesto.cancelar());
        this.debitoParcelaRepository.findByIdProtesto(idProtesto).forEach(parcela -> {
            parcela.setIdProtesto(null);
            this.debitoParcelaRepository.save(parcela);
        });
    }

    @Transactional
    public ImpressaoDTO imprimeDocumentoAnuencia(GeracaoDocumentoSimplificadoRequest request) {
        Protesto protesto = (Protesto)this.findById((Serializable)request.getId()).orElseThrow(() -> new EloValidationException("Protesto n\u00e3o encontrado"));
        if (!protesto.getSituacao().equals((Object)SituacaoProtesto.GERADO)) {
            throw new EloValidationException("S\u00f3 \u00e9 permitida a gera\u00e7\u00e3o de Documento de Anu\u00eancia para protestos com a situa\u00e7\u00e3o 'Gerado'.");
        }
        if (Objects.nonNull(protesto.getDocumentoAnuencia())) {
            DocumentoDTO dto = DocumentoDTO.from((Documento)protesto.getDocumentoAnuencia());
            dto.setUrl(this.documentoService.fetchDocumento(dto, null));
            return ImpressaoDTO.from((Long)dto.getId(), (String)dto.getUrl());
        }
        DocumentoGenericoDTO documentoGenerico = this.getDocumentoGenericoDTO(protesto, request);
        DocumentoDTO documentoDTO = this.documentoService.gerar(documentoGenerico, TipoDocumentoEnum.DECLARACAO_DE_ANUENCIA);
        if (Objects.nonNull(documentoDTO)) {
            protesto.setDocumentoAnuencia(this.documentoService.getDocumentoByCodigoValidacao(documentoDTO.getCodigoValidacao()));
            this.save((EloEntity)protesto, null);
            documentoDTO.setUrl(this.documentoService.fetchDocumento(documentoDTO, null));
            return ImpressaoDTO.from((Long)documentoDTO.getId(), (String)documentoDTO.getUrl());
        }
        throw new EloValidationException("Erro ao tentar gerar Documento de Anu\u00eancia");
    }

    public void verificaDebitosBaixados(Long idProtesto) {
        boolean todosDebitosBaixados = this.protestoRepository.verificaSeTodosDebitosEstaoBaixados(idProtesto);
        if (!todosDebitosBaixados) {
            throw new RestException(HttpStatus.PRECONDITION_FAILED, "Este Protesto possui d\u00e9bitos em aberto");
        }
    }

    private DocumentoGenericoDTO getDocumentoGenericoDTO(Protesto protesto, GeracaoDocumentoSimplificadoRequest request) {
        DocumentoGenericoDTO documentoGenerico = new DocumentoGenericoDTO();
        documentoGenerico.setIdCadastro(protesto.getDocumento().getCadastroGeral().getId());
        documentoGenerico.setCodigoPessoa(protesto.getDocumento().getPessoa().getId());
        documentoGenerico.setTipoPessoa(protesto.getDocumento().getPessoa().getTipoPessoa());
        documentoGenerico.setPessoaNome(request.getNomeRequerente());
        documentoGenerico.setPessoaCpfCnpj(request.getCpfCnpjRequerente());
        documentoGenerico.setFinalidade(Long.valueOf(0L));
        documentoGenerico.setUsuario(SecurityUtils.getUserAise());
        documentoGenerico.setObservacao(request.getObservacao());
        return documentoGenerico;
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    @Generated
    public ProtestoService(ProtestoRepository protestoRepository, ProtestoRemessaItemRepository protestoRemessaItemRepository, EntityManager em, JobLoteProtestoRepository jobLoteProtestoRepository, ResolversHandler resolversHandler, ParametroGeralService parametroGeralService, DebitoParcelaRepository debitoParcelaRepository, DocumentoService documentoService) {
        this.protestoRepository = protestoRepository;
        this.protestoRemessaItemRepository = protestoRemessaItemRepository;
        this.em = em;
        this.jobLoteProtestoRepository = jobLoteProtestoRepository;
        this.resolversHandler = resolversHandler;
        this.parametroGeralService = parametroGeralService;
        this.debitoParcelaRepository = debitoParcelaRepository;
        this.documentoService = documentoService;
    }
}

