/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.dto.ObservacaoRestritivaDTO;
import br.com.elotech.tributos.dto.ProtestoRemessaItemDTO;
import br.com.elotech.tributos.dto.ProtestoRemessaResumoDTO;
import br.com.elotech.tributos.enums.SituacaoProtestoTipoRemessa;
import br.com.elotech.tributos.repository.ProtestoRemessaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralObservacaoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ProtestoRemessaItemService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityExistsException;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ProtestoRemessaService
extends CrudService<ProtestoRemessa, Long> {
    private final ContextService contextService;
    private final ProtestoRemessaRepository protestoRemessaRepository;
    private final ProtestoRemessaItemService processoRemessaItemService;
    private final ResolversHandler resolversHandler;
    private final CadastroGeralObservacaoService cadastroGeralObservacaoService;

    public ProtestoRemessa createAndSave() {
        Long exercicioAtual = this.contextService.getExercicioAtual();
        Long entidadePrincipal = this.contextService.getEntidadePrincipal();
        ProtestoRemessa protestoRemessa = new ProtestoRemessa();
        protestoRemessa.setEntidade(entidadePrincipal);
        protestoRemessa.setExercicio(exercicioAtual);
        protestoRemessa.setUsuario(SecurityUtils.getUserName());
        protestoRemessa.setTipoRemessa(SituacaoProtestoTipoRemessa.R);
        return (ProtestoRemessa)this.protestoRemessaRepository.save((Object)protestoRemessa);
    }

    public Long getQtdRemessaPorData(LocalDate data, SituacaoProtestoTipoRemessa tipoRemessa) {
        return this.protestoRemessaRepository.getQtdRemessaPorData(data, tipoRemessa);
    }

    public ProtestoRemessaResumoDTO getProtestoRemessaResumo(Long id) {
        ProtestoRemessa protestoRemessa = (ProtestoRemessa)this.protestoRemessaRepository.findById((Object)id).orElseThrow(() -> new EntityExistsException(String.format("Remessa de protesto com ID %s n\u00e3o encontrada", id)));
        List protestoRemessaItens = this.processoRemessaItemService.findByProtestoRemessaAndBuildProtestoRemessaItemDTO(protestoRemessa);
        List observacoes = this.findObservacoesByProtestoRemessaItens(protestoRemessaItens);
        return new ProtestoRemessaResumoDTO(protestoRemessa, protestoRemessaItens, observacoes);
    }

    public List<ObservacaoRestritivaDTO> findObservacoesByProtestoRemessaItens(List<ProtestoRemessaItemDTO> protestoRemessaItens) {
        return protestoRemessaItens.stream().filter(item -> item.getCadastroGeral() != null).map(item -> this.cadastroGeralObservacaoService.findObsRestritiva(item.getCadastroGeral())).filter(ObservacaoRestritivaDTO::getExisteRestricao).collect(Collectors.toList());
    }

    public void downloadArquivo(HttpServletResponse response, Long idProtesto) throws IOException {
        ProtestoRemessa protestoRemessa = (ProtestoRemessa)this.protestoRemessaRepository.findById((Object)idProtesto).orElseThrow(() -> new EntityExistsException(String.format("Protesto de Remessa com ID %s n\u00e3o encontrado para realizar download de arquivo de envio.", idProtesto)));
        if (protestoRemessa.getArqenvArquivo() == null) {
            throw new EloValidationException(String.format("Arquivo de envio da remessa com ID %s n\u00e3o encontrado", idProtesto));
        }
        response.setHeader("Content-Disposition", "attachment; filename=" + protestoRemessa.getArqenvArquivonome());
        response.setHeader("Content-Type", "application/xml");
        response.setHeader("Content-Length", String.valueOf(protestoRemessa.getArqenvArquivo().length));
        response.getOutputStream().write(protestoRemessa.getArqenvArquivo());
    }

    public String getUrlArquivoEnvioRemessa(String idArquivo) {
        ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + idArquivo));
        return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
    }

    public ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    @Generated
    public ProtestoRemessaService(ContextService contextService, ProtestoRemessaRepository protestoRemessaRepository, ProtestoRemessaItemService processoRemessaItemService, ResolversHandler resolversHandler, CadastroGeralObservacaoService cadastroGeralObservacaoService) {
        this.contextService = contextService;
        this.protestoRemessaRepository = protestoRemessaRepository;
        this.processoRemessaItemService = processoRemessaItemService;
        this.resolversHandler = resolversHandler;
        this.cadastroGeralObservacaoService = cadastroGeralObservacaoService;
    }
}

