/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CadastroImobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.CalculoResultadoDTO;
import br.com.elotech.tributos.calculo.dto.ImobiliarioSegmentoDTO;
import br.com.elotech.tributos.calculo.dto.InconsistenciaCalculoDTO;
import br.com.elotech.tributos.calculo.service.CalculoAvaliacaoExecucaoService;
import br.com.elotech.tributos.calculo.service.CalculoAvaliacaoService;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacao;
import br.com.elotech.tributos.dto.ValoresAvaliacaoImobiliarioDTO;
import br.com.elotech.tributos.dto.ValoresImobiliarioSegmentoDTO;
import br.com.elotech.tributos.params.ImobiliarioSegmentoParams;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ImobiliarioAvaliacaoValoresService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!onpremise"})
public class OxyImobiliarioAvaliacaoValoresService
implements ImobiliarioAvaliacaoValoresService {
    private final CalculoAvaliacaoExecucaoService calculoAvaliacaoExecucaoService;
    private final CalculoAvaliacaoService calculoAvaliacaoService;
    private final ContextService contextService;

    public ValoresAvaliacaoImobiliarioDTO calcularValoresAvaliacao(Long tipoCadastro, Long cadastroGeral) {
        if (TipoCadastro.RURAL.getValue().equals(tipoCadastro)) {
            return new ValoresAvaliacaoImobiliarioDTO();
        }
        Long exercicio = this.contextService.getExercicioAtual();
        CalculoAvaliacao avaliacao = (CalculoAvaliacao)this.calculoAvaliacaoService.findByEntidadeAndExercicio(this.contextService.getEntidadePrincipal(), exercicio).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrada configura\u00e7\u00e3o de c\u00e1lculo de avalia\u00e7\u00e3o para o exerc\u00edcio de %d.", exercicio)));
        String filtro = String.format("cadastrogeral.tipocadastro = %d and cadastrogeral.cadastrogeral = %d", tipoCadastro, cadastroGeral);
        List result = this.calculoAvaliacaoExecucaoService.calcular(Collections.singletonList(avaliacao), exercicio, filtro, Boolean.valueOf(false), LocalDate.now());
        if (result.isEmpty()) {
            throw new EloValidationException(String.format("Falha ao calcular a avalia\u00e7\u00e3o do cadastro geral %d/%d.", tipoCadastro, cadastroGeral));
        }
        return this.parseResultado((CadastroCalculoRoot)result.get(0), avaliacao);
    }

    public ValoresAvaliacaoImobiliarioDTO calcularValoresSegmento(ImobiliarioSegmentoParams params) {
        if (TipoCadastro.RURAL.getValue().equals(params.getTipoCadastro())) {
            return new ValoresAvaliacaoImobiliarioDTO();
        }
        Long exercicio = this.contextService.getExercicioAtual();
        CalculoAvaliacao avaliacao = (CalculoAvaliacao)this.calculoAvaliacaoService.findByEntidadeAndExercicio(this.contextService.getEntidadePrincipal(), exercicio).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrada configura\u00e7\u00e3o de c\u00e1lculo de avalia\u00e7\u00e3o para o exerc\u00edcio de %d.", exercicio)));
        CadastroCalculoRoot result = this.calculoAvaliacaoExecucaoService.calcularSegmentoComAreaAlterada(avaliacao, params);
        return this.parseResultado(result, avaliacao);
    }

    private ValoresAvaliacaoImobiliarioDTO parseResultado(CadastroCalculoRoot root, CalculoAvaliacao calculoAvaliacao) {
        if (!root.getInconsistencias().isEmpty()) {
            String inconsistencias = root.getInconsistencias().stream().map(InconsistenciaCalculoDTO::getMessage).collect(Collectors.joining(", "));
            throw new EloValidationException(String.format("Erro ao realizar o c\u00e1lculo de avalia\u00e7\u00e3o: %s", inconsistencias));
        }
        ValoresAvaliacaoImobiliarioDTO dto = new ValoresAvaliacaoImobiliarioDTO();
        Optional<CalculoResultadoDTO> resultadoGeral = Optional.ofNullable((CalculoResultadoDTO)root.getResultadoAvaliacao().get(calculoAvaliacao));
        resultadoGeral.ifPresent(resultado -> {
            Optional.ofNullable(resultado.getValorVenalPredial()).map(BigDecimal::valueOf).map(arg_0 -> this.arredondaValor(arg_0)).ifPresent(arg_0 -> ((ValoresAvaliacaoImobiliarioDTO)dto).setValorVenalPredial(arg_0));
            Optional.ofNullable(resultado.getValorVenalTerritorial()).map(BigDecimal::valueOf).map(arg_0 -> this.arredondaValor(arg_0)).ifPresent(arg_0 -> ((ValoresAvaliacaoImobiliarioDTO)dto).setValorVenalTerritorial(arg_0));
            Optional.ofNullable(resultado.getValorVenalPredialITBI()).map(BigDecimal::valueOf).map(arg_0 -> this.arredondaValor(arg_0)).ifPresent(arg_0 -> ((ValoresAvaliacaoImobiliarioDTO)dto).setValorVenalPredialITBI(arg_0));
            Optional.ofNullable(resultado.getValorVenalTerritorialITBI()).map(BigDecimal::valueOf).map(arg_0 -> this.arredondaValor(arg_0)).ifPresent(arg_0 -> ((ValoresAvaliacaoImobiliarioDTO)dto).setValorVenalTerritorialITBI(arg_0));
        });
        List segmentos = root.getChildren().stream().map(child -> {
            ImobiliarioSegmentoDTO segmento = ((CadastroImobiliarioCalculoDTO)child).getSegmento();
            CalculoResultadoDTO resultadoSegmento = (CalculoResultadoDTO)child.getResultadoAvaliacao().get(calculoAvaliacao);
            BigDecimal valorVenalPredial = Optional.ofNullable(resultadoSegmento).map(CalculoResultadoDTO::getValorVenalPredial).map(BigDecimal::valueOf).map(arg_0 -> this.arredondaValor(arg_0)).orElse(BigDecimal.ZERO);
            BigDecimal valorVenalPredialItbi = Optional.ofNullable(resultadoSegmento).map(CalculoResultadoDTO::getValorVenalPredialITBI).map(BigDecimal::valueOf).map(arg_0 -> this.arredondaValor(arg_0)).orElse(BigDecimal.ZERO);
            dto.setValorVenalPredial(dto.getValorVenalPredial().add(valorVenalPredial));
            dto.setValorVenalPredialITBI(dto.getValorVenalPredialITBI().add(valorVenalPredialItbi));
            Optional.ofNullable(resultadoSegmento).map(CalculoResultadoDTO::getValorVenalTerritorial).map(BigDecimal::valueOf).map(arg_0 -> this.arredondaValor(arg_0)).ifPresent(valorVenalTerritorial -> dto.setValorVenalTerritorial(dto.getValorVenalTerritorial().add((BigDecimal)valorVenalTerritorial)));
            Optional.ofNullable(resultadoSegmento).map(CalculoResultadoDTO::getValorVenalTerritorialITBI).map(BigDecimal::valueOf).map(arg_0 -> this.arredondaValor(arg_0)).ifPresent(valorVenalTerritorialItbi -> dto.setValorVenalTerritorialITBI(dto.getValorVenalTerritorialITBI().add((BigDecimal)valorVenalTerritorialItbi)));
            if (Objects.isNull(segmento.getIdsegmento())) {
                return null;
            }
            ValoresImobiliarioSegmentoDTO segmentoDto = new ValoresImobiliarioSegmentoDTO();
            segmentoDto.setSequencia(Integer.valueOf(segmento.getSequencia().intValue()));
            segmentoDto.setTipoSegmento(Integer.valueOf(segmento.getTiposegmento().intValue()));
            segmentoDto.setDescricaoTipoSegmento(segmento.getDescricaotiposegmento());
            segmentoDto.setAreaConstruida(BigDecimal.valueOf(segmento.getAreaconstruida()));
            segmentoDto.setValorVenalPredial(valorVenalPredial);
            segmentoDto.setValorVenalPredialItbi(valorVenalPredialItbi);
            return segmentoDto;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        dto.setSegmentos(segmentos);
        return dto;
    }

    private BigDecimal arredondaValor(BigDecimal valor) {
        return valor.setScale(2, RoundingMode.HALF_EVEN);
    }

    @Generated
    public OxyImobiliarioAvaliacaoValoresService(CalculoAvaliacaoExecucaoService calculoAvaliacaoExecucaoService, CalculoAvaliacaoService calculoAvaliacaoService, ContextService contextService) {
        this.calculoAvaliacaoExecucaoService = calculoAvaliacaoExecucaoService;
        this.calculoAvaliacaoService = calculoAvaliacaoService;
        this.contextService = contextService;
    }
}

