/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlSpecification;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoHistoricoSituacao;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtivaId;
import br.com.elotech.tributos.domain.GrupoDocumento;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.ArquivoUnicoSalvarDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoFinalidadeDTO;
import br.com.elotech.tributos.dto.DocumentoFinalidadeTributosDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.GeracaoDocumentoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.RelatorioImpressaoDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoDocumentoDTO;
import br.com.elotech.tributos.dto.documento.peticao.ExecucaoPeticaoResponseDTO;
import br.com.elotech.tributos.dto.mobile.DocumentoMobileDTO;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.DocumentoHistoricoSituacaoRepository;
import br.com.elotech.tributos.repository.DocumentoRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.projections.DocumentoProjection;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoUnicoService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoFinalidadeService;
import br.com.elotech.tributos.service.GeraDocumentoService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.DocumentoNotFoundException;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.specs.DocumentoSpecifications;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.validation.Valid;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@Transactional
public class DocumentoService
extends CrudService<Documento, Long> {
    private final DocumentoRepository documentoRepository;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final AisePdfService aisePdfService;
    private final DocumentoHistoricoSituacaoRepository documentoHistoricoSituacaoRepository;
    private final CadastroImobiliarioService cadastroImobiliarioService;
    private final EntityManager em;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final PessoaService pessoaService;
    private final GeraDocumentoService geraDocumentoService;
    private final DocumentoFinalidadeService documentoFinalidadeService;
    private final ContextService contextService;
    private final ArquivoUnicoService arquivoUnicoService;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;

    public DocumentoService(DocumentoRepository documentoRepository, CadastroGeralRepository cadastroGeralRepository, AisePdfService aisePdfService, CadastroImobiliarioService cadastroImobiliarioService, DocumentoHistoricoSituacaoRepository documentoHistoricoSituacaoRepository, EntityManager em, SequenceGeneratorRepository sequenceGeneratorRepository, PessoaService pessoaService, GeraDocumentoService geraDocumentoService, DocumentoFinalidadeService documentoFinalidadeService, ContextService contextService, ArquivoUnicoService arquivoUnicoService, ArquivoStorageFeignClient arquivoStorageFeignClient) {
        this.documentoRepository = documentoRepository;
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.aisePdfService = aisePdfService;
        this.cadastroImobiliarioService = cadastroImobiliarioService;
        this.documentoHistoricoSituacaoRepository = documentoHistoricoSituacaoRepository;
        this.em = em;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.pessoaService = pessoaService;
        this.geraDocumentoService = geraDocumentoService;
        this.documentoFinalidadeService = documentoFinalidadeService;
        this.contextService = contextService;
        this.arquivoUnicoService = arquivoUnicoService;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
    }

    protected void beforeInsert(Documento documento) {
        Assert.notNull((Object)documento.getEntidade(), (String)"A propriedade 'entidade' n\u00e3o foi associada");
        Assert.notNull((Object)documento.getExercicio(), (String)"A propriedade 'exercicio' n\u00e3o foi associada");
        Assert.notNull((Object)documento.getDocumentoTipo(), (String)"A propriedade 'documentoTipo' n\u00e3o foi associada");
        super.beforeInsert((EloEntity)documento);
        documento.setDocumento(this.geraCodigoDocumento(documento));
        documento.setCodigoValidacao(DigestUtils.md5Hex((String)UUID.randomUUID().toString()).toUpperCase());
        if (Objects.isNull(documento.getDocumento())) {
            documento.setDocumento(this.geraCodigoDocumento(documento));
        }
        AtomicLong sequencia = new AtomicLong(1L);
        documento.getDocumentoItemDividaAtivas().forEach(item -> {
            if (Objects.isNull(item.getId())) {
                item.setId(DocumentoItemDividaAtivaId.of((Long)documento.getEntidade(), (Long)documento.getExercicio(), (Long)documento.getDocumento(), (Long)documento.getTipoDocumento(), (Long)sequencia.getAndIncrement()));
                item.setDocumento(documento);
            }
        });
    }

    public Documento getDocumentoByCodigoValidacao(String codigoValidacao) {
        return this.documentoRepository.findByCodigoValidacao(codigoValidacao);
    }

    public Page<ExecucaoPeticaoResponseDTO> getDocumentosExecucoesAtivas(String search, Pageable pageable) {
        Long SITUACAO_ATIVA = 1L;
        String searchFilter = String.format("tipoDocumento == %d and situacao.id == %d", TipoDocumentoEnum.PETICAO_DIVIDA_ATIVA.getCodigo(), SITUACAO_ATIVA);
        Page result = null;
        if (Objects.nonNull(search)) {
            searchFilter = searchFilter.concat(" and ").concat(search);
            result = this.documentoRepository.findAll((Specification)new RsqlSpecification(this.em, searchFilter, Optional.empty()), pageable);
        } else {
            result = this.documentoRepository.findAll(pageable);
        }
        return result.map(ExecucaoPeticaoResponseDTO::from);
    }

    public Page<DocumentoDTO> getDocumentos(Optional<String> search, Pageable pageable) {
        Page result = search.isPresent() ? this.documentoRepository.findAll((Specification)new RsqlSpecification(this.em, search.get(), Optional.empty()), pageable) : this.documentoRepository.findAll(pageable);
        return result.map(DocumentoDTO::from);
    }

    public DocumentoMobileDTO getDocumentoMobileDTO(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento documentoEntity = this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento);
        String urlImpressao = this.aisePdfService.fetchDocumento(documento, tipoDocumento, exercicio);
        DocumentoMobileDTO dto = new DocumentoMobileDTO(documentoEntity, urlImpressao);
        if (Optional.ofNullable(documentoEntity.getCadastroGeral()).isPresent() && documentoEntity.getCadastroGeral().getTipoCadastro().isImobiliario().booleanValue()) {
            Optional.ofNullable(this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(documentoEntity.getCadastroGeral().getTipoCadastro(), documentoEntity.getCadastroGeral().getCadastroGeral())).ifPresent(arg_0 -> ((DocumentoMobileDTO)dto).setCadastroImobiliarioEntity(arg_0));
        }
        return dto.from();
    }

    public DocumentoDTO getDocumentoDTO(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        Documento documentoEntity = this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento);
        String urlImpressao = this.aisePdfService.fetchDocumento(documento, tipoDocumento, exercicio);
        return DocumentoDTO.from((Documento)documentoEntity, (String)urlImpressao);
    }

    public Documento getDocumento(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        return Optional.ofNullable(this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Documento com o id '%d'.", documento)));
    }

    public DocumentoDTO getDocumentoDTO(Documento documento) {
        String urlImpressao = this.aisePdfService.fetchDocumento(documento.getDocumento(), documento.getTipoDocumento(), documento.getExercicio());
        return DocumentoDTO.from((Documento)documento, (String)urlImpressao);
    }

    public List<DocumentoProjection> getListDocumentoDTO(TipoCadastro tipoCadastro, Long cadastroGeral) {
        CadastroGeral cadastroGeralEntity = (CadastroGeral)this.cadastroGeralRepository.findOneByTipoCadastroAndCadastroGeralAndExclusaoLogicaFalse(tipoCadastro, cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(tipoCadastro, cadastroGeral));
        return this.documentoRepository.findByCadastroGeral(cadastroGeralEntity, LocalDate.now());
    }

    public Page<DocumentoDTO> findAllDocumentoByCpfCnpj(String cpfCnpj, LocalDate dataValidade, Optional<String> search, Pageable pageable) {
        Specification specification = DocumentoSpecifications.byImprimeWebAndCpfCnpjAndDataValidade((String)cpfCnpj, (LocalDate)dataValidade);
        if (search.isPresent()) {
            specification = specification.and(RsqlUtils.createSpecFrom((EntityManager)this.em, Documento.class, (String)search.get(), Optional.empty()));
        }
        return this.documentoRepository.findAll(specification, pageable).map(DocumentoDTO::from).map(dto -> {
            dto.setUrl(this.aisePdfService.fetchDocumento(dto.getDocumento(), dto.getTipoDocumento(), dto.getExercicio()));
            return dto;
        });
    }

    public DocumentoDTO findDocumentoById(Long id) {
        return this.documentoRepository.findById((Object)id).map(DocumentoDTO::from).orElseThrow(() -> new DocumentoNotFoundException(id));
    }

    public Documento cancelarDocumento(Long id, CancelamentoDocumentoDTO cancelamentoDocumentoDTO) {
        Documento documento = (Documento)this.documentoRepository.findById((Object)id).orElseThrow(() -> new DocumentoNotFoundException(id));
        if (documento.getCadastroGeral() != null && documento.getCadastroGeral().getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O cadastro %d-%d est\u00e1 em exclus\u00e3o l\u00f3gica.", documento.getCadastroGeral().getTipoCadastro().getValue(), documento.getCadastroGeral().getCadastroGeral()));
        }
        DocumentoHistoricoSituacao documentoHistoricoSituacao = new DocumentoHistoricoSituacao();
        documentoHistoricoSituacao.setDocumento(documento);
        documentoHistoricoSituacao.setData(LocalDate.now());
        documentoHistoricoSituacao.setObservacao(cancelamentoDocumentoDTO.getObservacao());
        documentoHistoricoSituacao.setSituacaoAnterior(documento.getSituacao());
        documentoHistoricoSituacao.setUsuario(documento.getUsuario());
        this.documentoHistoricoSituacaoRepository.save((Object)documentoHistoricoSituacao);
        documento.setCancelado(Boolean.TRUE);
        documento.setDataCancelamento(LocalDate.now());
        documento.setUsuarioCancelamento(SecurityUtils.getUserAise());
        documento.setSituacao(cancelamentoDocumentoDTO.getSituacao());
        documento.setObservacaoCancelamento(cancelamentoDocumentoDTO.getObservacao());
        return (Documento)this.documentoRepository.save((Object)documento);
    }

    private Long geraCodigoDocumento(Documento documento) {
        Long menorGrupoDocumentoId = documento.getDocumentoTipo().getGruposDocumento().stream().map(GrupoDocumento::getId).min(Long::compareTo).orElseThrow(() -> new EloValidationException("Tipo de Documento n\u00e3o possui Grupo cadastrado."));
        if (documento.getDocumentoTipo().getGruposDocumento().stream().anyMatch(GrupoDocumento::getSequenciaPorExercicio)) {
            return this.sequenceGeneratorRepository.getNextVal(String.format("S05documentoGrupo_%d_%d_%d", documento.getEntidade(), documento.getExercicio(), menorGrupoDocumentoId));
        }
        return this.sequenceGeneratorRepository.getNextVal(String.format("S05documentoGrupo_%d_%d", documento.getEntidade(), menorGrupoDocumentoId));
    }

    public DocumentoGenericoDTO getInitialValues(@Valid DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO, TipoDocumentoEnum tipoDocumentoEnum) {
        Boolean isPorContribuinte = documentoSearchInitialValuesDTO.getTipoFiltro().isPorContribuinte();
        Boolean isAtendimentoPresencial = documentoSearchInitialValuesDTO.getTipoAtendimento() != null ? documentoSearchInitialValuesDTO.getTipoAtendimento().isPresencial() : false;
        Boolean isAtendimentoTelefone = documentoSearchInitialValuesDTO.getTipoAtendimento() != null ? documentoSearchInitialValuesDTO.getTipoAtendimento().isTelefone() : false;
        DocumentoGenericoDTO valoresIniciais = new DocumentoGenericoDTO();
        valoresIniciais.setCodigoPessoa(isPorContribuinte != false ? this.getContribuinteFromRequest(documentoSearchInitialValuesDTO) : this.getPessoaFromRequest(documentoSearchInitialValuesDTO));
        if (documentoSearchInitialValuesDTO.getIdCadastro() != null) {
            valoresIniciais.setIdCadastro(documentoSearchInitialValuesDTO.getIdCadastro());
        }
        if (isAtendimentoPresencial.booleanValue() || isAtendimentoTelefone.booleanValue()) {
            valoresIniciais.setPessoaNome(documentoSearchInitialValuesDTO.getNomeRequerente());
            valoresIniciais.setPessoaCpfCnpj(documentoSearchInitialValuesDTO.getCpfCnpjRequerente());
            valoresIniciais.setTipoPessoa(this.getTipoPessoaByCpfCnpj(documentoSearchInitialValuesDTO.getCpfCnpjRequerente()));
        } else {
            Optional.ofNullable(this.pessoaService.findOne(valoresIniciais.getCodigoPessoa())).ifPresent(pessoa -> {
                valoresIniciais.setPessoaNome(pessoa.getNome());
                valoresIniciais.setPessoaCpfCnpj(pessoa.getCnpjCpf());
                valoresIniciais.setTipoPessoa(pessoa.getTipoPessoa());
            });
        }
        valoresIniciais.setFinalidadesDisponiveis(this.getFinalidadesAtivasOrdenadas(tipoDocumentoEnum));
        valoresIniciais.setFinalidade((Long)valoresIniciais.getFinalidadesDisponiveis().stream().map(DocumentoFinalidadeDTO::getId).findFirst().orElse(null));
        return valoresIniciais;
    }

    private Long getContribuinteFromRequest(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return documentoSearchInitialValuesDTO.getContribuinte().getId();
    }

    private Long getPessoaFromRequest(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ((CadastroGeral)this.cadastroGeralRepository.findById((Object)documentoSearchInitialValuesDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral %d n\u00e3o encontrado", documentoSearchInitialValuesDTO.getIdCadastro())))).getPessoa().getId();
    }

    private List<DocumentoFinalidadeDTO> getFinalidadesAtivasOrdenadas(TipoDocumentoEnum tipoDocumentoEnum) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        return this.documentoFinalidadeService.getListDTO(entidade, exercicio, tipoDocumentoEnum.getValue()).stream().map(DocumentoFinalidadeTributosDTO::from).collect(Collectors.toList());
    }

    public TipoPessoa getTipoPessoaByCpfCnpj(String cpfCnpj) {
        if (cpfCnpj.trim().length() > 11) {
            return TipoPessoa.JURIDICA;
        }
        return TipoPessoa.FISICA;
    }

    public DocumentoDTO gerar(@Valid DocumentoGenericoDTO documentoGenericoDTO, TipoDocumentoEnum tipoDocumento) {
        GeracaoDocumentoDTO geracaoDocumentoDTO = this.getGeracaoDocumentoDTO(documentoGenericoDTO, tipoDocumento);
        Documento documento = this.geraDocumentoService.getDocumentoAndValida(geracaoDocumentoDTO);
        documento.setSubTipo(documentoGenericoDTO.getSubTipo());
        return DocumentoDTO.from((Documento)((Documento)this.save((EloEntity)documento, null)));
    }

    private GeracaoDocumentoDTO getGeracaoDocumentoDTO(@Valid DocumentoGenericoDTO documentoGenericoDTO, TipoDocumentoEnum tipoDocumento) {
        if (documentoGenericoDTO.getPorCadastro().booleanValue()) {
            if (Objects.isNull(documentoGenericoDTO.getIdCadastro())) {
                throw new EloValidationException("Cadastro Geral \u00e9 obrigat\u00f3rio");
            }
            CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralRepository.findById((Object)documentoGenericoDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral %d n\u00e3o encontrado", documentoGenericoDTO.getIdCadastro())));
            return GeracaoDocumentoDTO.from((DocumentoGenericoDTO)documentoGenericoDTO, (CadastroGeral)cadastroGeral, (TipoDocumentoEnum)tipoDocumento);
        }
        if (Objects.isNull(documentoGenericoDTO.getCodigoPessoa())) {
            throw new EloValidationException("C\u00f3digo da pessoa \u00e9 obrigat\u00f3rio");
        }
        Pessoa pessoa = (Pessoa)this.pessoaService.findById(documentoGenericoDTO.getCodigoPessoa()).orElseThrow(() -> new EloValidationException(String.format("Pessoa %d n\u00e3o encontrada", documentoGenericoDTO.getCodigoPessoa())));
        return GeracaoDocumentoDTO.from((DocumentoGenericoDTO)documentoGenericoDTO, (Pessoa)pessoa, (TipoDocumentoEnum)tipoDocumento);
    }

    public Boolean existsDocumentoCDA(Long numero, Long exercicio) {
        return this.documentoRepository.existsDocumentoCDAByNumeroAndExercicio(numero, exercicio);
    }

    public Documento findDocumentoByEntidadeAndExercicioAndTipoDocumentoAndDocumento(Long entidade, Long exercicio, Long tipoDocumento, Long documento) {
        return this.documentoRepository.findByEntidadeTributacaoEntidadeIdAndEntidadeTributacaoExercicioAndTipoDocumentoAndDocumento(entidade, exercicio, tipoDocumento, documento);
    }

    public void removeDividaAtivaPeticao(Long id) {
        this.documentoRepository.removeDividaAtivaPeticao(id);
    }

    public String fetchDocumento(DocumentoDTO documento, RelatorioImpressaoDTO relatorio) {
        if (Objects.nonNull(relatorio) && relatorio.imprimePorLayoutSelecionado()) {
            return this.aisePdfService.fetchDocumentoPorRelatorio(documento.getDocumento(), documento.getTipoDocumento(), documento.getExercicio(), relatorio.getRelatorio(), relatorio.getTipoRelatorio());
        }
        return this.aisePdfService.fetchDocumento(documento.getDocumento(), documento.getTipoDocumento(), documento.getExercicio());
    }

    public ImpressaoDTO imprimirDocumento(Long id, RelatorioImpressaoDTO relatorioImpressao) throws IOException {
        Documento documento = (Documento)this.findOne((Serializable)id);
        String urlImpressao = this.getUrlImpressao(documento, relatorioImpressao);
        if (Boolean.TRUE.equals(documento.getDocumentoTipo().getArmazenarComoPdf()) && documento.getIdArquivoUnico() == null) {
            this.savePdfAsArquivoUnico(documento, this.fetchPdfFromUrl(urlImpressao));
        }
        return ImpressaoDTO.from((Long)documento.getId(), (String)urlImpressao);
    }

    public String getUrlImpressao(Documento documento, RelatorioImpressaoDTO relatorioImpressao) {
        if (Boolean.TRUE.equals(documento.getDocumentoTipo().getArmazenarComoPdf()) && documento.getIdArquivoUnico() != null) {
            ArquivoDTO arquivoDTO = this.arquivoStorageFeignClient.findOne(documento.getIdArquivoUnico());
            ArquivoUrl arquivoUrl = this.arquivoStorageFeignClient.getUrlDownload(arquivoDTO.getFullPath(), arquivoDTO.getNome());
            return arquivoUrl.getUrlAssinada();
        }
        DocumentoDTO documentoDTO = this.findDocumentoById(documento.getId());
        return this.fetchDocumento(documentoDTO, relatorioImpressao);
    }

    public void savePdfAsArquivoUnico(Documento documento, byte[] pdfBytes) {
        ArquivoUnicoSalvarDTO arquivoUnicoSalvarDTO = this.buildSalvarArquivoUnico(pdfBytes, documento);
        Long idArquivoUnico = this.arquivoUnicoService.salvarPDF(arquivoUnicoSalvarDTO);
        documento.setIdArquivoUnico(idArquivoUnico);
        this.save((EloEntity)documento, null);
    }

    public byte[] fetchPdfFromUrl(String pdfUrl) throws IOException {
        byte[] byArray;
        block9: {
            InputStream inputStream = new URL(pdfUrl).openStream();
            try {
                byArray = inputStream.readAllBytes();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    throw new EloValidationException("URL para impress\u00e3o do documento inv\u00e1lida.");
                }
                catch (IOException ex) {
                    throw new RuntimeException("Falha ao buscar o PDF.", ex);
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    public ArquivoUnicoSalvarDTO buildSalvarArquivoUnico(byte[] pdfBytes, Documento documento) {
        ArquivoUnicoSalvarDTO arquivoUnicoSalvarDTO = new ArquivoUnicoSalvarDTO();
        arquivoUnicoSalvarDTO.setContent(pdfBytes);
        arquivoUnicoSalvarDTO.setTipoArquivo(TipoArquivoEnum.OUTROS);
        arquivoUnicoSalvarDTO.setDiretorio("/documentos");
        arquivoUnicoSalvarDTO.setFileName("documento_" + documento.getId() + ".pdf");
        return arquivoUnicoSalvarDTO;
    }
}

