/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.MotivoExclusaoLogica;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.SituacaoMobiliario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSituacao;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscal;
import br.com.elotech.tributos.dto.CadastroAvulsoRowDTO;
import br.com.elotech.tributos.dto.CadastroGeralAcessoWebDTO;
import br.com.elotech.tributos.dto.CadastroGeralResponsavelDTO;
import br.com.elotech.tributos.dto.CadastroGeralResponseDTO;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.CadastroGeralRowDTO;
import br.com.elotech.tributos.dto.CadastroGeralSearchParamsDTO;
import br.com.elotech.tributos.dto.CadastroSearchDTO;
import br.com.elotech.tributos.dto.mobile.CadastroGeralMobileDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoCadastroDTO;
import br.com.elotech.tributos.enums.hibernatesearch.TipoCadastroIndexacao;
import br.com.elotech.tributos.hibernatesearch.domain.HibernateSearchParams;
import br.com.elotech.tributos.hibernatesearch.facet.FacetCadastroGeral;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.repository.projections.CadastroGeralResponsavelProjection;
import br.com.elotech.tributos.service.DebitoCotaUnicaService;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.HibernateSearchService;
import br.com.elotech.tributos.service.MotivoExclusaoLogicaService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.RegimeFiscalPeriodoService;
import br.com.elotech.tributos.service.ResponsavelCadastroService;
import br.com.elotech.tributos.service.exception.CadastroExclusaoLogicaException;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.MaskCnpjCpf;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import liquibase.util.StringUtils;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Service
@Transactional
public class CadastroGeralService
extends CrudService<CadastroGeral, Long> {
    private static final String RESPONSAVEL_PRINCIPAL_NOT_FOUND = "N\u00e3o existe um propriet\u00e1rio principal para o cadastro: %d-%d";
    private static final Long EXCLUSAO_LOGICA = 2L;
    private final ResponsavelCadastroService responsavelCadastroService;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final RegimeFiscalPeriodoService regimeFiscalPeriodoService;
    private final PessoaService pessoaService;
    private final HibernateSearchService hibernateSearchService;
    private final DebitoCotaUnicaService debitoCotaUnicaService;
    private final ParametroGeralService parametroGeralService;
    private final DebitoEmAbertoService debitoEmAbertoService;
    private final MotivoExclusaoLogicaService motivoExclusaoLogicaService;

    public CadastroGeralService(CadastroGeralRepository cadastroGeralRepository, ResponsavelCadastroService responsavelCadastroService, RegimeFiscalPeriodoService regimeFiscalPeriodoService, PessoaService pessoaService, HibernateSearchService hibernateSearchService, DebitoCotaUnicaService debitoCotaUnicaService, ParametroGeralService parametroGeralService, DebitoEmAbertoService debitoEmAbertoService, MotivoExclusaoLogicaService motivoExclusaoLogicaService) {
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.responsavelCadastroService = responsavelCadastroService;
        this.regimeFiscalPeriodoService = regimeFiscalPeriodoService;
        this.pessoaService = pessoaService;
        this.hibernateSearchService = hibernateSearchService;
        this.debitoCotaUnicaService = debitoCotaUnicaService;
        this.parametroGeralService = parametroGeralService;
        this.debitoEmAbertoService = debitoEmAbertoService;
        this.motivoExclusaoLogicaService = motivoExclusaoLogicaService;
    }

    private String mountFiltro(String columnName, String aliasDebitoParcela, Long tipoCadastro, Long cadastroGeral) {
        Object filtroAtual = String.format(" %s.TIPOCADASTRO = %d and %s.CADASTROGERAL = %d ", columnName, tipoCadastro, columnName, cadastroGeral);
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VISUALIZA_DEBITO_NAO_CONSTITUIDO).booleanValue()) {
            filtroAtual = (String)filtroAtual + String.format(" and ( %s.CONSTITUIDO='S' or ( %s.CONSTITUIDO='N' and %s.DATAVENCIMENTO >= '%s'))", columnName, columnName, aliasDebitoParcela, DateUtils.localDateToString((LocalDate)LocalDate.now()));
            return filtroAtual;
        }
        filtroAtual = (String)filtroAtual + String.format(" and %s.CONSTITUIDO='S' ", columnName);
        return filtroAtual;
    }

    public List<CadastroGeral> findByPessoaCnpjCpf(String cnpjCpf) {
        return this.cadastroGeralRepository.findByPessoaCnpjCpfAndExclusaoLogicaFalse(cnpjCpf);
    }

    public CadastroGeral restoreCadastroGeral(Long cadastroGeralId) {
        CadastroGeral cadastroGeral = (CadastroGeral)this.findById((Serializable)cadastroGeralId).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral %d n\u00e3o Encontrado!", cadastroGeralId)));
        if (!cadastroGeral.getExclusaoLogica().booleanValue()) {
            throw new EloValidationException("Esse cadastro j\u00e1 foi restaurado");
        }
        cadastroGeral.setExclusaoLogica(Boolean.valueOf(false));
        cadastroGeral.setDataRestauracaoLogica(LocalDate.now());
        this.indexCadastroGeralById(cadastroGeralId);
        return (CadastroGeral)this.save((EloEntity)cadastroGeral, null);
    }

    public CadastroGeralMobileDTO getCadastroGeralResumidoMobile(TipoCadastro tipoCadastro, Long cadastroGeral) {
        Optional cadastroGeralOptional = this.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
        return cadastroGeralOptional.map(CadastroGeralMobileDTO::from).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral %s n\u00e3o encontrado.", cadastroGeral)));
    }

    public Optional<CadastroGeral> findByTipoCadastroAndCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.cadastroGeralRepository.findOneByTipoCadastroAndCadastroGeralAndExclusaoLogicaFalse(tipoCadastro, cadastroGeral);
    }

    private Optional<CadastroGeral> findByTipoCadastroAndCadastroGeral(CadastroGeralResponsavelProjection projection) {
        return this.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)projection.getTipoCadastro()), projection.getCadastroGeral());
    }

    public Optional<CadastroGeralAcessoWebDTO> getCadastro(TipoCadastro tipoCadastro, Long codigoCadastroGeral) {
        return this.findByTipoCadastroAndCadastroGeral(tipoCadastro, codigoCadastroGeral).map(arg_0 -> this.preencheDTO(arg_0));
    }

    public List<CadastroGeralAcessoWebDTO> getCadastrosByCnpjCpf(String cnpjCpf) {
        ParametroGeral parametroSituacoesMobiliario = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.SITUACAO_MOBILIARIA_VISIVEL_PORTAL, ModuloEnum.MODULO_MAIS_ISS.getValue());
        ParametroGeral parametroSituacoesImobiliario = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.SITUACAO_IMOBILIARIA_VISIVEL_PORTAL, ModuloEnum.MODULO_MAIS_ISS.getValue());
        Set cadastros = this.responsavelCadastroService.findResponsavelList(cnpjCpf).stream().map(arg_0 -> this.findByTipoCadastroAndCadastroGeral(arg_0)).map(Optional::get).collect(Collectors.toSet());
        cadastros.addAll(this.cadastroGeralRepository.findByPessoaCnpjCpfAndExclusaoLogicaFalse(cnpjCpf));
        List situacoesMobiliario = this.getSituacoesCadastro(parametroSituacoesMobiliario);
        List situacoesImobiliario = this.getSituacoesCadastro(parametroSituacoesImobiliario);
        return cadastros.stream().map(arg_0 -> this.preencheDTO(arg_0)).filter(this.filterCadastros(situacoesMobiliario, situacoesImobiliario)).collect(Collectors.toList());
    }

    private Predicate<CadastroGeralAcessoWebDTO> filterCadastros(List<Integer> situacoesMobiliario, List<Integer> situacoesImobiliario) {
        return cadastro -> {
            if (situacoesMobiliario.isEmpty() && situacoesImobiliario.isEmpty()) {
                return true;
            }
            if (TipoCadastro.IMOBILIARIO.getValue().equals(cadastro.getTipoCadastro()) && !situacoesImobiliario.isEmpty()) {
                return situacoesImobiliario.contains(cadastro.getSituacaoCadastro().intValue());
            }
            if (TipoCadastro.MOBILIARIO.getValue().equals(cadastro.getTipoCadastro()) && !situacoesMobiliario.isEmpty()) {
                return situacoesMobiliario.contains(cadastro.getSituacao().intValue());
            }
            return true;
        };
    }

    private List<Integer> getSituacoesCadastro(ParametroGeral parametroSituacoesCadastro) {
        String valor = Optional.ofNullable(parametroSituacoesCadastro).map(ParametroGeral::getValor).orElse("");
        if (StringUtils.isEmpty((String)valor)) {
            return Collections.emptyList();
        }
        try {
            return Arrays.stream(valor.split(",")).map(Integer::parseInt).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel converter o valor do par\u00e2metro, 'Situa\u00e7\u00f5es vis\u00edveis no portal do contribuinte'. Utilizar apenas n\u00fameros separados por virgula. Ex: 1,2,3. Valor Atual: %s", parametroSituacoesCadastro.getValor()));
        }
    }

    private CadastroGeralAcessoWebDTO preencheDTO(CadastroGeral cadastroGeral) {
        CadastroImobiliarioSituacao situacao;
        CadastroGeralAcessoWebDTO cadastroGeralAcessoWebDTO = new CadastroGeralAcessoWebDTO();
        cadastroGeralAcessoWebDTO.setIdCadastro(cadastroGeral.getId());
        cadastroGeralAcessoWebDTO.setTipoCadastro(cadastroGeral.getTipoCadastro().getValue());
        cadastroGeralAcessoWebDTO.setDescTipoCadastro(cadastroGeral.getTipoCadastro().getDescricao());
        cadastroGeralAcessoWebDTO.setCadastroGeral(cadastroGeral.getCadastroGeral());
        cadastroGeralAcessoWebDTO.setIdPessoa(cadastroGeral.getPessoa().getId());
        cadastroGeralAcessoWebDTO.setNome(cadastroGeral.getPessoa().getNome());
        cadastroGeralAcessoWebDTO.setCnpjCpf(MaskCnpjCpf.ocultaCnpjCpf((String)cadastroGeral.getPessoa().getCnpjCpf()));
        cadastroGeralAcessoWebDTO.setEndereco(cadastroGeral.getEnderecoFormatado());
        cadastroGeralAcessoWebDTO.setCidadeUf(cadastroGeral.getCidadeFormatada());
        cadastroGeralAcessoWebDTO.setCep(cadastroGeral.getCep());
        if (TipoCadastro.MOBILIARIO.equals((Object)cadastroGeral.getTipoCadastro())) {
            SituacaoMobiliario situacao2;
            CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)cadastroGeral;
            RegimeFiscal regimeFiscal = this.regimeFiscalPeriodoService.findRegimeFiscal(cadastroMobiliario.getCadastroGeralISS());
            if (Objects.nonNull(regimeFiscal)) {
                cadastroGeralAcessoWebDTO.setRegimeFiscal(regimeFiscal.getDescricao());
            }
            if (Objects.nonNull(situacao2 = cadastroMobiliario.getSituacaoAtual())) {
                cadastroGeralAcessoWebDTO.setSituacao(situacao2.getId());
                cadastroGeralAcessoWebDTO.setDescSituacao(situacao2.getDescricao());
            }
            cadastroGeralAcessoWebDTO.setNumeroAlvara(cadastroMobiliario.getNumeroAlvara());
            cadastroGeralAcessoWebDTO.setExercicioAlvara(cadastroMobiliario.getExercicioAlvara());
            cadastroGeralAcessoWebDTO.setAtividadePrincipal(cadastroMobiliario.getAtividadePrincipal());
            cadastroGeralAcessoWebDTO.setObservacaoAlvara(cadastroMobiliario.getObservacaoAlvara());
            cadastroGeralAcessoWebDTO.setDataAbertura(cadastroMobiliario.getDataAbertura());
            cadastroGeralAcessoWebDTO.setDataEncerramento(cadastroMobiliario.getDataEncerramento());
            cadastroGeralAcessoWebDTO.setDataValidadeAlvara(cadastroMobiliario.getDataValidadeAlvara());
            cadastroGeralAcessoWebDTO.setDataUltimaFiscalizacao(cadastroMobiliario.getDataUltimaFiscalizacao());
        } else if (TipoCadastro.IMOBILIARIO.equals((Object)cadastroGeral.getTipoCadastro()) && Objects.nonNull(situacao = ((CadastroImobiliario)cadastroGeral).getSituacaoAtual())) {
            cadastroGeralAcessoWebDTO.setSituacao(situacao.getId());
            cadastroGeralAcessoWebDTO.setSituacaoCadastro(situacao.getSituacaoImobiliario().getId());
            cadastroGeralAcessoWebDTO.setDescSituacao(situacao.getSituacaoImobiliario().getDescricao());
        }
        return cadastroGeralAcessoWebDTO;
    }

    public boolean exists(TipoCadastro tipoCadastro, Long cadastroGeral) {
        return this.cadastroGeralRepository.existsByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral);
    }

    public void validaCadastroGeral(TipoCadastro tipoCadastro, Long cadastroGeral) {
        if (!this.exists(tipoCadastro, cadastroGeral)) {
            throw new CadastroNaoEncontradoException(tipoCadastro, cadastroGeral);
        }
    }

    public void validaCadastroGeralExclusaoLogica(CadastroGeral cadastroGeral) {
        CadastroGeral cadastroGeralSalvo;
        if (!cadastroGeral.isNew() && (cadastroGeralSalvo = (CadastroGeral)this.findOne((Serializable)cadastroGeral.getId())) != null && cadastroGeralSalvo.getExclusaoLogica().booleanValue()) {
            throw new CadastroExclusaoLogicaException(cadastroGeral.getTipoCadastro(), cadastroGeral.getCadastroGeral());
        }
    }

    public Pessoa getResponsavel(Long idCadastro) {
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralRepository.findOne((Object)idCadastro);
        if (Objects.isNull(cadastroGeral)) {
            throw new CadastroNaoEncontradoException(idCadastro);
        }
        return cadastroGeral.getPessoaResponsavel();
    }

    private String getResponsavelPrincipalNotFoundExceptionMessage(CadastroGeral cadastroGeral) {
        return String.format(RESPONSAVEL_PRINCIPAL_NOT_FOUND, cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral());
    }

    public Pessoa getResponsavelPrincipal(CadastroGeral cadastroGeral) {
        Supplier<EloValidationException> eloValidationExceptionSupplier = () -> new EloValidationException(this.getResponsavelPrincipalNotFoundExceptionMessage(cadastroGeral));
        if (Arrays.asList(TipoCadastro.IMOBILIARIO, TipoCadastro.RURAL, TipoCadastro.AVULSO).contains(cadastroGeral.getTipoCadastro())) {
            return this.cadastroGeralRepository.findProprietario(cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()).stream().filter(CadastroGeralResponsavelDTO::getResponsavel).findFirst().map(dto -> this.pessoaService.findOne(dto.getPessoa())).orElseThrow(eloValidationExceptionSupplier);
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)cadastroGeral.getTipoCadastro())) {
            return this.cadastroGeralRepository.findSocioMobiliario(cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()).stream().filter(CadastroGeralResponsavelDTO::getResponsavel).findFirst().map(dto -> this.pessoaService.findOne(dto.getPessoa())).orElseThrow(eloValidationExceptionSupplier);
        }
        return this.cadastroGeralRepository.findById((Object)cadastroGeral.getId()).map(CadastroGeral::getPessoa).orElseThrow(eloValidationExceptionSupplier);
    }

    public List<Pessoa> getTodosResponsaveis(CadastroGeral cadastroGeral) {
        if (Arrays.asList(TipoCadastro.IMOBILIARIO, TipoCadastro.RURAL, TipoCadastro.AVULSO).contains(cadastroGeral.getTipoCadastro())) {
            return this.cadastroGeralRepository.findProprietario(cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()).stream().map(CadastroGeralResponsavelDTO::getPessoa).map(arg_0 -> ((PessoaService)this.pessoaService).findOne(arg_0)).collect(Collectors.toList());
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)cadastroGeral.getTipoCadastro())) {
            return this.cadastroGeralRepository.findSocioMobiliario(cadastroGeral.getTipoCadastro().getValue(), cadastroGeral.getCadastroGeral()).stream().map(dto -> this.pessoaService.findOne(dto.getPessoa())).collect(Collectors.toList());
        }
        return this.cadastroGeralRepository.findProprietariosById(cadastroGeral.getId()).stream().map(Proprietario::getPessoa).collect(Collectors.toList());
    }

    public Page<ParcelamentoCadastroDTO> getCadastrosByCpfCnpj(String cpfCnpj, Optional<String> search, Pageable page) {
        return this.cadastroGeralRepository.getCadastrosByCpfCnpj(cpfCnpj, search, page);
    }

    public void indexCadastrosGerais() throws InterruptedException {
        this.hibernateSearchService.indexEntities(CadastroGeral.class);
    }

    public void indexCadastrosPorTipoCadastro(TipoCadastroIndexacao tipoCadastro, SseEmitter emitter) {
        if (Objects.isNull(tipoCadastro)) {
            throw new EloValidationException("Tipo cadastro n\u00e3o informado.");
        }
        this.hibernateSearchService.indexEntities(tipoCadastro, emitter);
    }

    public void indexCadastroGeralById(Long id) {
        this.findById((Serializable)id).ifPresent(arg_0 -> ((HibernateSearchService)this.hibernateSearchService).indexEntity(arg_0));
    }

    public Boolean hasDebitoVencido(Long idCadastro) {
        return this.cadastroGeralRepository.hasDebitoVencido(idCadastro);
    }

    public CadastroSearchDTO<CadastroAvulsoRowDTO> searchCadastrosAvulsos(CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        List<String> searchFields = Arrays.asList("cep", "pessoa.nome", "pessoa.cnpjCpf", "pessoa.nomeFantasia", "pessoa.rg", "proprietarios.pessoa.nome", "proprietarios.pessoa.cnpjCpf", "proprietarios.pessoa.nomeFantasia", "proprietarios.pessoa.rg", "enderecoFormatado");
        HibernateSearchParams hibernateSearchParams = new HibernateSearchParams(this.getEm(), CadastroGeral.class, pageable, searchParams.getSearch(), searchFields, Collections.emptyList());
        Query query = hibernateSearchParams.getQueryBuilder().bool().must(hibernateSearchParams.createQueryWithSpecificField("tipoCadastroDescricao", TipoCadastro.AVULSO.getDescricao())).should(hibernateSearchParams.createFuzzyQuery()).should((Query)new BoostQuery(hibernateSearchParams.createQueryWithSpecificField("cadastroGeral", searchParams.getSearch()), 1.5f)).createQuery();
        return this.hibernateSearchService.geraCadastroSearchDTO(query, hibernateSearchParams, searchParams.getFacets(), CadastroAvulsoRowDTO::from);
    }

    public CadastroSearchDTO<CadastroGeralRowDTO> searchCadastros(CadastroGeralSearchParamsDTO searchParams, Pageable pageable) {
        List<String> searchFields = Arrays.asList("cadastroGeral", "cep", "pessoa.nome", "pessoa.cnpjCpf", "proprietarios.pessoa.nome", "proprietarios.pessoa.cnpjCpf", "enderecoFormatado");
        HibernateSearchParams hibernateSearchParams = new HibernateSearchParams(this.getEm(), CadastroGeral.class, pageable, searchParams.getSearch(), searchFields, Arrays.asList(FacetCadastroGeral.values()));
        Query query = hibernateSearchParams.getQueryBuilder().bool().must(hibernateSearchParams.createQueryFromSearchFields()).createQuery();
        return this.hibernateSearchService.geraCadastroSearchDTO(query, hibernateSearchParams, searchParams.getFacets(), CadastroGeralRowDTO::from);
    }

    public List<CadastroGeralAcessoWebDTO> getCadastrosComCarneByCnpjCpf(String cnpjCpf) {
        Set vinculos = this.responsavelCadastroService.findResponsavelList(cnpjCpf).stream().map(arg_0 -> this.findByTipoCadastroAndCadastroGeral(arg_0)).map(Optional::get).collect(Collectors.toSet());
        vinculos.addAll(this.cadastroGeralRepository.findByPessoaCnpjCpfAndExclusaoLogicaFalse(cnpjCpf));
        List cadastros = vinculos.stream().map(arg_0 -> this.preencheDTO(arg_0)).collect(Collectors.toList());
        List idsCadastro = this.debitoCotaUnicaService.buscaDebitosAgrupadosPorFormaPagamentoDisponivelWeb(cadastros.stream().map(CadastroGeralAcessoWebDTO::getIdCadastro).collect(Collectors.toList()));
        return cadastros.stream().filter(item -> idsCadastro.contains(item.getIdCadastro())).collect(Collectors.toList());
    }

    public List<CadastroGeralResumidoDTO> findCadastrosPessoa(CadastroGeralResumidoDTO cadastro) {
        return this.cadastroGeralRepository.findCadastrosPessoa(cadastro.getTipoCadastro(), cadastro.getCadastroGeral());
    }

    public CadastroGeral excludeCadastroLogicamente(Long idCadastro) {
        CadastroGeral cadastroGeral = (CadastroGeral)this.findOne((Serializable)idCadastro);
        if (Objects.isNull(cadastroGeral)) {
            throw new CadastroNaoEncontradoException(idCadastro);
        }
        cadastroGeral.setExclusaoLogica(Boolean.TRUE);
        return (CadastroGeral)this.save((EloEntity)cadastroGeral, null);
    }

    public CadastroGeral excludeCadastroLogicamente(TipoCadastro tipoCadastro, Long cadastroGeral) {
        CadastroGeral cadastro = (CadastroGeral)this.cadastroGeralRepository.findOneByTipoCadastroAndCadastroGeralAndExclusaoLogicaFalse(tipoCadastro, cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(tipoCadastro, cadastroGeral));
        List debitos = this.debitoEmAbertoService.loadDebitoEmAberto(this.mountFiltro("TRIBDEBITO", "TRIBDEBITOPARCELA", tipoCadastro.getValue(), cadastroGeral), Boolean.FALSE);
        if (!debitos.isEmpty()) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel excluir cadastro com d\u00e9bitos em aberto! Tipo cadastro = %s, Cadastro Geral %s", tipoCadastro, cadastroGeral));
        }
        MotivoExclusaoLogica motivoExclusaoLogica = (MotivoExclusaoLogica)this.motivoExclusaoLogicaService.findOne((Serializable)EXCLUSAO_LOGICA);
        cadastro.setMotivoExclusaoLogica(motivoExclusaoLogica);
        cadastro.setDataExclusaoLogica(LocalDate.now());
        cadastro.setExclusaoLogica(Boolean.TRUE);
        return (CadastroGeral)this.cadastroGeralRepository.save((Object)cadastro);
    }

    public Boolean isInadimplente(Long cadastroGeral, Long tipoCadastroValue) {
        TipoCadastro tipoCadastro = TipoCadastro.fromValue((Long)tipoCadastroValue);
        return this.findByTipoCadastroAndCadastroGeral(tipoCadastro, cadastroGeral).map(cadastro -> this.hasDebitoVencido(cadastro.getId())).orElseThrow(() -> new RestException(HttpStatus.BAD_REQUEST, String.format("Cadastro n\u00e3o encontrado. CadastroGeral: %s e tipoCadastro: %s. Entre em contato com o munic\u00edpio para d\u00favidas.", cadastroGeral, tipoCadastro.getDescricao())));
    }

    public Page<CadastroGeralResponseDTO> searchByActive(String search, Pageable pageable) {
        Object and = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)search) ? search + " and " : "";
        String byActive = (String)and + "exclusaoLogica==false";
        return this.findByRsql(byActive, pageable).map(CadastroGeralResponseDTO::from);
    }
}

