/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.AvisoCadastro;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.AvisoCadastroDTO;
import br.com.elotech.tributos.dto.TextoAvisoCadastroDTO;
import br.com.elotech.tributos.exception.AvisoCadastroNotFoundException;
import br.com.elotech.tributos.repository.AvisoCadastroRepository;
import br.com.elotech.tributos.repository.ConsultaAvisoCadastroRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AvisoCadastroService
extends CrudService<AvisoCadastro, Long> {
    private final AvisoCadastroRepository repository;
    private final ConsultaAvisoCadastroRepository consultaRepository;

    public AvisoCadastro create(AvisoCadastroDTO dto) {
        return (AvisoCadastro)this.save((EloEntity)AvisoCadastro.from((AvisoCadastroDTO)dto), null);
    }

    public Page<AvisoCadastro> findAll(String search, Pageable pageable) {
        return this.findByRsql(search, pageable);
    }

    public AvisoCadastro buscaPorId(Long id) {
        return (AvisoCadastro)this.repository.findById((Object)id).orElseThrow(() -> new AvisoCadastroNotFoundException(String.format("N\u00e3o foi encontrado nenhum Aviso-Cadastro com o id %d", id)));
    }

    public AvisoCadastro update(Long id, AvisoCadastroDTO dto) {
        AvisoCadastro avisoCadastro = this.buscaPorId(id);
        AvisoCadastro avisoAtualizado = AvisoCadastro.from((AvisoCadastroDTO)dto);
        if (!dto.getFiltro().isEmpty()) {
            avisoCadastro.setFiltro(avisoAtualizado.getFiltro());
        }
        avisoCadastro.setStatus(avisoAtualizado.getStatus());
        avisoCadastro.setAviso(avisoAtualizado.getAviso());
        avisoCadastro.setDataAlteracao(avisoAtualizado.getDataAlteracao());
        avisoCadastro.setUsuario(SecurityUtils.getUserAise());
        return (AvisoCadastro)this.repository.save((Object)avisoCadastro);
    }

    public AvisoCadastro statusChange(Long id) {
        AvisoCadastro avisoCadastro;
        avisoCadastro.setStatus(Boolean.valueOf((avisoCadastro = this.buscaPorId(id)).getStatus() == false));
        return (AvisoCadastro)this.repository.save((Object)avisoCadastro);
    }

    public List<AvisoCadastro> findByTipoCadastroLista(TipoCadastro tipoCadastro) {
        return this.repository.findByTipoCadastroLista(tipoCadastro);
    }

    public TextoAvisoCadastroDTO verificaAviso(TipoCadastro tipoCadastro, Long id) {
        List avisos = this.findByTipoCadastroLista(tipoCadastro);
        for (AvisoCadastro avisoCadastro : avisos) {
            Long quantidade = this.consultaRepository.existsByFiltro(avisoCadastro.getFiltro(), tipoCadastro, id);
            if (quantidade <= 0L) continue;
            return new TextoAvisoCadastroDTO(avisoCadastro.getAviso());
        }
        return null;
    }

    @Generated
    public AvisoCadastroService(AvisoCadastroRepository repository, ConsultaAvisoCadastroRepository consultaRepository) {
        this.repository = repository;
        this.consultaRepository = consultaRepository;
    }
}

