/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.security;

import br.com.elotech.core.security.Http401UnauthorizedEntryPoint;
import br.com.elotech.core.security.SecurityConfigurationOverride;
import br.com.elotech.keycloakmultirealm.resolver.KeycloakResolver;
import br.com.elotech.keycloakmultirealm.resolver.TenantKeycloak;
import br.com.elotech.keycloakmultirealm.resolver.TenantKeycloakConfigResolver;
import br.com.elotech.tributos.security.GeoSecurityFilter;
import br.com.elotech.tributos.security.IntegracaoNovoRequerimentoSecurityFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.Filter;
import org.keycloak.adapters.springsecurity.KeycloakConfiguration;
import org.keycloak.adapters.springsecurity.KeycloakSecurityComponents;
import org.keycloak.adapters.springsecurity.client.KeycloakClientRequestFactory;
import org.keycloak.adapters.springsecurity.config.KeycloakWebSecurityConfigurerAdapter;
import org.keycloak.adapters.springsecurity.filter.KeycloakAuthenticationProcessingFilter;
import org.keycloak.adapters.springsecurity.filter.KeycloakPreAuthActionsFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;

@KeycloakConfiguration
@EnableWebSecurity
@ComponentScan(basePackageClasses={KeycloakSecurityComponents.class})
public class TributosSecurityConfiguration
extends KeycloakWebSecurityConfigurerAdapter
implements SecurityConfigurationOverride {
    @Autowired
    public KeycloakClientRequestFactory keycloakClientRequestFactory;

    public TributosSecurityConfiguration() {
        SecurityContextHolder.setStrategyName((String)"MODE_INHERITABLETHREADLOCAL");
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) {
        auth.authenticationProvider((AuthenticationProvider)this.keycloakAuthenticationProvider());
    }

    @Bean
    protected SessionAuthenticationStrategy sessionAuthenticationStrategy() {
        return new RegisterSessionAuthenticationStrategy((SessionRegistry)new SessionRegistryImpl());
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/public/*"})).antMatchers(new String[]{"/error"})).antMatchers(new String[]{"/actuator/**"})).antMatchers(new String[]{"/h2-console/**"})).antMatchers(new String[]{"/v2/api-docs"})).antMatchers(new String[]{"/configuration/ui"})).antMatchers(new String[]{"/swagger-resources/**"})).antMatchers(new String[]{"/configuration/security"})).antMatchers(new String[]{"/swagger-ui.html"})).antMatchers(new String[]{"/webjars/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/appwebconf/texto-apresentacao"})).antMatchers(HttpMethod.GET, new String[]{"/api/bloqueto/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/bloqueto/imprime**"})).antMatchers(HttpMethod.GET, new String[]{"/api/entidades/principal/entidade"})).antMatchers(HttpMethod.GET, new String[]{"/api/entidades/principal/brasao"})).antMatchers(HttpMethod.GET, new String[]{"/api/cadastro-imobiliario/imprimir-espelho**"})).antMatchers(HttpMethod.GET, new String[]{"/api/cadastro-geral/cadastros-com-carnes/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/cadastro-geral/getCadastros/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/cadastro-geral/getCadastro/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/cadastro-mobiliario/imprimir-espelho**"})).antMatchers(HttpMethod.GET, new String[]{"/api/debitos/agrupados/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/debitoscarne**"})).antMatchers(HttpMethod.GET, new String[]{"/api/debitoscarne/agrupado-forma-pagamento/**"})).antMatchers(HttpMethod.POST, new String[]{"/api/carne/gera-carne-forma-pagamento"})).antMatchers(HttpMethod.GET, new String[]{"/api/documentos/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/documentos/autenticidade/*"})).antMatchers(HttpMethod.GET, new String[]{"/api/documentos-tipos/*/tipos-cadastro"})).antMatchers(HttpMethod.GET, new String[]{"/api/documentofinalidade/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/imobiliario-avaliacao**"})).antMatchers(HttpMethod.GET, new String[]{"/api/imprimirdebitos/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/imprimir-situacaocadastral/cadastro/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/imprimir-situacaocadastral/cnpjcpf/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/laudoavaliacao/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/modulos/ativos"})).antMatchers(HttpMethod.GET, new String[]{"/api/parcelamentos/*/imprimir-contrato"})).antMatchers(HttpMethod.GET, new String[]{"/api/parametros-gerais/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/certidaoquitacaoitbi/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/registro/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/relatorios/avulso-completo/**"})).antMatchers(HttpMethod.POST, new String[]{"/api/bloqueto/gera-por-data-pagamento"})).antMatchers(HttpMethod.POST, new String[]{"/api/cadastro-geral/populate-index/**"})).antMatchers(HttpMethod.POST, new String[]{"/api/carne"})).antMatchers(HttpMethod.POST, new String[]{"/api/certidao"})).antMatchers(HttpMethod.POST, new String[]{"/api/data-vencimento-boleto/em-atraso"})).antMatchers(HttpMethod.POST, new String[]{"/api/imprimirdocumento"})).regexMatchers(HttpMethod.POST, new String[]{"/api/documentos/.*/gerar$"})).antMatchers(HttpMethod.GET, new String[]{"/api/debitos/documento/*"})).antMatchers(HttpMethod.POST, new String[]{"/api/cadastros-avulso"})).antMatchers(HttpMethod.POST, new String[]{"/api/debitos"})).antMatchers(HttpMethod.POST, new String[]{"/api/debitos/verificar-pagos"})).antMatchers(HttpMethod.POST, new String[]{"/api/mobile/bloqueto/gera"})).antMatchers(HttpMethod.GET, new String[]{"/api/tipos-requerimentos/com-taxas/assunto/*"})).antMatchers(HttpMethod.GET, new String[]{"/api/debitos/*/parcelas/*"})).antMatchers(HttpMethod.GET, new String[]{"/api/totalacesso"})).antMatchers(HttpMethod.GET, new String[]{"/api/requerimentos/id/**"})).antMatchers(HttpMethod.GET, new String[]{"/api/movimentacao-tributo/**"})).antMatchers(HttpMethod.POST, new String[]{"/api/integracao-boleto/*/webhook/pix"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.cors().and()).csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).sessionAuthenticationStrategy(this.sessionAuthenticationStrategy()).and()).authorizeRequests().anyRequest()).authenticated().and()).anonymous().disable()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new Http401UnauthorizedEntryPoint());
    }

    @Bean
    public KeycloakResolver keycloakResolver(@Value(value="${keycloak.configurationFile}") Resource keycloakConfigurationFile) throws IOException {
        return new TenantKeycloak(keycloakConfigurationFile.getInputStream().readAllBytes());
    }

    @Bean
    public TenantKeycloakConfigResolver keycloakConfigResolver(@Lazy KeycloakResolver keycloakResolver) {
        return new TenantKeycloakConfigResolver(keycloakResolver);
    }

    @Bean
    public FilterRegistrationBean<KeycloakAuthenticationProcessingFilter> keycloakAuthenticationProcessingFilterRegistrationBean(KeycloakAuthenticationProcessingFilter filter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setEnabled(false);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<KeycloakPreAuthActionsFilter> disableKeycloakPreAuthActionsFilter(KeycloakPreAuthActionsFilter filter) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setEnabled(false);
        return registrationBean;
    }

    @Bean
    @Profile(value={"!onpremise"})
    public FilterRegistrationBean<GeoSecurityFilter> geoSecurityFilterFilterRegistrationBean(ObjectMapper objectMapper) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new GeoSecurityFilter(objectMapper));
        registrationBean.setEnabled(true);
        registrationBean.setOrder(SecurityWebFiltersOrder.AUTHORIZATION.getOrder() + 2);
        return registrationBean;
    }

    @Bean
    @Profile(value={"!onpremise"})
    public FilterRegistrationBean<IntegracaoNovoRequerimentoSecurityFilter> integracaoNovoRequetimentoFilterRegistrationBean(ObjectMapper objectMapper) {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new IntegracaoNovoRequerimentoSecurityFilter(objectMapper));
        registrationBean.setEnabled(true);
        registrationBean.setOrder(SecurityWebFiltersOrder.AUTHORIZATION.getOrder() + 2);
        return registrationBean;
    }
}

