/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.documento.protesto;

import br.com.elotech.core.resource.support.CrudResource;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.dto.ProtestoRemessaResumoDTO;
import br.com.elotech.tributos.service.ProtestoRemessaService;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/protesto-remessa"})
public class ProtestoRemessaResource
extends CrudResource<ProtestoRemessa, Long> {
    private final ProtestoRemessaService protestoRemessaService;

    @GetMapping(value={"/{id}/resumo"})
    public ResponseEntity<ProtestoRemessaResumoDTO> getProtestoRemessaResumo(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.protestoRemessaService.getProtestoRemessaResumo(id));
    }

    @GetMapping(value={"/{idProtesto}/download-xml"})
    public ResponseEntity<Void> downloadArquivo(@PathVariable Long idProtesto, HttpServletResponse response) throws IOException {
        this.protestoRemessaService.downloadArquivo(response, idProtesto);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/download-txt/{idArquivo}"})
    public ResponseEntity<String> getUrlDownloadProtestoRemessaArquivoEnv(@PathVariable String idArquivo) {
        return ResponseEntity.ok((Object)this.protestoRemessaService.getUrlArquivoEnvioRemessa(idArquivo));
    }

    @Generated
    public ProtestoRemessaResource(ProtestoRemessaService protestoRemessaService) {
        this.protestoRemessaService = protestoRemessaService;
    }
}

