/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.DocumentoAutenticadoDTO;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.RelatorioImpressaoDTO;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoDocumentoDTO;
import br.com.elotech.tributos.enums.TipoAcaoAtendimento;
import br.com.elotech.tributos.params.CadastroGeralParams;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.repository.projections.DocumentoProjection;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.HistoricoAtendimentoService;
import br.com.elotech.tributos.service.ParcelamentoService;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import org.apache.commons.lang3.RegExUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/documentos"})
public class DocumentoResource
extends ReadOnlyResource<Documento, Long> {
    private final DocumentoService documentoService;
    private final BoletoRepository bloquetoRepository;
    private final ParcelamentoService parcelamentoService;
    private final HistoricoAtendimentoService historicoAtendimentoService;

    public DocumentoResource(DocumentoService documentoService, BoletoRepository bloquetoRepository, ParcelamentoService parcelamentoService, HistoricoAtendimentoService historicoAtendimentoService) {
        this.documentoService = documentoService;
        this.bloquetoRepository = bloquetoRepository;
        this.parcelamentoService = parcelamentoService;
        this.historicoAtendimentoService = historicoAtendimentoService;
    }

    @GetMapping(value={"/autenticidade/{codigovalidacao}"})
    public ResponseEntity<DocumentoAutenticadoDTO> getAutenticidade(@PathVariable(value="codigovalidacao") String payload) {
        String codigo = RegExUtils.replaceAll((String)payload, (String)"\\.", (String)"");
        Documento documento = this.documentoService.getDocumentoByCodigoValidacao(codigo);
        if (Objects.nonNull(documento)) {
            return ResponseEntity.ok().body((Object)documento.toDocumentoAutenticadoDTO());
        }
        Bloqueto bloqueto = this.bloquetoRepository.findByCodigoValidacao(codigo);
        if (Objects.nonNull(bloqueto)) {
            return ResponseEntity.ok().body((Object)bloqueto.toDocumentoAutenticadoDTO());
        }
        Parcelamento parcelamento = this.parcelamentoService.findByCodigoValidacao(codigo);
        if (Objects.nonNull(parcelamento)) {
            return ResponseEntity.ok().body((Object)parcelamento.toDocumentoAutenticadoDTO());
        }
        throw RestException.notFound();
    }

    @GetMapping(params={"tipoCadastro", "cadastroGeral"})
    public ResponseEntity<List<DocumentoProjection>> getListDocumentos(CadastroGeralParams params) {
        List listDto = this.loadListDocumentoDTO(params.getTipoCadastro(), params.getCadastroGeral());
        return ResponseEntity.ok().body((Object)listDto);
    }

    private List<DocumentoProjection> loadListDocumentoDTO(TipoCadastro tipoCadastro, Long cadastroGeral) {
        List listDto = this.documentoService.getListDocumentoDTO(tipoCadastro, cadastroGeral);
        return Optional.ofNullable(listDto).orElseThrow(RestException::notFound);
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<Page<DocumentoDTO>> findAllDocumentos(@RequestParam Optional<String> search, Pageable page) {
        return ResponseEntity.ok((Object)this.documentoService.getDocumentos(search, page));
    }

    @GetMapping(value={"/cpf-cnpj/{cpfCnpj}"})
    public ResponseEntity<Page<DocumentoDTO>> findDocumentosValidosByCpfCnpj(@PathVariable(value="cpfCnpj") String cpfCnpj, @RequestParam Optional<String> search, Pageable pageable) {
        return ResponseEntity.ok((Object)this.documentoService.findAllDocumentoByCpfCnpj(cpfCnpj, LocalDate.now(), search, pageable));
    }

    @PostMapping(value={"/imprimir/{id}"})
    public ResponseEntity<ImpressaoDTO> imprimirDocumento(@PathVariable(value="id") Long id, @RequestBody RelatorioImpressaoDTO relatorioImpressao) throws IOException {
        return ResponseEntity.ok((Object)this.documentoService.imprimirDocumento(id, relatorioImpressao));
    }

    @GetMapping(value={"/documento-resumo/{id}"})
    public ResponseEntity<DocumentoDTO> findDocumentoById(@PathVariable(value="id") Long id) {
        return ResponseEntity.ok((Object)this.documentoService.findDocumentoById(id));
    }

    @PutMapping(value={"/{id}/cancelar"})
    public ResponseEntity<DocumentoDTO> cancelarDocumento(@PathVariable(value="id") Long id, @RequestBody CancelamentoDocumentoDTO cancelamentoDocumentoDTO) {
        Documento documento = this.documentoService.cancelarDocumento(id, cancelamentoDocumentoDTO);
        return ResponseEntity.ok((Object)DocumentoDTO.from((Documento)documento));
    }

    @PostMapping(value={"/{tipoDocumento}/gerar"})
    public ResponseEntity<ImpressaoDTO> gerar(@PathVariable(value="tipoDocumento") Long tipoDocumento, @RequestBody @Valid DocumentoGenericoDTO documentoGenericoDTO) throws IOException {
        DocumentoDTO documentoDTO = this.documentoService.gerar(documentoGenericoDTO, TipoDocumentoEnum.fromValue((Long)tipoDocumento));
        this.historicoAtendimentoService.createHistoricoAtendimento(String.format("Documento tipo %s numero %s/%s gerado.", documentoDTO.getTipoDocumento(), documentoDTO.getDocumento(), documentoDTO.getExercicio()), TipoAcaoAtendimento.GERACAO_DOCUMENTO);
        return ResponseEntity.ok((Object)this.documentoService.imprimirDocumento(documentoDTO.getId(), documentoGenericoDTO.getRelatorioImpressao()));
    }

    @PostMapping(value={"/{tipoDocumento}/valores-iniciais"})
    public ResponseEntity<DocumentoGenericoDTO> getInitialValuesCadastro(@PathVariable(value="tipoDocumento") Long tipoDocumento, @RequestBody DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ResponseEntity.ok((Object)this.documentoService.getInitialValues(documentoSearchInitialValuesDTO, TipoDocumentoEnum.fromValue((Long)tipoDocumento)));
    }
}

