/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.impl;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoParcelaPagamentoDTO;
import br.com.elotech.tributos.dto.FiltroPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoDTO;
import br.com.elotech.tributos.repository.PagamentoRepositoryCustom;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.transform.Transformers;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class PagamentoRepositoryImpl
implements PagamentoRepositoryCustom {
    private static final String SQL_PAGAMENTOS_PARCELA = "sql/ConsultaDebitoParcelaPagamento.sql";
    private static final String SQL_PAGAMENTOS_EXISTENTES_MESMA_PARCELA_TRIBUTO = "br/com/elotech/tributos/repository/pagamento/existePagamentoMesmaParcelaTributo.sql";
    private static final String SQL_DEBITO_QUITADO_BY_PAGAMENTO = "br/com/elotech/tributos/repository/pagamento/find-debito-quitado-by-pagamento.sql";
    private static final String SQL_DEBITO_NAO_CONSTITUIDO_BY_PAGAMENTO = "br/com/elotech/tributos/repository/pagamento/find-debito-nao-constituido-by-pagamento.sql";
    private static final String ENTIDADE = "entidade";
    private final EntityManager em;
    private final NamedParameterJdbcTemplate jdbcTemplate;

    public PagamentoRepositoryImpl(EntityManager em, NamedParameterJdbcTemplate jdbcTemplate) {
        this.em = em;
        this.jdbcTemplate = jdbcTemplate;
    }

    public List<DebitoParcelaPagamentoDTO> loadDebitoParcelaPagamento(Debito debito, Long parcela) {
        String sql = FileUtils.readResourceAsString((String)"sql/ConsultaDebitoParcelaPagamento.sql");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)debito.getEntidade());
        parameters.addValue("exercicio", (Object)debito.getExercicio());
        parameters.addValue("tipoCadastro", (Object)debito.getTipoCadastro());
        parameters.addValue("cadastroGeral", (Object)debito.getCadastroGeral().getCadastroGeral());
        parameters.addValue("divida", (Object)debito.getDivida().getDivida());
        parameters.addValue("subDivida", (Object)debito.getSubDivida());
        parameters.addValue("parcela", (Object)parcela);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoParcelaPagamentoDTO.class));
    }

    public Page<PagamentoDTO> findPagamentosDTO(Long entidade, FiltroPagamentoDTO filtroPagamento, Pageable pageable) {
        String sqlFrom = String.format(" from Pagamento pagamento  join pagamento.pagamentoBoleto pagamentoBoleto  join pagamentoBoleto.boleto boleto  join boleto.pessoa pessoa  join pagamento.lote lote  join pagamentoBoleto.pagamentosDebito pagamentosDebito  join pagamentosDebito.id.debitoParcelaTributo tributo  join tributo.debitoParcela debitoParcela  left join pagamento.creditos creditos  where pagamento.id.entidade = :entidade  %s ", filtroPagamento.buildFiltro());
        StringBuilder sqlOrderBy = new StringBuilder("order by ").append(SqlUtils.convertSortToString((Sort)pageable.getSort()));
        String sqlPagamentos = PagamentoRepositoryImpl.getSqlPagamentos((String)sqlFrom, (StringBuilder)sqlOrderBy);
        String sqlCountForPage = String.format(" select count(distinct pagamentoBoleto.id) %s ", sqlFrom);
        TypedQuery queryCount = this.em.createQuery(sqlCountForPage, Long.class).setParameter("entidade", (Object)entidade);
        this.setFiltroDatas((Query)queryCount, filtroPagamento);
        Long quantidadeTotal = (Long)queryCount.getSingleResult();
        Query query = this.em.createQuery(sqlPagamentos).setParameter("entidade", (Object)entidade);
        this.setFiltroDatas(query, filtroPagamento);
        List result = ((org.hibernate.query.Query)query.setParameter("entidade", (Object)entidade).setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize()).unwrap(org.hibernate.query.Query.class)).setResultTransformer(Transformers.aliasToBean(PagamentoDTO.class)).getResultList();
        return new PageImpl(result, pageable, quantidadeTotal.longValue());
    }

    private static String getSqlPagamentos(String sqlFrom, StringBuilder sqlOrderBy) {
        String sqlGroupBy = " group by pagamento.id.entidade,  pagamento.id.exercicioPagamento,  pagamento.id.pagamento,  lote.id.exercicio,  lote.id.lote,  pagamento.sequenciaLote,  pagamentosDebito.estorno,  pagamentosDebito.situacao,  pessoa.id,  pessoa.nome,  pagamento.dataMovimento,  pagamento.dataPagamento,  pagamento.valorPago,  pagamento.valorPagoAMaior,  creditos.creditoContribuinte.id.exercicio,  creditos.creditoContribuinte.id.creditoContribuinte ";
        return String.format("select distinct pagamento.id.entidade as entidade,  pagamento.id.exercicioPagamento as exercicioPagamento,  pagamento.id.pagamento as pagamento,  lote.id.exercicio as exercicioLote,  lote.id.lote as lote,  pagamento.sequenciaLote as sequenciaLote,  pagamentosDebito.estorno as estorno,  pagamentosDebito.situacao as situacao,  sum(pagamentosDebito.valorDevolvido) as valorDevolvido,  pessoa.id as pessoaId,  pessoa.nome as nome,  pagamento.dataMovimento as dataMovimento,  pagamento.dataPagamento as dataPagamento,  pagamento.valorPago as valorPago,  pagamento.valorPagoAMaior as valorPagoAMaior,  case when  ( select count(*) from AcertoPagamentoItem api        where api.pagamentoOrigem.id.pagamento = pagamento.id.pagamento          and api.pagamentoOrigem.id.exercicioPagamento = pagamento.id.exercicioPagamento          and api.pagamentoOrigem.id.entidade = pagamento.id.entidade )  > 0 then true  else false end as usadoEmAcerto,    creditos.creditoContribuinte.id.exercicio as exercicioCredito,    creditos.creditoContribuinte.id.creditoContribuinte as creditoContribuinte  %s  %s  %s ", sqlFrom, sqlGroupBy, sqlOrderBy);
    }

    public List<Pagamento> findPagamentos(Long entidade, FiltroPagamentoDTO filtroPagamento) {
        String sqlFrom = String.format(" from Pagamento pagamento  join pagamento.pagamentoBoleto pagamentoBoleto  join pagamentoBoleto.boleto boleto  join boleto.pessoa pessoa  join pagamento.lote lote  join pagamentoBoleto.pagamentosDebito pagamentosDebito  join pagamentosDebito.id.debitoParcelaTributo tributo  join tributo.debitoParcela debitoParcela  where pagamento.id.entidade = :entidade  %s ", filtroPagamento.buildFiltro());
        String sqlPagamentos = String.format("select distinct pagamento  %s order by pagamento.id.entidade desc, pagamento.id.exercicioPagamento desc, pagamento.id.pagamento desc ", sqlFrom);
        TypedQuery query = this.em.createQuery(sqlPagamentos, Pagamento.class).setParameter("entidade", (Object)entidade);
        this.setFiltroDatas((Query)query, filtroPagamento);
        return query.setParameter("entidade", (Object)entidade).getResultList();
    }

    private void setFiltroDatas(Query query, FiltroPagamentoDTO filtroPagamento) {
        Map filtros = filtroPagamento.getFiltroDatas();
        filtros.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
    }

    public Boolean existePagamentoNaoEstornadoParaMesmaParcelaTributo(Pagamento pagamento, DebitoParcelaTributo debitoParcelaTributo) {
        String sql = FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/pagamento/existePagamentoMesmaParcelaTributo.sql");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)pagamento.getId().getEntidade());
        parameters.addValue("exercicio", (Object)pagamento.getId().getExercicioPagamento());
        parameters.addValue("pagamento", (Object)pagamento.getId().getPagamento());
        parameters.addValue("idDebitoParcelaTributo", (Object)debitoParcelaTributo.getId());
        return (Boolean)this.jdbcTemplate.queryForObject(sql, (SqlParameterSource)parameters, (rs, rowNum) -> rs.getBoolean("exist"));
    }

    public List<DebitoIdDTO> findIdDebitoItbiListByPagamento(Long entidade, Long exercicioPagamento, Long pagamento) {
        String tipoGuiaITBI = " AND TGR.TIPOGUIARECOLHIMENTO = 'T' ";
        String sql = String.format(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/pagamento/find-debito-quitado-by-pagamento.sql"), " AND TGR.TIPOGUIARECOLHIMENTO = 'T' ");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exerciciopagamento", (Object)exercicioPagamento);
        parameters.addValue("pagamento", (Object)pagamento);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoIdDTO.class));
    }

    public List<DebitoIdDTO> findIdDebitoQuitadoListByPagamento(Long entidade, Long exercicioPagamento, Long pagamento) {
        String sql = String.format(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/pagamento/find-debito-quitado-by-pagamento.sql"), "");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exerciciopagamento", (Object)exercicioPagamento);
        parameters.addValue("pagamento", (Object)pagamento);
        return this.jdbcTemplate.query(sql, (SqlParameterSource)parameters, (RowMapper)new ElotechBeanPropertyRowMapper(DebitoIdDTO.class));
    }

    public List<Long> findIdDebitoNaoConstituidoByPagamento(Long entidade, Long exercicioPagamento, Long pagamento) {
        String sql = String.format(FileUtils.readResourceAsString((String)"br/com/elotech/tributos/repository/pagamento/find-debito-nao-constituido-by-pagamento.sql"), "");
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        parameters.addValue("entidade", (Object)entidade);
        parameters.addValue("exerciciopagamento", (Object)exercicioPagamento);
        parameters.addValue("pagamento", (Object)pagamento);
        return this.jdbcTemplate.queryForList(sql, (SqlParameterSource)parameters, Long.class);
    }
}

