/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository;

import br.com.elotech.core.jpa.hibernate.HibernateUtils;
import br.com.elotech.core.jpa.support.DialectWrapper;
import br.com.elotech.core.jpa.support.JpaUtil;
import br.com.elotech.tributos.util.SqlUtils;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import lombok.Generated;
import org.hibernate.StatelessSession;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionImpl;
import org.springframework.batch.support.DatabaseType;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class SequenceGeneratorRepository {
    private final NamedParameterJdbcTemplate jdbcTemplate;
    private final EntityManager em;
    private final EntityManagerFactory emf;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextVal(String sequence) {
        SessionImpl session = (SessionImpl)this.em.unwrap(SessionImpl.class);
        Dialect dialect = HibernateUtils.getDialect((SessionImpl)session);
        if (!this.sequenceExists(dialect, sequence).booleanValue()) {
            DialectWrapper dialectWrapper = new DialectWrapper(dialect);
            String sqlCreateSequence = dialectWrapper.getCreateSequenceStrings(sequence, 2, 1);
            try (StatelessSession statelessSession = session.getFactory().openStatelessSession();){
                statelessSession.beginTransaction();
                statelessSession.createNativeQuery(sqlCreateSequence).executeUpdate();
                statelessSession.getTransaction().commit();
            }
            return 1L;
        }
        String sqlSequenceNextVal = dialect.getSelectSequenceNextValString(sequence);
        MapSqlParameterSource params = new MapSqlParameterSource();
        return (Long)this.jdbcTemplate.queryForObject("SELECT " + sqlSequenceNextVal + " FROM DUAL", (SqlParameterSource)params, Long.class);
    }

    private Boolean sequenceExists(Dialect dialect, String sequence) {
        String sqlSequenceQuery = JpaUtil.getQuerySequencesStringWithoutSchema((Dialect)dialect);
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("sequence_name", (Object)sequence.toUpperCase());
        List sequencesName = this.jdbcTemplate.queryForList(sqlSequenceQuery, (SqlParameterSource)params, String.class);
        return !sequencesName.isEmpty();
    }

    public Boolean sequenceExistsBySequenceName(String sequenceName) {
        SessionImpl session = (SessionImpl)this.em.unwrap(SessionImpl.class);
        Dialect dialect = HibernateUtils.getDialect((SessionImpl)session);
        return this.sequenceExists(dialect, sequenceName);
    }

    public void createSequenceWithCycle(String nomeSequence, Integer valorInicial, Integer valorFinal) {
        DataSource currentDataSource = this.namedParameterJdbcTemplate.getJdbcTemplate().getDataSource();
        DatabaseType currentDatabaseType = SqlUtils.getDatabaseType((DataSource)currentDataSource);
        StringBuilder query = new StringBuilder(String.format("create sequence %s minvalue %d maxvalue %d cycle", nomeSequence, valorInicial, valorFinal));
        if (DatabaseType.ORACLE.equals((Object)currentDatabaseType)) {
            query.append(" nocache");
        }
        this.executeQueryOnStatelessSession(query.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueryOnStatelessSession(String query) {
        SessionFactoryImplementor session = (SessionFactoryImplementor)this.emf.unwrap(SessionFactoryImpl.class);
        try (StatelessSession statelessSession = session.openStatelessSession();){
            statelessSession.beginTransaction();
            statelessSession.createNativeQuery(query).executeUpdate();
            statelessSession.getTransaction().commit();
        }
    }

    public void dropSequence(String sequenceName) {
        if (!this.sequenceExistsBySequenceName(sequenceName).booleanValue()) {
            return;
        }
        String query = String.format("drop sequence %s", sequenceName);
        this.executeQueryOnStatelessSession(query);
    }

    @Generated
    public SequenceGeneratorRepository(NamedParameterJdbcTemplate jdbcTemplate, EntityManager em, EntityManagerFactory emf, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.em = em;
        this.emf = emf;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    @Generated
    public NamedParameterJdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Generated
    public EntityManager getEm() {
        return this.em;
    }

    @Generated
    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    @Generated
    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceGeneratorRepository)) {
            return false;
        }
        SequenceGeneratorRepository other = (SequenceGeneratorRepository)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        NamedParameterJdbcTemplate this$jdbcTemplate = this.getJdbcTemplate();
        NamedParameterJdbcTemplate other$jdbcTemplate = other.getJdbcTemplate();
        if (this$jdbcTemplate == null ? other$jdbcTemplate != null : !this$jdbcTemplate.equals(other$jdbcTemplate)) {
            return false;
        }
        EntityManager this$em = this.getEm();
        EntityManager other$em = other.getEm();
        if (this$em == null ? other$em != null : !this$em.equals(other$em)) {
            return false;
        }
        EntityManagerFactory this$emf = this.getEmf();
        EntityManagerFactory other$emf = other.getEmf();
        if (this$emf == null ? other$emf != null : !this$emf.equals(other$emf)) {
            return false;
        }
        NamedParameterJdbcTemplate this$namedParameterJdbcTemplate = this.getNamedParameterJdbcTemplate();
        NamedParameterJdbcTemplate other$namedParameterJdbcTemplate = other.getNamedParameterJdbcTemplate();
        return !(this$namedParameterJdbcTemplate == null ? other$namedParameterJdbcTemplate != null : !this$namedParameterJdbcTemplate.equals(other$namedParameterJdbcTemplate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SequenceGeneratorRepository;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NamedParameterJdbcTemplate $jdbcTemplate = this.getJdbcTemplate();
        result = result * 59 + ($jdbcTemplate == null ? 43 : $jdbcTemplate.hashCode());
        EntityManager $em = this.getEm();
        result = result * 59 + ($em == null ? 43 : $em.hashCode());
        EntityManagerFactory $emf = this.getEmf();
        result = result * 59 + ($emf == null ? 43 : $emf.hashCode());
        NamedParameterJdbcTemplate $namedParameterJdbcTemplate = this.getNamedParameterJdbcTemplate();
        result = result * 59 + ($namedParameterJdbcTemplate == null ? 43 : $namedParameterJdbcTemplate.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SequenceGeneratorRepository(jdbcTemplate=" + this.getJdbcTemplate() + ", em=" + this.getEm() + ", emf=" + this.getEmf() + ", namedParameterJdbcTemplate=" + this.getNamedParameterJdbcTemplate() + ")";
    }
}

