/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.transferenciadebito;

import br.com.elotech.tributos.domain.transferenciadebito.TransferenciaDebito;
import br.com.elotech.tributos.dto.transferenciadebito.TDDebitoParcelaDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class TransferenciaDebitoDTO {
    private Long id;
    private String observacao;
    private LocalDate data;
    private String usuario;
    private BigDecimal valorTotalOrigem;
    private BigDecimal valorTotalDestino;
    private List<TDDebitoParcelaDTO> debitosParcelasOrigem;
    private List<TDDebitoParcelaDTO> debitosParcelasDestino;

    public static TransferenciaDebitoDTO fromWithoutDebitos(TransferenciaDebito transferenciaDebito) {
        TransferenciaDebitoDTO dto = new TransferenciaDebitoDTO();
        dto.setId(transferenciaDebito.getId());
        dto.setObservacao(transferenciaDebito.getObservacao());
        dto.setUsuario(transferenciaDebito.getUsuario());
        dto.setData(transferenciaDebito.getData());
        return dto;
    }

    public static TransferenciaDebitoDTO from(TransferenciaDebito transferenciaDebito) {
        TransferenciaDebitoDTO dto = TransferenciaDebitoDTO.fromWithoutDebitos((TransferenciaDebito)transferenciaDebito);
        dto.setValorTotalOrigem(transferenciaDebito.getValorTotalOrigem());
        dto.setValorTotalDestino(transferenciaDebito.getValorTotalDestino());
        transferenciaDebito.getDebitos().forEach(td -> {
            dto.setDebitosParcelasOrigem(td.getDebitoOrigem().getParcelas().stream().map(TDDebitoParcelaDTO::from).collect(Collectors.toList()));
            dto.setDebitosParcelasDestino(td.getDebitoDestino().getParcelas().stream().map(TDDebitoParcelaDTO::from).collect(Collectors.toList()));
        });
        dto.getDebitosParcelasOrigem().sort(TransferenciaDebitoDTO.comparator());
        dto.getDebitosParcelasDestino().sort(TransferenciaDebitoDTO.comparator());
        return dto;
    }

    private static Comparator<TDDebitoParcelaDTO> comparator() {
        return Comparator.comparing(TDDebitoParcelaDTO::getTipoCadastro).thenComparing(TDDebitoParcelaDTO::getCadastroGeral).thenComparing(TDDebitoParcelaDTO::getDivida).thenComparing(TDDebitoParcelaDTO::getSubDivida).thenComparing(TDDebitoParcelaDTO::getParcela);
    }

    @Generated
    public TransferenciaDebitoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public BigDecimal getValorTotalOrigem() {
        return this.valorTotalOrigem;
    }

    @Generated
    public BigDecimal getValorTotalDestino() {
        return this.valorTotalDestino;
    }

    @Generated
    public List<TDDebitoParcelaDTO> getDebitosParcelasOrigem() {
        return this.debitosParcelasOrigem;
    }

    @Generated
    public List<TDDebitoParcelaDTO> getDebitosParcelasDestino() {
        return this.debitosParcelasDestino;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setValorTotalOrigem(BigDecimal valorTotalOrigem) {
        this.valorTotalOrigem = valorTotalOrigem;
    }

    @Generated
    public void setValorTotalDestino(BigDecimal valorTotalDestino) {
        this.valorTotalDestino = valorTotalDestino;
    }

    @Generated
    public void setDebitosParcelasOrigem(List<TDDebitoParcelaDTO> debitosParcelasOrigem) {
        this.debitosParcelasOrigem = debitosParcelasOrigem;
    }

    @Generated
    public void setDebitosParcelasDestino(List<TDDebitoParcelaDTO> debitosParcelasDestino) {
        this.debitosParcelasDestino = debitosParcelasDestino;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferenciaDebitoDTO)) {
            return false;
        }
        TransferenciaDebitoDTO other = (TransferenciaDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        BigDecimal this$valorTotalOrigem = this.getValorTotalOrigem();
        BigDecimal other$valorTotalOrigem = other.getValorTotalOrigem();
        if (this$valorTotalOrigem == null ? other$valorTotalOrigem != null : !((Object)this$valorTotalOrigem).equals(other$valorTotalOrigem)) {
            return false;
        }
        BigDecimal this$valorTotalDestino = this.getValorTotalDestino();
        BigDecimal other$valorTotalDestino = other.getValorTotalDestino();
        if (this$valorTotalDestino == null ? other$valorTotalDestino != null : !((Object)this$valorTotalDestino).equals(other$valorTotalDestino)) {
            return false;
        }
        List this$debitosParcelasOrigem = this.getDebitosParcelasOrigem();
        List other$debitosParcelasOrigem = other.getDebitosParcelasOrigem();
        if (this$debitosParcelasOrigem == null ? other$debitosParcelasOrigem != null : !((Object)this$debitosParcelasOrigem).equals(other$debitosParcelasOrigem)) {
            return false;
        }
        List this$debitosParcelasDestino = this.getDebitosParcelasDestino();
        List other$debitosParcelasDestino = other.getDebitosParcelasDestino();
        return !(this$debitosParcelasDestino == null ? other$debitosParcelasDestino != null : !((Object)this$debitosParcelasDestino).equals(other$debitosParcelasDestino));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransferenciaDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        BigDecimal $valorTotalOrigem = this.getValorTotalOrigem();
        result = result * 59 + ($valorTotalOrigem == null ? 43 : ((Object)$valorTotalOrigem).hashCode());
        BigDecimal $valorTotalDestino = this.getValorTotalDestino();
        result = result * 59 + ($valorTotalDestino == null ? 43 : ((Object)$valorTotalDestino).hashCode());
        List $debitosParcelasOrigem = this.getDebitosParcelasOrigem();
        result = result * 59 + ($debitosParcelasOrigem == null ? 43 : ((Object)$debitosParcelasOrigem).hashCode());
        List $debitosParcelasDestino = this.getDebitosParcelasDestino();
        result = result * 59 + ($debitosParcelasDestino == null ? 43 : ((Object)$debitosParcelasDestino).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransferenciaDebitoDTO(id=" + this.getId() + ", observacao=" + this.getObservacao() + ", data=" + this.getData() + ", usuario=" + this.getUsuario() + ", valorTotalOrigem=" + this.getValorTotalOrigem() + ", valorTotalDestino=" + this.getValorTotalDestino() + ", debitosParcelasOrigem=" + this.getDebitosParcelasOrigem() + ", debitosParcelasDestino=" + this.getDebitosParcelasDestino() + ")";
    }
}

