/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaogeomais;

import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.imobiliario.BoletimImobiliarioTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO;
import br.com.elotech.tributos.dto.integracaogeomais.BairroGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroImobiliarioGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CidadeGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.LogradouroGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.PessoaGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.ProprietarioGeomaisDTO;
import br.com.elotech.tributos.util.BooleanToStringUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class CadastroGeralGeomaisDTO {
    private Long id;
    private Long codigo;
    private TipoCadastro tipo;
    private String numero;
    private String complemento;
    private Long cep;
    private LocalDate dataInclusao;
    private LocalDate dataAlteracao;
    private String exclusaoLogica;
    private String englobado;
    private String correspondenciaLocal;
    private PessoaGeomaisDTO pessoa;
    private LogradouroGeomaisDTO logradouro;
    private BairroGeomaisDTO bairro;
    private CidadeGeomaisDTO cidade;
    private CadastroImobiliarioGeomaisDTO imobiliario;
    private List<ProprietarioGeomaisDTO> proprietarios;

    public static CadastroGeralGeomaisDTO from(CadastroImobiliario cadastroImobiliarioEntity, List<BoletimImobiliarioTerreno> boletimTerreno) {
        CadastroGeralGeomaisDTO cadastroGeralGeomaisDTO = new CadastroGeralGeomaisDTO();
        cadastroGeralGeomaisDTO.setId(cadastroImobiliarioEntity.getId());
        cadastroGeralGeomaisDTO.setCodigo(cadastroImobiliarioEntity.getCadastroGeral());
        cadastroGeralGeomaisDTO.setTipo(cadastroImobiliarioEntity.getTipoCadastro());
        cadastroGeralGeomaisDTO.setNumero(cadastroImobiliarioEntity.getNumero());
        cadastroGeralGeomaisDTO.setComplemento(cadastroImobiliarioEntity.getComplemento());
        cadastroGeralGeomaisDTO.setCep(cadastroImobiliarioEntity.getCep());
        cadastroGeralGeomaisDTO.setDataInclusao(cadastroImobiliarioEntity.getDataInclusao());
        cadastroGeralGeomaisDTO.setDataAlteracao(cadastroImobiliarioEntity.getDataAlteracao());
        cadastroGeralGeomaisDTO.setExclusaoLogica(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getExclusaoLogica()));
        cadastroGeralGeomaisDTO.setEnglobado(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getEnglobado()));
        cadastroGeralGeomaisDTO.setCorrespondenciaLocal(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getCorrespondenciaLocal()));
        cadastroGeralGeomaisDTO.setPessoa(PessoaGeomaisDTO.from((Pessoa)cadastroImobiliarioEntity.getPessoa()));
        cadastroGeralGeomaisDTO.setLogradouro((LogradouroGeomaisDTO)Optional.ofNullable(cadastroImobiliarioEntity.getLogradouro()).map(logradouro -> LogradouroGeomaisDTO.from((Logradouro)cadastroImobiliarioEntity.getLogradouro())).orElse(null));
        cadastroGeralGeomaisDTO.setBairro((BairroGeomaisDTO)Optional.ofNullable(cadastroImobiliarioEntity.getBairro()).map(bairro -> BairroGeomaisDTO.from((Bairro)cadastroImobiliarioEntity.getBairro())).orElse(null));
        cadastroGeralGeomaisDTO.setCidade((CidadeGeomaisDTO)Optional.ofNullable(cadastroImobiliarioEntity.getCidade()).map(cidade -> CidadeGeomaisDTO.from((Cidade)cadastroImobiliarioEntity.getCidade())).orElse(null));
        cadastroGeralGeomaisDTO.setImobiliario(CadastroImobiliarioGeomaisDTO.from((CadastroImobiliario)cadastroImobiliarioEntity, boletimTerreno));
        cadastroGeralGeomaisDTO.setProprietarios(cadastroImobiliarioEntity.getProprietarios().stream().map(ProprietarioGeomaisDTO::from).collect(Collectors.toList()));
        return cadastroGeralGeomaisDTO;
    }

    public static CadastroGeralGeomaisDTO oxyFrom(CadastroImobiliario cadastroImobiliarioEntity, List<RespostaDTO> boletimTerreno) {
        CadastroGeralGeomaisDTO cadastroGeralGeomaisDTO = new CadastroGeralGeomaisDTO();
        cadastroGeralGeomaisDTO.setId(cadastroImobiliarioEntity.getId());
        cadastroGeralGeomaisDTO.setCodigo(cadastroImobiliarioEntity.getCadastroGeral());
        cadastroGeralGeomaisDTO.setTipo(cadastroImobiliarioEntity.getTipoCadastro());
        cadastroGeralGeomaisDTO.setNumero(cadastroImobiliarioEntity.getNumero());
        cadastroGeralGeomaisDTO.setComplemento(cadastroImobiliarioEntity.getComplemento());
        cadastroGeralGeomaisDTO.setCep(cadastroImobiliarioEntity.getCep());
        cadastroGeralGeomaisDTO.setDataInclusao(cadastroImobiliarioEntity.getDataInclusao());
        cadastroGeralGeomaisDTO.setDataAlteracao(cadastroImobiliarioEntity.getDataAlteracao());
        cadastroGeralGeomaisDTO.setExclusaoLogica(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getExclusaoLogica()));
        cadastroGeralGeomaisDTO.setEnglobado(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getEnglobado()));
        cadastroGeralGeomaisDTO.setCorrespondenciaLocal(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroImobiliarioEntity.getCorrespondenciaLocal()));
        cadastroGeralGeomaisDTO.setPessoa(PessoaGeomaisDTO.from((Pessoa)cadastroImobiliarioEntity.getPessoa()));
        cadastroGeralGeomaisDTO.setLogradouro((LogradouroGeomaisDTO)Optional.ofNullable(cadastroImobiliarioEntity.getLogradouro()).map(LogradouroGeomaisDTO::from).orElse(null));
        cadastroGeralGeomaisDTO.setBairro((BairroGeomaisDTO)Optional.ofNullable(cadastroImobiliarioEntity.getBairro()).map(BairroGeomaisDTO::from).orElse(null));
        cadastroGeralGeomaisDTO.setCidade((CidadeGeomaisDTO)Optional.ofNullable(cadastroImobiliarioEntity.getCidade()).map(CidadeGeomaisDTO::from).orElse(null));
        cadastroGeralGeomaisDTO.setImobiliario(CadastroImobiliarioGeomaisDTO.oxyFrom((CadastroImobiliario)cadastroImobiliarioEntity, boletimTerreno));
        cadastroGeralGeomaisDTO.setProprietarios(cadastroImobiliarioEntity.getProprietarios().stream().map(ProprietarioGeomaisDTO::from).collect(Collectors.toList()));
        return cadastroGeralGeomaisDTO;
    }

    @Generated
    public CadastroGeralGeomaisDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public TipoCadastro getTipo() {
        return this.tipo;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public String getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public String getEnglobado() {
        return this.englobado;
    }

    @Generated
    public String getCorrespondenciaLocal() {
        return this.correspondenciaLocal;
    }

    @Generated
    public PessoaGeomaisDTO getPessoa() {
        return this.pessoa;
    }

    @Generated
    public LogradouroGeomaisDTO getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public BairroGeomaisDTO getBairro() {
        return this.bairro;
    }

    @Generated
    public CidadeGeomaisDTO getCidade() {
        return this.cidade;
    }

    @Generated
    public CadastroImobiliarioGeomaisDTO getImobiliario() {
        return this.imobiliario;
    }

    @Generated
    public List<ProprietarioGeomaisDTO> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setTipo(TipoCadastro tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setExclusaoLogica(String exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setEnglobado(String englobado) {
        this.englobado = englobado;
    }

    @Generated
    public void setCorrespondenciaLocal(String correspondenciaLocal) {
        this.correspondenciaLocal = correspondenciaLocal;
    }

    @Generated
    public void setPessoa(PessoaGeomaisDTO pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setLogradouro(LogradouroGeomaisDTO logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setBairro(BairroGeomaisDTO bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCidade(CidadeGeomaisDTO cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setImobiliario(CadastroImobiliarioGeomaisDTO imobiliario) {
        this.imobiliario = imobiliario;
    }

    @Generated
    public void setProprietarios(List<ProprietarioGeomaisDTO> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroGeralGeomaisDTO)) {
            return false;
        }
        CadastroGeralGeomaisDTO other = (CadastroGeralGeomaisDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        Long this$cep = this.getCep();
        Long other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !((Object)this$cep).equals(other$cep)) {
            return false;
        }
        TipoCadastro this$tipo = this.getTipo();
        TipoCadastro other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        LocalDate this$dataAlteracao = this.getDataAlteracao();
        LocalDate other$dataAlteracao = other.getDataAlteracao();
        if (this$dataAlteracao == null ? other$dataAlteracao != null : !((Object)this$dataAlteracao).equals(other$dataAlteracao)) {
            return false;
        }
        String this$exclusaoLogica = this.getExclusaoLogica();
        String other$exclusaoLogica = other.getExclusaoLogica();
        if (this$exclusaoLogica == null ? other$exclusaoLogica != null : !this$exclusaoLogica.equals(other$exclusaoLogica)) {
            return false;
        }
        String this$englobado = this.getEnglobado();
        String other$englobado = other.getEnglobado();
        if (this$englobado == null ? other$englobado != null : !this$englobado.equals(other$englobado)) {
            return false;
        }
        String this$correspondenciaLocal = this.getCorrespondenciaLocal();
        String other$correspondenciaLocal = other.getCorrespondenciaLocal();
        if (this$correspondenciaLocal == null ? other$correspondenciaLocal != null : !this$correspondenciaLocal.equals(other$correspondenciaLocal)) {
            return false;
        }
        PessoaGeomaisDTO this$pessoa = this.getPessoa();
        PessoaGeomaisDTO other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        LogradouroGeomaisDTO this$logradouro = this.getLogradouro();
        LogradouroGeomaisDTO other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        BairroGeomaisDTO this$bairro = this.getBairro();
        BairroGeomaisDTO other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        CidadeGeomaisDTO this$cidade = this.getCidade();
        CidadeGeomaisDTO other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        CadastroImobiliarioGeomaisDTO this$imobiliario = this.getImobiliario();
        CadastroImobiliarioGeomaisDTO other$imobiliario = other.getImobiliario();
        if (this$imobiliario == null ? other$imobiliario != null : !this$imobiliario.equals(other$imobiliario)) {
            return false;
        }
        List this$proprietarios = this.getProprietarios();
        List other$proprietarios = other.getProprietarios();
        return !(this$proprietarios == null ? other$proprietarios != null : !((Object)this$proprietarios).equals(other$proprietarios));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroGeralGeomaisDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        Long $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : ((Object)$cep).hashCode());
        TipoCadastro $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        LocalDate $dataAlteracao = this.getDataAlteracao();
        result = result * 59 + ($dataAlteracao == null ? 43 : ((Object)$dataAlteracao).hashCode());
        String $exclusaoLogica = this.getExclusaoLogica();
        result = result * 59 + ($exclusaoLogica == null ? 43 : $exclusaoLogica.hashCode());
        String $englobado = this.getEnglobado();
        result = result * 59 + ($englobado == null ? 43 : $englobado.hashCode());
        String $correspondenciaLocal = this.getCorrespondenciaLocal();
        result = result * 59 + ($correspondenciaLocal == null ? 43 : $correspondenciaLocal.hashCode());
        PessoaGeomaisDTO $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        LogradouroGeomaisDTO $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        BairroGeomaisDTO $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        CidadeGeomaisDTO $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        CadastroImobiliarioGeomaisDTO $imobiliario = this.getImobiliario();
        result = result * 59 + ($imobiliario == null ? 43 : $imobiliario.hashCode());
        List $proprietarios = this.getProprietarios();
        result = result * 59 + ($proprietarios == null ? 43 : ((Object)$proprietarios).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroGeralGeomaisDTO(id=" + this.getId() + ", codigo=" + this.getCodigo() + ", tipo=" + this.getTipo() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", cep=" + this.getCep() + ", dataInclusao=" + this.getDataInclusao() + ", dataAlteracao=" + this.getDataAlteracao() + ", exclusaoLogica=" + this.getExclusaoLogica() + ", englobado=" + this.getEnglobado() + ", correspondenciaLocal=" + this.getCorrespondenciaLocal() + ", pessoa=" + this.getPessoa() + ", logradouro=" + this.getLogradouro() + ", bairro=" + this.getBairro() + ", cidade=" + this.getCidade() + ", imobiliario=" + this.getImobiliario() + ", proprietarios=" + this.getProprietarios() + ")";
    }
}

