/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaocontabil;

import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.dto.integracaocontabil.ArrecadacaoPorLoteDTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class ArrecadacaoPorLotePrintDTO {
    @Caption(value="Data")
    private LocalDate dataMovimento;
    @Caption(value="Lote/Ano")
    private String lote;
    @Caption(value="Conta Banc\u00e1ria")
    private String contaBancaria;
    @Caption(value="Conv\u00eanio")
    private String convenio;
    @Caption(value="Valor do Arquivo Retorno")
    private BigDecimal valorArquivo = BigDecimal.ZERO;
    private BigDecimal valorPagamento = BigDecimal.ZERO;
    private BigDecimal valorCredito = BigDecimal.ZERO;
    private BigDecimal valorEstornado = BigDecimal.ZERO;
    private BigDecimal valorReabilitado = BigDecimal.ZERO;
    @Caption(value="Valor Pagamentos")
    private BigDecimal valorPagamentos = BigDecimal.ZERO;
    private String tipoLote;

    public static ArrecadacaoPorLotePrintDTO from(ArrecadacaoPorLoteDTO arrecadacaoPorLoteDTO) {
        return Optional.ofNullable(arrecadacaoPorLoteDTO).map(lote -> {
            ArrecadacaoPorLotePrintDTO lotePrintDTO = new ArrecadacaoPorLotePrintDTO();
            lotePrintDTO.setDataMovimento(arrecadacaoPorLoteDTO.getDataMovimento());
            lotePrintDTO.setContaBancaria(arrecadacaoPorLoteDTO.getContaBancaria() + " - " + arrecadacaoPorLoteDTO.getDescricaoConta());
            lotePrintDTO.setLote(arrecadacaoPorLoteDTO.getLote() + "/" + arrecadacaoPorLoteDTO.getExercicio());
            lotePrintDTO.setConvenio(arrecadacaoPorLoteDTO.getConvenio() + " - " + arrecadacaoPorLoteDTO.getDescricaoConvenio());
            lotePrintDTO.setValorArquivo(arrecadacaoPorLoteDTO.getValorArquivo());
            lotePrintDTO.setValorPagamento(arrecadacaoPorLoteDTO.getValorPagamento());
            lotePrintDTO.setValorCredito(arrecadacaoPorLoteDTO.getValorCredito());
            lotePrintDTO.setValorEstornado(arrecadacaoPorLoteDTO.getValorEstornado());
            lotePrintDTO.setValorReabilitado(arrecadacaoPorLoteDTO.getValorReabilitado());
            lotePrintDTO.setValorPagamentos(lotePrintDTO.getValorPagamento().add(lotePrintDTO.getValorCredito()).subtract(lotePrintDTO.getValorEstornado()).add(lotePrintDTO.getValorReabilitado()));
            lotePrintDTO.setTipoLote(arrecadacaoPorLoteDTO.getTipoLote().getDescricao());
            return lotePrintDTO;
        }).orElse(null);
    }

    @Generated
    public ArrecadacaoPorLotePrintDTO() {
    }

    @Generated
    public LocalDate getDataMovimento() {
        return this.dataMovimento;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public String getContaBancaria() {
        return this.contaBancaria;
    }

    @Generated
    public String getConvenio() {
        return this.convenio;
    }

    @Generated
    public BigDecimal getValorArquivo() {
        return this.valorArquivo;
    }

    @Generated
    public BigDecimal getValorPagamento() {
        return this.valorPagamento;
    }

    @Generated
    public BigDecimal getValorCredito() {
        return this.valorCredito;
    }

    @Generated
    public BigDecimal getValorEstornado() {
        return this.valorEstornado;
    }

    @Generated
    public BigDecimal getValorReabilitado() {
        return this.valorReabilitado;
    }

    @Generated
    public BigDecimal getValorPagamentos() {
        return this.valorPagamentos;
    }

    @Generated
    public String getTipoLote() {
        return this.tipoLote;
    }

    @Generated
    public void setDataMovimento(LocalDate dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setContaBancaria(String contaBancaria) {
        this.contaBancaria = contaBancaria;
    }

    @Generated
    public void setConvenio(String convenio) {
        this.convenio = convenio;
    }

    @Generated
    public void setValorArquivo(BigDecimal valorArquivo) {
        this.valorArquivo = valorArquivo;
    }

    @Generated
    public void setValorPagamento(BigDecimal valorPagamento) {
        this.valorPagamento = valorPagamento;
    }

    @Generated
    public void setValorCredito(BigDecimal valorCredito) {
        this.valorCredito = valorCredito;
    }

    @Generated
    public void setValorEstornado(BigDecimal valorEstornado) {
        this.valorEstornado = valorEstornado;
    }

    @Generated
    public void setValorReabilitado(BigDecimal valorReabilitado) {
        this.valorReabilitado = valorReabilitado;
    }

    @Generated
    public void setValorPagamentos(BigDecimal valorPagamentos) {
        this.valorPagamentos = valorPagamentos;
    }

    @Generated
    public void setTipoLote(String tipoLote) {
        this.tipoLote = tipoLote;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArrecadacaoPorLotePrintDTO)) {
            return false;
        }
        ArrecadacaoPorLotePrintDTO other = (ArrecadacaoPorLotePrintDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LocalDate this$dataMovimento = this.getDataMovimento();
        LocalDate other$dataMovimento = other.getDataMovimento();
        if (this$dataMovimento == null ? other$dataMovimento != null : !((Object)this$dataMovimento).equals(other$dataMovimento)) {
            return false;
        }
        String this$lote = this.getLote();
        String other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !this$lote.equals(other$lote)) {
            return false;
        }
        String this$contaBancaria = this.getContaBancaria();
        String other$contaBancaria = other.getContaBancaria();
        if (this$contaBancaria == null ? other$contaBancaria != null : !this$contaBancaria.equals(other$contaBancaria)) {
            return false;
        }
        String this$convenio = this.getConvenio();
        String other$convenio = other.getConvenio();
        if (this$convenio == null ? other$convenio != null : !this$convenio.equals(other$convenio)) {
            return false;
        }
        BigDecimal this$valorArquivo = this.getValorArquivo();
        BigDecimal other$valorArquivo = other.getValorArquivo();
        if (this$valorArquivo == null ? other$valorArquivo != null : !((Object)this$valorArquivo).equals(other$valorArquivo)) {
            return false;
        }
        BigDecimal this$valorPagamento = this.getValorPagamento();
        BigDecimal other$valorPagamento = other.getValorPagamento();
        if (this$valorPagamento == null ? other$valorPagamento != null : !((Object)this$valorPagamento).equals(other$valorPagamento)) {
            return false;
        }
        BigDecimal this$valorCredito = this.getValorCredito();
        BigDecimal other$valorCredito = other.getValorCredito();
        if (this$valorCredito == null ? other$valorCredito != null : !((Object)this$valorCredito).equals(other$valorCredito)) {
            return false;
        }
        BigDecimal this$valorEstornado = this.getValorEstornado();
        BigDecimal other$valorEstornado = other.getValorEstornado();
        if (this$valorEstornado == null ? other$valorEstornado != null : !((Object)this$valorEstornado).equals(other$valorEstornado)) {
            return false;
        }
        BigDecimal this$valorReabilitado = this.getValorReabilitado();
        BigDecimal other$valorReabilitado = other.getValorReabilitado();
        if (this$valorReabilitado == null ? other$valorReabilitado != null : !((Object)this$valorReabilitado).equals(other$valorReabilitado)) {
            return false;
        }
        BigDecimal this$valorPagamentos = this.getValorPagamentos();
        BigDecimal other$valorPagamentos = other.getValorPagamentos();
        if (this$valorPagamentos == null ? other$valorPagamentos != null : !((Object)this$valorPagamentos).equals(other$valorPagamentos)) {
            return false;
        }
        String this$tipoLote = this.getTipoLote();
        String other$tipoLote = other.getTipoLote();
        return !(this$tipoLote == null ? other$tipoLote != null : !this$tipoLote.equals(other$tipoLote));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArrecadacaoPorLotePrintDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $dataMovimento = this.getDataMovimento();
        result = result * 59 + ($dataMovimento == null ? 43 : ((Object)$dataMovimento).hashCode());
        String $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : $lote.hashCode());
        String $contaBancaria = this.getContaBancaria();
        result = result * 59 + ($contaBancaria == null ? 43 : $contaBancaria.hashCode());
        String $convenio = this.getConvenio();
        result = result * 59 + ($convenio == null ? 43 : $convenio.hashCode());
        BigDecimal $valorArquivo = this.getValorArquivo();
        result = result * 59 + ($valorArquivo == null ? 43 : ((Object)$valorArquivo).hashCode());
        BigDecimal $valorPagamento = this.getValorPagamento();
        result = result * 59 + ($valorPagamento == null ? 43 : ((Object)$valorPagamento).hashCode());
        BigDecimal $valorCredito = this.getValorCredito();
        result = result * 59 + ($valorCredito == null ? 43 : ((Object)$valorCredito).hashCode());
        BigDecimal $valorEstornado = this.getValorEstornado();
        result = result * 59 + ($valorEstornado == null ? 43 : ((Object)$valorEstornado).hashCode());
        BigDecimal $valorReabilitado = this.getValorReabilitado();
        result = result * 59 + ($valorReabilitado == null ? 43 : ((Object)$valorReabilitado).hashCode());
        BigDecimal $valorPagamentos = this.getValorPagamentos();
        result = result * 59 + ($valorPagamentos == null ? 43 : ((Object)$valorPagamentos).hashCode());
        String $tipoLote = this.getTipoLote();
        result = result * 59 + ($tipoLote == null ? 43 : $tipoLote.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArrecadacaoPorLotePrintDTO(dataMovimento=" + this.getDataMovimento() + ", lote=" + this.getLote() + ", contaBancaria=" + this.getContaBancaria() + ", convenio=" + this.getConvenio() + ", valorArquivo=" + this.getValorArquivo() + ", valorPagamento=" + this.getValorPagamento() + ", valorCredito=" + this.getValorCredito() + ", valorEstornado=" + this.getValorEstornado() + ", valorReabilitado=" + this.getValorReabilitado() + ", valorPagamentos=" + this.getValorPagamentos() + ", tipoLote=" + this.getTipoLote() + ")";
    }
}

