/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.contribuicaomelhoria;

import br.com.elotech.tributos.domain.contribuicaomelhoria.MelhoriaEdital;
import br.com.elotech.tributos.domain.contribuicaomelhoria.MelhoriaEditalObra;
import br.com.elotech.tributos.domain.contribuicaomelhoria.ObraIntervencao;
import br.com.elotech.tributos.domain.contribuicaomelhoria.id.MelhoriaEditalId;
import br.com.elotech.tributos.domain.contribuicaomelhoria.id.MelhoriaEditalObraId;
import java.math.BigDecimal;
import java.util.Optional;
import lombok.Generated;

public class MelhoriaObraDTO {
    private Long entidade;
    private Long exercicio;
    private Long numeroEdital;
    private Long exercicioIntervencao;
    private Long intervencao;
    private String descricao;
    private BigDecimal valor;
    private BigDecimal valorContribuicao;
    private BigDecimal areaPavimentada;

    public static MelhoriaObraDTO from(MelhoriaEditalObra obra) {
        MelhoriaObraDTO dto = new MelhoriaObraDTO();
        dto.setEntidade(obra.getId().getMelhoriaEdital().getId().getEntidade());
        dto.setExercicio(obra.getId().getMelhoriaEdital().getId().getExercicio());
        dto.setNumeroEdital(obra.getId().getMelhoriaEdital().getId().getNumeroEdital());
        dto.setExercicioIntervencao(obra.getId().getExercicioIntervencao());
        dto.setIntervencao(obra.getId().getIntervencao());
        dto.setDescricao((String)Optional.ofNullable(obra.getObraIntervencao()).map(ObraIntervencao::getNome).orElse(null));
        dto.setValor((BigDecimal)Optional.ofNullable(obra.getObraIntervencao()).map(ObraIntervencao::getValorTotal).orElse(null));
        dto.setValorContribuicao(obra.getValorContribuicao());
        dto.setAreaPavimentada(obra.getAreaPavimentada());
        return dto;
    }

    public MelhoriaEditalObra toEntity(Long exercicio, Long numeroEdital) {
        MelhoriaEditalId melhoriaId = new MelhoriaEditalId();
        MelhoriaEdital melhoria = new MelhoriaEdital();
        MelhoriaEditalObraId obraId = new MelhoriaEditalObraId();
        MelhoriaEditalObra obra = new MelhoriaEditalObra();
        melhoriaId.setEntidade(this.entidade);
        melhoriaId.setExercicio(exercicio);
        melhoriaId.setNumeroEdital(numeroEdital);
        melhoria.setId(melhoriaId);
        obraId.setMelhoriaEdital(melhoria);
        obraId.setIntervencao(this.intervencao);
        obraId.setExercicioIntervencao(this.exercicioIntervencao);
        obra.setId(obraId);
        obra.setValorContribuicao(this.valorContribuicao);
        obra.setAreaPavimentada(this.areaPavimentada);
        return obra;
    }

    @Generated
    public MelhoriaObraDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getNumeroEdital() {
        return this.numeroEdital;
    }

    @Generated
    public Long getExercicioIntervencao() {
        return this.exercicioIntervencao;
    }

    @Generated
    public Long getIntervencao() {
        return this.intervencao;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public BigDecimal getValor() {
        return this.valor;
    }

    @Generated
    public BigDecimal getValorContribuicao() {
        return this.valorContribuicao;
    }

    @Generated
    public BigDecimal getAreaPavimentada() {
        return this.areaPavimentada;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setNumeroEdital(Long numeroEdital) {
        this.numeroEdital = numeroEdital;
    }

    @Generated
    public void setExercicioIntervencao(Long exercicioIntervencao) {
        this.exercicioIntervencao = exercicioIntervencao;
    }

    @Generated
    public void setIntervencao(Long intervencao) {
        this.intervencao = intervencao;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Generated
    public void setValorContribuicao(BigDecimal valorContribuicao) {
        this.valorContribuicao = valorContribuicao;
    }

    @Generated
    public void setAreaPavimentada(BigDecimal areaPavimentada) {
        this.areaPavimentada = areaPavimentada;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MelhoriaObraDTO)) {
            return false;
        }
        MelhoriaObraDTO other = (MelhoriaObraDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$numeroEdital = this.getNumeroEdital();
        Long other$numeroEdital = other.getNumeroEdital();
        if (this$numeroEdital == null ? other$numeroEdital != null : !((Object)this$numeroEdital).equals(other$numeroEdital)) {
            return false;
        }
        Long this$exercicioIntervencao = this.getExercicioIntervencao();
        Long other$exercicioIntervencao = other.getExercicioIntervencao();
        if (this$exercicioIntervencao == null ? other$exercicioIntervencao != null : !((Object)this$exercicioIntervencao).equals(other$exercicioIntervencao)) {
            return false;
        }
        Long this$intervencao = this.getIntervencao();
        Long other$intervencao = other.getIntervencao();
        if (this$intervencao == null ? other$intervencao != null : !((Object)this$intervencao).equals(other$intervencao)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        BigDecimal this$valor = this.getValor();
        BigDecimal other$valor = other.getValor();
        if (this$valor == null ? other$valor != null : !((Object)this$valor).equals(other$valor)) {
            return false;
        }
        BigDecimal this$valorContribuicao = this.getValorContribuicao();
        BigDecimal other$valorContribuicao = other.getValorContribuicao();
        if (this$valorContribuicao == null ? other$valorContribuicao != null : !((Object)this$valorContribuicao).equals(other$valorContribuicao)) {
            return false;
        }
        BigDecimal this$areaPavimentada = this.getAreaPavimentada();
        BigDecimal other$areaPavimentada = other.getAreaPavimentada();
        return !(this$areaPavimentada == null ? other$areaPavimentada != null : !((Object)this$areaPavimentada).equals(other$areaPavimentada));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MelhoriaObraDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $numeroEdital = this.getNumeroEdital();
        result = result * 59 + ($numeroEdital == null ? 43 : ((Object)$numeroEdital).hashCode());
        Long $exercicioIntervencao = this.getExercicioIntervencao();
        result = result * 59 + ($exercicioIntervencao == null ? 43 : ((Object)$exercicioIntervencao).hashCode());
        Long $intervencao = this.getIntervencao();
        result = result * 59 + ($intervencao == null ? 43 : ((Object)$intervencao).hashCode());
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        BigDecimal $valor = this.getValor();
        result = result * 59 + ($valor == null ? 43 : ((Object)$valor).hashCode());
        BigDecimal $valorContribuicao = this.getValorContribuicao();
        result = result * 59 + ($valorContribuicao == null ? 43 : ((Object)$valorContribuicao).hashCode());
        BigDecimal $areaPavimentada = this.getAreaPavimentada();
        result = result * 59 + ($areaPavimentada == null ? 43 : ((Object)$areaPavimentada).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MelhoriaObraDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", numeroEdital=" + this.getNumeroEdital() + ", exercicioIntervencao=" + this.getExercicioIntervencao() + ", intervencao=" + this.getIntervencao() + ", descricao=" + this.getDescricao() + ", valor=" + this.getValor() + ", valorContribuicao=" + this.getValorContribuicao() + ", areaPavimentada=" + this.getAreaPavimentada() + ")";
    }
}

