/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.DebitoManualId;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import java.io.Serializable;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="tribdebitomanual")
public class DebitoManual
implements Serializable,
EloEntity<DebitoManualId> {
    @EmbeddedId
    private DebitoManualId id;
    @NotNull(message="Data inclus\u00e3o \u00e9 obrigat\u00f3ria no D\u00e9bito Manual")
    private @NotNull(message="Data inclus\u00e3o \u00e9 obrigat\u00f3ria no D\u00e9bito Manual") LocalDate dataInclusao;
    private Long exercicioProcesso;
    private Long idProcesso;
    @NotNull(message="Exerc\u00edcio d\u00e9bito \u00e9 obrigat\u00f3rio no D\u00e9bito Manual")
    private @NotNull(message="Exerc\u00edcio d\u00e9bito \u00e9 obrigat\u00f3rio no D\u00e9bito Manual") Long exercicioDebito;
    @NotNull(message="Tipo Cadastro \u00e9 obrigat\u00f3rio no D\u00e9bito Manual")
    private @NotNull(message="Tipo Cadastro \u00e9 obrigat\u00f3rio no D\u00e9bito Manual") Long tipoCadastro;
    @NotNull(message="Cadastro \u00e9 obrigat\u00f3rio no D\u00e9bito Manual")
    private @NotNull(message="Cadastro \u00e9 obrigat\u00f3rio no D\u00e9bito Manual") Long cadastroGeral;
    @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3ria no D\u00e9bito Manual")
    @Column(name="guiarecolhimento")
    private @NotNull(message="D\u00edvida \u00e9 obrigat\u00f3ria no D\u00e9bito Manual") Long divida;
    @NotNull(message="Subdivida \u00e9 obrigat\u00f3ria no D\u00e9bito Manual")
    private @NotNull(message="Subdivida \u00e9 obrigat\u00f3ria no D\u00e9bito Manual") Long subDivida;
    @Length(max=1000, message="Tamanho m\u00e1ximo do motivo \u00e9 1000 caracteres")
    private @Length(max=1000, message="Tamanho m\u00e1ximo do motivo \u00e9 1000 caracteres") String motivo;
    @Length(max=15, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 15 caracteres")
    private @Length(max=15, message="Tamanho m\u00e1ximo do usu\u00e1rio \u00e9 15 caracteres") String usuario;

    public static final DebitoManual of(Long entidade, String usuario, DebitoManualDTO debitoManualDTO) {
        DebitoManualId debitoManualId = new DebitoManualId();
        debitoManualId.setEntidade(entidade);
        DebitoManual debitoManual = new DebitoManual();
        debitoManual.setId(debitoManualId);
        debitoManual.setExercicioDebito(debitoManualDTO.getExercicio());
        debitoManual.setTipoCadastro(debitoManualDTO.getTipoCadastro().getValue());
        debitoManual.setCadastroGeral(debitoManualDTO.getCadastroGeral());
        debitoManual.setDivida(debitoManualDTO.getDivida());
        debitoManual.setSubDivida(debitoManualDTO.getSubDivida());
        debitoManual.setUsuario(usuario);
        debitoManual.setDataInclusao(LocalDate.now());
        return debitoManual;
    }

    @Generated
    public DebitoManual() {
    }

    @Generated
    public DebitoManualId getId() {
        return this.id;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public Long getExercicioDebito() {
        return this.exercicioDebito;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getDivida() {
        return this.divida;
    }

    @Generated
    public Long getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public void setId(DebitoManualId id) {
        this.id = id;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setExercicioDebito(Long exercicioDebito) {
        this.exercicioDebito = exercicioDebito;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setDivida(Long divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(Long subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public String toString() {
        return "DebitoManual(id=" + this.getId() + ", dataInclusao=" + this.getDataInclusao() + ", exercicioProcesso=" + this.getExercicioProcesso() + ", idProcesso=" + this.getIdProcesso() + ", exercicioDebito=" + this.getExercicioDebito() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", motivo=" + this.getMotivo() + ", usuario=" + this.getUsuario() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebitoManual)) {
            return false;
        }
        DebitoManual other = (DebitoManual)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        DebitoManualId this$id = this.getId();
        DebitoManualId other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DebitoManual;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DebitoManualId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

