/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.audit.reader.DiffRevisionIgnore;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.converter.SituacaoCondominioConverter;
import br.com.elotech.tributos.converter.TipoCondominioConverter;
import br.com.elotech.tributos.converter.UtilizacaoCondominioConverter;
import br.com.elotech.tributos.domain.Ato;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Quadricula;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.SituacaoCondominio;
import br.com.elotech.tributos.domain.TipoCondominio;
import br.com.elotech.tributos.domain.UtilizacaoCondominio;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="TribCondominio")
@Audited
public class Condominio
implements EloEntity<Long> {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBCONDOMINIO_ID")
    private Long id;
    @ManyToOne
    @NotNull
    @JoinColumn(name="TRIBSETOR_IDKEY")
    @NotAudited
    @JsonIgnoreProperties(value={"quadras"})
    private Setor setor;
    @Caption(value="Quadra")
    @ManyToOne
    @NotAudited
    @JoinColumnsOrFormulas(value={@JoinColumnOrFormula(formula=@JoinFormula(value="TRIBSETOR_IDKEY", referencedColumnName="TRIBSETOR_IDKEY")), @JoinColumnOrFormula(column=@JoinColumn(name="QUADRA", referencedColumnName="QUADRA"))})
    private SetorQuadra quadra;
    @Column(name="condominio")
    @EloSequence(sequenceName="s05Condominio")
    @Caption(value="C\u00f3digo")
    private Long condominio;
    @Column(name="setor")
    private String setorCodigo;
    @Column(name="distrito")
    private String distritoCodigo;
    @NotEmpty
    @Length(max=100)
    @Caption(value="Descri\u00e7\u00e3o")
    private @NotEmpty @Length(max=100) String descricao;
    @Column(name="tipo")
    @Convert(converter=TipoCondominioConverter.class)
    private TipoCondominio tipoCondominio = TipoCondominio.OUTROS;
    @Caption(value="\u00c1rea Terreno")
    @Column(scale=15, precision=2)
    private BigDecimal areaTerreno = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Constru\u00edda")
    private BigDecimal areaConstruida = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Privativa")
    private BigDecimal areaPrivativa = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Comum")
    private BigDecimal areaComum = BigDecimal.ZERO;
    @Caption(value="N\u00famero Andares")
    private Long numeroAndares;
    @Caption(value="N\u00famero Garagem")
    private Long numeroGaragem;
    @Caption(value="N\u00famero Salas")
    private Long numeroSalas;
    @Caption(value="N\u00famero Aptos")
    private Long numeroAptos;
    @Caption(value="N\u00famero Unidades")
    private Long numeroUnidades;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="entidade", referencedColumnName="entidade"), @JoinColumn(name="idato", referencedColumnName="idato")})
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private Ato ato;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="cidade", referencedColumnName="cidade"), @JoinColumn(name="logradouro", referencedColumnName="logradouro")})
    @Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
    private Logradouro logradouro;
    @Caption(value="N\u00famero")
    @Length(max=10)
    private @Length(max=10) String numero;
    @Caption(value="Observa\u00e7\u00e3o")
    @Length(max=1000)
    private @Length(max=1000) String observacao;
    @Caption(value="Lote")
    @Length(max=15)
    private @Length(max=15) String lote;
    @Column(name="utilizacao")
    @Convert(converter=UtilizacaoCondominioConverter.class)
    private UtilizacaoCondominio utilizacaoCondominio;
    @Caption(value="Numero Alvar\u00e1")
    @Length(max=15)
    private @Length(max=15) String numeroAlvara;
    @Caption(value="Ano Constru\u00e7\u00e3o")
    private Long anoConstrucao;
    private LocalDate dataAprovacao;
    @Caption(value="Habite-se")
    @Length(max=15)
    private @Length(max=15) String numeroHabitese;
    private LocalDate dataHabitese;
    @Column(name="situacao")
    @Convert(converter=SituacaoCondominioConverter.class)
    private SituacaoCondominio situacaoCondominio = SituacaoCondominio.NAODESMEMBRADO;
    private LocalDate dataDesmembramento;
    @Caption(value="\u00c1rea \u00c1lvara")
    private BigDecimal areaAlvara = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Habitese Total")
    @Column(name="areahabitesetot")
    private BigDecimal areaHabiteseTotal = BigDecimal.ZERO;
    @Caption(value="\u00c1rea Habitese Parcial")
    @Column(name="areahabitesepar")
    private BigDecimal areaHabiteseParcial = BigDecimal.ZERO;
    @Column(name="datahabitesepar")
    private LocalDate dataHabiteseParcial;
    @Caption(value="N\u00ba Habite-se Parcial")
    @Length(max=15)
    @Column(name="numerohabitesepar")
    private @Length(max=15) String numeroHabiteseParcial;
    @ManyToOne
    @JoinColumn(name="quadricula")
    @NotAudited
    private Quadricula quadricula;

    @DiffRevisionIgnore
    public boolean isNew() {
        return Objects.nonNull(this.getId()) && Objects.nonNull(this.getSetor()) && Objects.nonNull(this.getCondominio());
    }

    @DiffRevisionIgnore
    public String getEndereco() {
        return Optional.ofNullable(this.logradouro).map(log -> String.format("%s %s, %s - %s", log.getTipoLogradouroDescricao(), log.getDescricao(), ObjectUtils.firstNonNull((Object[])new String[]{this.numero, ""}), log.getCidade().getDescricao())).orElse("");
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Condominio)) {
            return false;
        }
        Condominio other = (Condominio)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Condominio;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public Condominio() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Setor getSetor() {
        return this.setor;
    }

    @Generated
    public SetorQuadra getQuadra() {
        return this.quadra;
    }

    @Generated
    public Long getCondominio() {
        return this.condominio;
    }

    @Generated
    public String getSetorCodigo() {
        return this.setorCodigo;
    }

    @Generated
    public String getDistritoCodigo() {
        return this.distritoCodigo;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public TipoCondominio getTipoCondominio() {
        return this.tipoCondominio;
    }

    @Generated
    public BigDecimal getAreaTerreno() {
        return this.areaTerreno;
    }

    @Generated
    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    @Generated
    public BigDecimal getAreaPrivativa() {
        return this.areaPrivativa;
    }

    @Generated
    public BigDecimal getAreaComum() {
        return this.areaComum;
    }

    @Generated
    public Long getNumeroAndares() {
        return this.numeroAndares;
    }

    @Generated
    public Long getNumeroGaragem() {
        return this.numeroGaragem;
    }

    @Generated
    public Long getNumeroSalas() {
        return this.numeroSalas;
    }

    @Generated
    public Long getNumeroAptos() {
        return this.numeroAptos;
    }

    @Generated
    public Long getNumeroUnidades() {
        return this.numeroUnidades;
    }

    @Generated
    public Ato getAto() {
        return this.ato;
    }

    @Generated
    public Logradouro getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public UtilizacaoCondominio getUtilizacaoCondominio() {
        return this.utilizacaoCondominio;
    }

    @Generated
    public String getNumeroAlvara() {
        return this.numeroAlvara;
    }

    @Generated
    public Long getAnoConstrucao() {
        return this.anoConstrucao;
    }

    @Generated
    public LocalDate getDataAprovacao() {
        return this.dataAprovacao;
    }

    @Generated
    public String getNumeroHabitese() {
        return this.numeroHabitese;
    }

    @Generated
    public LocalDate getDataHabitese() {
        return this.dataHabitese;
    }

    @Generated
    public SituacaoCondominio getSituacaoCondominio() {
        return this.situacaoCondominio;
    }

    @Generated
    public LocalDate getDataDesmembramento() {
        return this.dataDesmembramento;
    }

    @Generated
    public BigDecimal getAreaAlvara() {
        return this.areaAlvara;
    }

    @Generated
    public BigDecimal getAreaHabiteseTotal() {
        return this.areaHabiteseTotal;
    }

    @Generated
    public BigDecimal getAreaHabiteseParcial() {
        return this.areaHabiteseParcial;
    }

    @Generated
    public LocalDate getDataHabiteseParcial() {
        return this.dataHabiteseParcial;
    }

    @Generated
    public String getNumeroHabiteseParcial() {
        return this.numeroHabiteseParcial;
    }

    @Generated
    public Quadricula getQuadricula() {
        return this.quadricula;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnoreProperties(value={"quadras"})
    @Generated
    public void setSetor(Setor setor) {
        this.setor = setor;
    }

    @Generated
    public void setQuadra(SetorQuadra quadra) {
        this.quadra = quadra;
    }

    @Generated
    public void setCondominio(Long condominio) {
        this.condominio = condominio;
    }

    @Generated
    public void setSetorCodigo(String setorCodigo) {
        this.setorCodigo = setorCodigo;
    }

    @Generated
    public void setDistritoCodigo(String distritoCodigo) {
        this.distritoCodigo = distritoCodigo;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setTipoCondominio(TipoCondominio tipoCondominio) {
        this.tipoCondominio = tipoCondominio;
    }

    @Generated
    public void setAreaTerreno(BigDecimal areaTerreno) {
        this.areaTerreno = areaTerreno;
    }

    @Generated
    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    @Generated
    public void setAreaPrivativa(BigDecimal areaPrivativa) {
        this.areaPrivativa = areaPrivativa;
    }

    @Generated
    public void setAreaComum(BigDecimal areaComum) {
        this.areaComum = areaComum;
    }

    @Generated
    public void setNumeroAndares(Long numeroAndares) {
        this.numeroAndares = numeroAndares;
    }

    @Generated
    public void setNumeroGaragem(Long numeroGaragem) {
        this.numeroGaragem = numeroGaragem;
    }

    @Generated
    public void setNumeroSalas(Long numeroSalas) {
        this.numeroSalas = numeroSalas;
    }

    @Generated
    public void setNumeroAptos(Long numeroAptos) {
        this.numeroAptos = numeroAptos;
    }

    @Generated
    public void setNumeroUnidades(Long numeroUnidades) {
        this.numeroUnidades = numeroUnidades;
    }

    @Generated
    public void setAto(Ato ato) {
        this.ato = ato;
    }

    @Generated
    public void setLogradouro(Logradouro logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setUtilizacaoCondominio(UtilizacaoCondominio utilizacaoCondominio) {
        this.utilizacaoCondominio = utilizacaoCondominio;
    }

    @Generated
    public void setNumeroAlvara(String numeroAlvara) {
        this.numeroAlvara = numeroAlvara;
    }

    @Generated
    public void setAnoConstrucao(Long anoConstrucao) {
        this.anoConstrucao = anoConstrucao;
    }

    @Generated
    public void setDataAprovacao(LocalDate dataAprovacao) {
        this.dataAprovacao = dataAprovacao;
    }

    @Generated
    public void setNumeroHabitese(String numeroHabitese) {
        this.numeroHabitese = numeroHabitese;
    }

    @Generated
    public void setDataHabitese(LocalDate dataHabitese) {
        this.dataHabitese = dataHabitese;
    }

    @Generated
    public void setSituacaoCondominio(SituacaoCondominio situacaoCondominio) {
        this.situacaoCondominio = situacaoCondominio;
    }

    @Generated
    public void setDataDesmembramento(LocalDate dataDesmembramento) {
        this.dataDesmembramento = dataDesmembramento;
    }

    @Generated
    public void setAreaAlvara(BigDecimal areaAlvara) {
        this.areaAlvara = areaAlvara;
    }

    @Generated
    public void setAreaHabiteseTotal(BigDecimal areaHabiteseTotal) {
        this.areaHabiteseTotal = areaHabiteseTotal;
    }

    @Generated
    public void setAreaHabiteseParcial(BigDecimal areaHabiteseParcial) {
        this.areaHabiteseParcial = areaHabiteseParcial;
    }

    @Generated
    public void setDataHabiteseParcial(LocalDate dataHabiteseParcial) {
        this.dataHabiteseParcial = dataHabiteseParcial;
    }

    @Generated
    public void setNumeroHabiteseParcial(String numeroHabiteseParcial) {
        this.numeroHabiteseParcial = numeroHabiteseParcial;
    }

    @Generated
    public void setQuadricula(Quadricula quadricula) {
        this.quadricula = quadricula;
    }

    @Generated
    public String toString() {
        return "Condominio(id=" + this.getId() + ", setor=" + this.getSetor() + ", quadra=" + this.getQuadra() + ", condominio=" + this.getCondominio() + ", setorCodigo=" + this.getSetorCodigo() + ", distritoCodigo=" + this.getDistritoCodigo() + ", descricao=" + this.getDescricao() + ", tipoCondominio=" + this.getTipoCondominio() + ", areaTerreno=" + this.getAreaTerreno() + ", areaConstruida=" + this.getAreaConstruida() + ", areaPrivativa=" + this.getAreaPrivativa() + ", areaComum=" + this.getAreaComum() + ", numeroAndares=" + this.getNumeroAndares() + ", numeroGaragem=" + this.getNumeroGaragem() + ", numeroSalas=" + this.getNumeroSalas() + ", numeroAptos=" + this.getNumeroAptos() + ", numeroUnidades=" + this.getNumeroUnidades() + ", ato=" + this.getAto() + ", logradouro=" + this.getLogradouro() + ", numero=" + this.getNumero() + ", observacao=" + this.getObservacao() + ", lote=" + this.getLote() + ", utilizacaoCondominio=" + this.getUtilizacaoCondominio() + ", numeroAlvara=" + this.getNumeroAlvara() + ", anoConstrucao=" + this.getAnoConstrucao() + ", dataAprovacao=" + this.getDataAprovacao() + ", numeroHabitese=" + this.getNumeroHabitese() + ", dataHabitese=" + this.getDataHabitese() + ", situacaoCondominio=" + this.getSituacaoCondominio() + ", dataDesmembramento=" + this.getDataDesmembramento() + ", areaAlvara=" + this.getAreaAlvara() + ", areaHabiteseTotal=" + this.getAreaHabiteseTotal() + ", areaHabiteseParcial=" + this.getAreaHabiteseParcial() + ", dataHabiteseParcial=" + this.getDataHabiteseParcial() + ", numeroHabiteseParcial=" + this.getNumeroHabiteseParcial() + ", quadricula=" + this.getQuadricula() + ")";
    }
}

