/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.tributos.calculo.dto.CalculoBuildDTO;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoContextFactory;
import br.com.elotech.tributos.calculo.exception.CalculoException;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.calculo.CalculoScriptBase;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ScriptEvaluator;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CalculoBuild {
    private CalculoBuild() {
    }

    public static CalculoContext evaluate(CalculoBuildDTO calculoBuildDTO) throws InvocationTargetException, IllegalAccessException {
        calculoBuildDTO.getContext().setCache(new LinkedHashMap());
        calculoBuildDTO.getContext().setTrace(new LinkedHashMap());
        calculoBuildDTO.getEvaluator().getMethod().invoke((Object)calculoBuildDTO.getContext(), new Object[0]);
        return calculoBuildDTO.getContext();
    }

    public static CalculoBuildDTO buildCalculo(String scriptParsed, Boolean traceAtivo, TipoDivida tipoDivida, TipoCadastro tipoCadastro) throws InstantiationException, IllegalAccessException {
        ScriptEvaluator evaluator = CalculoBuild.cook((String)scriptParsed, (TipoDivida)tipoDivida, (TipoCadastro)tipoCadastro);
        CalculoContext instance = (CalculoContext)evaluator.getMethod().getDeclaringClass().newInstance();
        instance.setTraceAtivo(traceAtivo);
        CalculoBuildDTO calculoDTO = new CalculoBuildDTO();
        calculoDTO.setContext(instance);
        calculoDTO.setEvaluator(evaluator);
        return calculoDTO;
    }

    private static ScriptEvaluator cook(String scriptParsed, TipoDivida tipoDivida, TipoCadastro tipoCadastro) {
        ScriptEvaluator evaluator = new ScriptEvaluator();
        evaluator.setExtendedClass(CalculoContextFactory.getContext((TipoDivida)tipoDivida, (TipoCadastro)tipoCadastro).getClass());
        evaluator.setStaticMethod(false);
        try {
            evaluator.cook(scriptParsed);
            return evaluator;
        }
        catch (CompileException e) {
            CalculoBuild.parseCompileException((CompileException)e);
            throw new CalculoException((Throwable)e);
        }
    }

    private static void parseCompileException(CompileException exception) {
        Pattern patternIdentificadorNaoEncontrado = Pattern.compile("A method named \"(\\w+)\" is not declared|Unknown variable or type \"(\\w+)\"");
        Matcher matcher = patternIdentificadorNaoEncontrado.matcher(exception.getLocalizedMessage());
        if (matcher.find()) {
            throw new CalculoException(String.format("N\u00e3o foi poss\u00edvel encontrar identificador ou fun\u00e7\u00e3o chamada %s.", ObjectUtils.firstNonNull((Object[])new String[]{matcher.group(1), matcher.group(2)})));
        }
        Pattern patternParametroFuncaoIncorreto = Pattern.compile("No applicable constructor/method found for (?:zero )?actual parameters.*?(\\w+)\\(");
        matcher = patternParametroFuncaoIncorreto.matcher(exception.getLocalizedMessage());
        if (matcher.find()) {
            String nomeFuncao = matcher.group(1);
            if ("castExpressaoCalculoToDouble".equals(nomeFuncao)) {
                throw new CalculoException("Express\u00e3o mal formada, existe alguma v\u00edrgula em local incorreto.");
            }
            throw new CalculoException(String.format("A fun\u00e7\u00e3o %s foi chamada com os par\u00e2metros incorretos.", nomeFuncao));
        }
        Pattern patternParentesesFaltando = Pattern.compile("'\\)' expected instead of");
        matcher = patternParentesesFaltando.matcher(exception.getLocalizedMessage());
        if (matcher.find()) {
            throw new CalculoException("Existem par\u00eanteses que foram abertos e n\u00e3o foram fechados.");
        }
        Pattern patternUnexpectedToken = Pattern.compile("Unexpected token \"(.*?)\" in primary");
        matcher = patternUnexpectedToken.matcher(exception.getLocalizedMessage());
        if (matcher.find()) {
            throw new CalculoException(String.format("Caractere em posi\u00e7\u00e3o incorreta: %s", matcher.group(1)));
        }
    }

    public static void buildCalculoDebugMode(List<? extends CalculoScriptBase> script, BiFunction<List<String>, CalculoScriptBase, String> parseScript, TipoDivida tipoDivida, TipoCadastro tipoCadastro) {
        List identificadores = script.stream().map(CalculoScriptBase::getIdentificador).collect(Collectors.toList());
        script.forEach(linha -> {
            try {
                CalculoBuild.cook((String)((String)parseScript.apply(identificadores, (CalculoScriptBase)linha)), (TipoDivida)tipoDivida, (TipoCadastro)tipoCadastro);
            }
            catch (Exception e) {
                throw new CalculoException(String.format("Falha ao compilar linha %s - %s", linha.getIdentificador(), e.getMessage()), (Throwable)e);
            }
        });
    }
}

