/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.importacao;

import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.repository.supersimples.SuperSimplesSolicitacaoCnpjRepository;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ImportacaoSuperSimplesBatchWriter
implements ItemWriter<SuperSimplesSolicitacaoCnpj> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoSuperSimplesBatchWriter.class);
    private final SuperSimplesSolicitacaoCnpjRepository superSimplesSolicitacaoCnpjRepository;
    private final EntityManager entityManager;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends SuperSimplesSolicitacaoCnpj> items) throws Exception {
        this.superSimplesSolicitacaoCnpjRepository.saveAll(items);
        this.entityManager.flush();
    }

    @AfterWrite
    public void afterWrite(List<? extends SuperSimplesSolicitacaoCnpj> items) {
        Long idSolicitacao = this.stepExecution.getJobExecution().getJobParameters().getLong("idSolicitacao");
        int quantidadeProcessada = this.stepExecution.getReadCount() + items.size();
        log.info("Finalizado chunk da solicita\u00e7\u00e3o {}. Itens processados at\u00e9 o momento {}", (Object)idSolicitacao, (Object)quantidadeProcessada);
    }

    @Generated
    public ImportacaoSuperSimplesBatchWriter(SuperSimplesSolicitacaoCnpjRepository superSimplesSolicitacaoCnpjRepository, EntityManager entityManager) {
        this.superSimplesSolicitacaoCnpjRepository = superSimplesSolicitacaoCnpjRepository;
        this.entityManager = entityManager;
    }
}

