/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.estornoarrecadacaocredito;

import br.com.elotech.tributos.domain.CreditoContribuinteItem;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.PagamentoDebito;
import br.com.elotech.tributos.domain.PagamentoDebitoId;
import br.com.elotech.tributos.domain.simam.EstornoArrecadacaoCredito;
import br.com.elotech.tributos.domain.simam.EstornoArrecadacaoCreditoCreditoContribuinte;
import br.com.elotech.tributos.domain.simam.EstornoArrecadacaoCreditoCreditoContribuinteId;
import br.com.elotech.tributos.domain.simam.EstornoArrecadacaoCreditoPagamento;
import br.com.elotech.tributos.domain.simam.EstornoArrecadacaoCreditoPagamentoId;
import br.com.elotech.tributos.domain.simam.EstornoArrecadacaoCreditoRetencaoContabil;
import br.com.elotech.tributos.domain.simam.EstornoTipoArrecadacaoCredito;
import br.com.elotech.tributos.dto.simam.EstornoArrecadacaoCreditoConsultaDTO;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import br.com.elotech.tributos.repository.simam.EstornoArrecadacaoCreditoRepository;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.annotation.OnProcessError;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EstornoArrecadacaoCreditoBatchProcessor
implements ItemProcessor<EstornoArrecadacaoCreditoConsultaDTO, EstornoTipoArrecadacaoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EstornoArrecadacaoCreditoBatchProcessor.class);
    private static final String PREFIXO = "SIM-AM - Estorno Arrecada\u00e7\u00e3o de Cr\u00e9dito - ";
    private final Map<String, Long> cargaExistente = new ConcurrentHashMap();
    private final AtomicLong ultimoNrEstorno = new AtomicLong(0L);
    private Long nrAnoEstorno;
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private final EstornoArrecadacaoCreditoRepository estornoArrecadacaoCreditoRepository;
    private final ObjectMapper objectMapper;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        LOGGER.info("SIM-AM - Estorno Arrecada\u00e7\u00e3o de Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados");
        LocalDate dataInicial = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataInicial")));
        LocalDate dataFinal = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long entidade = Objects.requireNonNull(this.stepExecution.getJobExecution().getJobParameters().getLong("entidade"));
        LOGGER.info("SIM-AM - Estorno Arrecada\u00e7\u00e3o de Cr\u00e9dito - Iniciando gera\u00e7\u00e3o de dados - data inicial: {}, data final: {}, entidade: {} ", new Object[]{dataInicial, dataFinal, entidade});
        this.nrAnoEstorno = dataInicial.getYear();
        this.ultimoNrEstorno.set(this.estornoArrecadacaoCreditoRepository.findNextNrEstornoByExercicio(this.nrAnoEstorno));
        LOGGER.info("SIM-AM - Estorno Arrecada\u00e7\u00e3o de Cr\u00e9dito - load da carga existente");
        this.estornoArrecadacaoCreditoRepository.getCargaExistente(entidade, dataInicial, dataFinal).forEach(item -> this.cargaExistente.put(item.getChave(), item.getIdTceArrTipoCreditoEst()));
    }

    public EstornoTipoArrecadacaoCredito process(EstornoArrecadacaoCreditoConsultaDTO item) {
        String chave = String.format("%d-%d-%s", item.getNrArrecadacao(), item.getNrAnoArrecadacao(), item.getDtEstorno().toString());
        Long finalId = this.cargaExistente.compute(chave, (k, v) -> {
            if (Objects.nonNull(v)) {
                return v;
            }
            Long nextId = this.sequenceGeneratorRepository.getNextVal("S05IDTCEARRTIPOCREDITO");
            EstornoArrecadacaoCredito estornoarrecadacaoCredito = new EstornoArrecadacaoCredito();
            estornoarrecadacaoCredito.setId(nextId);
            estornoarrecadacaoCredito.setNrAnoEstorno(this.nrAnoEstorno);
            estornoarrecadacaoCredito.setNrEstorno(Long.valueOf(this.ultimoNrEstorno.getAndIncrement()));
            estornoarrecadacaoCredito.setNrArrecadacao(item.getNrArrecadacao());
            estornoarrecadacaoCredito.setNrAnoArrecadacao(item.getNrAnoArrecadacao());
            estornoarrecadacaoCredito.setVlEstorno(item.getVlEstorno());
            estornoarrecadacaoCredito.setDtEstorno(item.getDtEstorno());
            estornoarrecadacaoCredito.setNrAno(Long.valueOf(item.getDtEstorno().getYear()));
            estornoarrecadacaoCredito.setNrMes(Long.valueOf(item.getDtEstorno().getMonthValue()));
            LOGGER.info("SIM-AM - Estorno Arrecada\u00e7\u00e3o de Cr\u00e9dito - Gerando novo registro -> {} ({}/{})", new Object[]{nextId, estornoarrecadacaoCredito.getNrArrecadacao(), estornoarrecadacaoCredito.getNrAnoArrecadacao()});
            this.estornoArrecadacaoCreditoRepository.save((Object)estornoarrecadacaoCredito);
            this.entityManager.flush();
            return nextId;
        });
        if (item.getIdRetencao() > 0L) {
            EstornoArrecadacaoCreditoRetencaoContabil eacrc = new EstornoArrecadacaoCreditoRetencaoContabil();
            eacrc.setId(item.getIdRetencao());
            eacrc.setIdTceArrTipoCreditoEst(finalId);
            return eacrc;
        }
        if (item.getIdCreditoContribuinteItem() > 0L) {
            EstornoArrecadacaoCreditoCreditoContribuinteId id = new EstornoArrecadacaoCreditoCreditoContribuinteId();
            id.setEstornoArrecadacaoCredito((EstornoArrecadacaoCredito)this.entityManager.getReference(EstornoArrecadacaoCredito.class, (Object)finalId));
            id.setCreditoContribuinteItem((CreditoContribuinteItem)this.entityManager.getReference(CreditoContribuinteItem.class, (Object)item.getIdCreditoContribuinteItem()));
            id.setParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
            return new EstornoArrecadacaoCreditoCreditoContribuinte(id, item.getVlEstorno());
        }
        EstornoArrecadacaoCreditoPagamentoId id = new EstornoArrecadacaoCreditoPagamentoId();
        id.setEstornoArrecadacaoCredito((EstornoArrecadacaoCredito)this.entityManager.getReference(EstornoArrecadacaoCredito.class, (Object)finalId));
        PagamentoDebitoId pagamentoDebitoId = new PagamentoDebitoId();
        pagamentoDebitoId.setIdPagamentoBoleto(item.getIdPagamentoBloqueto());
        pagamentoDebitoId.setDebitoParcelaTributo((DebitoParcelaTributo)this.entityManager.getReference(DebitoParcelaTributo.class, (Object)item.getIdDebitoParcelaReceita()));
        id.setPagamentoDebito((PagamentoDebito)this.entityManager.getReference(PagamentoDebito.class, (Object)pagamentoDebitoId));
        return new EstornoArrecadacaoCreditoPagamento(id, item.getVlEstorno());
    }

    @OnProcessError
    public void onProcessError(EstornoArrecadacaoCreditoConsultaDTO item, Exception e) throws Exception {
        LOGGER.error("SIM-AM - Estorno Arrecada\u00e7\u00e3o de Cr\u00e9dito - Erro: {}\n{})", (Object)e.getMessage(), (Object)this.objectMapper.writeValueAsString((Object)item));
    }

    @Generated
    public EstornoArrecadacaoCreditoBatchProcessor(EntityManager entityManager, SequenceGeneratorRepository sequenceGeneratorRepository, EstornoArrecadacaoCreditoRepository estornoArrecadacaoCreditoRepository, ObjectMapper objectMapper) {
        this.entityManager = entityManager;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
        this.estornoArrecadacaoCreditoRepository = estornoArrecadacaoCreditoRepository;
        this.objectMapper = objectMapper;
    }
}

