/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.arrecadacaocredito;

import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoCreditoContribuinte;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoDevolucao;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoPagamento;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoPagamentoReabilitado;
import br.com.elotech.tributos.domain.simam.ArrecadacaoCreditoRetencaoContabil;
import br.com.elotech.tributos.domain.simam.TipoArrecadacaoCredito;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoCreditoContribuinteRepository;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoDevolucaoRepository;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoPagamentoReabilitadoRepository;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoPagamentoRepository;
import br.com.elotech.tributos.repository.simam.ArrecadacaoCreditoRetencaoContabilRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ArrecadacaoCreditoBatchWriter
implements ItemWriter<TipoArrecadacaoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrecadacaoCreditoBatchWriter.class);
    private static String PREFIXO = "SIM-AM - Arrecada\u00e7\u00e3o de Cr\u00e9dito - ";
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final ArrecadacaoCreditoCreditoContribuinteRepository arrecadacaoCreditoCreditoContribuinteRepository;
    private final ArrecadacaoCreditoPagamentoRepository arrecadacaoCreditoPagamentoRepository;
    private final ArrecadacaoCreditoRetencaoContabilRepository arrecadacaoCreditoRetencaoContabilRepository;
    private final ArrecadacaoCreditoDevolucaoRepository arrecadacaoCreditoDevolucaoRepository;
    private final ArrecadacaoCreditoPagamentoReabilitadoRepository arrecadacaoCreditoPagamentoReabilitadoRepository;

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends TipoArrecadacaoCredito> items) {
        LOGGER.info(PREFIXO + "Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends TipoArrecadacaoCredito> items) {
        List creditos = items.stream().filter(ArrecadacaoCreditoCreditoContribuinte.class::isInstance).map(ArrecadacaoCreditoCreditoContribuinte.class::cast).collect(Collectors.toList());
        List pagamentos = items.stream().filter(ArrecadacaoCreditoPagamento.class::isInstance).map(ArrecadacaoCreditoPagamento.class::cast).collect(Collectors.toList());
        List retencoes = items.stream().filter(ArrecadacaoCreditoRetencaoContabil.class::isInstance).map(ArrecadacaoCreditoRetencaoContabil.class::cast).collect(Collectors.toList());
        List devolucoes = items.stream().filter(ArrecadacaoCreditoDevolucao.class::isInstance).map(ArrecadacaoCreditoDevolucao.class::cast).collect(Collectors.toList());
        List reabilitacaoPagamentos = items.stream().filter(ArrecadacaoCreditoPagamentoReabilitado.class::isInstance).map(ArrecadacaoCreditoPagamentoReabilitado.class::cast).collect(Collectors.toList());
        this.arrecadacaoCreditoCreditoContribuinteRepository.saveAll(creditos);
        this.arrecadacaoCreditoPagamentoRepository.saveAll(pagamentos);
        this.arrecadacaoCreditoRetencaoContabilRepository.saveAll(retencoes);
        this.arrecadacaoCreditoDevolucaoRepository.saveAll(devolucoes);
        this.arrecadacaoCreditoPagamentoReabilitadoRepository.saveAll(reabilitacaoPagamentos);
        this.entityManager.flush();
    }

    @Generated
    public ArrecadacaoCreditoBatchWriter(EntityManager entityManager, ArrecadacaoCreditoCreditoContribuinteRepository arrecadacaoCreditoCreditoContribuinteRepository, ArrecadacaoCreditoPagamentoRepository arrecadacaoCreditoPagamentoRepository, ArrecadacaoCreditoRetencaoContabilRepository arrecadacaoCreditoRetencaoContabilRepository, ArrecadacaoCreditoDevolucaoRepository arrecadacaoCreditoDevolucaoRepository, ArrecadacaoCreditoPagamentoReabilitadoRepository arrecadacaoCreditoPagamentoReabilitadoRepository) {
        this.entityManager = entityManager;
        this.arrecadacaoCreditoCreditoContribuinteRepository = arrecadacaoCreditoCreditoContribuinteRepository;
        this.arrecadacaoCreditoPagamentoRepository = arrecadacaoCreditoPagamentoRepository;
        this.arrecadacaoCreditoRetencaoContabilRepository = arrecadacaoCreditoRetencaoContabilRepository;
        this.arrecadacaoCreditoDevolucaoRepository = arrecadacaoCreditoDevolucaoRepository;
        this.arrecadacaoCreditoPagamentoReabilitadoRepository = arrecadacaoCreditoPagamentoReabilitadoRepository;
    }
}

