/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.EnvioProtestoRemessaDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JpaPagingItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EnvioProtestoRemessaBatchReader
extends JpaPagingItemReader<Protesto> {
    private static final String ENVIO_PROTESTO_REMESSA_DTO = "envioProtestoRemessaDTO";

    public EnvioProtestoRemessaBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, EntityManagerFactory entityManagerFactory, ObjectMapper objectMapper) {
        EnvioProtestoRemessaDTO envioProtestoRemessaDTO = this.getEnvioProtestoRemessaDTO(jobParameters, objectMapper);
        this.setPageSize(100);
        this.setName("envioProtestoRemessaId");
        this.setEntityManagerFactory(entityManagerFactory);
        this.setQueryString("select p from Protesto p where p.id in (:idsProtesto)");
        this.setParameterValues(Collections.singletonMap("idsProtesto", envioProtestoRemessaDTO.getIdsProtesto()));
    }

    private EnvioProtestoRemessaDTO getEnvioProtestoRemessaDTO(Map<String, Object> jobParameters, ObjectMapper objectMapper) {
        try {
            return (EnvioProtestoRemessaDTO)objectMapper.readValue((String)jobParameters.get(ENVIO_PROTESTO_REMESSA_DTO), EnvioProtestoRemessaDTO.class);
        }
        catch (JsonProcessingException jpe) {
            throw new EloValidationException("Erro ao converter JSON. " + jpe.getMessage());
        }
    }
}

