/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws.rest.dto.pessoa;

import br.com.elotech.core.enumerable.common.EnderecoTipo;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.util.ConvertToUpperCase;
import br.com.elotech.tributos.ws.rest.dto.pessoa.ContatoPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.ContatoPessoaTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.EnderecoPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.EnderecoPessoaTransportDTO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;

public class IncluirPessoaRequestDTO {
    @JsonProperty(value="ClassName")
    private String className = "TPessoaXML";
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private TipoPessoa tipoPessoa;
    private String nome;
    private String nomeFantasia;
    private String cnpjCpf;
    private String rg;
    private String orgaoEmissor;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy")
    private LocalDate dataEmissao;
    private String estadoEmissor;
    private String inscricaoEstadual;
    private String activeFormOrigem;
    @JsonProperty(value="ListaEndereco")
    private EnderecoPessoaTransportDTO enderecos = new EnderecoPessoaTransportDTO();
    @JsonProperty(value="ListaContato")
    private ContatoPessoaTransportDTO contatos = new ContatoPessoaTransportDTO();

    public static IncluirPessoaRequestDTO from(PessoaDTO dto) {
        IncluirPessoaRequestDTO incluirPessoaDTO = new IncluirPessoaRequestDTO();
        Optional.ofNullable(dto.getTipoPessoa()).map(TipoPessoa::fromString).ifPresent(arg_0 -> incluirPessoaDTO.setTipoPessoa(arg_0));
        Optional.ofNullable(dto.getNome()).ifPresent(arg_0 -> incluirPessoaDTO.setNome(arg_0));
        Optional.ofNullable(dto.getCnpjCpf()).ifPresent(arg_0 -> incluirPessoaDTO.setCnpjCpf(arg_0));
        Optional.ofNullable(dto.getActiveFormOrigem()).ifPresent(arg_0 -> incluirPessoaDTO.setActiveFormOrigem(arg_0));
        incluirPessoaDTO.setDataEmissao(LocalDate.now());
        EnderecoPessoaRequestDTO enderecoPessoaDTO = new EnderecoPessoaRequestDTO();
        enderecoPessoaDTO.setTipoEndereco(EnderecoTipo.RESIDENCIAL);
        Optional.ofNullable(dto.getLogradouro()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setLogradouro(arg_0));
        Optional.ofNullable(dto.getBairro()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setBairro(arg_0));
        Optional.ofNullable(dto.getNumero()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setNumero(arg_0));
        Optional.ofNullable(dto.getComplemento()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setComplemento(arg_0));
        Optional.ofNullable(dto.getCidade()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setCidade(arg_0));
        Optional.ofNullable(dto.getUf()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setUnidadeFederacao(arg_0));
        Optional.ofNullable(dto.getCep()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setCep(arg_0));
        Optional.ofNullable(dto.getCodigoCidadeAise()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setCodigoCidade(arg_0));
        Optional.ofNullable(dto.getCodigoBairroAise()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setCodigoBairro(arg_0));
        Optional.ofNullable(dto.getCodigoLogradouroAise()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setCodigoLogradouro(arg_0));
        Optional.ofNullable(dto.getCodigoTipoLogradouroAise()).ifPresent(arg_0 -> ((EnderecoPessoaRequestDTO)enderecoPessoaDTO).setCodigoTipoLogradouro(arg_0));
        ContatoPessoaRequestDTO contatoPessoaRequestDTO = new ContatoPessoaRequestDTO();
        Optional.ofNullable(dto.getEmail()).ifPresent(arg_0 -> ((ContatoPessoaRequestDTO)contatoPessoaRequestDTO).setEmail(arg_0));
        Optional.ofNullable(dto.getCelular()).ifPresent(arg_0 -> ((ContatoPessoaRequestDTO)contatoPessoaRequestDTO).setTelefoneCelular(arg_0));
        Optional.ofNullable(dto.getNome()).ifPresent(arg_0 -> ((ContatoPessoaRequestDTO)contatoPessoaRequestDTO).setNome(arg_0));
        incluirPessoaDTO.getEnderecos().getItems().add(enderecoPessoaDTO);
        incluirPessoaDTO.getContatos().getItems().add(contatoPessoaRequestDTO);
        return incluirPessoaDTO;
    }

    public void convertToUpperCase() {
        ConvertToUpperCase.convert((Object)this);
        this.getEnderecos().getItems().forEach(ConvertToUpperCase::convert);
        this.getContatos().getItems().forEach(ConvertToUpperCase::convert);
    }

    @Generated
    public IncluirPessoaRequestDTO() {
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public String getRg() {
        return this.rg;
    }

    @Generated
    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public String getEstadoEmissor() {
        return this.estadoEmissor;
    }

    @Generated
    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    @Generated
    public String getActiveFormOrigem() {
        return this.activeFormOrigem;
    }

    @Generated
    public EnderecoPessoaTransportDTO getEnderecos() {
        return this.enderecos;
    }

    @Generated
    public ContatoPessoaTransportDTO getContatos() {
        return this.contatos;
    }

    @JsonProperty(value="ClassName")
    @Generated
    public void setClassName(String className) {
        this.className = className;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @Generated
    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setRg(String rg) {
        this.rg = rg;
    }

    @Generated
    public void setOrgaoEmissor(String orgaoEmissor) {
        this.orgaoEmissor = orgaoEmissor;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd-MM-yyyy")
    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setEstadoEmissor(String estadoEmissor) {
        this.estadoEmissor = estadoEmissor;
    }

    @Generated
    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    @Generated
    public void setActiveFormOrigem(String activeFormOrigem) {
        this.activeFormOrigem = activeFormOrigem;
    }

    @JsonProperty(value="ListaEndereco")
    @Generated
    public void setEnderecos(EnderecoPessoaTransportDTO enderecos) {
        this.enderecos = enderecos;
    }

    @JsonProperty(value="ListaContato")
    @Generated
    public void setContatos(ContatoPessoaTransportDTO contatos) {
        this.contatos = contatos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IncluirPessoaRequestDTO)) {
            return false;
        }
        IncluirPessoaRequestDTO other = (IncluirPessoaRequestDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        TipoPessoa this$tipoPessoa = this.getTipoPessoa();
        TipoPessoa other$tipoPessoa = other.getTipoPessoa();
        if (this$tipoPessoa == null ? other$tipoPessoa != null : !this$tipoPessoa.equals(other$tipoPessoa)) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$nomeFantasia = this.getNomeFantasia();
        String other$nomeFantasia = other.getNomeFantasia();
        if (this$nomeFantasia == null ? other$nomeFantasia != null : !this$nomeFantasia.equals(other$nomeFantasia)) {
            return false;
        }
        String this$cnpjCpf = this.getCnpjCpf();
        String other$cnpjCpf = other.getCnpjCpf();
        if (this$cnpjCpf == null ? other$cnpjCpf != null : !this$cnpjCpf.equals(other$cnpjCpf)) {
            return false;
        }
        String this$rg = this.getRg();
        String other$rg = other.getRg();
        if (this$rg == null ? other$rg != null : !this$rg.equals(other$rg)) {
            return false;
        }
        String this$orgaoEmissor = this.getOrgaoEmissor();
        String other$orgaoEmissor = other.getOrgaoEmissor();
        if (this$orgaoEmissor == null ? other$orgaoEmissor != null : !this$orgaoEmissor.equals(other$orgaoEmissor)) {
            return false;
        }
        LocalDate this$dataEmissao = this.getDataEmissao();
        LocalDate other$dataEmissao = other.getDataEmissao();
        if (this$dataEmissao == null ? other$dataEmissao != null : !((Object)this$dataEmissao).equals(other$dataEmissao)) {
            return false;
        }
        String this$estadoEmissor = this.getEstadoEmissor();
        String other$estadoEmissor = other.getEstadoEmissor();
        if (this$estadoEmissor == null ? other$estadoEmissor != null : !this$estadoEmissor.equals(other$estadoEmissor)) {
            return false;
        }
        String this$inscricaoEstadual = this.getInscricaoEstadual();
        String other$inscricaoEstadual = other.getInscricaoEstadual();
        if (this$inscricaoEstadual == null ? other$inscricaoEstadual != null : !this$inscricaoEstadual.equals(other$inscricaoEstadual)) {
            return false;
        }
        String this$activeFormOrigem = this.getActiveFormOrigem();
        String other$activeFormOrigem = other.getActiveFormOrigem();
        if (this$activeFormOrigem == null ? other$activeFormOrigem != null : !this$activeFormOrigem.equals(other$activeFormOrigem)) {
            return false;
        }
        EnderecoPessoaTransportDTO this$enderecos = this.getEnderecos();
        EnderecoPessoaTransportDTO other$enderecos = other.getEnderecos();
        if (this$enderecos == null ? other$enderecos != null : !this$enderecos.equals(other$enderecos)) {
            return false;
        }
        ContatoPessoaTransportDTO this$contatos = this.getContatos();
        ContatoPessoaTransportDTO other$contatos = other.getContatos();
        return !(this$contatos == null ? other$contatos != null : !this$contatos.equals(other$contatos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IncluirPessoaRequestDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        TipoPessoa $tipoPessoa = this.getTipoPessoa();
        result = result * 59 + ($tipoPessoa == null ? 43 : $tipoPessoa.hashCode());
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $nomeFantasia = this.getNomeFantasia();
        result = result * 59 + ($nomeFantasia == null ? 43 : $nomeFantasia.hashCode());
        String $cnpjCpf = this.getCnpjCpf();
        result = result * 59 + ($cnpjCpf == null ? 43 : $cnpjCpf.hashCode());
        String $rg = this.getRg();
        result = result * 59 + ($rg == null ? 43 : $rg.hashCode());
        String $orgaoEmissor = this.getOrgaoEmissor();
        result = result * 59 + ($orgaoEmissor == null ? 43 : $orgaoEmissor.hashCode());
        LocalDate $dataEmissao = this.getDataEmissao();
        result = result * 59 + ($dataEmissao == null ? 43 : ((Object)$dataEmissao).hashCode());
        String $estadoEmissor = this.getEstadoEmissor();
        result = result * 59 + ($estadoEmissor == null ? 43 : $estadoEmissor.hashCode());
        String $inscricaoEstadual = this.getInscricaoEstadual();
        result = result * 59 + ($inscricaoEstadual == null ? 43 : $inscricaoEstadual.hashCode());
        String $activeFormOrigem = this.getActiveFormOrigem();
        result = result * 59 + ($activeFormOrigem == null ? 43 : $activeFormOrigem.hashCode());
        EnderecoPessoaTransportDTO $enderecos = this.getEnderecos();
        result = result * 59 + ($enderecos == null ? 43 : $enderecos.hashCode());
        ContatoPessoaTransportDTO $contatos = this.getContatos();
        result = result * 59 + ($contatos == null ? 43 : $contatos.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IncluirPessoaRequestDTO(className=" + this.getClassName() + ", tipoPessoa=" + this.getTipoPessoa() + ", nome=" + this.getNome() + ", nomeFantasia=" + this.getNomeFantasia() + ", cnpjCpf=" + this.getCnpjCpf() + ", rg=" + this.getRg() + ", orgaoEmissor=" + this.getOrgaoEmissor() + ", dataEmissao=" + this.getDataEmissao() + ", estadoEmissor=" + this.getEstadoEmissor() + ", inscricaoEstadual=" + this.getInscricaoEstadual() + ", activeFormOrigem=" + this.getActiveFormOrigem() + ", enderecos=" + this.getEnderecos() + ", contatos=" + this.getContatos() + ")";
    }
}

