/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacao;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnae;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.dto.supersimples.SuperSimplesSolicitacaoCnpjDTO;
import br.com.elotech.tributos.enums.supersimples.SituacaoSuperSimplesSolicitacao;
import br.com.elotech.tributos.enums.supersimples.TipoOperacaoSuperSimplesSolicitacao;
import br.com.elotech.tributos.repository.supersimples.SuperSimplesSolicitacaoCnaeRepository;
import br.com.elotech.tributos.repository.supersimples.SuperSimplesSolicitacaoCnpjRepository;
import br.com.elotech.tributos.repository.supersimples.SuperSimplesSolicitacaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.unico.client.ArquivoStorageFeignClient;
import br.com.elotech.unico.client.domain.TipoArquivoEnum;
import br.com.elotech.unico.client.dto.ArquivoDTO;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SuperSimplesSolicitacaoService
extends CrudService<SuperSimplesSolicitacao, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SuperSimplesSolicitacaoService.class);
    private final SuperSimplesSolicitacaoRepository repository;
    private final SuperSimplesSolicitacaoCnpjRepository superSimplesSolicitacaoCnpjRepository;
    private final SuperSimplesSolicitacaoCnaeRepository superSimplesSolicitacaoCnaeRepository;
    private final ArquivoStorageFeignClient arquivoStorageFeignClient;

    public Optional<SuperSimplesSolicitacao> findByHash(String hash) {
        return this.repository.findByHash(hash);
    }

    public SuperSimplesSolicitacao createSolicitacao(String nomeArquivo, String usuario) {
        SuperSimplesSolicitacao solicitacao = new SuperSimplesSolicitacao();
        solicitacao.setNomeArquivo(nomeArquivo);
        solicitacao.setDataImportacao(LocalDate.now());
        solicitacao.setUsuario(usuario);
        solicitacao.setVarreduraFinal(Boolean.valueOf(false));
        solicitacao.setSituacao(SituacaoSuperSimplesSolicitacao.CRIADO);
        return (SuperSimplesSolicitacao)this.save((EloEntity)solicitacao, null);
    }

    public SuperSimplesSolicitacao uploadArquivo(SuperSimplesSolicitacao superSimplesSolicitacao, MultipartFile file, String hash) {
        HashMap<String, String> metadados = new HashMap<String, String>();
        metadados.put("idsolicitacao", superSimplesSolicitacao.getId().toString());
        ArquivoDTO arquivoDTO = new ArquivoDTO(null, file.getOriginalFilename(), SecurityUtils.getUserId(), TipoArquivoEnum.OUTROS, Modulo.OXY_TRIBUTOS, "/super-simples", LocalDate.now(), "text/plain", null, null, metadados);
        ArquivoDTO result = this.arquivoStorageFeignClient.createWithFile(arquivoDTO, file);
        superSimplesSolicitacao.setHash(hash);
        superSimplesSolicitacao.setIdArquivo(result.getId());
        return (SuperSimplesSolicitacao)this.save((EloEntity)superSimplesSolicitacao, null);
    }

    private SuperSimplesSolicitacao getSolicitacao(Long idSolicitacao) {
        return (SuperSimplesSolicitacao)this.findById((Serializable)idSolicitacao).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a solicita\u00e7\u00e3o com o id %d.", idSolicitacao)));
    }

    public void iniciarImportacao(Long idSolicitacao) {
        SuperSimplesSolicitacao solicitacao = this.getSolicitacao(idSolicitacao);
        solicitacao.setSituacao(SituacaoSuperSimplesSolicitacao.IMPORTANDO);
        this.save((EloEntity)solicitacao, null);
    }

    public void finalizarImportacaoSucesso(Long idSolicitacao) {
        SuperSimplesSolicitacao solicitacao = this.getSolicitacao(idSolicitacao);
        solicitacao.setSituacao(SituacaoSuperSimplesSolicitacao.IMPORTADO);
        this.save((EloEntity)solicitacao, null);
    }

    public void finalizarImportacaoErro(Long idSolicitacao) {
        SuperSimplesSolicitacao solicitacao = this.getSolicitacao(idSolicitacao);
        solicitacao.setHash(null);
        solicitacao.setSituacao(SituacaoSuperSimplesSolicitacao.ERRO_IMPORTACAO);
        this.save((EloEntity)solicitacao, null);
    }

    public void iniciarProcessamento(Long idSolicitacao) {
        SuperSimplesSolicitacao solicitacao = this.getSolicitacao(idSolicitacao);
        solicitacao.setSituacao(SituacaoSuperSimplesSolicitacao.PROCESSANDO);
        this.save((EloEntity)solicitacao, null);
    }

    public void finalizarProcessamentoSucesso(Long idSolicitacao) {
        SuperSimplesSolicitacao solicitacao = this.getSolicitacao(idSolicitacao);
        solicitacao.setSituacao(SituacaoSuperSimplesSolicitacao.PROCESSADO);
        this.save((EloEntity)solicitacao, null);
    }

    public void finalizarProcessamentoErro(Long idSolicitacao, String tipoOperacao) {
        SuperSimplesSolicitacao solicitacao = this.getSolicitacao(idSolicitacao);
        if (TipoOperacaoSuperSimplesSolicitacao.INICIAL.getDescricao().equals(tipoOperacao)) {
            solicitacao.setHash(null);
        }
        solicitacao.setSituacao(SituacaoSuperSimplesSolicitacao.ERRO_PROCESSAMENTO);
        this.save((EloEntity)solicitacao, null);
    }

    public Page<SuperSimplesSolicitacaoCnpjDTO> searchDadosImportados(Long idSolicitacao, String search, Pageable pageable) {
        String queryIdSolicitacao = String.format("id.solicitacao.id==%d", idSolicitacao);
        String queryFinal = StringUtils.isBlank((CharSequence)search) ? queryIdSolicitacao : String.format("(%s) and (%s)", queryIdSolicitacao, search);
        Specification specification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), (String)queryFinal);
        return this.superSimplesSolicitacaoCnpjRepository.findAll(specification, pageable).map(SuperSimplesSolicitacaoCnpjDTO::from);
    }

    public List<SuperSimplesSolicitacaoCnae> findCnaesByIdSolicitacaoAndSequencia(Long id, Long sequencia, Sort sort) {
        return this.superSimplesSolicitacaoCnaeRepository.findByIdSolicitacaoIdAndIdSequencia(id, sequencia, sort);
    }

    public SuperSimplesSolicitacaoCnpj findCnpjByIdSolicitacaoAndSequencia(Long id, Long sequencia) {
        return this.superSimplesSolicitacaoCnpjRepository.findByIdSolicitacaoIdAndIdSequencia(id, sequencia);
    }

    @Generated
    public SuperSimplesSolicitacaoService(SuperSimplesSolicitacaoRepository repository, SuperSimplesSolicitacaoCnpjRepository superSimplesSolicitacaoCnpjRepository, SuperSimplesSolicitacaoCnaeRepository superSimplesSolicitacaoCnaeRepository, ArquivoStorageFeignClient arquivoStorageFeignClient) {
        this.repository = repository;
        this.superSimplesSolicitacaoCnpjRepository = superSimplesSolicitacaoCnpjRepository;
        this.superSimplesSolicitacaoCnaeRepository = superSimplesSolicitacaoCnaeRepository;
        this.arquivoStorageFeignClient = arquivoStorageFeignClient;
    }
}

