/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.TipoOperacaoCredito;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.LancamentoCreditoValidacaoDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class LancamentoCreditoValidacaoAMService {
    private static final Set<Long> tiposCreditoValidos = Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L), Long.valueOf(7L));
    private static final Set<Long> tiposNaturezaCreditoValidos = Set.of(Long.valueOf(1L), Long.valueOf(2L));
    private static final Long CODIGO_ESCOPO_LEI = 22L;

    public List<ErrosImportacaoSIMAM> validateLancamentoCredito(LancamentoCreditoValidacaoDTO lancamentoCreditoValidacaoDTO, StepExecution stepExecution) {
        ArrayList<Optional> erros = new ArrayList<Optional>();
        erros.add(this.validateRegistroDuplicado(lancamentoCreditoValidacaoDTO));
        erros.add(this.validateSequenciaNrCredito(lancamentoCreditoValidacaoDTO));
        erros.add(this.validateIdTipoCredito(lancamentoCreditoValidacaoDTO));
        erros.add(this.validateDataLancamento(lancamentoCreditoValidacaoDTO, stepExecution));
        erros.add(this.validateMesAnoBase(lancamentoCreditoValidacaoDTO, stepExecution));
        erros.add(this.validateCdControleLeiAto(lancamentoCreditoValidacaoDTO));
        erros.add(this.validateVlLancamento(lancamentoCreditoValidacaoDTO));
        erros.add(this.validateidTipoOperacaoCredito(lancamentoCreditoValidacaoDTO));
        erros.add(this.validateAnoCredito(lancamentoCreditoValidacaoDTO));
        return erros.stream().flatMap(Optional::stream).collect(Collectors.toList());
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicado(LancamentoCreditoValidacaoDTO lancamentoCreditoValidacaoDTO) {
        if (lancamentoCreditoValidacaoDTO.getNrRegistro() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)lancamentoCreditoValidacaoDTO.getIdTceLancCredito(), (String)"O conjunto(nrCredito e nrAnoCredito) declarado da tabela (LancamentoCredito) apresenta-se com registro duplicado.", (Long)1307L, (TipoRegistroSimAm)TipoRegistroSimAm.LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateSequenciaNrCredito(LancamentoCreditoValidacaoDTO lancamentoCreditoValidacaoDTO) {
        if (lancamentoCreditoValidacaoDTO.getNrCreditoAnterior() != 0L && lancamentoCreditoValidacaoDTO.getNrCredito() - lancamentoCreditoValidacaoDTO.getNrCreditoAnterior() != 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)lancamentoCreditoValidacaoDTO.getIdTceLancCredito(), (String)"O N\u00famero e Ano do Cr\u00e9dito (nrCredito e nrAnoCredito) da tabela (LancamentoCredito) apresenta-se quebra da ordem num\u00e9rica no ano de trabalho com ou cronol\u00f3gica associada a num\u00e9rica", (Long)1308L, (TipoRegistroSimAm)TipoRegistroSimAm.LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateIdTipoCredito(LancamentoCreditoValidacaoDTO lancamentoCreditoValidacaoDTO) {
        if (!tiposNaturezaCreditoValidos.contains(lancamentoCreditoValidacaoDTO.getIdTipoNaturezaCredito())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)lancamentoCreditoValidacaoDTO.getIdTceLancCredito(), (String)"O Tipo de Opera\u00e7\u00e3o do Cr\u00e9dito (idTipoOperacaoCredito) da tabela (LancamentoCredito) n\u00e3o existe na tabela (TipoOperacaoCredito) e n\u00e3o pode ser diferente de 1 ou 2.", (Long)1310L, (TipoRegistroSimAm)TipoRegistroSimAm.LANCAMENTO_CREDITO));
        }
        if (!tiposCreditoValidos.contains(lancamentoCreditoValidacaoDTO.getIdTipoCredito()) && lancamentoCreditoValidacaoDTO.getIdTipoNaturezaCredito() != 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)lancamentoCreditoValidacaoDTO.getIdTceLancCredito(), (String)"A combina\u00e7\u00e3o (idTipoNaturezaCredito e idTipoCredito) da tabela (LancamentoCredito) n\u00e3o existe na possibilidades v\u00e1lidas da tabela (ConsolidacaoTipoCredito).", (Long)1309L, (TipoRegistroSimAm)TipoRegistroSimAm.LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDataLancamento(LancamentoCreditoValidacaoDTO lancamentoCreditoValidacaoDTO, StepExecution stepExecution) {
        LocalDate mesValidacao = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Month mesLancamento = lancamentoCreditoValidacaoDTO.getDtLancamento().getMonth();
        Year anoLancamento = Year.of(lancamentoCreditoValidacaoDTO.getDtLancamento().getYear());
        if (!mesLancamento.equals(mesValidacao.getMonth()) || !anoLancamento.equals(Year.of(mesValidacao.getYear()))) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)lancamentoCreditoValidacaoDTO.getIdTceLancCredito(), (String)"O m\u00eas de refer\u00eancia do cr\u00e9dito (dtLancamento) da tabela (LancamentoCredito) n\u00e3o pode ser diferente do m\u00eas de refer\u00eancia do arquivo.", (Long)1311L, (TipoRegistroSimAm)TipoRegistroSimAm.LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateMesAnoBase(LancamentoCreditoValidacaoDTO lancamentoCreditoValidacaoDTO, StepExecution stepExecution) {
        LocalDate mesValidacao = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Long nrMesLancamento = lancamentoCreditoValidacaoDTO.getNrMesBase();
        Long nrAnoLancamento = lancamentoCreditoValidacaoDTO.getNrAnoBase();
        if (!nrMesLancamento.equals(mesValidacao.getMonth().getValue()) || !nrAnoLancamento.equals(mesValidacao.getYear())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)lancamentoCreditoValidacaoDTO.getIdTceLancCredito(), (String)"O m\u00eas de refer\u00eancia do cr\u00e9dito (dtLancamento) da tabela (LancamentoCredito) n\u00e3o pode ser diferente do m\u00eas de refer\u00eancia do arquivo.", (Long)1312L, (TipoRegistroSimAm)TipoRegistroSimAm.LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateCdControleLeiAto(LancamentoCreditoValidacaoDTO lancamentoCreditoValidacaoDTO) {
        if (Objects.isNull(lancamentoCreditoValidacaoDTO.getCdControleLeiAto()) || !CODIGO_ESCOPO_LEI.equals(lancamentoCreditoValidacaoDTO.getEscopoLei())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)lancamentoCreditoValidacaoDTO.getIdTceLancCredito(), (String)"O C\u00f3digo de Controle da Lei ou Ato (cdControleLeiAto) da tabela (LancamentoCredito) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.", (Long)1313L, (TipoRegistroSimAm)TipoRegistroSimAm.LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateVlLancamento(LancamentoCreditoValidacaoDTO lancamentoCreditoValidacaoDTO) {
        if (lancamentoCreditoValidacaoDTO.getVlLancamento().compareTo(BigDecimal.ZERO) < 0) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)lancamentoCreditoValidacaoDTO.getIdTceLancCredito(), (String)"O Valor do Cr\u00e9dito (vlLancamento) da tabela (LancamentoCredito) n\u00e3o pode ser menor que 0.", (Long)1317L, (TipoRegistroSimAm)TipoRegistroSimAm.LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateidTipoOperacaoCredito(LancamentoCreditoValidacaoDTO lancamentoCreditoValidacaoDTO) {
        if (TipoOperacaoCredito.INSCRICAO_DIVIDA_ATIVA.getCodigo().equals(lancamentoCreditoValidacaoDTO.getIdTipoOperacaoCredito())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)lancamentoCreditoValidacaoDTO.getIdTceLancCredito(), (String)"O tipo de Opera\u00e7\u00e3o Cr\u00e9dito idTipoOperacaoCredito) = 3 \u2013 Inscri\u00e7\u00e3o D\u00edvida Ativa da tabela (LancamentoCredito) deve ser utilizado apenas na tabela (InscricaoDividaAtiva).", (Long)2113L, (TipoRegistroSimAm)TipoRegistroSimAm.LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateAnoCredito(LancamentoCreditoValidacaoDTO lancamentoCreditoValidacaoDTO) {
        if (Objects.isNull(lancamentoCreditoValidacaoDTO.getNrAnoCredito()) || lancamentoCreditoValidacaoDTO.getNrAnoCredito() < 2023L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)lancamentoCreditoValidacaoDTO.getIdTceLancCredito(), (String)"O registro declarado na tabela (LancamentoCredito) n\u00e3o pode conter o valor do campo (nrAnoCredito) menor que o exerc\u00edcio financeiro de 2023.", (Long)2232L, (TipoRegistroSimAm)TipoRegistroSimAm.LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }
}

