/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoLancamentoCreditoValidacaoDTO;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.Year;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class EstornoLancamentoCreditoValidacaoService {
    private static final Long CODIGO_ESCOPO_LEI = 22L;

    public List<ErrosImportacaoSIMAM> validateEstornoLancamentoCredito(EstornoLancamentoCreditoValidacaoDTO dto, StepExecution stepExecution) {
        ArrayList<Optional> erros = new ArrayList<Optional>();
        erros.add(this.validateRegistroDuplicado(dto));
        erros.add(this.validateSequenciaNrEstorno(dto));
        erros.add(this.validateNrCreditoNrAnoCredito(dto));
        erros.add(this.validateCdControleLeiAto(dto));
        erros.add(this.validateDtEstorno(dto, stepExecution));
        erros.add(this.validateVlEstorno(dto));
        erros.add(this.validateDsMotivo(dto));
        erros.add(this.validateNrAnoEstorno(dto));
        return erros.stream().flatMap(Optional::stream).collect(Collectors.toList());
    }

    private Optional<ErrosImportacaoSIMAM> validateRegistroDuplicado(EstornoLancamentoCreditoValidacaoDTO dto) {
        if (dto.getNrRegistro() > 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceLancCreditoEst(), (String)"O N\u00famero e Ano do Estorno (nrEstorno e nrAnoEstorno) declarados da tabela (EstornoLancamentoCredito) apresenta-se com registro duplicado no ano de trabalho", (Long)1318L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateSequenciaNrEstorno(EstornoLancamentoCreditoValidacaoDTO dto) {
        if (dto.getNrEstornoAnterior() != 0L && dto.getNrEstorno() - dto.getNrEstornoAnterior() != 1L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceLancCreditoEst(), (String)"O N\u00famero e Ano do Estorno (nrEstorno e nrAnoEstorno) da tabela (EstornoLancamentoCredito) apresenta-se quebra da ordem num\u00e9rica no ano de trabalho.", (Long)1319L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateCdControleLeiAto(EstornoLancamentoCreditoValidacaoDTO dto) {
        if (Objects.isNull(dto.getCdControleLeiAto()) || !CODIGO_ESCOPO_LEI.equals(dto.getEscopoLei())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceLancCreditoEst(), (String)"O Controle da Lei/Ato (cdControleLeiAto) declarado da tabela (EstornoLancamentoCredito) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.", (Long)1321L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrCreditoNrAnoCredito(EstornoLancamentoCreditoValidacaoDTO dto) {
        if (Objects.isNull(dto.getNrCredito()) || Objects.isNull(dto.getNrAnoCredito())) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceLancCreditoEst(), (String)"A combina\u00e7\u00e3o (nrCredito e nrAnoCredito) da tabela (EstornoLancamentoCredito) n\u00e3o existe na tabela (LancamentoCredito).", (Long)1320L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDtEstorno(EstornoLancamentoCreditoValidacaoDTO dto, StepExecution stepExecution) {
        LocalDate mesValidacao = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        Month mesEstorno = dto.getDtEstorno().getMonth();
        Year anoEstorno = Year.of(dto.getDtEstorno().getYear());
        if (Objects.isNull(dto.getDtLancamento()) || dto.getDtEstorno().isBefore(dto.getDtLancamento()) || !mesEstorno.equals(mesValidacao.getMonth()) || !anoEstorno.equals(Year.of(mesValidacao.getYear()))) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceLancCreditoEst(), (String)"A Data do Estorno (dtEstorno) declarada na tabela (EstornoLancamentoCredito) n\u00e3o pode ser menor que a data do lan\u00e7amento na tabela (LancamentoCredito) e nem maior que o m\u00eas/ano de trabalho.", (Long)1322L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateVlEstorno(EstornoLancamentoCreditoValidacaoDTO dto) {
        if (dto.getVlEstorno().compareTo(BigDecimal.ZERO) < 0) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceLancCreditoEst(), (String)"O Valor do Estorno (vlEstorno) declarado na tabela (EstornoLancamentoCredito) n\u00e3o pode ser menor ou igual a zero.", (Long)1323L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateDsMotivo(EstornoLancamentoCreditoValidacaoDTO dto) {
        if (Objects.isNull(dto.getDsMotivo()) || dto.getDsMotivo().length() < 10) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceLancCreditoEst(), (String)"A descri\u00e7\u00e3o do motivo do estorno (dsMotivo) declarada na tabela (EstornoLancamentoCredito) n\u00e3o pode conter menos de 10 (dez) caracteres.", (Long)1324L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }

    private Optional<ErrosImportacaoSIMAM> validateNrAnoEstorno(EstornoLancamentoCreditoValidacaoDTO dto) {
        if (dto.getNrAnoEstorno() < 2023L) {
            return Optional.of(ErrosImportacaoSIMAM.from((Long)dto.getIdTceLancCreditoEst(), (String)"O registro declarado da tabela (EstornoLancamentoCredito) n\u00e3o pode estar vinculado com ano de cr\u00e9dito (nrAnoCredito) menor que o exerc\u00edcio financeiro de 2023.", (Long)2242L, (TipoRegistroSimAm)TipoRegistroSimAm.ESTORNO_LANCAMENTO_CREDITO));
        }
        return Optional.empty();
    }
}

