/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.sanepar;

import br.com.elotech.tributos.domain.sanepar.BaixaSanepar;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ImportacaoSaneparJobStarter {
    private JobLauncher jobLauncher;
    private Job importacaoSaneparJob;

    public ImportacaoSaneparJobStarter(JobLauncher jobLauncher, @Qualifier(value="importacaoSaneparBatchJob") Job importacaoSaneparJob) {
        this.jobLauncher = jobLauncher;
        this.importacaoSaneparJob = importacaoSaneparJob;
    }

    public JobExecution startJob(BaixaSanepar baixaSanepar) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idBaixa", baixaSanepar.getId(), true);
        jobParametersBuilder.addString("tipoBaixa", baixaSanepar.getTipo().getCodigo(), true);
        jobParametersBuilder.addLong("idArquivo", baixaSanepar.getIdArquivo());
        jobParametersBuilder.addDate("date", new Date());
        return this.jobLauncher.run(this.importacaoSaneparJob, jobParametersBuilder.toJobParameters());
    }
}

