/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.projeto;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.jpa.support.EloSequenceCache;
import br.com.elotech.core.jpa.support.EloSequenceGenerator;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.domain.projeto.ProjetoResponsavelPK;
import br.com.elotech.tributos.dto.EnderecoResumidoResponse;
import br.com.elotech.tributos.dto.IntegracaoProjetoIssResponse;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoRowDTO;
import br.com.elotech.tributos.repository.projeto.ProjetoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.exception.projeto.ProjetoNotFoundException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ProjetoService
extends CrudService<Projeto, ProjetoPK> {
    private final ContextService contextService;
    private final EloSequenceCache eloSequenceCache;
    private final ProjetoRepository projetoRepository;

    protected void beforeSave(Projeto projeto, Authentication authentication) {
        super.beforeSave((EloEntity)projeto, authentication);
        if (Objects.isNull(projeto.getId())) {
            ProjetoPK projetoPK = new ProjetoPK();
            projetoPK.setEntidade(this.contextService.getEntidadePrincipal());
            projetoPK.setExercicio(this.contextService.getExercicioAtual());
            projeto.setId(projetoPK);
            EloSequenceGenerator.attrNextValues((Object)projeto, (SessionFactory)((SessionFactory)this.getEm().getEntityManagerFactory().unwrap(SessionFactoryImplementor.class)), (EloSequenceCache)this.eloSequenceCache);
        }
        projeto.getItens().forEach(item -> {
            if (Objects.isNull(item.getProjeto())) {
                item.setProjeto(projeto);
            }
        });
        AtomicLong sequencia = new AtomicLong(projeto.getNextSequenciaResponsavel());
        projeto.getResponsaveis().forEach(responsavel -> {
            if (Objects.isNull(responsavel.getId())) {
                ProjetoResponsavelPK projetoResponsavelPK = new ProjetoResponsavelPK();
                projetoResponsavelPK.setEntidade(projeto.getId().getEntidade());
                projetoResponsavelPK.setExercicio(projeto.getId().getExercicio());
                projetoResponsavelPK.setProjeto(projeto.getId().getProjeto());
                projetoResponsavelPK.setSequencia(Long.valueOf(sequencia.getAndIncrement()));
                responsavel.setId(projetoResponsavelPK);
                responsavel.setProjeto(projeto);
            }
        });
        projeto.getObservacoes().forEach(observacao -> {
            if (Objects.isNull(observacao.getProjeto())) {
                observacao.setProjeto(projeto);
            }
        });
    }

    public Page<ProjetoRowDTO> findByRsqlProjetoRowDTOS(String search, Pageable pageable) {
        Page projetos = this.findByRsql(search, pageable);
        return projetos.map(ProjetoRowDTO::from);
    }

    public ProjetoDTO findOneProjetoDTO(ProjetoPK id) {
        return this.findById((Serializable)id).map(ProjetoDTO::from).orElseThrow(() -> new ProjetoNotFoundException(id));
    }

    public List<IntegracaoProjetoIssResponse> findProjetoIntegracao(Long idProcesso, Long exercicio) {
        List projetos = this.projetoRepository.findAllProjetosIntegradosByProcessoAndExercicio(idProcesso, exercicio);
        return projetos.stream().map(arg_0 -> this.mapIntegracaoProjetoIssResponse(arg_0)).collect(Collectors.toList());
    }

    public IntegracaoProjetoIssResponse mapIntegracaoProjetoIssResponse(Projeto projeto) {
        IntegracaoProjetoIssResponse response = new IntegracaoProjetoIssResponse();
        response.setResponsavel(this.setResponsavel(projeto));
        response.setEndereco(this.setEndereco(projeto));
        response.setArt(projeto.getArt());
        response.setExercicio(projeto.getId().getExercicio());
        response.setEntidade(projeto.getId().getEntidade());
        response.setProjeto(projeto.getId().getProjeto());
        response.setOpcaoPagamento(projeto.getOpcaoPagamento().getCodigo());
        return response;
    }

    private PessoaDTO setResponsavel(Projeto projeto) {
        PessoaDTO responsavel = new PessoaDTO();
        responsavel.setNome(projeto.getResponsavel().getNome());
        responsavel.setCnpjCpf(projeto.getResponsavel().getCnpjCpf());
        return responsavel;
    }

    private EnderecoResumidoResponse setEndereco(Projeto projeto) {
        EnderecoResumidoResponse endereco = new EnderecoResumidoResponse();
        CadastroGeral cadastroGeral = projeto.getCadastroGeral();
        endereco.setCep(cadastroGeral.getCep());
        endereco.setNumero(cadastroGeral.getNumero());
        endereco.setComplemento(cadastroGeral.getComplemento());
        Optional.of(cadastroGeral.getBairro()).ifPresent(bairro -> endereco.setBairro(bairro.getDescricao()));
        Optional.of(cadastroGeral.getCidade()).ifPresent(cidade -> {
            endereco.setCidade(cidade.getDescricao());
            endereco.setUnidadeFederacao(cidade.getUnidadeFederacao());
        });
        Optional.of(cadastroGeral.getLogradouro()).ifPresent(logradouro -> {
            endereco.setLogradouro(logradouro.getDescricao());
            Optional.of(logradouro.getTipoLogradouro()).ifPresent(tipo -> endereco.setTipoLogradouro(tipo.getDescricao()));
        });
        return endereco;
    }

    @Generated
    public ProjetoService(ContextService contextService, EloSequenceCache eloSequenceCache, ProjetoRepository projetoRepository) {
        this.contextService = contextService;
        this.eloSequenceCache = eloSequenceCache;
        this.projetoRepository = projetoRepository;
    }
}

