/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.oxyadmin;

import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.oxyadmin.DashBoardRepository;
import br.com.elotech.tributos.service.ExercicioService;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class DashBoardService {
    private final EntidadeRepository entidadeRepository;
    private final ExercicioService exercicioService;
    private final DashBoardRepository dashBoardRepository;

    public DashBoardService(EntidadeRepository entidadeRepository, ExercicioService exercicioService, DashBoardRepository dashBoardRepository) {
        this.entidadeRepository = entidadeRepository;
        this.exercicioService = exercicioService;
        this.dashBoardRepository = dashBoardRepository;
    }

    public Long getTotalGuiasEmitidas(Optional<Long> entidade, Optional<Long> exercicio, Optional<Long> mes) {
        Entidade entidadeEntity = entidade.map(arg_0 -> ((EntidadeRepository)this.entidadeRepository).findOne(arg_0)).orElseGet(() -> ((EntidadeRepository)this.entidadeRepository).findByEntidadeprincipal());
        Long exercicioLong = exercicio.map(id -> id).orElse(this.exercicioService.getExercicio());
        Long mesLong = mes.map(id -> id).orElse(this.exercicioService.getMes());
        return this.dashBoardRepository.getTotalGuiasEmitidas(entidadeEntity.getId(), exercicioLong, mesLong);
    }

    public Long getTotalCertidoesEmitidas(Optional<Long> entidade, Optional<Long> exercicio, Optional<Long> mes) {
        Entidade entidadeEntity = entidade.map(arg_0 -> ((EntidadeRepository)this.entidadeRepository).findOne(arg_0)).orElseGet(() -> ((EntidadeRepository)this.entidadeRepository).findByEntidadeprincipal());
        Long exercicioLong = exercicio.map(id -> id).orElse(this.exercicioService.getExercicio());
        Long mesLong = mes.map(id -> id).orElse(this.exercicioService.getMes());
        return this.dashBoardRepository.getTotalCertidoesEmitidas(entidadeEntity.getId(), exercicioLong, mesLong);
    }
}

