/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoprotestocra;

import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaHeaderDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaTraillerDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaTransacaoDTO;
import br.com.elotech.tributos.enums.protestoremessa.CabecalhoProtestoRemessa;
import br.com.elotech.tributos.enums.protestoremessa.DetalheProtestoRemessa;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ArquivoTxtProtestoRemessa {
    private ByteArrayOutputStream outStream;
    private ZipOutputStream zipOutStream;
    private String nomeArquivo;

    public ArquivoTxtProtestoRemessa(String nomeArquivo) {
        try {
            this.nomeArquivo = nomeArquivo;
            this.outStream = new ByteArrayOutputStream();
            this.zipOutStream = new ZipOutputStream(this.outStream);
            ZipEntry e = new ZipEntry(nomeArquivo);
            this.zipOutStream.putNextEntry(e);
        }
        catch (IOException ex) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel criar o arquivo txt da Protesto remessa.", ex);
        }
    }

    public void gerarCabecalho(CraComarcaHeaderDTO craComarcaHeaderDTO) {
        String identificadorRegistro = this.formatField(craComarcaHeaderDTO.getIdHeader(), CabecalhoProtestoRemessa.IDENTIFICADOR_REGISTRO.getTamanho());
        String codigoPortador = this.formatField(craComarcaHeaderDTO.getCodApresentante(), CabecalhoProtestoRemessa.CODIGO_PORTADOR.getTamanho());
        String nomePortador = this.formatField(craComarcaHeaderDTO.getNomeApresentante(), CabecalhoProtestoRemessa.NOME_PORTADOR.getTamanho());
        String dataMovimento = this.formatField(craComarcaHeaderDTO.getDataEnvioRemessa(), CabecalhoProtestoRemessa.DATA_MOVIMENTO.getTamanho());
        String identificadorRemetente = this.formatField(craComarcaHeaderDTO.getIdTransacaoRemetente(), CabecalhoProtestoRemessa.IDENTIFICACAO_TRANSACAO_REMETENTE.getTamanho());
        String identificadorDestinatario = this.formatField(craComarcaHeaderDTO.getIdTransacaoDestinatario(), CabecalhoProtestoRemessa.IDENTIFICACAO_TRANSACAO_DESTINATARIO.getTamanho());
        String identificadorTipo = this.formatField(craComarcaHeaderDTO.getIdTransacaoTipo(), CabecalhoProtestoRemessa.IDENTIFICACAO_TRANSACAO_TIPO.getTamanho());
        String numeroSequencial = this.formatField(craComarcaHeaderDTO.getSequencialRemessa(), CabecalhoProtestoRemessa.NUMERO_SEQUENCIAL_REMESSA.getTamanho());
        String quantidadeRegistro = this.formatField(craComarcaHeaderDTO.getQtdeRegistrosTransacao(), CabecalhoProtestoRemessa.QUANTIDADE_REGISTROS_REMESSA.getTamanho());
        String quantidadeTitulo = this.formatField(craComarcaHeaderDTO.getQtdeTitulosRemessa(), CabecalhoProtestoRemessa.QUANTIDADE_TITULOS_REMESSA.getTamanho());
        String quantidadeIndicacao = this.formatField(craComarcaHeaderDTO.getQtdeIndicacoesTipo(), CabecalhoProtestoRemessa.QUANTIDADE_ORIGINAIS_REMESSA.getTamanho());
        String quantidadeOriginal = this.formatField(craComarcaHeaderDTO.getQtdeTitulosOriginaisRemessa(), CabecalhoProtestoRemessa.QUANTIDADE_ORIGINAIS_REMESSA.getTamanho());
        String identificacaoAgencia = this.formatField(craComarcaHeaderDTO.getNumIdApresentante(), CabecalhoProtestoRemessa.IDENTIFICACAO_AGENCIA_CENTRALIZADORA.getTamanho());
        String versaoLayout = this.formatField(craComarcaHeaderDTO.getVersaoLayout(), CabecalhoProtestoRemessa.VERSAO_LAYOUT.getTamanho());
        String codigoMunicipioPraca = this.formatField(craComarcaHeaderDTO.getCodMunicipio(), CabecalhoProtestoRemessa.CODIGO_MUNICIPIO_PRACA_PAGAMENTO.getTamanho());
        String complementoRegistro = this.formatField(craComarcaHeaderDTO.getCodApresentanteCompleto(), CabecalhoProtestoRemessa.COMPLEMENTO_REGISTRO.getTamanho());
        String numeroSequencialArquivo = this.formatField(craComarcaHeaderDTO.getSequencialRegistro(), CabecalhoProtestoRemessa.NUMERO_SEQUENCIAL_REGISTRO_ARQUIVO.getTamanho());
        this.escreverLinha(new String[]{identificadorRegistro, codigoPortador, nomePortador, dataMovimento, identificadorRemetente, identificadorDestinatario, identificadorTipo, numeroSequencial, quantidadeRegistro, quantidadeTitulo, quantidadeIndicacao, quantidadeOriginal, identificacaoAgencia, versaoLayout, codigoMunicipioPraca, complementoRegistro, numeroSequencialArquivo});
    }

    public void gerarRodape(CraComarcaTraillerDTO craComarcaTraillerDTO) {
        String identificadorRegistro = this.formatField(craComarcaTraillerDTO.getIdTrailler(), CabecalhoProtestoRemessa.IDENTIFICADOR_REGISTRO.getTamanho());
        String codigoPortador = this.formatField(craComarcaTraillerDTO.getCodApresentante(), CabecalhoProtestoRemessa.CODIGO_PORTADOR.getTamanho());
        String nomePortador = this.formatField(craComarcaTraillerDTO.getNomeApresentante(), CabecalhoProtestoRemessa.NOME_PORTADOR.getTamanho());
        String dataMovimento = this.formatField(craComarcaTraillerDTO.getDataEnvioRemessa(), CabecalhoProtestoRemessa.DATA_MOVIMENTO.getTamanho());
        String somatorioSegurancaQtde = this.formatField(craComarcaTraillerDTO.getSomatoriaDeSeguranca(), CabecalhoProtestoRemessa.IDENTIFICACAO_TRANSACAO_REMETENTE.getTamanho());
        String somatorioSegurancaValor = this.formatField(craComarcaTraillerDTO.getSomatoriaSaldoTitulo(), CabecalhoProtestoRemessa.IDENTIFICACAO_TRANSACAO_DESTINATARIO.getTamanho());
        String complementoRegistro = this.formatField(craComarcaTraillerDTO.getComplementoRegistro(), CabecalhoProtestoRemessa.COMPLEMENTO_REGISTRO.getTamanho());
        String numeroSequencialArquivo = this.formatField(craComarcaTraillerDTO.getSequencialRegistro(), CabecalhoProtestoRemessa.NUMERO_SEQUENCIAL_REGISTRO_ARQUIVO.getTamanho());
        this.escreverLinha(new String[]{identificadorRegistro, codigoPortador, nomePortador, dataMovimento, somatorioSegurancaQtde, somatorioSegurancaValor, complementoRegistro, numeroSequencialArquivo});
    }

    public void gerarDetalhe(CraComarcaTransacaoDTO craComarcaTransacaoDTO) {
        String identificadorRegistro = this.formatField(craComarcaTransacaoDTO.getIdTransacao(), DetalheProtestoRemessa.IDENTIFICADOR_REGISTRO.getTamanho());
        String codigoPortador = this.formatField(craComarcaTransacaoDTO.getCodApresentante(), DetalheProtestoRemessa.CODIGO_PORTADOR.getTamanho());
        String agenciaCedente = this.formatField(craComarcaTransacaoDTO.getCodCedenteTitulo(), DetalheProtestoRemessa.AGENCIA_CODIGO_CEDENTE.getTamanho());
        String nomeCedente = this.formatField(craComarcaTransacaoDTO.getNomeCedente(), DetalheProtestoRemessa.NOME_CEDENTE_FAVORECIDO.getTamanho());
        String nomeSacador = this.formatField(craComarcaTransacaoDTO.getNomeSacador(), DetalheProtestoRemessa.NOME_SACADOR_VENDEDOR.getTamanho());
        String documentoSacador = this.formatField(craComarcaTransacaoDTO.getNumCnpjSacador(), DetalheProtestoRemessa.DOCUMENTO_SACADOR.getTamanho());
        String enderecoSacador = this.formatField(craComarcaTransacaoDTO.getEnderecoSacador(), DetalheProtestoRemessa.ENDERECO_SACADOR_VENDEDOR.getTamanho());
        String cepSacador = this.formatField(craComarcaTransacaoDTO.getCepSacador(), DetalheProtestoRemessa.CEP_SACADOR_VENDEDOR.getTamanho());
        String cidadeSacador = this.formatField(craComarcaTransacaoDTO.getCidadeSacador(), DetalheProtestoRemessa.CIDADE_SACADOR_VENDEDOR.getTamanho());
        String ufSacador = this.formatField(craComarcaTransacaoDTO.getUfSacador(), DetalheProtestoRemessa.UF_SACADOR_VENDEDOR.getTamanho());
        String nossoNumero = this.formatField(craComarcaTransacaoDTO.getNossoNumero(), DetalheProtestoRemessa.NOSSO_NUMERO.getTamanho());
        String especieTituloCda = this.formatField(craComarcaTransacaoDTO.getEspecieTitulo(), DetalheProtestoRemessa.ESPECIE_TITULO_CDA.getTamanho());
        String numeroTitulo = this.formatField(craComarcaTransacaoDTO.getNumTitulo(), DetalheProtestoRemessa.NUMERO_TITULO.getTamanho());
        String dataEmissaoTitulo = this.formatField(craComarcaTransacaoDTO.getDataEmissaoTitulo(), DetalheProtestoRemessa.DATA_EMISSAO_TITULO.getTamanho());
        String dataVencimentoTitulo = this.formatField(craComarcaTransacaoDTO.getDataVencimentoTitulo(), DetalheProtestoRemessa.DATA_VENCIMENTO_TITULO.getTamanho());
        String tipoMoeda = this.formatField(craComarcaTransacaoDTO.getTipoMoeda(), DetalheProtestoRemessa.TIPO_MOEDA.getTamanho());
        String valorTitulo = this.formatField(craComarcaTransacaoDTO.getValorTitulo(), DetalheProtestoRemessa.VALOR_TITULO.getTamanho());
        String saldoTitulo = this.formatField(craComarcaTransacaoDTO.getSaldoTitulo(), DetalheProtestoRemessa.SALDO_TITULO.getTamanho());
        String pracaProtesto = this.formatField(craComarcaTransacaoDTO.getPracaPagamento(), DetalheProtestoRemessa.PRACA_PROTESTO.getTamanho());
        String tipoEndosso = this.formatField(craComarcaTransacaoDTO.getTipoEndosso(), DetalheProtestoRemessa.TIPO_ENDOSSO.getTamanho());
        String informacoesAceite = this.formatField(craComarcaTransacaoDTO.getInfoAceite(), DetalheProtestoRemessa.INFORMACOES_ACEITE.getTamanho());
        String numeroControleDevedor = this.formatField(craComarcaTransacaoDTO.getSequencialDevedoresNoMesmoTitulo(), DetalheProtestoRemessa.NUMERO_CONTROLE_DEVEDOR.getTamanho());
        String nomeDevedor = this.formatField(craComarcaTransacaoDTO.getNomeDevedor(), DetalheProtestoRemessa.NOME_DEVEDOR.getTamanho());
        String tipoIdentificadorDevedor = this.formatField(craComarcaTransacaoDTO.getTipoDocumentoDevedor(), DetalheProtestoRemessa.TIPO_IDENTIFICACAO_DEVEDOR.getTamanho());
        String numeroIdentificadorDevedor = this.formatField(craComarcaTransacaoDTO.getNumDocumentoDevedor(), DetalheProtestoRemessa.NUMERO_IDENTIFICADOR_DEVEDOR.getTamanho());
        String documentoDevedor = this.formatField(craComarcaTransacaoDTO.getRg(), DetalheProtestoRemessa.DOCUMENTO_DEVEDOR.getTamanho());
        String enderecoDevedor = this.formatField(craComarcaTransacaoDTO.getEnderecoDevedor(), DetalheProtestoRemessa.ENDERECO_DEVEDOR.getTamanho());
        String cepDevedor = this.formatField(craComarcaTransacaoDTO.getCepDevedor(), DetalheProtestoRemessa.CEP_DEVEDOR.getTamanho());
        String cidadeDevedor = this.formatField(craComarcaTransacaoDTO.getCidadeDevedor(), DetalheProtestoRemessa.CIDADE_DEVEDOR.getTamanho());
        String ufDevedor = this.formatField(craComarcaTransacaoDTO.getUfDevedor(), DetalheProtestoRemessa.UF_DEVEDOR.getTamanho());
        String codigoCartorio = this.formatField(craComarcaTransacaoDTO.getCodCartorio(), DetalheProtestoRemessa.CODIGO_CARTORIO.getTamanho());
        String numeroProtocoloCartorio = this.formatField(craComarcaTransacaoDTO.getNumProtocoloCartorio(), DetalheProtestoRemessa.NUMERO_PROTOCOLO_CARTORIO.getTamanho());
        String tipoOcorrencia = this.formatField(craComarcaTransacaoDTO.getTipoOcorrencia(), DetalheProtestoRemessa.TIPO_OCORRENCIA.getTamanho());
        String dataProtocolo = this.formatField(craComarcaTransacaoDTO.getDataProtocolo(), DetalheProtestoRemessa.DATA_PROTOCOLO.getTamanho());
        String valorCustaCartorio = this.formatField(craComarcaTransacaoDTO.getValorCustasCartorio(), DetalheProtestoRemessa.VALOR_CUSTA_CARTORIO.getTamanho());
        String declaracaoPortador = this.formatField(craComarcaTransacaoDTO.getDeclaracaoPortador(), DetalheProtestoRemessa.DECLARACAO_PORTADOR.getTamanho());
        String dataOcorrencia = this.formatField(craComarcaTransacaoDTO.getDataOcorrencia(), DetalheProtestoRemessa.DATA_OCORRENCIA.getTamanho());
        String codigoIrregularidade = this.formatField(craComarcaTransacaoDTO.getCodIrregularidade(), DetalheProtestoRemessa.CODIGO_IRREGULARIDADE.getTamanho());
        String bairroDevedor = this.formatField(craComarcaTransacaoDTO.getBairroDevedor(), DetalheProtestoRemessa.BAIRRO_DEVEDOR.getTamanho());
        String valorCustaCartorioDistribuidor = this.formatField(craComarcaTransacaoDTO.getValorCustasCartorioDistribuidor(), DetalheProtestoRemessa.VALOR_CUSTA_CARTORIO_DISTRIBUIDOR.getTamanho());
        String registroDistribuicao = this.formatField(craComarcaTransacaoDTO.getRegistroDistribuicao(), DetalheProtestoRemessa.REGISTRO_DISTRIBUICAO.getTamanho());
        String valorGravacaoEletronica = this.formatField(craComarcaTransacaoDTO.getValorGravacaoEletronicaEDemaisDespesas(), DetalheProtestoRemessa.VALOR_GRAVACAO_ELETRONICA.getTamanho());
        String numeroOperacaoBanco = this.formatField(craComarcaTransacaoDTO.getNumOperacaoBanco(), DetalheProtestoRemessa.NUMERO_OPERACAO_BANCO.getTamanho());
        String numeroContratoBanco = this.formatField(craComarcaTransacaoDTO.getNumContratoBanco(), DetalheProtestoRemessa.NUMERO_CONTRATO_BANCO.getTamanho());
        String numeroParcelaContrato = this.formatField(craComarcaTransacaoDTO.getNumParcelaContrato(), DetalheProtestoRemessa.NUMERO_PARCELA_CONTRATO.getTamanho());
        String tipoLetraCambio = this.formatField(craComarcaTransacaoDTO.getTipoLetraCambio(), DetalheProtestoRemessa.TIPO_LETRA_CAMBIO.getTamanho());
        String complementoCodigoIrregularidade = this.formatField(craComarcaTransacaoDTO.getComplementoCodIrregularidade(), DetalheProtestoRemessa.COMPLEMENTO_CODIGO_IRREGULARIDADE.getTamanho());
        String protestoMotivoFalencia = this.formatField(craComarcaTransacaoDTO.getProtestoPorMotivoFalencia(), DetalheProtestoRemessa.PROTESTO_MOTIVO_FALENCIA.getTamanho());
        String instrumentoProtesto = this.formatField(craComarcaTransacaoDTO.getInstrumentoDeProtesto(), DetalheProtestoRemessa.INSTRUMENTO_PROTESTO.getTamanho());
        String valorDemaisDespesas = this.formatField(craComarcaTransacaoDTO.getValorDemaisDespesas(), DetalheProtestoRemessa.VALOR_DEMAIS_DESPESAS.getTamanho());
        String complementoRegistro = this.formatField(craComarcaTransacaoDTO.getImagemDocumentos(), DetalheProtestoRemessa.COMPLEMENTO_REGISTRO.getTamanho());
        String numeroSequencialArquivo = this.formatField(craComarcaTransacaoDTO.getSequencialRegistro(), DetalheProtestoRemessa.NUMERO_SEQUENCIAL_ARQUIVO.getTamanho());
        this.escreverLinha(new String[]{identificadorRegistro, codigoPortador, agenciaCedente, nomeCedente, nomeSacador, documentoSacador, enderecoSacador, cepSacador, cidadeSacador, ufSacador, nossoNumero, especieTituloCda, numeroTitulo, dataEmissaoTitulo, dataVencimentoTitulo, tipoMoeda, valorTitulo, saldoTitulo, pracaProtesto, tipoEndosso, informacoesAceite, numeroControleDevedor, nomeDevedor, tipoIdentificadorDevedor, numeroIdentificadorDevedor, documentoDevedor, enderecoDevedor, cepDevedor, cidadeDevedor, ufDevedor, codigoCartorio, numeroProtocoloCartorio, tipoOcorrencia, dataProtocolo, valorCustaCartorio, declaracaoPortador, dataOcorrencia, codigoIrregularidade, bairroDevedor, valorCustaCartorioDistribuidor, registroDistribuicao, valorGravacaoEletronica, numeroOperacaoBanco, numeroContratoBanco, numeroParcelaContrato, tipoLetraCambio, complementoCodigoIrregularidade, protestoMotivoFalencia, instrumentoProtesto, valorDemaisDespesas, complementoRegistro, numeroSequencialArquivo});
    }

    private void escreverLinha(String ... campos) {
        String linha = String.join((CharSequence)"", campos) + "\n";
        try {
            byte[] data = linha.getBytes();
            this.zipOutStream.write(data, 0, data.length);
        }
        catch (IOException ex) {
            throw new RuntimeException("Erro ao escrever no arquivo txt da protesto remessa.", ex);
        }
    }

    public void finalizarGeracaoArquivo() {
        try {
            this.zipOutStream.closeEntry();
            this.zipOutStream.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Erro ao finalizar gera\u00e7\u00e3o do txt da protesto remessa.", ex);
        }
    }

    private String formatField(String value, Long tamanho) {
        return StringUtils.truncate((String)StringUtils.rightPad((String)StringUtils.defaultString((String)value), (int)tamanho.intValue()), (int)tamanho.intValue());
    }

    private String formatField(Long numero, Long tamanho) {
        return StringUtils.leftPad((String)numero.toString(), (int)tamanho.intValue(), (String)"0");
    }

    private String formatField(BigDecimal value, Long tamanho) {
        Long valorMultiplicadoPorCem = Optional.ofNullable(value).map(valor -> valor.multiply(BigDecimal.valueOf(100L)).longValue()).orElse(0L);
        return this.formatField(valorMultiplicadoPorCem, tamanho);
    }

    @Generated
    public ByteArrayOutputStream getOutStream() {
        return this.outStream;
    }

    @Generated
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }
}

