/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.comunicado;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.calculo.dto.CalculoGeracaoLoteFiltroDTO;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.dto.comunicado.GerarComunicadoRequest;
import br.com.elotech.tributos.enums.OrigemComunicado;
import br.com.elotech.tributos.enums.comunicado.TipoComunicadoGeracaoManual;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.batch.comunicado.ComunicadoManualJobStarter;
import br.com.elotech.tributos.service.comunicado.ComunicadoService;
import br.com.elotech.tributos.service.comunicado.ValidacaoComunicadoService;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class GerarComunicadoManualService {
    private static final HashMap<TipoComunicadoGeracaoManual, String> SQL_SOURCE = new HashMap<TipoComunicadoGeracaoManual, String>(Map.of(TipoComunicadoGeracaoManual.CADASTRO_IMOBILIARIO, "sql/batch/findCadastrosParaComunicado.sql", TipoComunicadoGeracaoManual.CONTRIBUINTE, "sql/batch/findCadastrosParaComunicado.sql"));
    private static final String AND = " AND ";
    private final EntityManager entityManager;
    private final ComunicadoService comunicadoService;
    private final ContextService contextService;
    private final ComunicadoManualJobStarter comunicadoManualJobStarter;
    private final ValidacaoComunicadoService validacaoComunicadoService;

    public void gerarComunicadoManual(GerarComunicadoRequest request) {
        this.validateSeTemFiltros(request);
        String sql = this.getSql(request);
        if (!this.existemRegistros(sql)) {
            throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o h\u00e1 cadastros para gerar comunicado com os filtros escolhidos");
        }
        this.validacaoComunicadoService.validaParametroComunicadoManualDuplicado(this.getFilters(request));
        Comunicado comunicado = this.gerarComunicado(request);
        this.comunicadoManualJobStarter.startJob(comunicado, request.getTipoComunicadoGeracaoManual());
    }

    private void validateSeTemFiltros(GerarComunicadoRequest request) {
        if (request.getFiltrosCamposDinamicos().isEmpty()) {
            throw new RestException(HttpStatus.BAD_REQUEST, "\u00c9 necess\u00e1rio ao menos um filtro selecionado");
        }
    }

    private Comunicado gerarComunicado(GerarComunicadoRequest request) {
        ComunicadoId comunicadoId = new ComunicadoId();
        comunicadoId.setEntidade(this.contextService.getEntidadePrincipal());
        comunicadoId.setExercicio(this.contextService.getExercicioAtual());
        Comunicado comunicado = new Comunicado();
        comunicado.setId(comunicadoId);
        comunicado.setDescricao(request.getDescricao());
        comunicado.setTipoNotificacao(request.getTipoNotificacao());
        comunicado.setRelatorio(request.getTipoNotificacao().getRelatorio());
        comunicado.setDataValidade(request.getDataValidade());
        comunicado.setDataGeracao(request.getDataGeracao());
        comunicado.setUsuario(request.getUsuario());
        comunicado.setOrigem(OrigemComunicado.GERACAO_MANUAL);
        comunicado.setFiltroUtilizado(this.getFilters(request));
        return (Comunicado)this.comunicadoService.save((EloEntity)comunicado, null);
    }

    private String getSql(GerarComunicadoRequest request) {
        String sqlPath = this.getSqlString(request.getTipoComunicadoGeracaoManual());
        return String.format(FileUtils.readResourceAsString((String)sqlPath), this.getFilters(request));
    }

    public String getSqlString(TipoComunicadoGeracaoManual tipo) {
        String sqlPath = (String)SQL_SOURCE.get(tipo);
        if (sqlPath == null) {
            throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o implementado consulta de " + tipo.getDescricao());
        }
        return sqlPath;
    }

    private boolean existemRegistros(String sql) {
        String sqlExists = String.format("SELECT EXISTS(%s)", sql);
        return this.entityManager.createNativeQuery(sqlExists).getSingleResult().equals(Boolean.TRUE);
    }

    private String getFilters(GerarComunicadoRequest request) {
        return AND + request.getFiltrosCamposDinamicos().stream().map(CalculoGeracaoLoteFiltroDTO::generateFiltro).collect(Collectors.joining(AND));
    }

    @Generated
    public GerarComunicadoManualService(EntityManager entityManager, ComunicadoService comunicadoService, ContextService contextService, ComunicadoManualJobStarter comunicadoManualJobStarter, ValidacaoComunicadoService validacaoComunicadoService) {
        this.entityManager = entityManager;
        this.comunicadoService = comunicadoService;
        this.contextService = contextService;
        this.comunicadoManualJobStarter = comunicadoManualJobStarter;
        this.validacaoComunicadoService = validacaoComunicadoService;
    }
}

