/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.notifiers.implementations;

import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.repository.agendamentorotina.AgendamentoRotinaRepository;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.implementations.InscricaoDividaAtivaNotifier;
import org.springframework.batch.core.JobExecution;
import org.springframework.stereotype.Service;

@Service
public class InscricaoDividaAtivaNotifier
implements AgendamentoRotinaNotifier {
    private final MailService mailService;
    private final AgendamentoRotinaRepository repository;
    private final PessoaService pessoaService;

    protected InscricaoDividaAtivaNotifier(MailService mailService, AgendamentoRotinaRepository repository, PessoaService pessoaService) {
        this.mailService = mailService;
        this.repository = repository;
        this.pessoaService = pessoaService;
    }

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.INSCRICAO_DIVIDA_ATIVA.equals((Object)agendamentoRotina.getRotina());
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public <R> void notify(AgendamentoRotina agendamentoRotina, R resource) {
        if (resource instanceof JobExecution) {
            this.notifyBatchStatus(agendamentoRotina, (JobExecution)resource);
        }
    }

    public <R> void notify(Long idAgendamento, R resource) {
        this.repository.findById((Object)idAgendamento).ifPresent(agendamentoRotina -> this.notify(agendamentoRotina, resource));
    }

    private void notifyBatchStatus(AgendamentoRotina agendamentoRotina, JobExecution jobExecution) {
        String messageContent = this.buildMessageContent(jobExecution);
        this.notifyEmail(agendamentoRotina, messageContent);
    }

    private void notifyEmail(AgendamentoRotina agendamentoRotina, String message) {
        if (agendamentoRotina.shouldSendEmail()) {
            MailParams mailParams = this.buildMailParams(agendamentoRotina, message);
            this.notifyByEmail(mailParams);
        }
    }

    private MailParams buildMailParams(AgendamentoRotina agendamentoRotina, String message) {
        Pessoa pessoa = this.pessoaService.findByCnpjCpf(agendamentoRotina.getUsuario());
        return MailParams.builder().to(pessoa.getContatoPrincipal().getEmail()).subject("Agendamento de rotina " + agendamentoRotina.getId() + " - Gera\u00e7\u00e3o de Livro de D\u00edvida Ativa").multipart(false).content(message).html(false).build();
    }

    private String buildMessageContent(JobExecution jobExecution) {
        Livro livro = (Livro)jobExecution.getExecutionContext().get("livro");
        String messageTemplate = "Rotina de gera\u00e7\u00e3o de livro de d\u00edvida ativa foi executada";
        String message = "";
        switch (1.$SwitchMap$org$springframework$batch$core$BatchStatus[jobExecution.getStatus().ordinal()]) {
            case 1: {
                if (livro == null) break;
                message = String.format("Rotina de gera\u00e7\u00e3o de livro de d\u00edvida ativa foi executada com sucesso. Livro gerado: %s/%s", livro.getId().getLivro(), livro.getId().getExercicio());
                break;
            }
            case 2: {
                message = String.format("Rotina de gera\u00e7\u00e3o de livro de d\u00edvida ativa foi executada com falha. Motivo: %s", ((Throwable)jobExecution.getFailureExceptions().get(0)).getMessage());
            }
        }
        return message;
    }
}

