/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.PagamentoBoleto;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoDevolucaoCredito;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCredito;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoDebito;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoDebitoId;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItem;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItemId;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoRestituicaoDTO;
import br.com.elotech.tributos.dto.devolucaocredito.DevolucaoCreditoRestituicaoResumoDTO;
import br.com.elotech.tributos.repository.DebitoParcelaTributoRepository;
import br.com.elotech.tributos.repository.DevolucaoCreditoItemRepository;
import br.com.elotech.tributos.repository.DevolucaoCreditoRepository;
import br.com.elotech.tributos.repository.PagamentoBoletoRepository;
import br.com.elotech.tributos.repository.PagamentoDebitoRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContaBancariaService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.util.DateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DevolucaoCreditoService
extends CrudService<DevolucaoCredito, Long> {
    private final MotivoDeducaoService motivoDeducaoService;
    private final PessoaService pessoaService;
    private final CadastroGeralService cadastroGeralService;
    private final PagamentoService pagamentoService;
    private final DevolucaoCreditoRepository devolucaoCreditoRepository;
    private final ContaBancariaService contaBancariaService;
    private final DevolucaoCreditoItemRepository devolucaoCreditoItemRepository;
    private final DebitoParcelaTributoRepository debitoParcelaTributoRepository;
    private final PagamentoBoletoRepository pagamentoBoletoRepository;
    private final PagamentoDebitoRepository pagamentoDebitoRepository;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DebitoParcelaService debitoParcelaService;

    public DevolucaoCreditoService(MotivoDeducaoService motivoDeducaoService, PessoaService pessoaService, CadastroGeralService cadastroGeralService, PagamentoService pagamentoService, DevolucaoCreditoItemRepository devolucaoCreditoItemRepository, DevolucaoCreditoRepository devolucaoCreditoItemRepository1, DevolucaoCreditoRepository devolucaoCreditoRepository, ContaBancariaService contaBancariaService, DevolucaoCreditoItemRepository devolucaoCreditoItemRepository2, DebitoParcelaTributoRepository debitoParcelaTributoRepository, PagamentoBoletoRepository pagamentoBoletoRepository, PagamentoDebitoRepository pagamentoDebitoRepository, SituacaoParcelaService situacaoParcelaService, DebitoParcelaService debitoParcelaService) {
        this.motivoDeducaoService = motivoDeducaoService;
        this.pessoaService = pessoaService;
        this.cadastroGeralService = cadastroGeralService;
        this.pagamentoService = pagamentoService;
        this.devolucaoCreditoRepository = devolucaoCreditoRepository;
        this.contaBancariaService = contaBancariaService;
        this.devolucaoCreditoItemRepository = devolucaoCreditoItemRepository2;
        this.debitoParcelaTributoRepository = debitoParcelaTributoRepository;
        this.pagamentoBoletoRepository = pagamentoBoletoRepository;
        this.pagamentoDebitoRepository = pagamentoDebitoRepository;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoParcelaService = debitoParcelaService;
    }

    public Page<DevolucaoCreditoRestituicaoDTO> getDevolucaoCreditos(Optional<String> search, Pageable pageable) {
        return this.findByRsql(search.orElse(""), pageable).map(DevolucaoCreditoRestituicaoDTO::from);
    }

    public List<DevolucaoCreditoItem> saveItens(DevolucaoCreditoRestituicaoResumoDTO devolucaoCreditoRestituicaoDTO, DevolucaoCredito devolucaoCredito) {
        AtomicLong sequenciaItem = new AtomicLong(1L);
        List<DevolucaoCreditoItem> devolucaoCreditoItems = devolucaoCreditoRestituicaoDTO.getItens().stream().map(item -> {
            DevolucaoCreditoItem devolucaoCreditoItem = new DevolucaoCreditoItem();
            DevolucaoCreditoItemId devolucaoCreditoItemId = new DevolucaoCreditoItemId();
            devolucaoCreditoItem.setCadastroGeral((CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(item.getTipoCadastro(), item.getCadastroGeral()).orElseThrow(() -> new EloValidationException("Cadastro Geral n\u00e3o encontrado.")));
            devolucaoCreditoItem.setPagamento(this.pagamentoService.findPagamentoById(item.getEntidade(), item.getExercicioPagamento(), item.getPagamento()));
            devolucaoCreditoItem.setValorDevolucao(item.getValorDevolucao());
            devolucaoCreditoItem.setValorCorrecao(item.getValorCorrecao());
            devolucaoCreditoItem.setValorCorrigido(item.getValorCorrigido());
            devolucaoCreditoItem.setEntidade(item.getEntidade());
            devolucaoCreditoItemId.setSequenciaItem(Long.valueOf(sequenciaItem.getAndIncrement()));
            devolucaoCreditoItemId.setDevolucaoCredito(devolucaoCredito);
            devolucaoCreditoItem.setId(devolucaoCreditoItemId);
            AtomicLong sequenciaDebito = new AtomicLong(1L);
            List devolucaoCreditoItemDTO = new ArrayList();
            ArrayList devolucaoCreditoDebitos = new ArrayList();
            devolucaoCreditoItemDTO = this.devolucaoCreditoItemRepository.getDebitos(item.getEntidade(), item.getExercicioPagamento(), item.getPagamento(), item.getTipoCadastro().getValue(), item.getCadastroGeral());
            devolucaoCreditoItemDTO.forEach(debitoDto -> {
                DevolucaoCreditoDebitoId devolucaoCreditoDebitoId = new DevolucaoCreditoDebitoId();
                devolucaoCreditoDebitoId.setDevolucaoCreditoItem(devolucaoCreditoItem);
                devolucaoCreditoDebitoId.setSequenciaDebito(Long.valueOf(sequenciaDebito.getAndIncrement()));
                DevolucaoCreditoDebito devolucaoCreditoDebito = new DevolucaoCreditoDebito();
                devolucaoCreditoDebito.setId(devolucaoCreditoDebitoId);
                devolucaoCreditoDebito.setValorOriginal(debitoDto.getSaldo());
                devolucaoCreditoDebito.setValorDevolvido(debitoDto.getSaldo());
                devolucaoCreditoDebito.setPagamentoBoleto((PagamentoBoleto)this.pagamentoBoletoRepository.findById((Object)debitoDto.getIdPagamentoBloqueto()).orElseThrow(() -> new EloValidationException("Pagamento Boleto n\u00e3o encontrado.")));
                devolucaoCreditoDebito.setDebitoParcelaTributo((DebitoParcelaTributo)this.debitoParcelaTributoRepository.findById((Object)debitoDto.getIdDebitoParcelaReceita()).orElseThrow(() -> new EloValidationException("Debito Parcela Tributo n\u00e3o encontrado.")));
                devolucaoCreditoDebitos.add(devolucaoCreditoDebito);
            });
            devolucaoCreditoItem.setDebitos(devolucaoCreditoDebitos);
            return devolucaoCreditoItem;
        }).collect(Collectors.toList());
        return devolucaoCreditoItems;
    }

    public DevolucaoCredito createDevolucaoCredito(DevolucaoCreditoRestituicaoResumoDTO devolucaoCreditoRestituicaoDTO, Long id) {
        DevolucaoCredito devolucaoCredito = new DevolucaoCredito();
        if (Objects.nonNull(id)) {
            devolucaoCredito = (DevolucaoCredito)this.devolucaoCreditoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar devolu\u00e7\u00e3o cr\u00e9dito com id '%d'.", id)));
        }
        if (!SituacaoDevolucaoCredito.AGUARDANDO.getDescricao().equals(devolucaoCreditoRestituicaoDTO.getSituacao())) {
            throw new EloValidationException("Somente devolu\u00e7\u00f5es com a situa\u00e7\u00e3o aguardando podem ser confirmadas");
        }
        MotivoDeducao motivoDeducao = this.motivoDeducaoService.findByMotivoId(devolucaoCreditoRestituicaoDTO.getMotivoDesconto().getId());
        ContaBancaria contaBancaria = (ContaBancaria)this.contaBancariaService.findById((Serializable)devolucaoCreditoRestituicaoDTO.getContaBancaria().getId()).orElseThrow(() -> new EloValidationException("Conta Bancaria n\u00e3o encontrado."));
        Pessoa pessoa = (Pessoa)this.pessoaService.findById(devolucaoCreditoRestituicaoDTO.getPessoa().getId()).orElseThrow(() -> new EloValidationException("Pessoa n\u00e3o encontrado."));
        List itens = this.saveItens(devolucaoCreditoRestituicaoDTO, devolucaoCredito);
        BigDecimal valorDevolucao = devolucaoCreditoRestituicaoDTO.getValorDevolucao(devolucaoCreditoRestituicaoDTO);
        devolucaoCredito.setDataInclusao(devolucaoCreditoRestituicaoDTO.getDataInclusao());
        devolucaoCredito.setSituacao(SituacaoDevolucaoCredito.AGUARDANDO);
        devolucaoCredito.setData(devolucaoCreditoRestituicaoDTO.getData());
        devolucaoCredito.setContaBancaria(contaBancaria);
        devolucaoCredito.setMotivoDesconto(motivoDeducao);
        devolucaoCredito.setObservacao(devolucaoCreditoRestituicaoDTO.getObservacao());
        devolucaoCredito.setObsNotificacao(devolucaoCreditoRestituicaoDTO.getObsNotificacao());
        devolucaoCredito.setObsParecer(devolucaoCreditoRestituicaoDTO.getObsParecer());
        devolucaoCredito.setBancoCredito(devolucaoCreditoRestituicaoDTO.getBancoCredito());
        devolucaoCredito.setAgenciaCredito(devolucaoCreditoRestituicaoDTO.getAgenciaCredito());
        devolucaoCredito.setContaCredito(devolucaoCreditoRestituicaoDTO.getContaCredito());
        devolucaoCredito.setContaOperacao(devolucaoCreditoRestituicaoDTO.getContaOperacao());
        devolucaoCredito.setPessoaCredito(pessoa);
        devolucaoCredito.getItens().clear();
        devolucaoCredito.getItens().addAll(itens);
        devolucaoCredito.setValorDevolucao(valorDevolucao);
        devolucaoCredito.setEntidade(devolucaoCreditoRestituicaoDTO.getEntidade());
        devolucaoCredito.setExercicio(devolucaoCreditoRestituicaoDTO.getExercicio());
        devolucaoCredito.setTipo(devolucaoCreditoRestituicaoDTO.getTipo());
        return devolucaoCredito;
    }

    public DevolucaoCredito saveDevolucaoCredito(DevolucaoCreditoRestituicaoResumoDTO devolucaoCreditoRestituicaoDTO) {
        return (DevolucaoCredito)this.devolucaoCreditoRepository.save((Object)this.createDevolucaoCredito(devolucaoCreditoRestituicaoDTO, null));
    }

    public DevolucaoCredito updateDevolucaoCredito(DevolucaoCreditoRestituicaoResumoDTO devolucaoCreditoRestituicaoDTO, Long id) {
        return (DevolucaoCredito)this.devolucaoCreditoRepository.save((Object)this.createDevolucaoCredito(devolucaoCreditoRestituicaoDTO, id));
    }

    public DevolucaoCredito confirmDevolucao(Long id) {
        DevolucaoCredito devolucaoCredito = (DevolucaoCredito)this.devolucaoCreditoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException("Devolu\u00e7\u00e3o cr\u00e9dito n\u00e3o encontrado."));
        if (Objects.isNull(devolucaoCredito.getData())) {
            throw new EloValidationException("\u00c9 preciso adicionar uma data para a restitui\u00e7\u00e3o!");
        }
        if (DateUtils.isVencido((LocalDate)devolucaoCredito.getData()).booleanValue()) {
            throw new EloValidationException("A data de restitui\u00e7\u00e3o deve ser maior que a data de hoje!");
        }
        if (!devolucaoCredito.getSituacao().equals((Object)SituacaoDevolucaoCredito.AGUARDANDO)) {
            throw new EloValidationException("Somente devolu\u00e7\u00f5es com a situa\u00e7\u00e3o aguardando podem ser confirmadas");
        }
        devolucaoCredito.getItens().forEach(item -> item.getDebitos().forEach(debito -> {
            this.updateValorDevolvidoPagamentoDebito(debito);
            this.updateSituacaoParcela(item, debito);
        }));
        devolucaoCredito.setSituacao(SituacaoDevolucaoCredito.DEVOLVIDO);
        this.devolucaoCreditoRepository.save((Object)devolucaoCredito);
        return devolucaoCredito;
    }

    private void updateSituacaoParcela(DevolucaoCreditoItem item, DevolucaoCreditoDebito debito) {
        Boolean validaParcela = this.devolucaoCreditoRepository.confirmDevolucao(debito.getPagamentoBoleto().getId(), item.getPagamento().getId().getEntidade(), item.getPagamento().getId().getExercicioPagamento(), item.getCadastroGeral().getTipoCadastro().getValue(), item.getCadastroGeral().getCadastroGeral(), debito.getDebitoParcelaTributo().getDivida(), debito.getDebitoParcelaTributo().getSubDivida(), debito.getDebitoParcelaTributo().getParcela());
        if (Boolean.TRUE.equals(validaParcela)) {
            DebitoParcela debitoParcela = debito.getDebitoParcelaTributo().getDebitoParcela();
            debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.ESTORNO_PAGAMENTO, debitoParcela.getSituacaoDebito()));
            debitoParcela.setDataSituacao(LocalDate.now());
            this.debitoParcelaService.save((EloEntity)debitoParcela, null);
        }
    }

    private void updateValorDevolvidoPagamentoDebito(DevolucaoCreditoDebito debito) {
        List pagamentosDebito = debito.getPagamentoBoleto().getPagamentosDebito().stream().filter(pagamentoDebito -> pagamentoDebito.getId().getDebitoParcelaTributo().equals((Object)debito.getDebitoParcelaTributo())).map(pagamentoDebito -> {
            pagamentoDebito.setValorDevolvido(pagamentoDebito.getValorDevolvido().add(debito.getValorDevolvido()));
            return pagamentoDebito;
        }).collect(Collectors.toList());
        this.pagamentoDebitoRepository.saveAll(pagamentosDebito);
    }
}

