/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.TributoDTO;
import br.com.elotech.tributos.dto.dividaativa.DividaAtivaBoletoDebitoDTO;
import br.com.elotech.tributos.params.DebitoFilterParams;
import br.com.elotech.tributos.params.DebitoTributosPorcentagemParams;
import br.com.elotech.tributos.repository.DebitoParcelaTributoRepository;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Service;

@Service
public class DebitoParcelaTributoService
extends CrudService<DebitoParcelaTributo, Long> {
    private static final Integer TODAS_SITUACOES_LEGAL = 3;
    private final DebitoParcelaTributoRepository debitoParcelaTributoRepository;
    private final NamedParameterJdbcTemplate namedParameterJdbcTemplate;

    public DebitoParcelaTributoService(DebitoParcelaTributoRepository debitoParcelaTributoRepository, NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.debitoParcelaTributoRepository = debitoParcelaTributoRepository;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public List<DebitoParcelaTributo> findByDebitoParcelaDebitoIdAndTributo(Long id, String tributo) {
        return this.debitoParcelaTributoRepository.findByDebitoParcelaDebitoIdAndTributo(id, tributo);
    }

    public List<CancelamentoDebitoTributoDTO> findByDebitoAndAberto(DebitoFilterParams debito, Integer situacaoLegal) {
        return this.debitoParcelaTributoRepository.findByDebitoAndAberto(debito, this.getSituacaoLegal(situacaoLegal));
    }

    public List<TributoDTO> getDebitoTributoDescricao(DebitoFilterParams params, Integer situacaoLegal) {
        return this.debitoParcelaTributoRepository.findDebitoDescricao(params, this.getSituacaoLegal(situacaoLegal));
    }

    public List<CancelamentoDebitoTributoDTO> getDebitoParcelaTributoCancelamento(DebitoTributosPorcentagemParams params) {
        List situacoesLegais = this.getSituacaoLegal(params.getSituacaoLegal());
        ArrayList debitoParcelaTributoCancelamento = new ArrayList();
        params.getTributos().forEach(tributo -> debitoParcelaTributoCancelamento.addAll(this.debitoParcelaTributoRepository.findDebitoParcelaTributoCancelamento(params.getDebitoFilters(), tributo, situacoesLegais)));
        Comparator<CancelamentoDebitoTributoDTO> comparator = Comparator.comparing(CancelamentoDebitoTributoDTO::getEntidade).thenComparing(CancelamentoDebitoTributoDTO::getExercicio).thenComparing(CancelamentoDebitoTributoDTO::getTipoCadastro).thenComparing(CancelamentoDebitoTributoDTO::getCadastroGeral).thenComparing(CancelamentoDebitoTributoDTO::getDivida).thenComparing(CancelamentoDebitoTributoDTO::getSubDivida).thenComparing(CancelamentoDebitoTributoDTO::getParcela).thenComparing(CancelamentoDebitoTributoDTO::getTributo);
        return debitoParcelaTributoCancelamento.stream().sorted(comparator).collect(Collectors.toList());
    }

    private List<Integer> getSituacaoLegal(Integer situacaoLegal) {
        if (TODAS_SITUACOES_LEGAL.equals(situacaoLegal)) {
            return Arrays.asList(SituacaoLegal.NO_EXERCICIO.getValue(), SituacaoLegal.DIVIDA_ATIVA.getValue(), SituacaoLegal.JUIZO.getValue());
        }
        return Arrays.asList(situacaoLegal);
    }

    public List<DebitoParcelaTributo> saveAll(List<DebitoParcelaTributo> entities) {
        return this.debitoParcelaTributoRepository.saveAll(entities);
    }

    public List<DebitoParcelaTributo> findByIds(List<Long> ids) {
        return this.debitoParcelaTributoRepository.findAllById(ids);
    }

    public List<DividaAtivaBoletoDebitoDTO> findBoletosNaoVencidosDividaAtiva(Long exercicio, Long entidade, Long tipoDocumento, Long documento, LocalDate data) {
        String sql = " SELECT TDPR.EXERCICIO as exercicio,              TDPR.TIPOCADASTRO as tipoCadastro,              TDPR.CADASTROGERAL as cadastroGeral,              TDPR.GUIARECOLHIMENTO as guiaRecolhimento,              TDPR.SUBDIVIDA as subdivida,              TDPR.PARCELA as parcela,              TB.BLOQUETO as bloqueto,              TB.DATAVENCIMENTO as dataVencimento       FROM TRIBDEBITOPARCELARECEITA TDPR            INNER JOIN TRIBBLOQUETODEBITO TBD ON TBD.IDDEBITOPARCELARECEITA = TDPR.IDDEBITOPARCELARECEITA             INNER JOIN TRIBBLOQUETO TB ON TB.ENTIDADE = TBD.ENTIDADE AND TB.EXERCICIOBLOQUETO = TBD.EXERCICIOBLOQUETO                                            AND TB.BLOQUETO = TBD.BLOQUETO            INNER JOIN TRIBDOCUMENTOITEMDIVIDAATIVA IDA ON IDA.ENTIDADE = TDPR.ENTIDADE AND IDA.EXERCICIODEBITO = TDPR.EXERCICIO                                                            AND IDA.TIPOCADASTRO = TDPR.TIPOCADASTRO AND IDA.CADASTROGERAL = TDPR.CADASTROGERAL                                                            AND IDA.GUIARECOLHIMENTO = TDPR.GUIARECOLHIMENTO AND IDA.RECEITA = TDPR.RECEITA                                                            AND IDA.SUBDIVIDA = TDPR.SUBDIVIDA            INNER JOIN TRIBDOCUMENTO DOC ON DOC.ENTIDADE = IDA.ENTIDADE AND DOC.EXERCICIO = IDA.EXERCICIO                                            AND DOC.TIPODOCUMENTO = IDA.TIPODOCUMENTO AND DOC.DOCUMENTO = IDA.DOCUMENTO  WHERE TB.DATAVENCIMENTO >= :data    AND DOC.ENTIDADE = :entidade    AND DOC.EXERCICIO = :exercicio    AND DOC.TIPODOCUMENTO = :tipodocumento    AND DOC.DOCUMENTO = :documento ";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("data", (Object)data);
        params.addValue("entidade", (Object)entidade);
        params.addValue("exercicio", (Object)exercicio);
        params.addValue("tipodocumento", (Object)tipoDocumento);
        params.addValue("documento", (Object)documento);
        return this.namedParameterJdbcTemplate.query(sql, (SqlParameterSource)params, (RowMapper)new ElotechBeanPropertyRowMapper(DividaAtivaBoletoDebitoDTO.class));
    }
}

