/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoCertidaoDebitos;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.dto.integracaowebiss.WebIssResponseDTO;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.RastreamentoService;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.validation.Valid;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import lombok.Generated;
import org.openl.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Transactional
public class CertidaoDebitosService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertidaoDebitosService.class);
    private final RastreamentoService rastreamentoService;
    private final DocumentoService documentoService;
    private final ParametroGeralService parametroGeralService;
    private final CadastroGeralService cadastroGeralService;
    private final RestTemplate restTemplate;
    private final PessoaService pessoaService;

    public DocumentoDTO geraCertidaoPorContribuinte(@Valid DocumentoGenericoDTO documentoGenericoDTO) {
        documentoGenericoDTO.setPorCadastro(Boolean.FALSE);
        Set rastreamentoCadastroDTOS = this.rastreamentoService.porContribuinte(documentoGenericoDTO.getCodigoPessoa());
        documentoGenericoDTO.setSubTipo(this.getTipoCertidaoDebitos(rastreamentoCadastroDTOS, documentoGenericoDTO.getCertidaoEspecial()).getValue());
        this.validateGeracaoDocumentoWebIss(documentoGenericoDTO);
        return this.documentoService.gerar(documentoGenericoDTO, TipoDocumentoEnum.CERTIDAO_CONTRIBUINTE);
    }

    public DocumentoDTO geraCertidaoPorCadastro(@Valid DocumentoGenericoDTO documentoGenericoDTO) {
        Set rastreamentoCadastroDTOS = this.rastreamentoService.porCadastro(documentoGenericoDTO.getIdCadastro());
        documentoGenericoDTO.setSubTipo(this.getTipoCertidaoDebitos(rastreamentoCadastroDTOS, documentoGenericoDTO.getCertidaoEspecial()).getValue());
        this.validateGeracaoDocumentoWebIss(documentoGenericoDTO);
        return this.documentoService.gerar(documentoGenericoDTO, TipoDocumentoEnum.CERTIDAO_CADASTRO_MUNICIPAL);
    }

    private TipoCertidaoDebitos getTipoCertidaoDebitos(Set<RastreamentoCadastroDTO> rastreamentoCadastroDTOS, Boolean certidaoEspecial) {
        if (certidaoEspecial.booleanValue()) {
            return this.getTipoCertidaoDebitosByCertidaoCndQdoSemContrato();
        }
        return RastreamentoCadastroDTO.getTipoCertidaoDebitos(rastreamentoCadastroDTOS);
    }

    private TipoCertidaoDebitos getTipoCertidaoDebitosByCertidaoCndQdoSemContrato() {
        if (this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CERTIDAO_CND_QDO_SEM_CONTRATO).booleanValue()) {
            return TipoCertidaoDebitos.NEGATIVA;
        }
        return TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA;
    }

    private void validateGeracaoDocumentoWebIss(DocumentoGenericoDTO documentoGenericoDTO) {
        if (TipoCertidaoDebitos.NEGATIVA.getValue().equals(documentoGenericoDTO.getSubTipo()) || TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA.getValue().equals(documentoGenericoDTO.getSubTipo())) {
            String enderecoIntegracao = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.ENDERECO_INTEGRACAO_WEB_ISS, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            String empresaIss = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.EMPRESA_ISS, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (StringUtils.isBlank((CharSequence)enderecoIntegracao) || StringUtils.isBlank((CharSequence)empresaIss)) {
                return;
            }
            if (Objects.nonNull(documentoGenericoDTO.getIdCadastro())) {
                this.consultaWebIssPorCadastro(documentoGenericoDTO, enderecoIntegracao, empresaIss);
            } else {
                this.consultaWebIssPorContribuinte(documentoGenericoDTO, enderecoIntegracao, empresaIss);
            }
        }
    }

    private void consultaWebIssPorContribuinte(DocumentoGenericoDTO documentoGenericoDTO, String enderecoIntegracao, String empresaIss) {
        Pessoa pessoa = (Pessoa)this.pessoaService.findById(documentoGenericoDTO.getCodigoPessoa()).orElseThrow(() -> new EloValidationException("Pessoa n\u00e3o encontrada"));
        if (TipoPessoa.JURIDICA.equals((Object)pessoa.getTipoPessoa())) {
            WebIssResponseDTO webIssResponseDTO = this.consultaSituacaoWebIss(enderecoIntegracao, empresaIss, pessoa.getCnpjCpfSemMascara());
            this.validateResponseWebIss(webIssResponseDTO, documentoGenericoDTO);
        }
    }

    private void consultaWebIssPorCadastro(DocumentoGenericoDTO documentoGenericoDTO, String enderecoIntegracao, String empresaIss) {
        CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findById((Serializable)documentoGenericoDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException("Cadastro n\u00e3o encontrado"));
        if (!TipoCadastro.MOBILIARIO.equals((Object)cadastroGeral.getTipoCadastro())) {
            return;
        }
        String cnpj = Optional.ofNullable(cadastroGeral.getPessoa()).map(Pessoa::getCnpjCpfSemMascara).orElseThrow(() -> new EloValidationException("CNPJ n\u00e3o encontrado para o cadastro informado"));
        WebIssResponseDTO webIssResponseDTO = this.consultaSituacaoWebIss(enderecoIntegracao, empresaIss, cnpj);
        this.validateResponseWebIss(webIssResponseDTO, documentoGenericoDTO);
    }

    private void validateResponseWebIss(WebIssResponseDTO webIssResponseDTO, DocumentoGenericoDTO documentoGenericoDTO) {
        if (Objects.nonNull(webIssResponseDTO) && TipoCertidaoDebitos.POSITIVA.equals((Object)webIssResponseDTO.getTipoCertidaoDebitos())) {
            documentoGenericoDTO.setSubTipo(TipoCertidaoDebitos.POSITIVA.getValue());
        }
    }

    private WebIssResponseDTO consultaSituacaoWebIss(String enderecoIntegracao, String empresaIss, String cnpj) {
        String urlCompleta = String.format("https://%s.%s.com.br/ws/integracao/consulta-certidao-negativa/%s", enderecoIntegracao, empresaIss, cnpj);
        String auth = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.CODIGO_AUTORIZACAO_WEBISS, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        ResponseEntity response = this.restTemplate.exchange(urlCompleta, HttpMethod.GET, this.createHttpEntity(auth), String.class, new Object[0]);
        return this.unmarshalRetornoConsulta((String)response.getBody());
    }

    private <T> HttpEntity<T> createHttpEntity(String auth) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("autenticacao", auth);
        return new HttpEntity((MultiValueMap)headers);
    }

    private WebIssResponseDTO unmarshalRetornoConsulta(String xmlRetorno) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{WebIssResponseDTO.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (WebIssResponseDTO)unmarshaller.unmarshal((Reader)new StringReader(xmlRetorno));
        }
        catch (JAXBException e) {
            log.error("Erro ao fazer unmarshal do xml de retorno da consulta WebISS", (Throwable)e);
            return null;
        }
    }

    @Generated
    public CertidaoDebitosService(RastreamentoService rastreamentoService, DocumentoService documentoService, ParametroGeralService parametroGeralService, CadastroGeralService cadastroGeralService, RestTemplate restTemplate, PessoaService pessoaService) {
        this.rastreamentoService = rastreamentoService;
        this.documentoService = documentoService;
        this.parametroGeralService = parametroGeralService;
        this.cadastroGeralService = cadastroGeralService;
        this.restTemplate = restTemplate;
        this.pessoaService = pessoaService;
    }
}

