/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetaria;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.parcelamento.AtualizacaoMonetariaDTO;
import br.com.elotech.tributos.dto.parcelamento.AtualizacaoMonetariaResponseDTO;
import br.com.elotech.tributos.exception.AtualizacaoMonetariaException;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.ws.domain.LoginRespostaRest;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
public class AtualizacaoMonetariaService
extends CrudService<AtualizacaoMonetaria, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AtualizacaoMonetariaService.class);
    private static final String URL_ATUALIZACAO_MONETARIA_AISE = "/datasnap/rest/tatualizacaomonetaria/GerarAtualizacao/";
    private static final Map<NotificationStatus, String> messagesNotificacao = Map.of(NotificationStatus.STARTED, "Iniciado atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento", NotificationStatus.COMPLETED, "Conclu\u00eddo atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento", NotificationStatus.FAILED, "Atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento falhou");
    @Autowired
    private final AiseLoginServiceRest aiseLoginServiceRest;
    @Autowired
    private final RestTemplate restTemplate;
    @Autowired
    private final TributosProperties tributosProperties;
    @Autowired
    private final TarefaAssincronaService tarefaAssincronaService;
    @Autowired
    private final NotificacaoService notificacaoService;

    @Async
    @Transactional
    public void atualizaMonetariamenteParcelamanto(AtualizacaoMonetariaDTO request, UserSecurityDTO user) {
        log.debug("Preparando ambiente atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento com os seguintes dados {}", (Object)request.toString());
        TarefaAssincronaExecucao tarefaEmExecucao = this.startTarefaAssincrona(request);
        Optional idNotificacao = this.notificaInicioTarefaAssincrona(tarefaEmExecucao, user);
        try {
            log.debug("Iniciando atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento");
            Long idReajuste = this.generateAtualizacaoMonetaria(request).getIdreajsute();
            log.debug("Parcelamento atualizado. Reajuste criado: {}", (Object)idReajuste);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.COMPLETED, null);
        }
        catch (Exception e) {
            log.error("Erro ao realizar rotina de atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento.", (Throwable)e);
            this.stopTarefaAssincrona(tarefaEmExecucao, idNotificacao, user, NotificationStatus.FAILED, e);
        }
        log.debug("Finalizado rotina de atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento");
    }

    public AtualizacaoMonetariaResponseDTO generateAtualizacaoMonetaria(AtualizacaoMonetariaDTO atualizacaoMonetariaDTO) {
        HttpHeaders headers = this.createHeaders();
        try {
            return (AtualizacaoMonetariaResponseDTO)this.restTemplate.exchange(this.getUrlAtualizacaoMonetariaAise(), HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)atualizacaoMonetariaDTO, (HttpHeaders)headers), AtualizacaoMonetariaResponseDTO.class, new Object[0]).getBody();
        }
        catch (Exception ex) {
            log.error("{} - {}", new Object[]{"Erro ao gerar atualiza\u00e7\u00e3o monet\u00e1ria", ex.getMessage(), ex});
            throw new AtualizacaoMonetariaException(ex.getMessage());
        }
    }

    private HttpHeaders createHeaders() {
        LoginRespostaRest loginResponse = this.aiseLoginServiceRest.login();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + loginResponse.getIdToken());
        return headers;
    }

    private String getUrlAtualizacaoMonetariaAise() {
        return this.tributosProperties.getAise().getWsBaseUrl() + URL_ATUALIZACAO_MONETARIA_AISE;
    }

    private TarefaAssincronaExecucao startTarefaAssincrona(AtualizacaoMonetariaDTO request) {
        return this.tarefaAssincronaService.createTarefaAssincronaAtualizacaoMonetariaDeParcelamento(request);
    }

    private Optional<UUID> notificaInicioTarefaAssincrona(TarefaAssincronaExecucao execucao, UserSecurityDTO user) {
        return this.notificaCliente(execucao, Optional.empty(), user, NotificationStatus.STARTED);
    }

    private void stopTarefaAssincrona(TarefaAssincronaExecucao execucao, Optional<UUID> idNotificacao, UserSecurityDTO user, NotificationStatus status, Exception exception) {
        if (status.equals((Object)NotificationStatus.FAILED)) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
        } else {
            this.tarefaAssincronaService.finalizarExecucao(execucao);
        }
        this.notificaCliente(execucao, idNotificacao, user, status);
    }

    private Optional<UUID> notificaCliente(TarefaAssincronaExecucao execucao, Optional<UUID> idNotificacao, UserSecurityDTO user, NotificationStatus status) {
        String titulo = "Atualiza\u00e7\u00e3o monet\u00e1ria de parcelamento";
        String message = (String)messagesNotificacao.get(status);
        TarefaAssincrona tarefa = execucao.getTarefaAssincrona();
        return this.notificacaoService.send(titulo, message, tarefa, idNotificacao, user, status);
    }

    @Generated
    public AtualizacaoMonetariaService(AiseLoginServiceRest aiseLoginServiceRest, RestTemplate restTemplate, TributosProperties tributosProperties, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService) {
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.restTemplate = restTemplate;
        this.tributosProperties = tributosProperties;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
    }
}

