/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.integracaogeomais.VinculoGeomaisDTO;
import br.com.elotech.tributos.service.VinculoService;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/vinculo"})
public class VinculoGeomaisResource {
    private final VinculoService vinculoService;

    public VinculoGeomaisResource(VinculoService vinculoService) {
        this.vinculoService = vinculoService;
    }

    @ApiOperation(value="Retorna um lista de v\u00ednculos dos propriet\u00e1rios")
    @GetMapping
    public ResponseEntity<Page<VinculoGeomaisDTO>> findAll(Pageable page) {
        Page vinculos = this.vinculoService.findAll(page).map(VinculoGeomaisDTO::from);
        return ResponseEntity.ok((Object)vinculos);
    }

    @ApiOperation(value="Retorna um v\u00ednculo dos propriet\u00e1rios em espec\u00edfico")
    @GetMapping(value={"/{id}"})
    public ResponseEntity<VinculoGeomaisDTO> findById(@PathVariable Long id) {
        VinculoGeomaisDTO vinculoGeomaisDTO = this.vinculoService.findById((Serializable)id).map(VinculoGeomaisDTO::from).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o V\u00ednculo com o id '%d'.", id)));
        return ResponseEntity.ok((Object)vinculoGeomaisDTO);
    }
}

