/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.documento;

import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.documento.CertidaoIsencaoService;
import javax.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/certidao-isencao"})
@RestController
public class CertidaoIsencaoResource {
    private final CertidaoIsencaoService certidaoIsencaoService;
    private final DocumentoService documentoService;

    @PostMapping(value={"/valores-iniciais"})
    public ResponseEntity<DocumentoGenericoDTO> getInitialValues(@RequestBody DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return ResponseEntity.ok((Object)this.certidaoIsencaoService.getInitialValues(documentoSearchInitialValuesDTO));
    }

    @PostMapping
    public ResponseEntity<ImpressaoDTO> save(@RequestBody @Valid DocumentoGenericoDTO geracaoDocumentoDto) {
        DocumentoDTO dto = this.certidaoIsencaoService.save(geracaoDocumentoDto);
        dto.setUrl(this.documentoService.fetchDocumento(dto, geracaoDocumentoDto.getRelatorioImpressao()));
        return ResponseEntity.ok((Object)ImpressaoDTO.from((Long)dto.getId(), (String)dto.getUrl()));
    }

    @Generated
    public CertidaoIsencaoResource(CertidaoIsencaoService certidaoIsencaoService, DocumentoService documentoService) {
        this.certidaoIsencaoService = certidaoIsencaoService;
        this.documentoService = documentoService;
    }
}

