/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.devolucaocredito;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.devolucaocredito.DevolucaoCreditoItem;
import java.math.BigDecimal;
import java.util.Optional;
import lombok.Generated;

public class DevolucaoCreditoItemDTO {
    private Long sequenciaItem;
    private TipoCadastro tipoCadastro;
    private Long entidade;
    private String nomeCadastro;
    private Long cadastroGeral;
    private Long creditoContribuinte;
    private Long exercicioCreditoContribuinte;
    private Long pagamento;
    private Long exercicioPagamento;
    private BigDecimal valorDevolucao;
    private BigDecimal valorCorrecao;
    private BigDecimal valorCorrigido;

    public static DevolucaoCreditoItemDTO from(DevolucaoCreditoItem devolucaoCreditoItem) {
        DevolucaoCreditoItemDTO devolucaoCreditoItemDTO = new DevolucaoCreditoItemDTO();
        Optional.ofNullable(devolucaoCreditoItem.getCadastroGeral()).ifPresent(cadastro -> {
            devolucaoCreditoItemDTO.setTipoCadastro(cadastro.getTipoCadastro());
            devolucaoCreditoItemDTO.setCadastroGeral(cadastro.getCadastroGeral());
            devolucaoCreditoItemDTO.setNomeCadastro(cadastro.getPessoa().getNome());
        });
        Optional.ofNullable(devolucaoCreditoItem.getCreditoContribuinte()).ifPresent(credito -> {
            devolucaoCreditoItemDTO.setCreditoContribuinte(credito.getId().getCreditoContribuinte());
            devolucaoCreditoItemDTO.setExercicioCreditoContribuinte(credito.getId().getExercicio());
        });
        Optional.ofNullable(devolucaoCreditoItem.getPagamento()).ifPresent(pagamento -> {
            devolucaoCreditoItemDTO.setPagamento(pagamento.getId().getPagamento());
            devolucaoCreditoItemDTO.setExercicioPagamento(pagamento.getId().getExercicioPagamento());
        });
        devolucaoCreditoItemDTO.setEntidade(devolucaoCreditoItem.getEntidade());
        devolucaoCreditoItemDTO.setValorDevolucao(devolucaoCreditoItem.getValorDevolucao());
        devolucaoCreditoItemDTO.setValorCorrecao(devolucaoCreditoItem.getValorCorrecao());
        devolucaoCreditoItemDTO.setValorCorrigido(devolucaoCreditoItem.getValorCorrigido());
        devolucaoCreditoItemDTO.setSequenciaItem(devolucaoCreditoItem.getId().getSequenciaItem());
        return devolucaoCreditoItemDTO;
    }

    public static DevolucaoCreditoItemDTO from(Pagamento pagamento) {
        DevolucaoCreditoItemDTO devolucao = new DevolucaoCreditoItemDTO();
        devolucao.setPagamento(pagamento.getId().getPagamento());
        devolucao.setCadastroGeral(pagamento.getPagamentoBoleto().getBoleto().getCadastroGeral().getCadastroGeral());
        devolucao.setTipoCadastro(pagamento.getPagamentoBoleto().getBoleto().getCadastroGeral().getTipoCadastro());
        devolucao.setValorDevolucao(pagamento.getValorPago());
        devolucao.setEntidade(pagamento.getId().getEntidade());
        devolucao.setValorCorrecao(BigDecimal.ZERO);
        devolucao.setValorCorrigido(pagamento.getValorPago());
        devolucao.setExercicioPagamento(pagamento.getId().getExercicioPagamento());
        devolucao.setNomeCadastro(pagamento.getPagamentoBoleto().getBoleto().getCadastroGeral().getPessoa().getNome());
        return devolucao;
    }

    public DevolucaoCreditoItemDTO getPagamentoItem(Pagamento pagamento, CadastroGeral cadastroGeral, Long tipoCadastro, Long entidade) {
        DevolucaoCreditoItemDTO item = new DevolucaoCreditoItemDTO();
        item.setPagamento(pagamento.getId().getPagamento());
        item.setCadastroGeral(cadastroGeral.getCadastroGeral());
        item.setTipoCadastro(TipoCadastro.fromValue((Long)tipoCadastro));
        item.setValorDevolucao(pagamento.getValorPago());
        item.setEntidade(entidade);
        item.setValorCorrecao(BigDecimal.ZERO);
        item.setValorCorrigido(pagamento.getValorPago());
        item.setExercicioPagamento(pagamento.getId().getExercicioPagamento());
        item.setNomeCadastro(cadastroGeral.getPessoa().getNome());
        return item;
    }

    @Generated
    public DevolucaoCreditoItemDTO() {
    }

    @Generated
    public Long getSequenciaItem() {
        return this.sequenciaItem;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public String getNomeCadastro() {
        return this.nomeCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getCreditoContribuinte() {
        return this.creditoContribuinte;
    }

    @Generated
    public Long getExercicioCreditoContribuinte() {
        return this.exercicioCreditoContribuinte;
    }

    @Generated
    public Long getPagamento() {
        return this.pagamento;
    }

    @Generated
    public Long getExercicioPagamento() {
        return this.exercicioPagamento;
    }

    @Generated
    public BigDecimal getValorDevolucao() {
        return this.valorDevolucao;
    }

    @Generated
    public BigDecimal getValorCorrecao() {
        return this.valorCorrecao;
    }

    @Generated
    public BigDecimal getValorCorrigido() {
        return this.valorCorrigido;
    }

    @Generated
    public void setSequenciaItem(Long sequenciaItem) {
        this.sequenciaItem = sequenciaItem;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setNomeCadastro(String nomeCadastro) {
        this.nomeCadastro = nomeCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setCreditoContribuinte(Long creditoContribuinte) {
        this.creditoContribuinte = creditoContribuinte;
    }

    @Generated
    public void setExercicioCreditoContribuinte(Long exercicioCreditoContribuinte) {
        this.exercicioCreditoContribuinte = exercicioCreditoContribuinte;
    }

    @Generated
    public void setPagamento(Long pagamento) {
        this.pagamento = pagamento;
    }

    @Generated
    public void setExercicioPagamento(Long exercicioPagamento) {
        this.exercicioPagamento = exercicioPagamento;
    }

    @Generated
    public void setValorDevolucao(BigDecimal valorDevolucao) {
        this.valorDevolucao = valorDevolucao;
    }

    @Generated
    public void setValorCorrecao(BigDecimal valorCorrecao) {
        this.valorCorrecao = valorCorrecao;
    }

    @Generated
    public void setValorCorrigido(BigDecimal valorCorrigido) {
        this.valorCorrigido = valorCorrigido;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DevolucaoCreditoItemDTO)) {
            return false;
        }
        DevolucaoCreditoItemDTO other = (DevolucaoCreditoItemDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$sequenciaItem = this.getSequenciaItem();
        Long other$sequenciaItem = other.getSequenciaItem();
        if (this$sequenciaItem == null ? other$sequenciaItem != null : !((Object)this$sequenciaItem).equals(other$sequenciaItem)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$creditoContribuinte = this.getCreditoContribuinte();
        Long other$creditoContribuinte = other.getCreditoContribuinte();
        if (this$creditoContribuinte == null ? other$creditoContribuinte != null : !((Object)this$creditoContribuinte).equals(other$creditoContribuinte)) {
            return false;
        }
        Long this$exercicioCreditoContribuinte = this.getExercicioCreditoContribuinte();
        Long other$exercicioCreditoContribuinte = other.getExercicioCreditoContribuinte();
        if (this$exercicioCreditoContribuinte == null ? other$exercicioCreditoContribuinte != null : !((Object)this$exercicioCreditoContribuinte).equals(other$exercicioCreditoContribuinte)) {
            return false;
        }
        Long this$pagamento = this.getPagamento();
        Long other$pagamento = other.getPagamento();
        if (this$pagamento == null ? other$pagamento != null : !((Object)this$pagamento).equals(other$pagamento)) {
            return false;
        }
        Long this$exercicioPagamento = this.getExercicioPagamento();
        Long other$exercicioPagamento = other.getExercicioPagamento();
        if (this$exercicioPagamento == null ? other$exercicioPagamento != null : !((Object)this$exercicioPagamento).equals(other$exercicioPagamento)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$nomeCadastro = this.getNomeCadastro();
        String other$nomeCadastro = other.getNomeCadastro();
        if (this$nomeCadastro == null ? other$nomeCadastro != null : !this$nomeCadastro.equals(other$nomeCadastro)) {
            return false;
        }
        BigDecimal this$valorDevolucao = this.getValorDevolucao();
        BigDecimal other$valorDevolucao = other.getValorDevolucao();
        if (this$valorDevolucao == null ? other$valorDevolucao != null : !((Object)this$valorDevolucao).equals(other$valorDevolucao)) {
            return false;
        }
        BigDecimal this$valorCorrecao = this.getValorCorrecao();
        BigDecimal other$valorCorrecao = other.getValorCorrecao();
        if (this$valorCorrecao == null ? other$valorCorrecao != null : !((Object)this$valorCorrecao).equals(other$valorCorrecao)) {
            return false;
        }
        BigDecimal this$valorCorrigido = this.getValorCorrigido();
        BigDecimal other$valorCorrigido = other.getValorCorrigido();
        return !(this$valorCorrigido == null ? other$valorCorrigido != null : !((Object)this$valorCorrigido).equals(other$valorCorrigido));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DevolucaoCreditoItemDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $sequenciaItem = this.getSequenciaItem();
        result = result * 59 + ($sequenciaItem == null ? 43 : ((Object)$sequenciaItem).hashCode());
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $creditoContribuinte = this.getCreditoContribuinte();
        result = result * 59 + ($creditoContribuinte == null ? 43 : ((Object)$creditoContribuinte).hashCode());
        Long $exercicioCreditoContribuinte = this.getExercicioCreditoContribuinte();
        result = result * 59 + ($exercicioCreditoContribuinte == null ? 43 : ((Object)$exercicioCreditoContribuinte).hashCode());
        Long $pagamento = this.getPagamento();
        result = result * 59 + ($pagamento == null ? 43 : ((Object)$pagamento).hashCode());
        Long $exercicioPagamento = this.getExercicioPagamento();
        result = result * 59 + ($exercicioPagamento == null ? 43 : ((Object)$exercicioPagamento).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $nomeCadastro = this.getNomeCadastro();
        result = result * 59 + ($nomeCadastro == null ? 43 : $nomeCadastro.hashCode());
        BigDecimal $valorDevolucao = this.getValorDevolucao();
        result = result * 59 + ($valorDevolucao == null ? 43 : ((Object)$valorDevolucao).hashCode());
        BigDecimal $valorCorrecao = this.getValorCorrecao();
        result = result * 59 + ($valorCorrecao == null ? 43 : ((Object)$valorCorrecao).hashCode());
        BigDecimal $valorCorrigido = this.getValorCorrigido();
        result = result * 59 + ($valorCorrigido == null ? 43 : ((Object)$valorCorrigido).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DevolucaoCreditoItemDTO(sequenciaItem=" + this.getSequenciaItem() + ", tipoCadastro=" + this.getTipoCadastro() + ", entidade=" + this.getEntidade() + ", nomeCadastro=" + this.getNomeCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", creditoContribuinte=" + this.getCreditoContribuinte() + ", exercicioCreditoContribuinte=" + this.getExercicioCreditoContribuinte() + ", pagamento=" + this.getPagamento() + ", exercicioPagamento=" + this.getExercicioPagamento() + ", valorDevolucao=" + this.getValorDevolucao() + ", valorCorrecao=" + this.getValorCorrecao() + ", valorCorrigido=" + this.getValorCorrigido() + ")";
    }
}

