/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.CategoriaMobiliario;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.ClassificacaoMobiliario;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Loteamento;
import br.com.elotech.tributos.domain.NaturezaJuridica;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.PessoaMobiliario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoEnderecoCorrespondencia;
import br.com.elotech.tributos.domain.Veiculo;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaMobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioAtividade;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioCbo;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioCnae;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioHorarioEspecial;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioVeiculo;
import br.com.elotech.tributos.domain.mobiliario.RegimeFiscalPeriodo;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.BairroDTO;
import br.com.elotech.tributos.dto.CadastroRuralDTO;
import br.com.elotech.tributos.dto.CidadeDTO;
import br.com.elotech.tributos.dto.LogradouroDTO;
import br.com.elotech.tributos.dto.RegimeFiscalPeriodoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.CadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.LoteamentoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.ObservacaoDTO;
import br.com.elotech.tributos.dto.cadastroimobiliario.PessoaDTO;
import br.com.elotech.tributos.dto.camposdinamicos.GrupoRespostasDTO;
import br.com.elotech.tributos.dto.sanepar.SaneparMatriculaDTO;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonIgnoreProperties(ignoreUnknown=true)
public class CadastroMobiliarioDTO {
    private Long id;
    private TipoCadastro tipoCadastro = TipoCadastro.MOBILIARIO;
    private Long cadastroGeral;
    private String numeroRegistro;
    @NotNull(message="\u00c9 necess\u00e1rio informar uma empresa.")
    private @NotNull(message="\u00c9 necess\u00e1rio informar uma empresa.") PessoaDTO pessoa;
    private String atividadePrincipal;
    private CadastroImobiliarioDTO cadastroImobiliario;
    private CadastroRuralDTO cadastroRural;
    @NotNull(message="Cidade \u00e9 obrigat\u00f3ria.")
    private @NotNull(message="Cidade \u00e9 obrigat\u00f3ria.") CidadeDTO cidade;
    @NotNull(message="Logradouro \u00e9 obrigat\u00f3rio.")
    private @NotNull(message="Logradouro \u00e9 obrigat\u00f3rio.") LogradouroDTO logradouro;
    @NotEmpty(message="N\u00famero \u00e9 obrigat\u00f3rio.")
    private @NotEmpty(message="N\u00famero \u00e9 obrigat\u00f3rio.") String numero;
    @NotNull(message="Cep \u00e9 obrigat\u00f3rio.")
    private @NotNull(message="Cep \u00e9 obrigat\u00f3rio.") Long cep;
    private LoteamentoDTO loteamento;
    @NotNull(message="Bairro \u00e9 obrigat\u00f3rio.")
    private @NotNull(message="Bairro \u00e9 obrigat\u00f3rio.") BairroDTO bairro;
    private String complemento;
    private String telefone;
    private Long situacaoMobiliario;
    private String situacaoMobiliarioDescricao;
    private LocalDate dataInclusao;
    private LocalDate dataAlteracao;
    private String usuario;
    private Long exercicioAlvara;
    private Long numeroAlvara;
    private LocalDate dataAlvara;
    private LocalDate dataValidadeAlvara;
    @NotNull(message="Data de Abertura \u00e9 obrigat\u00f3ria.")
    private @NotNull(message="Data de Abertura \u00e9 obrigat\u00f3ria.") LocalDate dataAbertura;
    private Long exercicioProcessoAbertura;
    private Long idProcessoAbertura;
    @NotNull(message="Tipo Pessoa \u00e9 obrigat\u00f3rio.")
    private @NotNull(message="Tipo Pessoa \u00e9 obrigat\u00f3rio.") PessoaMobiliario pessoaMobiliario;
    private CadastroMobiliarioDTO cmcResponsavel;
    private String observacaoAlvara;
    private NaturezaJuridica naturezaJuridica;
    private ClassificacaoMobiliario classificacaoMobiliario;
    private CategoriaMobiliario categoriaMobiliario;
    private Boolean microEmpresa = Boolean.FALSE;
    private Boolean dispensaNotaFiscal = Boolean.FALSE;
    private Boolean substituicaoTributaria = Boolean.FALSE;
    private Boolean visivelNfse = Boolean.FALSE;
    private Boolean utilizaCupomFiscal = Boolean.FALSE;
    private LocalDate dataAuditoriaInicio;
    private LocalDate dataAuditoriaFim;
    private LocalDate dataHomologacao;
    private BigDecimal areaUtilizada;
    private BigDecimal areaConstruida;
    private BigDecimal areaBombeiro;
    private BigDecimal areaPublicidade1;
    private BigDecimal areaPublicidade2;
    private BigDecimal areaPatio;
    private Long qtdeFuncionario;
    private List<CadastroMobiliarioAtividade> cadastroMobiliarioAtividades = new ArrayList();
    private List<CadastroMobiliarioHorarioEspecial> cadastroMobiliarioHorariosEspeciais = new ArrayList();
    private List<ObservacaoDTO> observacoes = new ArrayList();
    private List<CadastroMobiliarioCnae> cadastroMobiliarioCnaes = new ArrayList();
    private List<Veiculo> veiculos = new ArrayList();
    private List<RegimeFiscalPeriodoDTO> regimeFiscalPeriodo = new ArrayList();
    private List<GrupoRespostasDTO> respostasMobiliario = new ArrayList();
    private String cepCorrespondencia;
    private String enderecoCorrespondencia;
    private String numeroCorrespondencia;
    private String complementoCorrespondencia;
    private String bairroCorrespondencia;
    private String cidadeUfCorrespondencia;
    private String ufCorrespondencia;
    private TipoEnderecoCorrespondencia tipoEnderecoCorrespondencia;
    private List<SaneparMatriculaDTO> convenioSaneparMatriculas = new ArrayList();
    private List<CadastroMobiliarioCbo> cadastroMobiliarioCbos = new ArrayList();
    private BigDecimal valorIssEstimado;
    private String protocolo;

    public static CadastroMobiliarioDTO from(CadastroMobiliario cadastro) {
        CadastroMobiliarioDTO dto = new CadastroMobiliarioDTO();
        dto.setId(cadastro.getId());
        Optional.ofNullable(cadastro.getCadastroGeral()).ifPresent(arg_0 -> dto.setCadastroGeral(arg_0));
        Optional.ofNullable(cadastro.getPessoa()).ifPresent(pessoa -> dto.setPessoa(PessoaDTO.from((Pessoa)pessoa)));
        Optional.ofNullable(cadastro.getNumeroRegistro()).ifPresent(arg_0 -> dto.setNumeroRegistro(arg_0));
        Optional.ofNullable(cadastro.getAtividadePrincipal()).ifPresent(arg_0 -> dto.setAtividadePrincipal(arg_0));
        if (Objects.nonNull(cadastro.getCadastroImobiliario())) {
            CadastroImobiliarioDTO cadastroImobiliarioDTO = new CadastroImobiliarioDTO();
            cadastroImobiliarioDTO.setId(cadastro.getCadastroImobiliario().getId());
            cadastroImobiliarioDTO.setTipoCadastro(cadastro.getCadastroImobiliario().getTipoCadastro());
            cadastroImobiliarioDTO.setCadastroGeral(cadastro.getCadastroImobiliario().getCadastroGeral());
            dto.setCadastroImobiliario(cadastroImobiliarioDTO);
            Optional.ofNullable(cadastro.getCadastroImobiliario().getLoteamento()).ifPresent(loteamento -> dto.setLoteamento(LoteamentoDTO.from((Loteamento)loteamento)));
        }
        if (Objects.nonNull(cadastro.getCadastroRural())) {
            CadastroRuralDTO cadastroRuralDTO = new CadastroRuralDTO();
            cadastroRuralDTO.setId(cadastro.getCadastroRural().getId());
            cadastroRuralDTO.setTipoCadastro(cadastro.getCadastroRural().getTipoCadastro());
            cadastroRuralDTO.setCadastroGeral(cadastro.getCadastroRural().getCadastroGeral());
            dto.setCadastroRural(cadastroRuralDTO);
        }
        Optional.ofNullable(cadastro.getCidade()).ifPresent(cidade -> dto.setCidade(CidadeDTO.from((Cidade)cidade)));
        Optional.ofNullable(cadastro.getLogradouro()).ifPresent(logradouro -> dto.setLogradouro(LogradouroDTO.from((Logradouro)logradouro)));
        Optional.ofNullable(cadastro.getNumero()).ifPresent(arg_0 -> dto.setNumero(arg_0));
        Optional.ofNullable(cadastro.getCep()).ifPresent(arg_0 -> dto.setCep(arg_0));
        Optional.ofNullable(cadastro.getBairro()).ifPresent(bairro -> dto.setBairro(BairroDTO.from((Bairro)bairro)));
        Optional.ofNullable(cadastro.getComplemento()).ifPresent(arg_0 -> dto.setComplemento(arg_0));
        Optional.ofNullable(cadastro.getTelefone()).ifPresent(arg_0 -> dto.setTelefone(arg_0));
        Optional.ofNullable(cadastro.getSituacaoAtual()).ifPresent(situacao -> {
            dto.setSituacaoMobiliario(situacao.getId());
            dto.setSituacaoMobiliarioDescricao(situacao.getDescricao());
        });
        Optional.ofNullable(cadastro.getDataInclusao()).ifPresent(arg_0 -> dto.setDataInclusao(arg_0));
        Optional.ofNullable(cadastro.getDataAlteracao()).ifPresent(arg_0 -> dto.setDataAlteracao(arg_0));
        Optional.ofNullable(cadastro.getUsuario()).ifPresent(arg_0 -> dto.setUsuario(arg_0));
        Optional.ofNullable(cadastro.getExercicioAlvara()).ifPresent(arg_0 -> dto.setExercicioAlvara(arg_0));
        Optional.ofNullable(cadastro.getNumeroAlvara()).ifPresent(arg_0 -> dto.setNumeroAlvara(arg_0));
        Optional.ofNullable(cadastro.getDataAlvara()).ifPresent(arg_0 -> dto.setDataAlvara(arg_0));
        Optional.ofNullable(cadastro.getDataValidadeAlvara()).ifPresent(arg_0 -> dto.setDataValidadeAlvara(arg_0));
        Optional.ofNullable(cadastro.getDataAbertura()).ifPresent(arg_0 -> dto.setDataAbertura(arg_0));
        Optional.ofNullable(cadastro.getExercicioProcessoAbertura()).ifPresent(arg_0 -> dto.setExercicioProcessoAbertura(arg_0));
        Optional.ofNullable(cadastro.getIdProcessoAbertura()).ifPresent(arg_0 -> dto.setIdProcessoAbertura(arg_0));
        Optional.ofNullable(cadastro.getPessoaMobiliario()).ifPresent(arg_0 -> dto.setPessoaMobiliario(arg_0));
        Optional.ofNullable(cadastro.getCmcResponsavel()).ifPresent(responsavel -> {
            CadastroMobiliarioDTO responsavelDTO = new CadastroMobiliarioDTO();
            responsavelDTO.setId(responsavel.getId());
            responsavelDTO.setTipoCadastro(responsavel.getTipoCadastro());
            responsavelDTO.setCadastroGeral(responsavel.getCadastroGeral());
            Optional.ofNullable(responsavel.getPessoa()).ifPresent(pessoa -> responsavelDTO.setPessoa(PessoaDTO.from((Pessoa)pessoa)));
            dto.setCmcResponsavel(responsavelDTO);
        });
        Optional.ofNullable(cadastro.getObservacaoAlvara()).ifPresent(arg_0 -> dto.setObservacaoAlvara(arg_0));
        Optional.ofNullable(cadastro.getNaturezaJuridica()).ifPresent(arg_0 -> dto.setNaturezaJuridica(arg_0));
        Optional.ofNullable(cadastro.getClassificacaoMobiliario()).ifPresent(arg_0 -> dto.setClassificacaoMobiliario(arg_0));
        Optional.ofNullable(cadastro.getCategoriaMobiliario()).ifPresent(arg_0 -> dto.setCategoriaMobiliario(arg_0));
        Optional.ofNullable(cadastro.getMicroEmpresa()).ifPresent(arg_0 -> dto.setMicroEmpresa(arg_0));
        Optional.ofNullable(cadastro.getDispensaNotaFiscal()).ifPresent(arg_0 -> dto.setDispensaNotaFiscal(arg_0));
        Optional.ofNullable(cadastro.getSubstituicaoTributaria()).ifPresent(arg_0 -> dto.setSubstituicaoTributaria(arg_0));
        Optional.ofNullable(cadastro.getVisivelNfse()).ifPresent(arg_0 -> dto.setVisivelNfse(arg_0));
        Optional.ofNullable(cadastro.getUtilizaCupomFiscal()).ifPresent(arg_0 -> dto.setUtilizaCupomFiscal(arg_0));
        Optional.ofNullable(cadastro.getDataAuditoriaInicio()).ifPresent(arg_0 -> dto.setDataAuditoriaInicio(arg_0));
        Optional.ofNullable(cadastro.getDataAuditoriaFim()).ifPresent(arg_0 -> dto.setDataAuditoriaFim(arg_0));
        Optional.ofNullable(cadastro.getDataHomologacao()).ifPresent(arg_0 -> dto.setDataHomologacao(arg_0));
        Optional.ofNullable(cadastro.getAreaUtilizada()).ifPresent(arg_0 -> dto.setAreaUtilizada(arg_0));
        Optional.ofNullable(cadastro.getAreaConstruida()).ifPresent(arg_0 -> dto.setAreaConstruida(arg_0));
        Optional.ofNullable(cadastro.getAreaBombeiro()).ifPresent(arg_0 -> dto.setAreaBombeiro(arg_0));
        Optional.ofNullable(cadastro.getAreaPublicidade1()).ifPresent(arg_0 -> dto.setAreaPublicidade1(arg_0));
        Optional.ofNullable(cadastro.getAreaPublicidade2()).ifPresent(arg_0 -> dto.setAreaPublicidade2(arg_0));
        Optional.ofNullable(cadastro.getAreaPatio()).ifPresent(arg_0 -> dto.setAreaPatio(arg_0));
        Optional.ofNullable(cadastro.getQtdeFuncionario()).ifPresent(arg_0 -> dto.setQtdeFuncionario(arg_0));
        Optional.ofNullable(cadastro.getValorIssEstimado()).ifPresent(arg_0 -> dto.setValorIssEstimado(arg_0));
        Optional.ofNullable(cadastro.getProtocolo()).ifPresent(arg_0 -> dto.setProtocolo(arg_0));
        cadastro.getCadastroMobiliarioAtividades().sort(Comparator.comparing(mobiliarioAtividade -> mobiliarioAtividade.getAtividade().getId()));
        dto.getCadastroMobiliarioAtividades().addAll(cadastro.getCadastroMobiliarioAtividades());
        cadastro.getCadastroMobiliarioHorariosEspeciais().sort(Comparator.comparing(mobiliarioHorarioEspecial -> mobiliarioHorarioEspecial.getHorarioEspecial().getId()));
        dto.getCadastroMobiliarioHorariosEspeciais().addAll(cadastro.getCadastroMobiliarioHorariosEspeciais());
        dto.getObservacoes().addAll(cadastro.getObservacoes().stream().map(ObservacaoDTO::from).collect(Collectors.toList()));
        cadastro.getCadastroMobiliarioCnaes().sort(Comparator.comparing(mobiliarioCnae -> mobiliarioCnae.getCnae().getCodigo()));
        dto.getCadastroMobiliarioCnaes().addAll(cadastro.getCadastroMobiliarioCnaes());
        cadastro.getCadastroMobiliarioVeiculos().sort(Comparator.comparing(mobiliarioVeiculo -> mobiliarioVeiculo.getVeiculo().getId()));
        cadastro.getCadastroMobiliarioVeiculos().forEach(cadastroMob -> dto.getVeiculos().add(cadastroMob.getVeiculo()));
        cadastro.getRegimeFiscalPeriodo().sort(Comparator.comparing(RegimeFiscalPeriodo::getId).reversed());
        dto.getRegimeFiscalPeriodo().addAll(cadastro.getRegimeFiscalPeriodo().stream().map(RegimeFiscalPeriodoDTO::from).collect(Collectors.toList()));
        dto.setCepCorrespondencia(cadastro.getCepCorrespondencia());
        dto.setEnderecoCorrespondencia(cadastro.getEnderecoCorrespondencia());
        dto.setNumeroCorrespondencia(cadastro.getNumeroCorrespondencia());
        Optional.ofNullable(cadastro.getComplementoCorrespondencia()).ifPresent(arg_0 -> dto.setComplementoCorrespondencia(arg_0));
        dto.setBairroCorrespondencia(cadastro.getBairroCorrespondencia());
        dto.setCidadeUfCorrespondencia(cadastro.getCidadeUfCorrespondencia());
        dto.setUfCorrespondencia(cadastro.getUfCorrespondencia());
        dto.setTipoEnderecoCorrespondencia(cadastro.getTipoEnderecoCorrespondencia());
        dto.setConvenioSaneparMatriculas(cadastro.getSaneparMatriculas().stream().map(SaneparMatriculaDTO::from).collect(Collectors.toList()));
        dto.setCadastroMobiliarioCbos(cadastro.getCadastroMobiliarioCbos());
        return dto;
    }

    public static CadastroMobiliarioDTO fromComRespostaAgrupada(CadastroMobiliario entity) {
        CadastroMobiliarioDTO dto = CadastroMobiliarioDTO.from((CadastroMobiliario)entity);
        List respostasTerrenoAgrupadas = GrupoRespostasDTO.agruparRespostasPorGrupoCampo((List)entity.getRespostasMobiliarios());
        dto.setRespostasMobiliario(respostasTerrenoAgrupadas);
        return dto;
    }

    public CadastroMobiliario toEntity() {
        CadastroMobiliario cadastroMobiliario = new CadastroMobiliario();
        cadastroMobiliario.setId(this.id);
        cadastroMobiliario.setTipoCadastro(TipoCadastro.MOBILIARIO);
        cadastroMobiliario.setCadastroGeral(this.cadastroGeral);
        Optional.ofNullable(this.pessoa).ifPresent(pessoaDTO -> cadastroMobiliario.setPessoa(pessoaDTO.toEntity()));
        cadastroMobiliario.setNumeroRegistro(this.getNumeroRegistro());
        cadastroMobiliario.setAtividadePrincipal(this.getAtividadePrincipal());
        if (Objects.nonNull(this.cadastroImobiliario)) {
            CadastroImobiliario cadastroImobiliario = new CadastroImobiliario();
            cadastroImobiliario.setId(this.cadastroImobiliario.getId());
            cadastroImobiliario.setTipoCadastro(this.cadastroImobiliario.getTipoCadastro());
            cadastroImobiliario.setCadastroGeral(this.cadastroImobiliario.getCadastroGeral());
            cadastroMobiliario.setCadastroImobiliario(cadastroImobiliario);
        }
        if (Objects.nonNull(this.cadastroRural)) {
            CadastroRural cadastroRural = new CadastroRural();
            cadastroRural.setId(this.cadastroRural.getId());
            cadastroRural.setTipoCadastro(this.cadastroRural.getTipoCadastro());
            cadastroRural.setCadastroGeral(this.cadastroRural.getCadastroGeral());
            cadastroMobiliario.setCadastroRural(cadastroRural);
        }
        Optional.ofNullable(this.cidade).ifPresent(cidadeDTO -> cadastroMobiliario.setCidade(cidadeDTO.toEntity()));
        Optional.ofNullable(this.logradouro).ifPresent(logradouroDTO -> cadastroMobiliario.setLogradouro(logradouroDTO.toEntity()));
        cadastroMobiliario.setNumero(this.numero);
        cadastroMobiliario.setCep(this.cep);
        Optional.ofNullable(this.bairro).ifPresent(bairroDTO -> cadastroMobiliario.setBairro(bairroDTO.toEntity()));
        cadastroMobiliario.setComplemento(this.complemento);
        cadastroMobiliario.setTelefone(this.telefone);
        cadastroMobiliario.setExercicioAlvara(this.exercicioAlvara);
        cadastroMobiliario.setNumeroAlvara(this.numeroAlvara);
        cadastroMobiliario.setDataAlvara(this.dataAlvara);
        cadastroMobiliario.setDataValidadeAlvara(this.dataValidadeAlvara);
        cadastroMobiliario.setDataAbertura(this.dataAbertura);
        cadastroMobiliario.setExercicioProcessoAbertura(this.exercicioProcessoAbertura);
        cadastroMobiliario.setIdProcessoAbertura(this.idProcessoAbertura);
        cadastroMobiliario.setPessoaMobiliario(this.pessoaMobiliario);
        Optional.ofNullable(this.cmcResponsavel).ifPresent(responsavel -> {
            CadastroGeral cadastroGeral = new CadastroGeral();
            cadastroGeral.setId(responsavel.getId());
            cadastroGeral.setTipoCadastro(responsavel.getTipoCadastro());
            cadastroGeral.setCadastroGeral(responsavel.getCadastroGeral());
            cadastroMobiliario.setCmcResponsavel(cadastroGeral);
        });
        cadastroMobiliario.setObservacaoAlvara(this.observacaoAlvara);
        Optional.ofNullable(this.naturezaJuridica).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setNaturezaJuridica(arg_0));
        Optional.ofNullable(this.classificacaoMobiliario).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setClassificacaoMobiliario(arg_0));
        Optional.ofNullable(this.categoriaMobiliario).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setCategoriaMobiliario(arg_0));
        cadastroMobiliario.setMicroEmpresa(this.microEmpresa);
        cadastroMobiliario.setDispensaNotaFiscal(this.dispensaNotaFiscal);
        cadastroMobiliario.setSubstituicaoTributaria(this.substituicaoTributaria);
        cadastroMobiliario.setVisivelNfse(this.visivelNfse);
        cadastroMobiliario.setUtilizaCupomFiscal(this.utilizaCupomFiscal);
        cadastroMobiliario.setDataAuditoriaInicio(this.dataAuditoriaInicio);
        cadastroMobiliario.setDataAuditoriaFim(this.dataAuditoriaFim);
        cadastroMobiliario.setDataHomologacao(this.dataHomologacao);
        Optional.ofNullable(this.areaUtilizada).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setAreaUtilizada(arg_0));
        Optional.ofNullable(this.areaConstruida).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setAreaConstruida(arg_0));
        Optional.ofNullable(this.areaBombeiro).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setAreaBombeiro(arg_0));
        Optional.ofNullable(this.areaPublicidade1).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setAreaPublicidade1(arg_0));
        Optional.ofNullable(this.areaPublicidade2).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setAreaPublicidade2(arg_0));
        Optional.ofNullable(this.areaPatio).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setAreaPatio(arg_0));
        Optional.ofNullable(this.qtdeFuncionario).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setQtdeFuncionario(arg_0));
        Optional.ofNullable(this.valorIssEstimado).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setValorIssEstimado(arg_0));
        Optional.ofNullable(this.protocolo).ifPresent(arg_0 -> ((CadastroMobiliario)cadastroMobiliario).setProtocolo(arg_0));
        cadastroMobiliario.getCadastroMobiliarioAtividades().addAll(this.cadastroMobiliarioAtividades);
        cadastroMobiliario.getCadastroMobiliarioHorariosEspeciais().addAll(this.cadastroMobiliarioHorariosEspeciais);
        cadastroMobiliario.getObservacoes().addAll(this.observacoes.stream().map(observacao -> observacao.toEntity((CadastroGeral)cadastroMobiliario)).collect(Collectors.toList()));
        cadastroMobiliario.getCadastroMobiliarioCnaes().addAll(this.cadastroMobiliarioCnaes);
        this.veiculos.forEach(veiculo -> {
            CadastroMobiliarioVeiculo cadastro = new CadastroMobiliarioVeiculo();
            cadastro.setId(veiculo.getId());
            cadastro.setVeiculo(veiculo);
            cadastroMobiliario.getCadastroMobiliarioVeiculos().add(cadastro);
        });
        this.getRespostasMobiliario().forEach(grupoRespostasDTO -> grupoRespostasDTO.getRespostasPreenchidas().forEach(resposta -> cadastroMobiliario.getRespostasMobiliarios().add((RespostaMobiliario)resposta.copyTo((Resposta)new RespostaMobiliario()))));
        cadastroMobiliario.getRegimeFiscalPeriodo().addAll(this.regimeFiscalPeriodo.stream().map(RegimeFiscalPeriodo::of).collect(Collectors.toList()));
        cadastroMobiliario.setTipoEnderecoCorrespondencia(this.getTipoEnderecoCorrespondencia());
        if (TipoEnderecoCorrespondencia.OUTROS.equals((Object)this.getTipoEnderecoCorrespondencia())) {
            cadastroMobiliario.setCepCorrespondencia(this.cepCorrespondencia);
            cadastroMobiliario.setEnderecoCorrespondencia(this.enderecoCorrespondencia);
            cadastroMobiliario.setNumeroCorrespondencia(this.numeroCorrespondencia);
            cadastroMobiliario.setComplementoCorrespondencia(this.complementoCorrespondencia);
            cadastroMobiliario.setBairroCorrespondencia(this.bairroCorrespondencia);
            cadastroMobiliario.setCidadeUfCorrespondencia(this.cidadeUfCorrespondencia);
            cadastroMobiliario.setUfCorrespondencia(this.ufCorrespondencia);
        }
        cadastroMobiliario.getSaneparMatriculas().addAll(this.convenioSaneparMatriculas.stream().map(saneparMatricula -> saneparMatricula.toEntity((CadastroGeral)cadastroMobiliario)).collect(Collectors.toList()));
        cadastroMobiliario.getCadastroMobiliarioCbos().addAll(this.cadastroMobiliarioCbos);
        return cadastroMobiliario;
    }

    @Generated
    public CadastroMobiliarioDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public String getNumeroRegistro() {
        return this.numeroRegistro;
    }

    @Generated
    public PessoaDTO getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getAtividadePrincipal() {
        return this.atividadePrincipal;
    }

    @Generated
    public CadastroImobiliarioDTO getCadastroImobiliario() {
        return this.cadastroImobiliario;
    }

    @Generated
    public CadastroRuralDTO getCadastroRural() {
        return this.cadastroRural;
    }

    @Generated
    public CidadeDTO getCidade() {
        return this.cidade;
    }

    @Generated
    public LogradouroDTO getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public LoteamentoDTO getLoteamento() {
        return this.loteamento;
    }

    @Generated
    public BairroDTO getBairro() {
        return this.bairro;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public String getTelefone() {
        return this.telefone;
    }

    @Generated
    public Long getSituacaoMobiliario() {
        return this.situacaoMobiliario;
    }

    @Generated
    public String getSituacaoMobiliarioDescricao() {
        return this.situacaoMobiliarioDescricao;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Long getExercicioAlvara() {
        return this.exercicioAlvara;
    }

    @Generated
    public Long getNumeroAlvara() {
        return this.numeroAlvara;
    }

    @Generated
    public LocalDate getDataAlvara() {
        return this.dataAlvara;
    }

    @Generated
    public LocalDate getDataValidadeAlvara() {
        return this.dataValidadeAlvara;
    }

    @Generated
    public LocalDate getDataAbertura() {
        return this.dataAbertura;
    }

    @Generated
    public Long getExercicioProcessoAbertura() {
        return this.exercicioProcessoAbertura;
    }

    @Generated
    public Long getIdProcessoAbertura() {
        return this.idProcessoAbertura;
    }

    @Generated
    public PessoaMobiliario getPessoaMobiliario() {
        return this.pessoaMobiliario;
    }

    @Generated
    public CadastroMobiliarioDTO getCmcResponsavel() {
        return this.cmcResponsavel;
    }

    @Generated
    public String getObservacaoAlvara() {
        return this.observacaoAlvara;
    }

    @Generated
    public NaturezaJuridica getNaturezaJuridica() {
        return this.naturezaJuridica;
    }

    @Generated
    public ClassificacaoMobiliario getClassificacaoMobiliario() {
        return this.classificacaoMobiliario;
    }

    @Generated
    public CategoriaMobiliario getCategoriaMobiliario() {
        return this.categoriaMobiliario;
    }

    @Generated
    public Boolean getMicroEmpresa() {
        return this.microEmpresa;
    }

    @Generated
    public Boolean getDispensaNotaFiscal() {
        return this.dispensaNotaFiscal;
    }

    @Generated
    public Boolean getSubstituicaoTributaria() {
        return this.substituicaoTributaria;
    }

    @Generated
    public Boolean getVisivelNfse() {
        return this.visivelNfse;
    }

    @Generated
    public Boolean getUtilizaCupomFiscal() {
        return this.utilizaCupomFiscal;
    }

    @Generated
    public LocalDate getDataAuditoriaInicio() {
        return this.dataAuditoriaInicio;
    }

    @Generated
    public LocalDate getDataAuditoriaFim() {
        return this.dataAuditoriaFim;
    }

    @Generated
    public LocalDate getDataHomologacao() {
        return this.dataHomologacao;
    }

    @Generated
    public BigDecimal getAreaUtilizada() {
        return this.areaUtilizada;
    }

    @Generated
    public BigDecimal getAreaConstruida() {
        return this.areaConstruida;
    }

    @Generated
    public BigDecimal getAreaBombeiro() {
        return this.areaBombeiro;
    }

    @Generated
    public BigDecimal getAreaPublicidade1() {
        return this.areaPublicidade1;
    }

    @Generated
    public BigDecimal getAreaPublicidade2() {
        return this.areaPublicidade2;
    }

    @Generated
    public BigDecimal getAreaPatio() {
        return this.areaPatio;
    }

    @Generated
    public Long getQtdeFuncionario() {
        return this.qtdeFuncionario;
    }

    @Generated
    public List<CadastroMobiliarioAtividade> getCadastroMobiliarioAtividades() {
        return this.cadastroMobiliarioAtividades;
    }

    @Generated
    public List<CadastroMobiliarioHorarioEspecial> getCadastroMobiliarioHorariosEspeciais() {
        return this.cadastroMobiliarioHorariosEspeciais;
    }

    @Generated
    public List<ObservacaoDTO> getObservacoes() {
        return this.observacoes;
    }

    @Generated
    public List<CadastroMobiliarioCnae> getCadastroMobiliarioCnaes() {
        return this.cadastroMobiliarioCnaes;
    }

    @Generated
    public List<Veiculo> getVeiculos() {
        return this.veiculos;
    }

    @Generated
    public List<RegimeFiscalPeriodoDTO> getRegimeFiscalPeriodo() {
        return this.regimeFiscalPeriodo;
    }

    @Generated
    public List<GrupoRespostasDTO> getRespostasMobiliario() {
        return this.respostasMobiliario;
    }

    @Generated
    public String getCepCorrespondencia() {
        return this.cepCorrespondencia;
    }

    @Generated
    public String getEnderecoCorrespondencia() {
        return this.enderecoCorrespondencia;
    }

    @Generated
    public String getNumeroCorrespondencia() {
        return this.numeroCorrespondencia;
    }

    @Generated
    public String getComplementoCorrespondencia() {
        return this.complementoCorrespondencia;
    }

    @Generated
    public String getBairroCorrespondencia() {
        return this.bairroCorrespondencia;
    }

    @Generated
    public String getCidadeUfCorrespondencia() {
        return this.cidadeUfCorrespondencia;
    }

    @Generated
    public String getUfCorrespondencia() {
        return this.ufCorrespondencia;
    }

    @Generated
    public TipoEnderecoCorrespondencia getTipoEnderecoCorrespondencia() {
        return this.tipoEnderecoCorrespondencia;
    }

    @Generated
    public List<SaneparMatriculaDTO> getConvenioSaneparMatriculas() {
        return this.convenioSaneparMatriculas;
    }

    @Generated
    public List<CadastroMobiliarioCbo> getCadastroMobiliarioCbos() {
        return this.cadastroMobiliarioCbos;
    }

    @Generated
    public BigDecimal getValorIssEstimado() {
        return this.valorIssEstimado;
    }

    @Generated
    public String getProtocolo() {
        return this.protocolo;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setNumeroRegistro(String numeroRegistro) {
        this.numeroRegistro = numeroRegistro;
    }

    @Generated
    public void setPessoa(PessoaDTO pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setAtividadePrincipal(String atividadePrincipal) {
        this.atividadePrincipal = atividadePrincipal;
    }

    @Generated
    public void setCadastroImobiliario(CadastroImobiliarioDTO cadastroImobiliario) {
        this.cadastroImobiliario = cadastroImobiliario;
    }

    @Generated
    public void setCadastroRural(CadastroRuralDTO cadastroRural) {
        this.cadastroRural = cadastroRural;
    }

    @Generated
    public void setCidade(CidadeDTO cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setLogradouro(LogradouroDTO logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public void setLoteamento(LoteamentoDTO loteamento) {
        this.loteamento = loteamento;
    }

    @Generated
    public void setBairro(BairroDTO bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    @Generated
    public void setSituacaoMobiliario(Long situacaoMobiliario) {
        this.situacaoMobiliario = situacaoMobiliario;
    }

    @Generated
    public void setSituacaoMobiliarioDescricao(String situacaoMobiliarioDescricao) {
        this.situacaoMobiliarioDescricao = situacaoMobiliarioDescricao;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setExercicioAlvara(Long exercicioAlvara) {
        this.exercicioAlvara = exercicioAlvara;
    }

    @Generated
    public void setNumeroAlvara(Long numeroAlvara) {
        this.numeroAlvara = numeroAlvara;
    }

    @Generated
    public void setDataAlvara(LocalDate dataAlvara) {
        this.dataAlvara = dataAlvara;
    }

    @Generated
    public void setDataValidadeAlvara(LocalDate dataValidadeAlvara) {
        this.dataValidadeAlvara = dataValidadeAlvara;
    }

    @Generated
    public void setDataAbertura(LocalDate dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Generated
    public void setExercicioProcessoAbertura(Long exercicioProcessoAbertura) {
        this.exercicioProcessoAbertura = exercicioProcessoAbertura;
    }

    @Generated
    public void setIdProcessoAbertura(Long idProcessoAbertura) {
        this.idProcessoAbertura = idProcessoAbertura;
    }

    @Generated
    public void setPessoaMobiliario(PessoaMobiliario pessoaMobiliario) {
        this.pessoaMobiliario = pessoaMobiliario;
    }

    @Generated
    public void setCmcResponsavel(CadastroMobiliarioDTO cmcResponsavel) {
        this.cmcResponsavel = cmcResponsavel;
    }

    @Generated
    public void setObservacaoAlvara(String observacaoAlvara) {
        this.observacaoAlvara = observacaoAlvara;
    }

    @Generated
    public void setNaturezaJuridica(NaturezaJuridica naturezaJuridica) {
        this.naturezaJuridica = naturezaJuridica;
    }

    @Generated
    public void setClassificacaoMobiliario(ClassificacaoMobiliario classificacaoMobiliario) {
        this.classificacaoMobiliario = classificacaoMobiliario;
    }

    @Generated
    public void setCategoriaMobiliario(CategoriaMobiliario categoriaMobiliario) {
        this.categoriaMobiliario = categoriaMobiliario;
    }

    @Generated
    public void setMicroEmpresa(Boolean microEmpresa) {
        this.microEmpresa = microEmpresa;
    }

    @Generated
    public void setDispensaNotaFiscal(Boolean dispensaNotaFiscal) {
        this.dispensaNotaFiscal = dispensaNotaFiscal;
    }

    @Generated
    public void setSubstituicaoTributaria(Boolean substituicaoTributaria) {
        this.substituicaoTributaria = substituicaoTributaria;
    }

    @Generated
    public void setVisivelNfse(Boolean visivelNfse) {
        this.visivelNfse = visivelNfse;
    }

    @Generated
    public void setUtilizaCupomFiscal(Boolean utilizaCupomFiscal) {
        this.utilizaCupomFiscal = utilizaCupomFiscal;
    }

    @Generated
    public void setDataAuditoriaInicio(LocalDate dataAuditoriaInicio) {
        this.dataAuditoriaInicio = dataAuditoriaInicio;
    }

    @Generated
    public void setDataAuditoriaFim(LocalDate dataAuditoriaFim) {
        this.dataAuditoriaFim = dataAuditoriaFim;
    }

    @Generated
    public void setDataHomologacao(LocalDate dataHomologacao) {
        this.dataHomologacao = dataHomologacao;
    }

    @Generated
    public void setAreaUtilizada(BigDecimal areaUtilizada) {
        this.areaUtilizada = areaUtilizada;
    }

    @Generated
    public void setAreaConstruida(BigDecimal areaConstruida) {
        this.areaConstruida = areaConstruida;
    }

    @Generated
    public void setAreaBombeiro(BigDecimal areaBombeiro) {
        this.areaBombeiro = areaBombeiro;
    }

    @Generated
    public void setAreaPublicidade1(BigDecimal areaPublicidade1) {
        this.areaPublicidade1 = areaPublicidade1;
    }

    @Generated
    public void setAreaPublicidade2(BigDecimal areaPublicidade2) {
        this.areaPublicidade2 = areaPublicidade2;
    }

    @Generated
    public void setAreaPatio(BigDecimal areaPatio) {
        this.areaPatio = areaPatio;
    }

    @Generated
    public void setQtdeFuncionario(Long qtdeFuncionario) {
        this.qtdeFuncionario = qtdeFuncionario;
    }

    @Generated
    public void setCadastroMobiliarioAtividades(List<CadastroMobiliarioAtividade> cadastroMobiliarioAtividades) {
        this.cadastroMobiliarioAtividades = cadastroMobiliarioAtividades;
    }

    @Generated
    public void setCadastroMobiliarioHorariosEspeciais(List<CadastroMobiliarioHorarioEspecial> cadastroMobiliarioHorariosEspeciais) {
        this.cadastroMobiliarioHorariosEspeciais = cadastroMobiliarioHorariosEspeciais;
    }

    @Generated
    public void setObservacoes(List<ObservacaoDTO> observacoes) {
        this.observacoes = observacoes;
    }

    @Generated
    public void setCadastroMobiliarioCnaes(List<CadastroMobiliarioCnae> cadastroMobiliarioCnaes) {
        this.cadastroMobiliarioCnaes = cadastroMobiliarioCnaes;
    }

    @Generated
    public void setVeiculos(List<Veiculo> veiculos) {
        this.veiculos = veiculos;
    }

    @Generated
    public void setRegimeFiscalPeriodo(List<RegimeFiscalPeriodoDTO> regimeFiscalPeriodo) {
        this.regimeFiscalPeriodo = regimeFiscalPeriodo;
    }

    @Generated
    public void setRespostasMobiliario(List<GrupoRespostasDTO> respostasMobiliario) {
        this.respostasMobiliario = respostasMobiliario;
    }

    @Generated
    public void setCepCorrespondencia(String cepCorrespondencia) {
        this.cepCorrespondencia = cepCorrespondencia;
    }

    @Generated
    public void setEnderecoCorrespondencia(String enderecoCorrespondencia) {
        this.enderecoCorrespondencia = enderecoCorrespondencia;
    }

    @Generated
    public void setNumeroCorrespondencia(String numeroCorrespondencia) {
        this.numeroCorrespondencia = numeroCorrespondencia;
    }

    @Generated
    public void setComplementoCorrespondencia(String complementoCorrespondencia) {
        this.complementoCorrespondencia = complementoCorrespondencia;
    }

    @Generated
    public void setBairroCorrespondencia(String bairroCorrespondencia) {
        this.bairroCorrespondencia = bairroCorrespondencia;
    }

    @Generated
    public void setCidadeUfCorrespondencia(String cidadeUfCorrespondencia) {
        this.cidadeUfCorrespondencia = cidadeUfCorrespondencia;
    }

    @Generated
    public void setUfCorrespondencia(String ufCorrespondencia) {
        this.ufCorrespondencia = ufCorrespondencia;
    }

    @Generated
    public void setTipoEnderecoCorrespondencia(TipoEnderecoCorrespondencia tipoEnderecoCorrespondencia) {
        this.tipoEnderecoCorrespondencia = tipoEnderecoCorrespondencia;
    }

    @Generated
    public void setConvenioSaneparMatriculas(List<SaneparMatriculaDTO> convenioSaneparMatriculas) {
        this.convenioSaneparMatriculas = convenioSaneparMatriculas;
    }

    @Generated
    public void setCadastroMobiliarioCbos(List<CadastroMobiliarioCbo> cadastroMobiliarioCbos) {
        this.cadastroMobiliarioCbos = cadastroMobiliarioCbos;
    }

    @Generated
    public void setValorIssEstimado(BigDecimal valorIssEstimado) {
        this.valorIssEstimado = valorIssEstimado;
    }

    @Generated
    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroMobiliarioDTO)) {
            return false;
        }
        CadastroMobiliarioDTO other = (CadastroMobiliarioDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$cadastroGeral = this.getCadastroGeral();
        Long other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !((Object)this$cadastroGeral).equals(other$cadastroGeral)) {
            return false;
        }
        Long this$cep = this.getCep();
        Long other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !((Object)this$cep).equals(other$cep)) {
            return false;
        }
        Long this$situacaoMobiliario = this.getSituacaoMobiliario();
        Long other$situacaoMobiliario = other.getSituacaoMobiliario();
        if (this$situacaoMobiliario == null ? other$situacaoMobiliario != null : !((Object)this$situacaoMobiliario).equals(other$situacaoMobiliario)) {
            return false;
        }
        Long this$exercicioAlvara = this.getExercicioAlvara();
        Long other$exercicioAlvara = other.getExercicioAlvara();
        if (this$exercicioAlvara == null ? other$exercicioAlvara != null : !((Object)this$exercicioAlvara).equals(other$exercicioAlvara)) {
            return false;
        }
        Long this$numeroAlvara = this.getNumeroAlvara();
        Long other$numeroAlvara = other.getNumeroAlvara();
        if (this$numeroAlvara == null ? other$numeroAlvara != null : !((Object)this$numeroAlvara).equals(other$numeroAlvara)) {
            return false;
        }
        Long this$exercicioProcessoAbertura = this.getExercicioProcessoAbertura();
        Long other$exercicioProcessoAbertura = other.getExercicioProcessoAbertura();
        if (this$exercicioProcessoAbertura == null ? other$exercicioProcessoAbertura != null : !((Object)this$exercicioProcessoAbertura).equals(other$exercicioProcessoAbertura)) {
            return false;
        }
        Long this$idProcessoAbertura = this.getIdProcessoAbertura();
        Long other$idProcessoAbertura = other.getIdProcessoAbertura();
        if (this$idProcessoAbertura == null ? other$idProcessoAbertura != null : !((Object)this$idProcessoAbertura).equals(other$idProcessoAbertura)) {
            return false;
        }
        Boolean this$microEmpresa = this.getMicroEmpresa();
        Boolean other$microEmpresa = other.getMicroEmpresa();
        if (this$microEmpresa == null ? other$microEmpresa != null : !((Object)this$microEmpresa).equals(other$microEmpresa)) {
            return false;
        }
        Boolean this$dispensaNotaFiscal = this.getDispensaNotaFiscal();
        Boolean other$dispensaNotaFiscal = other.getDispensaNotaFiscal();
        if (this$dispensaNotaFiscal == null ? other$dispensaNotaFiscal != null : !((Object)this$dispensaNotaFiscal).equals(other$dispensaNotaFiscal)) {
            return false;
        }
        Boolean this$substituicaoTributaria = this.getSubstituicaoTributaria();
        Boolean other$substituicaoTributaria = other.getSubstituicaoTributaria();
        if (this$substituicaoTributaria == null ? other$substituicaoTributaria != null : !((Object)this$substituicaoTributaria).equals(other$substituicaoTributaria)) {
            return false;
        }
        Boolean this$visivelNfse = this.getVisivelNfse();
        Boolean other$visivelNfse = other.getVisivelNfse();
        if (this$visivelNfse == null ? other$visivelNfse != null : !((Object)this$visivelNfse).equals(other$visivelNfse)) {
            return false;
        }
        Boolean this$utilizaCupomFiscal = this.getUtilizaCupomFiscal();
        Boolean other$utilizaCupomFiscal = other.getUtilizaCupomFiscal();
        if (this$utilizaCupomFiscal == null ? other$utilizaCupomFiscal != null : !((Object)this$utilizaCupomFiscal).equals(other$utilizaCupomFiscal)) {
            return false;
        }
        Long this$qtdeFuncionario = this.getQtdeFuncionario();
        Long other$qtdeFuncionario = other.getQtdeFuncionario();
        if (this$qtdeFuncionario == null ? other$qtdeFuncionario != null : !((Object)this$qtdeFuncionario).equals(other$qtdeFuncionario)) {
            return false;
        }
        TipoCadastro this$tipoCadastro = this.getTipoCadastro();
        TipoCadastro other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$numeroRegistro = this.getNumeroRegistro();
        String other$numeroRegistro = other.getNumeroRegistro();
        if (this$numeroRegistro == null ? other$numeroRegistro != null : !this$numeroRegistro.equals(other$numeroRegistro)) {
            return false;
        }
        PessoaDTO this$pessoa = this.getPessoa();
        PessoaDTO other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        String this$atividadePrincipal = this.getAtividadePrincipal();
        String other$atividadePrincipal = other.getAtividadePrincipal();
        if (this$atividadePrincipal == null ? other$atividadePrincipal != null : !this$atividadePrincipal.equals(other$atividadePrincipal)) {
            return false;
        }
        CadastroImobiliarioDTO this$cadastroImobiliario = this.getCadastroImobiliario();
        CadastroImobiliarioDTO other$cadastroImobiliario = other.getCadastroImobiliario();
        if (this$cadastroImobiliario == null ? other$cadastroImobiliario != null : !this$cadastroImobiliario.equals(other$cadastroImobiliario)) {
            return false;
        }
        CadastroRuralDTO this$cadastroRural = this.getCadastroRural();
        CadastroRuralDTO other$cadastroRural = other.getCadastroRural();
        if (this$cadastroRural == null ? other$cadastroRural != null : !this$cadastroRural.equals(other$cadastroRural)) {
            return false;
        }
        CidadeDTO this$cidade = this.getCidade();
        CidadeDTO other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        LogradouroDTO this$logradouro = this.getLogradouro();
        LogradouroDTO other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        LoteamentoDTO this$loteamento = this.getLoteamento();
        LoteamentoDTO other$loteamento = other.getLoteamento();
        if (this$loteamento == null ? other$loteamento != null : !this$loteamento.equals(other$loteamento)) {
            return false;
        }
        BairroDTO this$bairro = this.getBairro();
        BairroDTO other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        String this$telefone = this.getTelefone();
        String other$telefone = other.getTelefone();
        if (this$telefone == null ? other$telefone != null : !this$telefone.equals(other$telefone)) {
            return false;
        }
        String this$situacaoMobiliarioDescricao = this.getSituacaoMobiliarioDescricao();
        String other$situacaoMobiliarioDescricao = other.getSituacaoMobiliarioDescricao();
        if (this$situacaoMobiliarioDescricao == null ? other$situacaoMobiliarioDescricao != null : !this$situacaoMobiliarioDescricao.equals(other$situacaoMobiliarioDescricao)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        LocalDate this$dataAlteracao = this.getDataAlteracao();
        LocalDate other$dataAlteracao = other.getDataAlteracao();
        if (this$dataAlteracao == null ? other$dataAlteracao != null : !((Object)this$dataAlteracao).equals(other$dataAlteracao)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        LocalDate this$dataAlvara = this.getDataAlvara();
        LocalDate other$dataAlvara = other.getDataAlvara();
        if (this$dataAlvara == null ? other$dataAlvara != null : !((Object)this$dataAlvara).equals(other$dataAlvara)) {
            return false;
        }
        LocalDate this$dataValidadeAlvara = this.getDataValidadeAlvara();
        LocalDate other$dataValidadeAlvara = other.getDataValidadeAlvara();
        if (this$dataValidadeAlvara == null ? other$dataValidadeAlvara != null : !((Object)this$dataValidadeAlvara).equals(other$dataValidadeAlvara)) {
            return false;
        }
        LocalDate this$dataAbertura = this.getDataAbertura();
        LocalDate other$dataAbertura = other.getDataAbertura();
        if (this$dataAbertura == null ? other$dataAbertura != null : !((Object)this$dataAbertura).equals(other$dataAbertura)) {
            return false;
        }
        PessoaMobiliario this$pessoaMobiliario = this.getPessoaMobiliario();
        PessoaMobiliario other$pessoaMobiliario = other.getPessoaMobiliario();
        if (this$pessoaMobiliario == null ? other$pessoaMobiliario != null : !this$pessoaMobiliario.equals(other$pessoaMobiliario)) {
            return false;
        }
        CadastroMobiliarioDTO this$cmcResponsavel = this.getCmcResponsavel();
        CadastroMobiliarioDTO other$cmcResponsavel = other.getCmcResponsavel();
        if (this$cmcResponsavel == null ? other$cmcResponsavel != null : !this$cmcResponsavel.equals(other$cmcResponsavel)) {
            return false;
        }
        String this$observacaoAlvara = this.getObservacaoAlvara();
        String other$observacaoAlvara = other.getObservacaoAlvara();
        if (this$observacaoAlvara == null ? other$observacaoAlvara != null : !this$observacaoAlvara.equals(other$observacaoAlvara)) {
            return false;
        }
        NaturezaJuridica this$naturezaJuridica = this.getNaturezaJuridica();
        NaturezaJuridica other$naturezaJuridica = other.getNaturezaJuridica();
        if (this$naturezaJuridica == null ? other$naturezaJuridica != null : !this$naturezaJuridica.equals(other$naturezaJuridica)) {
            return false;
        }
        ClassificacaoMobiliario this$classificacaoMobiliario = this.getClassificacaoMobiliario();
        ClassificacaoMobiliario other$classificacaoMobiliario = other.getClassificacaoMobiliario();
        if (this$classificacaoMobiliario == null ? other$classificacaoMobiliario != null : !this$classificacaoMobiliario.equals(other$classificacaoMobiliario)) {
            return false;
        }
        CategoriaMobiliario this$categoriaMobiliario = this.getCategoriaMobiliario();
        CategoriaMobiliario other$categoriaMobiliario = other.getCategoriaMobiliario();
        if (this$categoriaMobiliario == null ? other$categoriaMobiliario != null : !this$categoriaMobiliario.equals(other$categoriaMobiliario)) {
            return false;
        }
        LocalDate this$dataAuditoriaInicio = this.getDataAuditoriaInicio();
        LocalDate other$dataAuditoriaInicio = other.getDataAuditoriaInicio();
        if (this$dataAuditoriaInicio == null ? other$dataAuditoriaInicio != null : !((Object)this$dataAuditoriaInicio).equals(other$dataAuditoriaInicio)) {
            return false;
        }
        LocalDate this$dataAuditoriaFim = this.getDataAuditoriaFim();
        LocalDate other$dataAuditoriaFim = other.getDataAuditoriaFim();
        if (this$dataAuditoriaFim == null ? other$dataAuditoriaFim != null : !((Object)this$dataAuditoriaFim).equals(other$dataAuditoriaFim)) {
            return false;
        }
        LocalDate this$dataHomologacao = this.getDataHomologacao();
        LocalDate other$dataHomologacao = other.getDataHomologacao();
        if (this$dataHomologacao == null ? other$dataHomologacao != null : !((Object)this$dataHomologacao).equals(other$dataHomologacao)) {
            return false;
        }
        BigDecimal this$areaUtilizada = this.getAreaUtilizada();
        BigDecimal other$areaUtilizada = other.getAreaUtilizada();
        if (this$areaUtilizada == null ? other$areaUtilizada != null : !((Object)this$areaUtilizada).equals(other$areaUtilizada)) {
            return false;
        }
        BigDecimal this$areaConstruida = this.getAreaConstruida();
        BigDecimal other$areaConstruida = other.getAreaConstruida();
        if (this$areaConstruida == null ? other$areaConstruida != null : !((Object)this$areaConstruida).equals(other$areaConstruida)) {
            return false;
        }
        BigDecimal this$areaBombeiro = this.getAreaBombeiro();
        BigDecimal other$areaBombeiro = other.getAreaBombeiro();
        if (this$areaBombeiro == null ? other$areaBombeiro != null : !((Object)this$areaBombeiro).equals(other$areaBombeiro)) {
            return false;
        }
        BigDecimal this$areaPublicidade1 = this.getAreaPublicidade1();
        BigDecimal other$areaPublicidade1 = other.getAreaPublicidade1();
        if (this$areaPublicidade1 == null ? other$areaPublicidade1 != null : !((Object)this$areaPublicidade1).equals(other$areaPublicidade1)) {
            return false;
        }
        BigDecimal this$areaPublicidade2 = this.getAreaPublicidade2();
        BigDecimal other$areaPublicidade2 = other.getAreaPublicidade2();
        if (this$areaPublicidade2 == null ? other$areaPublicidade2 != null : !((Object)this$areaPublicidade2).equals(other$areaPublicidade2)) {
            return false;
        }
        BigDecimal this$areaPatio = this.getAreaPatio();
        BigDecimal other$areaPatio = other.getAreaPatio();
        if (this$areaPatio == null ? other$areaPatio != null : !((Object)this$areaPatio).equals(other$areaPatio)) {
            return false;
        }
        List this$cadastroMobiliarioAtividades = this.getCadastroMobiliarioAtividades();
        List other$cadastroMobiliarioAtividades = other.getCadastroMobiliarioAtividades();
        if (this$cadastroMobiliarioAtividades == null ? other$cadastroMobiliarioAtividades != null : !((Object)this$cadastroMobiliarioAtividades).equals(other$cadastroMobiliarioAtividades)) {
            return false;
        }
        List this$cadastroMobiliarioHorariosEspeciais = this.getCadastroMobiliarioHorariosEspeciais();
        List other$cadastroMobiliarioHorariosEspeciais = other.getCadastroMobiliarioHorariosEspeciais();
        if (this$cadastroMobiliarioHorariosEspeciais == null ? other$cadastroMobiliarioHorariosEspeciais != null : !((Object)this$cadastroMobiliarioHorariosEspeciais).equals(other$cadastroMobiliarioHorariosEspeciais)) {
            return false;
        }
        List this$observacoes = this.getObservacoes();
        List other$observacoes = other.getObservacoes();
        if (this$observacoes == null ? other$observacoes != null : !((Object)this$observacoes).equals(other$observacoes)) {
            return false;
        }
        List this$cadastroMobiliarioCnaes = this.getCadastroMobiliarioCnaes();
        List other$cadastroMobiliarioCnaes = other.getCadastroMobiliarioCnaes();
        if (this$cadastroMobiliarioCnaes == null ? other$cadastroMobiliarioCnaes != null : !((Object)this$cadastroMobiliarioCnaes).equals(other$cadastroMobiliarioCnaes)) {
            return false;
        }
        List this$veiculos = this.getVeiculos();
        List other$veiculos = other.getVeiculos();
        if (this$veiculos == null ? other$veiculos != null : !((Object)this$veiculos).equals(other$veiculos)) {
            return false;
        }
        List this$regimeFiscalPeriodo = this.getRegimeFiscalPeriodo();
        List other$regimeFiscalPeriodo = other.getRegimeFiscalPeriodo();
        if (this$regimeFiscalPeriodo == null ? other$regimeFiscalPeriodo != null : !((Object)this$regimeFiscalPeriodo).equals(other$regimeFiscalPeriodo)) {
            return false;
        }
        List this$respostasMobiliario = this.getRespostasMobiliario();
        List other$respostasMobiliario = other.getRespostasMobiliario();
        if (this$respostasMobiliario == null ? other$respostasMobiliario != null : !((Object)this$respostasMobiliario).equals(other$respostasMobiliario)) {
            return false;
        }
        String this$cepCorrespondencia = this.getCepCorrespondencia();
        String other$cepCorrespondencia = other.getCepCorrespondencia();
        if (this$cepCorrespondencia == null ? other$cepCorrespondencia != null : !this$cepCorrespondencia.equals(other$cepCorrespondencia)) {
            return false;
        }
        String this$enderecoCorrespondencia = this.getEnderecoCorrespondencia();
        String other$enderecoCorrespondencia = other.getEnderecoCorrespondencia();
        if (this$enderecoCorrespondencia == null ? other$enderecoCorrespondencia != null : !this$enderecoCorrespondencia.equals(other$enderecoCorrespondencia)) {
            return false;
        }
        String this$numeroCorrespondencia = this.getNumeroCorrespondencia();
        String other$numeroCorrespondencia = other.getNumeroCorrespondencia();
        if (this$numeroCorrespondencia == null ? other$numeroCorrespondencia != null : !this$numeroCorrespondencia.equals(other$numeroCorrespondencia)) {
            return false;
        }
        String this$complementoCorrespondencia = this.getComplementoCorrespondencia();
        String other$complementoCorrespondencia = other.getComplementoCorrespondencia();
        if (this$complementoCorrespondencia == null ? other$complementoCorrespondencia != null : !this$complementoCorrespondencia.equals(other$complementoCorrespondencia)) {
            return false;
        }
        String this$bairroCorrespondencia = this.getBairroCorrespondencia();
        String other$bairroCorrespondencia = other.getBairroCorrespondencia();
        if (this$bairroCorrespondencia == null ? other$bairroCorrespondencia != null : !this$bairroCorrespondencia.equals(other$bairroCorrespondencia)) {
            return false;
        }
        String this$cidadeUfCorrespondencia = this.getCidadeUfCorrespondencia();
        String other$cidadeUfCorrespondencia = other.getCidadeUfCorrespondencia();
        if (this$cidadeUfCorrespondencia == null ? other$cidadeUfCorrespondencia != null : !this$cidadeUfCorrespondencia.equals(other$cidadeUfCorrespondencia)) {
            return false;
        }
        String this$ufCorrespondencia = this.getUfCorrespondencia();
        String other$ufCorrespondencia = other.getUfCorrespondencia();
        if (this$ufCorrespondencia == null ? other$ufCorrespondencia != null : !this$ufCorrespondencia.equals(other$ufCorrespondencia)) {
            return false;
        }
        TipoEnderecoCorrespondencia this$tipoEnderecoCorrespondencia = this.getTipoEnderecoCorrespondencia();
        TipoEnderecoCorrespondencia other$tipoEnderecoCorrespondencia = other.getTipoEnderecoCorrespondencia();
        if (this$tipoEnderecoCorrespondencia == null ? other$tipoEnderecoCorrespondencia != null : !this$tipoEnderecoCorrespondencia.equals(other$tipoEnderecoCorrespondencia)) {
            return false;
        }
        List this$convenioSaneparMatriculas = this.getConvenioSaneparMatriculas();
        List other$convenioSaneparMatriculas = other.getConvenioSaneparMatriculas();
        if (this$convenioSaneparMatriculas == null ? other$convenioSaneparMatriculas != null : !((Object)this$convenioSaneparMatriculas).equals(other$convenioSaneparMatriculas)) {
            return false;
        }
        List this$cadastroMobiliarioCbos = this.getCadastroMobiliarioCbos();
        List other$cadastroMobiliarioCbos = other.getCadastroMobiliarioCbos();
        if (this$cadastroMobiliarioCbos == null ? other$cadastroMobiliarioCbos != null : !((Object)this$cadastroMobiliarioCbos).equals(other$cadastroMobiliarioCbos)) {
            return false;
        }
        BigDecimal this$valorIssEstimado = this.getValorIssEstimado();
        BigDecimal other$valorIssEstimado = other.getValorIssEstimado();
        if (this$valorIssEstimado == null ? other$valorIssEstimado != null : !((Object)this$valorIssEstimado).equals(other$valorIssEstimado)) {
            return false;
        }
        String this$protocolo = this.getProtocolo();
        String other$protocolo = other.getProtocolo();
        return !(this$protocolo == null ? other$protocolo != null : !this$protocolo.equals(other$protocolo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroMobiliarioDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : ((Object)$cadastroGeral).hashCode());
        Long $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : ((Object)$cep).hashCode());
        Long $situacaoMobiliario = this.getSituacaoMobiliario();
        result = result * 59 + ($situacaoMobiliario == null ? 43 : ((Object)$situacaoMobiliario).hashCode());
        Long $exercicioAlvara = this.getExercicioAlvara();
        result = result * 59 + ($exercicioAlvara == null ? 43 : ((Object)$exercicioAlvara).hashCode());
        Long $numeroAlvara = this.getNumeroAlvara();
        result = result * 59 + ($numeroAlvara == null ? 43 : ((Object)$numeroAlvara).hashCode());
        Long $exercicioProcessoAbertura = this.getExercicioProcessoAbertura();
        result = result * 59 + ($exercicioProcessoAbertura == null ? 43 : ((Object)$exercicioProcessoAbertura).hashCode());
        Long $idProcessoAbertura = this.getIdProcessoAbertura();
        result = result * 59 + ($idProcessoAbertura == null ? 43 : ((Object)$idProcessoAbertura).hashCode());
        Boolean $microEmpresa = this.getMicroEmpresa();
        result = result * 59 + ($microEmpresa == null ? 43 : ((Object)$microEmpresa).hashCode());
        Boolean $dispensaNotaFiscal = this.getDispensaNotaFiscal();
        result = result * 59 + ($dispensaNotaFiscal == null ? 43 : ((Object)$dispensaNotaFiscal).hashCode());
        Boolean $substituicaoTributaria = this.getSubstituicaoTributaria();
        result = result * 59 + ($substituicaoTributaria == null ? 43 : ((Object)$substituicaoTributaria).hashCode());
        Boolean $visivelNfse = this.getVisivelNfse();
        result = result * 59 + ($visivelNfse == null ? 43 : ((Object)$visivelNfse).hashCode());
        Boolean $utilizaCupomFiscal = this.getUtilizaCupomFiscal();
        result = result * 59 + ($utilizaCupomFiscal == null ? 43 : ((Object)$utilizaCupomFiscal).hashCode());
        Long $qtdeFuncionario = this.getQtdeFuncionario();
        result = result * 59 + ($qtdeFuncionario == null ? 43 : ((Object)$qtdeFuncionario).hashCode());
        TipoCadastro $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $numeroRegistro = this.getNumeroRegistro();
        result = result * 59 + ($numeroRegistro == null ? 43 : $numeroRegistro.hashCode());
        PessoaDTO $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        String $atividadePrincipal = this.getAtividadePrincipal();
        result = result * 59 + ($atividadePrincipal == null ? 43 : $atividadePrincipal.hashCode());
        CadastroImobiliarioDTO $cadastroImobiliario = this.getCadastroImobiliario();
        result = result * 59 + ($cadastroImobiliario == null ? 43 : $cadastroImobiliario.hashCode());
        CadastroRuralDTO $cadastroRural = this.getCadastroRural();
        result = result * 59 + ($cadastroRural == null ? 43 : $cadastroRural.hashCode());
        CidadeDTO $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        LogradouroDTO $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        LoteamentoDTO $loteamento = this.getLoteamento();
        result = result * 59 + ($loteamento == null ? 43 : $loteamento.hashCode());
        BairroDTO $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        String $telefone = this.getTelefone();
        result = result * 59 + ($telefone == null ? 43 : $telefone.hashCode());
        String $situacaoMobiliarioDescricao = this.getSituacaoMobiliarioDescricao();
        result = result * 59 + ($situacaoMobiliarioDescricao == null ? 43 : $situacaoMobiliarioDescricao.hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        LocalDate $dataAlteracao = this.getDataAlteracao();
        result = result * 59 + ($dataAlteracao == null ? 43 : ((Object)$dataAlteracao).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        LocalDate $dataAlvara = this.getDataAlvara();
        result = result * 59 + ($dataAlvara == null ? 43 : ((Object)$dataAlvara).hashCode());
        LocalDate $dataValidadeAlvara = this.getDataValidadeAlvara();
        result = result * 59 + ($dataValidadeAlvara == null ? 43 : ((Object)$dataValidadeAlvara).hashCode());
        LocalDate $dataAbertura = this.getDataAbertura();
        result = result * 59 + ($dataAbertura == null ? 43 : ((Object)$dataAbertura).hashCode());
        PessoaMobiliario $pessoaMobiliario = this.getPessoaMobiliario();
        result = result * 59 + ($pessoaMobiliario == null ? 43 : $pessoaMobiliario.hashCode());
        CadastroMobiliarioDTO $cmcResponsavel = this.getCmcResponsavel();
        result = result * 59 + ($cmcResponsavel == null ? 43 : $cmcResponsavel.hashCode());
        String $observacaoAlvara = this.getObservacaoAlvara();
        result = result * 59 + ($observacaoAlvara == null ? 43 : $observacaoAlvara.hashCode());
        NaturezaJuridica $naturezaJuridica = this.getNaturezaJuridica();
        result = result * 59 + ($naturezaJuridica == null ? 43 : $naturezaJuridica.hashCode());
        ClassificacaoMobiliario $classificacaoMobiliario = this.getClassificacaoMobiliario();
        result = result * 59 + ($classificacaoMobiliario == null ? 43 : $classificacaoMobiliario.hashCode());
        CategoriaMobiliario $categoriaMobiliario = this.getCategoriaMobiliario();
        result = result * 59 + ($categoriaMobiliario == null ? 43 : $categoriaMobiliario.hashCode());
        LocalDate $dataAuditoriaInicio = this.getDataAuditoriaInicio();
        result = result * 59 + ($dataAuditoriaInicio == null ? 43 : ((Object)$dataAuditoriaInicio).hashCode());
        LocalDate $dataAuditoriaFim = this.getDataAuditoriaFim();
        result = result * 59 + ($dataAuditoriaFim == null ? 43 : ((Object)$dataAuditoriaFim).hashCode());
        LocalDate $dataHomologacao = this.getDataHomologacao();
        result = result * 59 + ($dataHomologacao == null ? 43 : ((Object)$dataHomologacao).hashCode());
        BigDecimal $areaUtilizada = this.getAreaUtilizada();
        result = result * 59 + ($areaUtilizada == null ? 43 : ((Object)$areaUtilizada).hashCode());
        BigDecimal $areaConstruida = this.getAreaConstruida();
        result = result * 59 + ($areaConstruida == null ? 43 : ((Object)$areaConstruida).hashCode());
        BigDecimal $areaBombeiro = this.getAreaBombeiro();
        result = result * 59 + ($areaBombeiro == null ? 43 : ((Object)$areaBombeiro).hashCode());
        BigDecimal $areaPublicidade1 = this.getAreaPublicidade1();
        result = result * 59 + ($areaPublicidade1 == null ? 43 : ((Object)$areaPublicidade1).hashCode());
        BigDecimal $areaPublicidade2 = this.getAreaPublicidade2();
        result = result * 59 + ($areaPublicidade2 == null ? 43 : ((Object)$areaPublicidade2).hashCode());
        BigDecimal $areaPatio = this.getAreaPatio();
        result = result * 59 + ($areaPatio == null ? 43 : ((Object)$areaPatio).hashCode());
        List $cadastroMobiliarioAtividades = this.getCadastroMobiliarioAtividades();
        result = result * 59 + ($cadastroMobiliarioAtividades == null ? 43 : ((Object)$cadastroMobiliarioAtividades).hashCode());
        List $cadastroMobiliarioHorariosEspeciais = this.getCadastroMobiliarioHorariosEspeciais();
        result = result * 59 + ($cadastroMobiliarioHorariosEspeciais == null ? 43 : ((Object)$cadastroMobiliarioHorariosEspeciais).hashCode());
        List $observacoes = this.getObservacoes();
        result = result * 59 + ($observacoes == null ? 43 : ((Object)$observacoes).hashCode());
        List $cadastroMobiliarioCnaes = this.getCadastroMobiliarioCnaes();
        result = result * 59 + ($cadastroMobiliarioCnaes == null ? 43 : ((Object)$cadastroMobiliarioCnaes).hashCode());
        List $veiculos = this.getVeiculos();
        result = result * 59 + ($veiculos == null ? 43 : ((Object)$veiculos).hashCode());
        List $regimeFiscalPeriodo = this.getRegimeFiscalPeriodo();
        result = result * 59 + ($regimeFiscalPeriodo == null ? 43 : ((Object)$regimeFiscalPeriodo).hashCode());
        List $respostasMobiliario = this.getRespostasMobiliario();
        result = result * 59 + ($respostasMobiliario == null ? 43 : ((Object)$respostasMobiliario).hashCode());
        String $cepCorrespondencia = this.getCepCorrespondencia();
        result = result * 59 + ($cepCorrespondencia == null ? 43 : $cepCorrespondencia.hashCode());
        String $enderecoCorrespondencia = this.getEnderecoCorrespondencia();
        result = result * 59 + ($enderecoCorrespondencia == null ? 43 : $enderecoCorrespondencia.hashCode());
        String $numeroCorrespondencia = this.getNumeroCorrespondencia();
        result = result * 59 + ($numeroCorrespondencia == null ? 43 : $numeroCorrespondencia.hashCode());
        String $complementoCorrespondencia = this.getComplementoCorrespondencia();
        result = result * 59 + ($complementoCorrespondencia == null ? 43 : $complementoCorrespondencia.hashCode());
        String $bairroCorrespondencia = this.getBairroCorrespondencia();
        result = result * 59 + ($bairroCorrespondencia == null ? 43 : $bairroCorrespondencia.hashCode());
        String $cidadeUfCorrespondencia = this.getCidadeUfCorrespondencia();
        result = result * 59 + ($cidadeUfCorrespondencia == null ? 43 : $cidadeUfCorrespondencia.hashCode());
        String $ufCorrespondencia = this.getUfCorrespondencia();
        result = result * 59 + ($ufCorrespondencia == null ? 43 : $ufCorrespondencia.hashCode());
        TipoEnderecoCorrespondencia $tipoEnderecoCorrespondencia = this.getTipoEnderecoCorrespondencia();
        result = result * 59 + ($tipoEnderecoCorrespondencia == null ? 43 : $tipoEnderecoCorrespondencia.hashCode());
        List $convenioSaneparMatriculas = this.getConvenioSaneparMatriculas();
        result = result * 59 + ($convenioSaneparMatriculas == null ? 43 : ((Object)$convenioSaneparMatriculas).hashCode());
        List $cadastroMobiliarioCbos = this.getCadastroMobiliarioCbos();
        result = result * 59 + ($cadastroMobiliarioCbos == null ? 43 : ((Object)$cadastroMobiliarioCbos).hashCode());
        BigDecimal $valorIssEstimado = this.getValorIssEstimado();
        result = result * 59 + ($valorIssEstimado == null ? 43 : ((Object)$valorIssEstimado).hashCode());
        String $protocolo = this.getProtocolo();
        result = result * 59 + ($protocolo == null ? 43 : $protocolo.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroMobiliarioDTO(id=" + this.getId() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", numeroRegistro=" + this.getNumeroRegistro() + ", pessoa=" + this.getPessoa() + ", atividadePrincipal=" + this.getAtividadePrincipal() + ", cadastroImobiliario=" + this.getCadastroImobiliario() + ", cadastroRural=" + this.getCadastroRural() + ", cidade=" + this.getCidade() + ", logradouro=" + this.getLogradouro() + ", numero=" + this.getNumero() + ", cep=" + this.getCep() + ", loteamento=" + this.getLoteamento() + ", bairro=" + this.getBairro() + ", complemento=" + this.getComplemento() + ", telefone=" + this.getTelefone() + ", situacaoMobiliario=" + this.getSituacaoMobiliario() + ", situacaoMobiliarioDescricao=" + this.getSituacaoMobiliarioDescricao() + ", dataInclusao=" + this.getDataInclusao() + ", dataAlteracao=" + this.getDataAlteracao() + ", usuario=" + this.getUsuario() + ", exercicioAlvara=" + this.getExercicioAlvara() + ", numeroAlvara=" + this.getNumeroAlvara() + ", dataAlvara=" + this.getDataAlvara() + ", dataValidadeAlvara=" + this.getDataValidadeAlvara() + ", dataAbertura=" + this.getDataAbertura() + ", exercicioProcessoAbertura=" + this.getExercicioProcessoAbertura() + ", idProcessoAbertura=" + this.getIdProcessoAbertura() + ", pessoaMobiliario=" + this.getPessoaMobiliario() + ", cmcResponsavel=" + this.getCmcResponsavel() + ", observacaoAlvara=" + this.getObservacaoAlvara() + ", naturezaJuridica=" + this.getNaturezaJuridica() + ", classificacaoMobiliario=" + this.getClassificacaoMobiliario() + ", categoriaMobiliario=" + this.getCategoriaMobiliario() + ", microEmpresa=" + this.getMicroEmpresa() + ", dispensaNotaFiscal=" + this.getDispensaNotaFiscal() + ", substituicaoTributaria=" + this.getSubstituicaoTributaria() + ", visivelNfse=" + this.getVisivelNfse() + ", utilizaCupomFiscal=" + this.getUtilizaCupomFiscal() + ", dataAuditoriaInicio=" + this.getDataAuditoriaInicio() + ", dataAuditoriaFim=" + this.getDataAuditoriaFim() + ", dataHomologacao=" + this.getDataHomologacao() + ", areaUtilizada=" + this.getAreaUtilizada() + ", areaConstruida=" + this.getAreaConstruida() + ", areaBombeiro=" + this.getAreaBombeiro() + ", areaPublicidade1=" + this.getAreaPublicidade1() + ", areaPublicidade2=" + this.getAreaPublicidade2() + ", areaPatio=" + this.getAreaPatio() + ", qtdeFuncionario=" + this.getQtdeFuncionario() + ", cadastroMobiliarioAtividades=" + this.getCadastroMobiliarioAtividades() + ", cadastroMobiliarioHorariosEspeciais=" + this.getCadastroMobiliarioHorariosEspeciais() + ", observacoes=" + this.getObservacoes() + ", cadastroMobiliarioCnaes=" + this.getCadastroMobiliarioCnaes() + ", veiculos=" + this.getVeiculos() + ", regimeFiscalPeriodo=" + this.getRegimeFiscalPeriodo() + ", respostasMobiliario=" + this.getRespostasMobiliario() + ", cepCorrespondencia=" + this.getCepCorrespondencia() + ", enderecoCorrespondencia=" + this.getEnderecoCorrespondencia() + ", numeroCorrespondencia=" + this.getNumeroCorrespondencia() + ", complementoCorrespondencia=" + this.getComplementoCorrespondencia() + ", bairroCorrespondencia=" + this.getBairroCorrespondencia() + ", cidadeUfCorrespondencia=" + this.getCidadeUfCorrespondencia() + ", ufCorrespondencia=" + this.getUfCorrespondencia() + ", tipoEnderecoCorrespondencia=" + this.getTipoEnderecoCorrespondencia() + ", convenioSaneparMatriculas=" + this.getConvenioSaneparMatriculas() + ", cadastroMobiliarioCbos=" + this.getCadastroMobiliarioCbos() + ", valorIssEstimado=" + this.getValorIssEstimado() + ", protocolo=" + this.getProtocolo() + ")";
    }
}

