/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.transferenciadebito;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.transferenciadebito.TransferenciaDebitoItem;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="tribtransferenciadebito")
public class TransferenciaDebito
implements EloEntity<Long> {
    @Id
    @Column(name="idtransferencia")
    private Long id;
    private String observacao;
    private LocalDate data;
    private String usuario;
    @OneToMany(mappedBy="id.idTransferencia")
    private List<TransferenciaDebitoItem> debitos;

    public BigDecimal getValorTotalOrigem() {
        return this.debitos.stream().map(TransferenciaDebitoItem::getDebitoOrigem).map(Debito::getValorTotalDebito).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public BigDecimal getValorTotalDestino() {
        return this.debitos.stream().map(TransferenciaDebitoItem::getDebitoDestino).map(Debito::getValorTotalDebito).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Generated
    public TransferenciaDebito() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public LocalDate getData() {
        return this.data;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public List<TransferenciaDebitoItem> getDebitos() {
        return this.debitos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setData(LocalDate data) {
        this.data = data;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setDebitos(List<TransferenciaDebitoItem> debitos) {
        this.debitos = debitos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferenciaDebito)) {
            return false;
        }
        TransferenciaDebito other = (TransferenciaDebito)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$observacao = this.getObservacao();
        String other$observacao = other.getObservacao();
        if (this$observacao == null ? other$observacao != null : !this$observacao.equals(other$observacao)) {
            return false;
        }
        LocalDate this$data = this.getData();
        LocalDate other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        List this$debitos = this.getDebitos();
        List other$debitos = other.getDebitos();
        return !(this$debitos == null ? other$debitos != null : !((Object)this$debitos).equals(other$debitos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransferenciaDebito;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $observacao = this.getObservacao();
        result = result * 59 + ($observacao == null ? 43 : $observacao.hashCode());
        LocalDate $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        List $debitos = this.getDebitos();
        result = result * 59 + ($debitos == null ? 43 : ((Object)$debitos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransferenciaDebito(id=" + this.getId() + ", observacao=" + this.getObservacao() + ", data=" + this.getData() + ", usuario=" + this.getUsuario() + ", debitos=" + this.getDebitos() + ")";
    }
}

