/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.metamodel.annotation.MetaModelIgnore;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.DocumentoHistoricoSituacao;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.DocumentoPessoa;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.SituacaoDocumento;
import br.com.elotech.tributos.domain.TipoAlvaraLocalizacao;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoCertidaoDebitos;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoAutenticadoDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Length;

@Audited
@Entity
@Table(name="TRIBDOCUMENTO")
public class Documento
implements EloEntity<Long>,
Serializable {
    @Id
    @Column(name="idkey")
    @EloSequence(sequenceName="S_TRIBDOCUMENTO_ID")
    private Long id;
    @NotAudited
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TRIBENTIDADETRIBUTACAO_IDKEY")
    @JsonIgnoreProperties(value={"modeloBci", "modeloBce", "parametroITBI", "entidade.brasao"})
    private EntidadeTributacao entidadeTributacao;
    @NotNull
    private Long entidade;
    @NotNull
    private Long exercicio;
    @NotNull
    private Long tipoDocumento;
    @NotNull
    private Long documento;
    @NotAudited
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumnOrFormula(formula=@JoinFormula(value="tipodocumento", referencedColumnName="tipodocumento"))
    @JsonIgnoreProperties(value={"outros", "textos", "assinaturas", "relatorios"})
    private DocumentoTipo documentoTipo;
    @Length(max=20)
    @Column(name="CNPJ_CPF")
    private @Length(max=20) String cnpjCpf;
    private LocalDate dataEmissao;
    private LocalDate dataSolicitacao;
    private LocalDate dataValidade;
    @Length(max=150)
    private @Length(max=150) String outraFinalidade;
    @ManyToOne
    @JoinColumn(name="TRIBCADASTROGERAL_IDKEY")
    @MetaModelIgnore
    @JsonIgnoreProperties(value={"cadastroGeralIsencoes", "cadastroImobiliarioAvaliacoes", "cadastroImobiliarioSegmentos", "cadastroImobiliarioTestadas", "boletinsImobiliarioTerreno", "imobiliarioTestadasGenericas"})
    private CadastroGeral cadastroGeral;
    private TipoCadastro tipoCadastro;
    @Column(name="cadastrogeral")
    private Long codigoCadastroGeral;
    @Length(max=150)
    private @Length(max=150) String requerente;
    @Length(max=20)
    private @Length(max=20) String cpfRequerente;
    private TipoPessoa tipoPessoaRequerente;
    @Length(max=1)
    private @Length(max=1) String subTipo;
    @Length(max=100)
    private @Length(max=100) String codigoValidacao;
    @NotAudited
    @ManyToOne
    @JoinColumn(name="TRIBDOCUMENTOFINALIDADE_IDKEY")
    @JsonIgnoreProperties(value={"entidadeTributacao", "tipoDocumento"})
    private DocumentoFinalidade documentoFinalidade;
    private Long sequenciaFinalidade;
    @NotAudited
    @ManyToOne
    private Pessoa pessoa;
    @Length(max=250)
    private @Length(max=250) String usuario;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean cancelado = Boolean.FALSE;
    @Column(name="datacancelamento")
    private LocalDate dataCancelamento;
    @Column(name="usuariocancelamento")
    private String usuarioCancelamento;
    @Column(name="observacaocancelamento")
    private String observacaoCancelamento;
    @Column(name="exercicioprocesso")
    private Long exercicioProcesso;
    @Column(name="idprocesso")
    private Long idProcesso;
    @NotAudited
    @OneToMany(mappedBy="documento", cascade={CascadeType.ALL})
    private List<DocumentoHistoricoSituacao> documentoHistoricoSituacoes = new ArrayList();
    @OneToMany(mappedBy="documento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DocumentoPessoa> documentoPessoas = new ArrayList();
    @OneToMany(mappedBy="documento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DocumentoItemDividaAtiva> documentoItemDividaAtivas = new ArrayList();
    @NotAudited
    @OneToMany
    @JoinTable(name="tribdocumentopeticaocda", joinColumns={@JoinColumn(name="idpeticao", referencedColumnName="idkey")}, inverseJoinColumns={@JoinColumn(name="idcertidaodividaativa", referencedColumnName="idkey")})
    @MetaModelIgnore
    private List<Documento> certidoesDividaAtivaPeticao = new ArrayList();
    @NotAudited
    @ManyToOne
    @JoinColumn(name="situacao", referencedColumnName="idsituacaodocumento")
    private SituacaoDocumento situacao;
    private Boolean impresso = Boolean.FALSE;
    private String situacaoCadastral;
    private Boolean web = Boolean.FALSE;
    private Boolean assinadoDigitalmente = Boolean.FALSE;
    @Length(max=4000)
    private @Length(max=4000) String observacao;
    @Column(name="id_arquivo_unico")
    private Long idArquivoUnico;
    private Boolean certidaoEspecial = Boolean.FALSE;
    @Column(name="idsequenciaitbi")
    private Long idSequenciaItbi;
    @NotAudited
    @Column(name="enviadoprocuradoria")
    private Boolean enviadoProcuradoria = Boolean.FALSE;
    @Column(name="idlaudo")
    private UUID idLaudo;
    @Column(name="exercicioprojeto")
    private Long exercicioProjeto;
    @Column(name="projeto")
    private Long numeroProjeto;

    @JsonIgnore
    public BigDecimal getValorTotalDividaAtivas() {
        return this.documentoItemDividaAtivas.stream().map(DocumentoItemDividaAtiva::getTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonIgnore
    public BigDecimal getValorTotalDividaAtivasPeticao() {
        return this.certidoesDividaAtivaPeticao.stream().flatMap(peticao -> peticao.getDocumentoItemDividaAtivas().stream()).map(DocumentoItemDividaAtiva::getTotal).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public String getSubTipoDescricao() {
        if (TipoDocumentoEnum.ALVARA_LOCALIZACAO.getCodigo().equals(this.tipoDocumento)) {
            return Optional.ofNullable(TipoAlvaraLocalizacao.fromValue((String)this.subTipo)).map(TipoAlvaraLocalizacao::getDescricao).orElse("");
        }
        if (Arrays.asList(TipoDocumentoEnum.CERTIDAO_CONTRIBUINTE.getCodigo(), TipoDocumentoEnum.CERTIDAO_CADASTRO_MUNICIPAL.getCodigo()).contains(this.tipoDocumento)) {
            return Optional.ofNullable(TipoCertidaoDebitos.fromValue((String)this.subTipo)).map(TipoCertidaoDebitos::getDescricao).orElse("");
        }
        return "";
    }

    public DocumentoAutenticadoDTO toDocumentoAutenticadoDTO() {
        DocumentoAutenticadoDTO documentoAutenticado = new DocumentoAutenticadoDTO();
        documentoAutenticado.setExercicio(this.exercicio);
        documentoAutenticado.setTipoDocumento(this.tipoDocumento);
        if (Objects.nonNull(this.documentoTipo)) {
            documentoAutenticado.setDescricao(this.documentoTipo.getDescricao());
            documentoAutenticado.setImpressaoWeb(this.documentoTipo.getImpressaoWeb());
        }
        if (Objects.nonNull(this.documento)) {
            documentoAutenticado.setDocumento(this.documento.toString());
        }
        documentoAutenticado.setCnpjCpf(this.cnpjCpf);
        documentoAutenticado.setDataEmissao(this.dataEmissao);
        documentoAutenticado.setDataValidade(this.dataValidade);
        documentoAutenticado.setOutraFinalidade(this.outraFinalidade);
        documentoAutenticado.setRequerente(this.requerente);
        documentoAutenticado.setCpfRequerente(this.cpfRequerente);
        documentoAutenticado.setSubTipo(this.subTipo);
        if (Objects.nonNull(this.tipoPessoaRequerente)) {
            documentoAutenticado.setTipoPessoaRequerente(this.tipoPessoaRequerente.getValue());
        }
        if (Objects.nonNull(this.cadastroGeral)) {
            documentoAutenticado.setTipoCadastro(this.cadastroGeral.getTipoCadastro().getValue());
            documentoAutenticado.setCadastroGeral(this.cadastroGeral.getCadastroGeral());
        }
        Optional.ofNullable(this.documentoFinalidade).ifPresent(finalidade -> documentoAutenticado.setFinalidade(finalidade.getDescricao()));
        Optional.ofNullable(this.situacao).ifPresent(situacaoDocumento -> {
            String subTipoDescricao = this.getSubTipoDescricao();
            if (subTipoDescricao.isEmpty()) {
                documentoAutenticado.setDescricaoSituacao(situacaoDocumento.getDescricao());
            } else {
                documentoAutenticado.setDescricaoSituacao(situacaoDocumento.getDescricao() + " - " + this.getSubTipoDescricao());
            }
            if (situacaoDocumento.getCancelamento().booleanValue()) {
                documentoAutenticado.setImpressaoWeb(Boolean.FALSE);
            }
        });
        return documentoAutenticado;
    }

    public static Documento to(Long entidade, CadastroGeral cadastroGeral, LocalDate dataReferencia, Long numeroCertidao, Long anoCertidao, Pessoa pessoa, EntidadeTributacao entidadeTributacao, DocumentoTipo documentoTipo) {
        Documento documento = new Documento();
        documento.setDocumento(numeroCertidao);
        documento.setEntidade(entidade);
        documento.setTipoDocumento(documentoTipo.getId());
        documento.setExercicio(anoCertidao);
        documento.setDocumentoTipo(documentoTipo);
        documento.setDataEmissao(dataReferencia);
        documento.setEntidadeTributacao(entidadeTributacao);
        documento.setTipoCadastro(cadastroGeral.getTipoCadastro());
        documento.setCadastroGeral(cadastroGeral);
        documento.setPessoa(pessoa);
        documento.setCnpjCpf(documento.getPessoa().getCnpjCpf());
        documento.setSituacao(SituacaoDocumento.aberto());
        documento.setUsuario(SecurityUtils.getUserAise());
        return documento;
    }

    @Generated
    public String toString() {
        return "Documento(id=" + this.getId() + ", entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", tipoDocumento=" + this.getTipoDocumento() + ", documento=" + this.getDocumento() + ")";
    }

    @Generated
    public Documento() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public EntidadeTributacao getEntidadeTributacao() {
        return this.entidadeTributacao;
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getTipoDocumento() {
        return this.tipoDocumento;
    }

    @Generated
    public Long getDocumento() {
        return this.documento;
    }

    @Generated
    public DocumentoTipo getDocumentoTipo() {
        return this.documentoTipo;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public LocalDate getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    @Generated
    public LocalDate getDataValidade() {
        return this.dataValidade;
    }

    @Generated
    public String getOutraFinalidade() {
        return this.outraFinalidade;
    }

    @Generated
    public CadastroGeral getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public TipoCadastro getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCodigoCadastroGeral() {
        return this.codigoCadastroGeral;
    }

    @Generated
    public String getRequerente() {
        return this.requerente;
    }

    @Generated
    public String getCpfRequerente() {
        return this.cpfRequerente;
    }

    @Generated
    public TipoPessoa getTipoPessoaRequerente() {
        return this.tipoPessoaRequerente;
    }

    @Generated
    public String getSubTipo() {
        return this.subTipo;
    }

    @Generated
    public String getCodigoValidacao() {
        return this.codigoValidacao;
    }

    @Generated
    public DocumentoFinalidade getDocumentoFinalidade() {
        return this.documentoFinalidade;
    }

    @Generated
    public Long getSequenciaFinalidade() {
        return this.sequenciaFinalidade;
    }

    @Generated
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Boolean getCancelado() {
        return this.cancelado;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    @Generated
    public String getObservacaoCancelamento() {
        return this.observacaoCancelamento;
    }

    @Generated
    public Long getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    @Generated
    public Long getIdProcesso() {
        return this.idProcesso;
    }

    @Generated
    public List<DocumentoHistoricoSituacao> getDocumentoHistoricoSituacoes() {
        return this.documentoHistoricoSituacoes;
    }

    @Generated
    public List<DocumentoPessoa> getDocumentoPessoas() {
        return this.documentoPessoas;
    }

    @Generated
    public List<DocumentoItemDividaAtiva> getDocumentoItemDividaAtivas() {
        return this.documentoItemDividaAtivas;
    }

    @Generated
    public List<Documento> getCertidoesDividaAtivaPeticao() {
        return this.certidoesDividaAtivaPeticao;
    }

    @Generated
    public SituacaoDocumento getSituacao() {
        return this.situacao;
    }

    @Generated
    public Boolean getImpresso() {
        return this.impresso;
    }

    @Generated
    public String getSituacaoCadastral() {
        return this.situacaoCadastral;
    }

    @Generated
    public Boolean getWeb() {
        return this.web;
    }

    @Generated
    public Boolean getAssinadoDigitalmente() {
        return this.assinadoDigitalmente;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public Long getIdArquivoUnico() {
        return this.idArquivoUnico;
    }

    @Generated
    public Boolean getCertidaoEspecial() {
        return this.certidaoEspecial;
    }

    @Generated
    public Long getIdSequenciaItbi() {
        return this.idSequenciaItbi;
    }

    @Generated
    public Boolean getEnviadoProcuradoria() {
        return this.enviadoProcuradoria;
    }

    @Generated
    public UUID getIdLaudo() {
        return this.idLaudo;
    }

    @Generated
    public Long getExercicioProjeto() {
        return this.exercicioProjeto;
    }

    @Generated
    public Long getNumeroProjeto() {
        return this.numeroProjeto;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnoreProperties(value={"modeloBci", "modeloBce", "parametroITBI", "entidade.brasao"})
    @Generated
    public void setEntidadeTributacao(EntidadeTributacao entidadeTributacao) {
        this.entidadeTributacao = entidadeTributacao;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setTipoDocumento(Long tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    @Generated
    public void setDocumento(Long documento) {
        this.documento = documento;
    }

    @JsonIgnoreProperties(value={"outros", "textos", "assinaturas", "relatorios"})
    @Generated
    public void setDocumentoTipo(DocumentoTipo documentoTipo) {
        this.documentoTipo = documentoTipo;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setDataSolicitacao(LocalDate dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    @Generated
    public void setDataValidade(LocalDate dataValidade) {
        this.dataValidade = dataValidade;
    }

    @Generated
    public void setOutraFinalidade(String outraFinalidade) {
        this.outraFinalidade = outraFinalidade;
    }

    @JsonIgnoreProperties(value={"cadastroGeralIsencoes", "cadastroImobiliarioAvaliacoes", "cadastroImobiliarioSegmentos", "cadastroImobiliarioTestadas", "boletinsImobiliarioTerreno", "imobiliarioTestadasGenericas"})
    @Generated
    public void setCadastroGeral(CadastroGeral cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setTipoCadastro(TipoCadastro tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCodigoCadastroGeral(Long codigoCadastroGeral) {
        this.codigoCadastroGeral = codigoCadastroGeral;
    }

    @Generated
    public void setRequerente(String requerente) {
        this.requerente = requerente;
    }

    @Generated
    public void setCpfRequerente(String cpfRequerente) {
        this.cpfRequerente = cpfRequerente;
    }

    @Generated
    public void setTipoPessoaRequerente(TipoPessoa tipoPessoaRequerente) {
        this.tipoPessoaRequerente = tipoPessoaRequerente;
    }

    @Generated
    public void setSubTipo(String subTipo) {
        this.subTipo = subTipo;
    }

    @Generated
    public void setCodigoValidacao(String codigoValidacao) {
        this.codigoValidacao = codigoValidacao;
    }

    @JsonIgnoreProperties(value={"entidadeTributacao", "tipoDocumento"})
    @Generated
    public void setDocumentoFinalidade(DocumentoFinalidade documentoFinalidade) {
        this.documentoFinalidade = documentoFinalidade;
    }

    @Generated
    public void setSequenciaFinalidade(Long sequenciaFinalidade) {
        this.sequenciaFinalidade = sequenciaFinalidade;
    }

    @Generated
    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setCancelado(Boolean cancelado) {
        this.cancelado = cancelado;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    @Generated
    public void setObservacaoCancelamento(String observacaoCancelamento) {
        this.observacaoCancelamento = observacaoCancelamento;
    }

    @Generated
    public void setExercicioProcesso(Long exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    @Generated
    public void setIdProcesso(Long idProcesso) {
        this.idProcesso = idProcesso;
    }

    @Generated
    public void setDocumentoHistoricoSituacoes(List<DocumentoHistoricoSituacao> documentoHistoricoSituacoes) {
        this.documentoHistoricoSituacoes = documentoHistoricoSituacoes;
    }

    @Generated
    public void setDocumentoPessoas(List<DocumentoPessoa> documentoPessoas) {
        this.documentoPessoas = documentoPessoas;
    }

    @Generated
    public void setDocumentoItemDividaAtivas(List<DocumentoItemDividaAtiva> documentoItemDividaAtivas) {
        this.documentoItemDividaAtivas = documentoItemDividaAtivas;
    }

    @Generated
    public void setCertidoesDividaAtivaPeticao(List<Documento> certidoesDividaAtivaPeticao) {
        this.certidoesDividaAtivaPeticao = certidoesDividaAtivaPeticao;
    }

    @Generated
    public void setSituacao(SituacaoDocumento situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setImpresso(Boolean impresso) {
        this.impresso = impresso;
    }

    @Generated
    public void setSituacaoCadastral(String situacaoCadastral) {
        this.situacaoCadastral = situacaoCadastral;
    }

    @Generated
    public void setWeb(Boolean web) {
        this.web = web;
    }

    @Generated
    public void setAssinadoDigitalmente(Boolean assinadoDigitalmente) {
        this.assinadoDigitalmente = assinadoDigitalmente;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setIdArquivoUnico(Long idArquivoUnico) {
        this.idArquivoUnico = idArquivoUnico;
    }

    @Generated
    public void setCertidaoEspecial(Boolean certidaoEspecial) {
        this.certidaoEspecial = certidaoEspecial;
    }

    @Generated
    public void setIdSequenciaItbi(Long idSequenciaItbi) {
        this.idSequenciaItbi = idSequenciaItbi;
    }

    @Generated
    public void setEnviadoProcuradoria(Boolean enviadoProcuradoria) {
        this.enviadoProcuradoria = enviadoProcuradoria;
    }

    @Generated
    public void setIdLaudo(UUID idLaudo) {
        this.idLaudo = idLaudo;
    }

    @Generated
    public void setExercicioProjeto(Long exercicioProjeto) {
        this.exercicioProjeto = exercicioProjeto;
    }

    @Generated
    public void setNumeroProjeto(Long numeroProjeto) {
        this.numeroProjeto = numeroProjeto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Documento)) {
            return false;
        }
        Documento other = (Documento)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Documento;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

