/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.dto.CadastroImobiliarioCalculoDTO;
import br.com.elotech.tributos.calculo.dto.ParametroTesteScriptDTO;
import br.com.elotech.tributos.calculo.repository.CadastroImobiliarioCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroMobiliarioCalculoRepository;
import br.com.elotech.tributos.calculo.repository.CadastroRuralCalculoRepository;
import br.com.elotech.tributos.calculo.service.CalculoBuild;
import br.com.elotech.tributos.calculo.service.CalculoExecucaoBaseService;
import br.com.elotech.tributos.calculo.service.CalculoParser;
import br.com.elotech.tributos.calculo.service.TabelaValorService;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.calculo.CalculoAvaliacao;
import br.com.elotech.tributos.params.ImobiliarioSegmentoParams;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Service;

@Service
public class CalculoAvaliacaoExecucaoService
extends CalculoExecucaoBaseService<CalculoAvaliacao> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculoAvaliacaoExecucaoService.class);

    public CalculoAvaliacaoExecucaoService(CadastroImobiliarioCalculoRepository cadastroImobiliarioCalculoRepository, ConversionService conversionService, TabelaValorService tabelaValorService, CadastroMobiliarioCalculoRepository cadastroMobiliarioCalculoRepository, CadastroRuralCalculoRepository cadastroRuralCalculoRepository) {
        super(cadastroImobiliarioCalculoRepository, conversionService, tabelaValorService, cadastroMobiliarioCalculoRepository, cadastroRuralCalculoRepository);
    }

    public List<CadastroCalculoRoot> testarScript(ParametroTesteScriptDTO parametroTestScriptDTO) {
        parametroTestScriptDTO.getCalculoAvaliacao().setIdentificadorResultado(parametroTestScriptDTO.getIdentificador());
        parametroTestScriptDTO.getCalculoAvaliacao().setIdentificadorBaseCalculo(null);
        parametroTestScriptDTO.setTipoCadastro(TipoCadastro.IMOBILIARIO);
        CalculoBuild.buildCalculoDebugMode((List)parametroTestScriptDTO.getCalculoAvaliacao().getScript(), CalculoParser::parseLinhaDebugMode, (TipoDivida)TipoDivida.IPTU, (TipoCadastro)TipoCadastro.IMOBILIARIO);
        return this.calcular(Collections.singletonList(parametroTestScriptDTO.getCalculoAvaliacao()), parametroTestScriptDTO.getCalculoAvaliacao().getExercicio(), parametroTestScriptDTO.buildFiltro(), parametroTestScriptDTO.getSegmento(), Boolean.TRUE, LocalDate.now());
    }

    public CadastroCalculoRoot calcularSegmentoComAreaAlterada(CalculoAvaliacao avaliacao, ImobiliarioSegmentoParams params) {
        String filtro = String.format("cadastrogeral.tipocadastro = %d and cadastrogeral.cadastrogeral = %d", params.getTipoCadastro(), params.getCadastroGeral());
        List result = super.calcular(Collections.singletonList(avaliacao), avaliacao.getExercicio(), filtro, Long.valueOf(params.getSequencia().intValue()), Boolean.valueOf(false), LocalDate.now(), this.alterarAreaSegmentos(params.getAreaConstruida()));
        return (CadastroCalculoRoot)result.stream().findFirst().orElseThrow(() -> new EloValidationException("Erro ao calcular o valor da avalia\u00e7\u00e3o para o segmento"));
    }

    private UnaryOperator<List<CadastroCalculoRoot>> alterarAreaSegmentos(BigDecimal areaNova) {
        return roots -> {
            if (roots.isEmpty()) {
                throw new EloValidationException("N\u00e3o foram encontrados segmentos com os dados informados.");
            }
            List children = ((CadastroCalculoRoot)roots.get(0)).getChildren();
            if (children.isEmpty()) {
                throw new EloValidationException("N\u00e3o foram encontrados cadastros com os dados informados.");
            }
            if (children.size() > 1) {
                throw new EloValidationException("Foram encontrados mais de um cadastro com os dados informados.");
            }
            if (!(children.get(0) instanceof CadastroImobiliarioCalculoDTO)) {
                throw new EloValidationException("O c\u00e1lculo de avalia\u00e7\u00e3o s\u00f3 pode ser feito para cadastros imobili\u00e1rios.");
            }
            CadastroImobiliarioCalculoDTO cadastro = (CadastroImobiliarioCalculoDTO)children.get(0);
            cadastro.getSegmento().setAreaconstruida(Double.valueOf(areaNova.doubleValue()));
            return roots;
        };
    }
}

