/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.processamento;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.supersimples.SuperSimplesSolicitacaoService;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ProcessamentoSuperSimplesJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoSuperSimplesJobListener.class);
    private final SuperSimplesSolicitacaoService superSimplesSolicitacaoService;
    private final NotificacaoService notificacaoService;
    private final String notificationKey = "notificacaoId";
    private static final Map<NotificationStatus, String> notificationMessage = Map.of(NotificationStatus.STARTED, "Iniciando processamento de gera\u00e7\u00e3o do arquivo da varredura % do super simples %s", NotificationStatus.COMPLETED, "Finalizado processamento de gera\u00e7\u00e3o do arquivo da varredura % do super simples %s", NotificationStatus.FAILED, "Erro no processamento de gera\u00e7\u00e3o do arquivo da varredura % do super simples %s");

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idSolicitacao = jobExecution.getJobParameters().getLong("idSolicitacao");
        Long sequenciaVarredura = jobExecution.getJobParameters().getLong("sequenciaVarredura");
        this.superSimplesSolicitacaoService.iniciarProcessamento(idSolicitacao);
        Optional notificacaoId = this.notificarInicio(idSolicitacao, sequenciaVarredura, jobExecution);
        notificacaoId.ifPresent(id -> jobExecution.getExecutionContext().put("notificacaoId", id));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idSolicitacao = jobExecution.getJobParameters().getLong("idSolicitacao");
        Long sequenciaVarredura = jobExecution.getJobParameters().getLong("sequenciaVarredura");
        String tipoOperacao = jobExecution.getJobParameters().getString("tipoOperacao");
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.superSimplesSolicitacaoService.finalizarProcessamentoSucesso(idSolicitacao);
            this.notificarFinalSucesso(idSolicitacao, sequenciaVarredura, jobExecution);
        } else {
            this.superSimplesSolicitacaoService.finalizarProcessamentoErro(idSolicitacao, tipoOperacao);
            this.notificarFinalErro(idSolicitacao, sequenciaVarredura, jobExecution);
        }
    }

    private Optional<UUID> notificarInicio(Long idSolicitacao, Long sequenciaVarredura, JobExecution jobExecution) {
        return this.notificar(idSolicitacao, sequenciaVarredura, jobExecution, NotificationStatus.STARTED);
    }

    private void notificarFinalSucesso(Long idSolicitacao, Long sequenciaVarredura, JobExecution jobExecution) {
        this.notificar(idSolicitacao, sequenciaVarredura, jobExecution, NotificationStatus.COMPLETED);
    }

    private void notificarFinalErro(Long idSolicitacao, Long sequenciaVarredura, JobExecution jobExecution) {
        this.notificar(idSolicitacao, sequenciaVarredura, jobExecution, NotificationStatus.FAILED);
    }

    private Optional<UUID> notificar(Long idSolicitacao, Long sequenciaVarredura, JobExecution jobExecution, NotificationStatus status) {
        String message = String.format((String)notificationMessage.get(status), sequenciaVarredura, idSolicitacao);
        Optional<UUID> notificacaoId = Optional.ofNullable(jobExecution.getExecutionContext().get("notificacaoId")).map(id -> UUID.fromString(String.valueOf(id)));
        return this.notificacaoService.send("Processamento do super simples", message, jobExecution, notificacaoId, status);
    }

    @Generated
    public ProcessamentoSuperSimplesJobListener(SuperSimplesSolicitacaoService superSimplesSolicitacaoService, NotificacaoService notificacaoService) {
        this.superSimplesSolicitacaoService = superSimplesSolicitacaoService;
        this.notificacaoService = notificacaoService;
    }
}

