/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.simam.inscricaodividaativa;

import br.com.elotech.tributos.domain.simam.DebitoInscricaoDividaAtiva;
import br.com.elotech.tributos.domain.simam.LancamentoCreditoTributo;
import br.com.elotech.tributos.domain.simam.RestituicaoDebitoDividaAtiva;
import br.com.elotech.tributos.domain.simam.TipoLancamentoCredito;
import br.com.elotech.tributos.repository.simam.DebitoInscricaoDividaAtivaRepository;
import br.com.elotech.tributos.repository.simam.RestituicaoDebitoDividaAtivaRepository;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class InscricaoDividaAtivaBatchWriter
implements ItemWriter<TipoLancamentoCredito> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InscricaoDividaAtivaBatchWriter.class);
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final DebitoInscricaoDividaAtivaRepository debitoInscricaoDividaAtivaRepository;
    private final RestituicaoDebitoDividaAtivaRepository restituicaoDebitoDividaAtivaRepository;

    public InscricaoDividaAtivaBatchWriter(EntityManager entityManager, DebitoInscricaoDividaAtivaRepository debitoInscricaoDividaAtivaRepository, RestituicaoDebitoDividaAtivaRepository restituicaoDebitoDividaAtivaRepository) {
        this.entityManager = entityManager;
        this.debitoInscricaoDividaAtivaRepository = debitoInscricaoDividaAtivaRepository;
        this.restituicaoDebitoDividaAtivaRepository = restituicaoDebitoDividaAtivaRepository;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    @AfterWrite
    public void afterWrite(List<? extends LancamentoCreditoTributo> items) {
        LOGGER.info("SIM-AM - Inscri\u00e7\u00e3o D\u00edvida Ativa - Registros salvos at\u00e9 o momento: {}. Job Id {}.", (Object)(this.stepExecution.getReadCount() + items.size()), (Object)this.stepExecution.getJobExecution().getId());
    }

    public void write(List<? extends TipoLancamentoCredito> items) {
        List debitoInscricaoDividaAtiva = items.stream().filter(DebitoInscricaoDividaAtiva.class::isInstance).map(DebitoInscricaoDividaAtiva.class::cast).collect(Collectors.toList());
        List restituicaoDebitoDividaAtiva = items.stream().filter(RestituicaoDebitoDividaAtiva.class::isInstance).map(RestituicaoDebitoDividaAtiva.class::cast).collect(Collectors.toList());
        this.debitoInscricaoDividaAtivaRepository.saveAll(debitoInscricaoDividaAtiva);
        this.restituicaoDebitoDividaAtivaRepository.saveAll(restituicaoDebitoDividaAtiva);
        this.entityManager.flush();
    }
}

