/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.validacaoendereco;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ValidacaoEnderecoJobListener
extends JobExecutionListenerSupport {
    private static final String EXERCICIO = "exercicio";
    private static final String ID_COMUNICADO = "idComunicado";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private final NotificacaoService notificacaoService;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long exercicio = Objects.requireNonNull(jobExecution.getJobParameters().getLong(EXERCICIO));
        Long idComunicado = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ID_COMUNICADO));
        Optional notificacaoId = this.notificacaoService.send("COMUNICADOS - Valida\u00e7\u00e3o de Endere\u00e7os iniciada", String.format("Foi iniciada a Valida\u00e7\u00e3o de Endere\u00e7os para o comunicado %d do exercicio: %d", idComunicado, exercicio), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idComunicado = Objects.requireNonNull(jobExecution.getJobParameters().getLong(ID_COMUNICADO));
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("COMUNICADOS - Valida\u00e7\u00e3o de endere\u00e7os finalizada com sucesso", String.format("Os endere\u00e7os do comunicado %d foram validados onde poss\u00edvel.", idComunicado), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("COMUNICADOS - N\u00e3o foi poss\u00edvel validar os endere\u00e7os.", "Erro na valida\u00e7\u00e3o de endere\u00e7os", jobExecution, Optional.of(notificacaoId), NotificationStatus.STARTED);
        }
    }

    @Generated
    public ValidacaoEnderecoJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

