/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.simulacao;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.domain.documento.cda.SituacaoLoteCda;
import br.com.elotech.tributos.repository.documento.cda.LoteCdaRepository;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class SimulacaoLoteCdaJobListener
extends JobExecutionListenerSupport {
    private static final String DATA = "data";
    private static final String JOB_TYPE = "jobType";
    private static final String ID_LOTE = "idLote";
    private static final String ID_NOTIFICACAO = "idNotificacao";
    private static final String SIMULACAO_LOTE_CDA = JobType.SIMULACAO_LOTE_CDA.getTipo();
    private final NotificacaoService notificacaoService;
    private final LoteCdaRepository loteCdaRepository;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        Long idLote = jobExecution.getJobParameters().getLong(ID_LOTE);
        LoteCda lote = (LoteCda)this.loteCdaRepository.findOne((Object)idLote);
        lote.setBatchJobExecutionSimulacao(BatchJobExecution.of((JobExecution)jobExecution));
        this.loteCdaRepository.save((Object)lote);
        LocalDate data = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA)));
        Optional notificacaoId = this.notificacaoService.send("CDA - Inicianda a simula\u00e7\u00e3o do lote", String.format("Iniciada a gera\u00e7\u00e3o de dados da simula\u00e7\u00e3o do lote de certid\u00e3o de d\u00edvida ativa - %s", data.toString()), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_NOTIFICACAO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        UUID notificacaoId = UUID.fromString(jobExecution.getExecutionContext().getString(ID_NOTIFICACAO));
        LocalDate data = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(jobExecution.getJobParameters().getDate(DATA)));
        this.onHavingFailedSteps(jobExecution);
        this.onCompleted(jobExecution, notificacaoId, data);
        this.onFailed(jobExecution, notificacaoId, data);
    }

    private void onHavingFailedSteps(JobExecution jobExecution) {
        jobExecution.getStepExecutions().stream().filter(stepExecution -> BatchStatus.FAILED.equals((Object)stepExecution.getStatus())).forEach(stepExecution -> {
            jobExecution.setStatus(stepExecution.getStatus());
            jobExecution.setExitStatus(stepExecution.getExitStatus());
            stepExecution.getFailureExceptions().forEach(arg_0 -> ((JobExecution)jobExecution).addFailureException(arg_0));
        });
    }

    private void onCompleted(JobExecution jobExecution, UUID notificacaoId, LocalDate data) {
        Long idLote = jobExecution.getJobParameters().getLong(ID_LOTE);
        LoteCda lote = (LoteCda)this.loteCdaRepository.findOne((Object)idLote);
        lote.setSituacao(SituacaoLoteCda.SIMULACAO_GERADA);
        this.loteCdaRepository.save((Object)lote);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("CDA - Simula\u00e7\u00e3o do lote conclu\u00edda", String.format("Conclu\u00edda a gera\u00e7\u00e3o de dados da simula\u00e7\u00e3o do lote de certid\u00e3o de d\u00edvida ativa - %s", data.toString()), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
    }

    private void onFailed(JobExecution jobExecution, UUID notificacaoId, LocalDate data) {
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            Long idLote = jobExecution.getJobParameters().getLong(ID_LOTE);
            LoteCda lote = (LoteCda)this.loteCdaRepository.findOne((Object)idLote);
            lote.setSituacao(SituacaoLoteCda.ERRO_SIMULACAO);
            this.loteCdaRepository.save((Object)lote);
            this.notificacaoService.send("CDA - Erro na simula\u00e7\u00e3o do lote", String.format("N\u00e3o foi poss\u00edvel gerar os dados da simula\u00e7\u00e3o do lote de certid\u00e3o de d\u00edvida ativa - %s", data.toString()), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public SimulacaoLoteCdaJobListener(NotificacaoService notificacaoService, LoteCdaRepository loteCdaRepository) {
        this.notificacaoService = notificacaoService;
        this.loteCdaRepository = loteCdaRepository;
    }
}

